<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/PositionCB.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/PositionCB.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Fri Feb 18 09:49:48 PST 1994 by najork                   

<P>
<P> In accordance with the terminology used by Trestle, we refer to mouse 
   movements as to {\em position events}. A position event is represented
   by a record <CODE>PositionCB.Rec</CODE>.
<P>
   A {\em position event callback object} is an object which has one
   method, <CODE>invoke</CODE>. Each geometric object has a stack of position callback
   objects. When a position event <CODE>pr</CODE> is relayed to a particular geometric
   <CODE>o</CODE>, the the message <CODE>cb.invoke(pr)</CODE> is sent to the top callback
   object on <CODE>o</CODE>'s position callback stack (if <CODE>o</CODE>'s position callback stack 
   is empty, the event is simply dropped). It is <CODE>cb</CODE>'s reponsibility to
   perform whatever action is appropriate in the current context. 

<P><PRE>INTERFACE <interface><A HREF="PositionCB.m3">PositionCB</A></interface>;

IMPORT <A HREF="CB.i3">CB</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="ProxiedObj.i3">ProxiedObj</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  <A HREF="PositionCB.m3#T">T</A> &lt;: Public;
  Public = ProxiedObj.T OBJECT
  METHODS
    init () : T;
    invoke (pr : Rec) RAISES {CB.BadMethod};
  END;
</PRE><BLOCKQUOTE><EM> <CODE>PositionCB.T</CODE> is the abstract class of position callback objects. If <CODE>o</CODE> 
   is a geometric object, <CODE>c</CODE> is the top object in its position callback stack,
   and a position event <CODE>pr</CODE> gets relayed to <CODE>o</CODE>, then <CODE>cb.invoke(pr)</CODE> will be
   called. It is up to the user to create subclasses of <CODE>PositionCB.T</CODE> that 
   handle position events in a given context appropriately. </EM></BLOCKQUOTE><PRE>

  Rec = RECORD
    pos2D     : Point.T;
    modifiers : VBT.Modifiers;
  END;
</PRE><BLOCKQUOTE><EM> <CODE>PositionCB.Rec</CODE> is a record type containing information about a position 
   event. <CODE>pos2D</CODE> is the position of the mouse when the movement occurred.
   <CODE>modifiers</CODE> is the set of modifiers (Shift, Control, Mouse Buttons, etc.) 
   that was active when the movement took place.
<P>
   {\em NOTE: There is a fair chance that I will add other fields to <CODE>Rec</CODE>,
   once we have gained more experience with event handling. So far, I pretty
   much mimick (part of) what is there in <CODE>VBT.PositionRec</CODE>.} </EM></BLOCKQUOTE><PRE>

END PositionCB.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
