<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/Prop.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/Prop.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Thu May 19 14:43:45 PDT 1994 by najork                   

<P>
<P><PRE>MODULE <module>Prop</module> EXPORTS <A HREF="Prop.i3"><implements>Prop</A></implements>, <A HREF="PropPrivate.i3"><implements>PropPrivate</A></implements>, <A HREF="PropProxy.i3"><implements>PropProxy</A></implements>;

IMPORT <A HREF="Anim3D.i3">Anim3D</A>, <A HREF="AnimServer.i3">AnimServer</A>, <A HREF="GO.i3">GO</A>, <A HREF="GOPrivate.i3">GOPrivate</A>, <A HREF="ProxiedObj.i3">ProxiedObj</A>;

PROCEDURE <A NAME="Equal"><procedure>Equal</procedure></A> (a, b : T) : BOOLEAN =
  BEGIN
    RETURN a.n = b.n AND a.v = b.v;
  END Equal;

REVEAL
  <A NAME="T">T</A> = PrivateT BRANDED OBJECT
  OVERRIDES
    init          := InitT;
    adjust        := AdjustT;
    refreshDamage := RefreshDamage;
  END;

PROCEDURE <A NAME="InitT"><procedure>InitT</procedure></A> (self : T; n : Name; v : Val) : T =
  BEGIN
    self.n := n;
    self.v := v;
    IF MkProxyT # NIL THEN
      MkProxyT (self);
    END;
    RETURN self;
  END InitT;

PROCEDURE <A NAME="AdjustT"><procedure>AdjustT</procedure></A> (self : T; time : LONGREAL; caller : GO.T) =
  BEGIN
    TRY
      IF self.v.adjust (time) THEN
        self.n.damage (caller);
      END;
    EXCEPT
    | BadMethod (msg) =&gt;
      AnimServer.ReportError (msg &amp; &quot;\n&quot;);
    END;
  END AdjustT;

PROCEDURE <A NAME="RefreshDamage"><procedure>RefreshDamage</procedure></A> (self : T; caller : GO.T) =
  BEGIN
    IF self.v.damaged THEN
      self.n.damage (caller);
    END;
  END RefreshDamage;
</PRE>***************************************************************************
 Type <CODE>Name</CODE>                                                               
***************************************************************************

<P><PRE>REVEAL
  <A NAME="Name">Name</A> = PrivateName BRANDED OBJECT
  OVERRIDES
    init   := InitName;
    damage := DamageName;
  END;

PROCEDURE <A NAME="InitName"><procedure>InitName</procedure></A> (self : Name) : Name =
  BEGIN
    self.id := next;
    INC (next);

    list := NEW (NameList, this := self, next := list);

    RETURN self;
  END InitName;

PROCEDURE <A NAME="DamageName"><procedure>DamageName</procedure></A> (self : Name; caller : GO.T) =
  BEGIN
    caller.damageIfDependent (self);
  END DamageName;
</PRE>***************************************************************************
 Type <CODE>Val</CODE>                                                                
***************************************************************************

<P>
<P><PRE>REVEAL
  <A NAME="Val">Val</A> = PrivateVal BRANDED OBJECT END;
</PRE>***************************************************************************
 Type <CODE>Beh</CODE>                                                                
***************************************************************************

<P><PRE>REVEAL
  <A NAME="Beh">Beh</A> = ProxiedObj.T BRANDED OBJECT END;

REVEAL
  <A NAME="Request">Request</A> = PublicRequest BRANDED OBJECT
  OVERRIDES
    init := InitRequest;
  END;

PROCEDURE <A NAME="InitRequest"><procedure>InitRequest</procedure></A> (self : Request; start, dur : REAL) : Request =
  BEGIN
    self.proxy := NIL;
    self.start := start;
    self.dur   := dur;
    RETURN self;
  END InitRequest;
</PRE>***************************************************************************
 Type <CODE>Stack</CODE>                                                              
***************************************************************************

<P><PRE>REVEAL
  <A NAME="Stack">Stack</A> = BRANDED OBJECT END;
</PRE>***************************************************************************
 Property Name Management                                                  
***************************************************************************

<P>
<P><PRE>TYPE
  NameList = REF RECORD
    this : Name;
    next : NameList;
  END;

VAR
  list : NameList := NIL;
  next : INTEGER  := 0;

PROCEDURE <A NAME="NewStacks"><procedure>NewStacks</procedure></A> () : REF ARRAY OF Stack =
  VAR
    stacks : REF ARRAY OF Stack;
    tmp    : NameList;
  BEGIN
    &lt;* ASSERT next &gt; 0 *&gt;
    stacks := NEW (REF ARRAY OF Stack, next);
    tmp := list;
    WITH time = Anim3D.Now () DO
      WHILE tmp # NIL DO
        WITH pn = tmp.this DO
          stacks[pn.id] := pn.newStack();
        END;
        tmp := tmp.next;
      END;
    END;
    RETURN stacks;
  END NewStacks;

BEGIN
END Prop.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
