<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/PropPrivate.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/PropPrivate.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Thu May 19 14:05:27 PDT 1994 by najork                   

<P>
<P><PRE>INTERFACE <interface><A HREF="Prop.m3">PropPrivate</A></interface>;

IMPORT <A HREF="GO.i3">GO</A>, <A HREF="GraphicsState.i3">GraphicsState</A>, <A HREF="ProxiedObj.i3">ProxiedObj</A>;

FROM <A HREF="Prop.i3">Prop</A> IMPORT T, Name, Val, BadMethod;

REVEAL T &lt;: PrivateT;

TYPE
  PrivateT = ProxiedObj.T OBJECT
    n : Name;
    v : Val;
  METHODS
    init (n : Name; v : Val) : T;
    adjust (time : LONGREAL; caller : GO.T);
    refreshDamage (caller : GO.T);
  END;
</PRE> <CODE>p.adjust(time)</CODE> reevaluates the value of the property based on the given
   time. If the property value got damaged since the last adjustment, the
   property name is called upon to perform the appropriate damages to the 
   caller and/or its descendants. 
<P>
   <CODE>p.refreshDamage(caller)</CODE> refreshes the damage that a changed property 
   may have caused to <CODE>caller</CODE> or or of its descendents. This is crucial, 
   as the damaged descendent may have been redrawn (in a different way) and 
   thereby repaired coming through a different way in the scene DAG. 

<P><PRE>REVEAL Name &lt;: PrivateName;

TYPE
  PrivateName = ProxiedObj.T OBJECT
    id : INTEGER;
  METHODS
    init () : Name;
    damage (caller : GO.T);
    push (state : GraphicsState.T; val : Val);
    pop (state : GraphicsState.T);
    newStack () : Stack;
  END;
</PRE> <CODE>pn.damage(caller)</CODE> indicates that a property value bound to <CODE>pn</CODE> has
   changed since the last adjustment, which might cause damages in the scene.
   The default definition of <CODE>damage</CODE> asks all descendents of <CODE>caller</CODE>
   to damage themselves if their appearance depends on <CODE>pn</CODE>, and propagates
   damages back up to <CODE>caller</CODE>.
   Subclasses of <CODE>Name</CODE> can override the <CODE>damage</CODE> method to perform the
   appropriate damages to <CODE>caller</CODE> and/or its descendants. 

<P><PRE>REVEAL
  Val &lt;: PrivateVal;

TYPE
  PrivateVal = ProxiedObj.T OBJECT
    time    : LONGREAL;    (* Subclasses cache value at time &quot;time&quot;.         *)
    damaged : BOOLEAN;     (* Did the value change since the last rendering? *)
  METHODS
    adjust (time : LONGREAL) : BOOLEAN
        RAISES {BadMethod};
  END;
</PRE> <CODE>pv.adjust(now)</CODE> does two things: it updates the cached information 
   (time, value, and damage since last rendering cycle), and it returns
   if the property value is damaged, i.e. if it has changed since the last 
   rendering. Note that this technique relied on the fact that there is 
   a single, system-wide animation server, and that all roots get redrawn 
   at the same time. 

<P>
<P><PRE>TYPE
  <A HREF="Prop.m3#Stack">Stack</A> &lt;: ROOT;

PROCEDURE <A HREF="Prop.m3#NewStacks">NewStacks</A> () : REF ARRAY OF Stack;
</PRE><BLOCKQUOTE><EM> <CODE>NewStacks()</CODE> returns a new array of property value stacks, one stack
   for each existing property name. </EM></BLOCKQUOTE><PRE>

END PropPrivate.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
