<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/QuadMeshGO.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/QuadMeshGO.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P> A <CODE>QuadMershGO.T</CODE> is a geometric object that describes a quadrilateral
   mesh. A quadrilateral mesh is defined by a 2-dimensional array of points.
   Neighboring points are connected by quadrangles. 
   
<P><PRE>INTERFACE <interface><A HREF="QuadMeshGO.m3">QuadMeshGO</A></interface>;

IMPORT <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="GO.i3">GO</A>, <A HREF="Point3.i3">Point3</A>, <A HREF="SurfaceGO.i3">SurfaceGO</A>;

EXCEPTION BadSize;
EXCEPTION ColorsUndefined;

TYPE
  <A HREF="QuadMeshGO.m3#T">T</A> &lt;: Public;
  Public = SurfaceGO.T OBJECT
  METHODS
    init (READONLY pts : ARRAY OF ARRAY OF Point3.T;
          s := GO.Shape.Unknown) : T;
    addFacetColors (READONLY cols : ARRAY OF ARRAY OF Color.T)
        RAISES {BadSize};
    setColorOfFacet (i, j : INTEGER; c : Color.T) RAISES {ColorsUndefined};
  END;
</PRE><BLOCKQUOTE><EM> <CODE>qm.init(pts,s)</CODE> initializes the quad-mesh <CODE>qm</CODE> and returns it.
   <CODE>pts</CODE> is the matrix of points defining the quad-mesh; <CODE>s</CODE> is a 
   `shape hint'', i.e.\ a hint whether each polygon of the quad-mesh 
   is convex, non-convex, or complex.
   Refer to the \interface{GO} interface for details on shape hints. 
   By default, the quad-mesh is drawn in the color specified by the 
   \type{SurfaceGO}{Colour} property.
<P>
   <CODE>qm.addFacetColors(cols)</CODE> overrides the surface color specified by the 
   \type{SurfaceGO}{Colour} property, and instead attaches an individual 
   color to each quadrangle. The quadrangle <CODE>(i,j)</CODE> 
   (i.e. the quadrangle specified by the points 
   <CODE>pts[i][j]</CODE>, <CODE>pts[i][j+1]</CODE>, <CODE>pts[i+1][j+1]</CODE>, <CODE>pts[i+1][j]</CODE>) is drawn in 
   <CODE>col[i][j]</CODE>. If <CODE>pts</CODE> was an $m+1 \times n+1$ array,
   <CODE>cols</CODE> must be an $m \times n$ array; otherwise, the exception <CODE>BadSize</CODE> 
   is raised. 
<P>
   <CODE>qm.setColorOfFacet(i,j,c)</CODE> changes the color of quadrangle <CODE>(i,j)</CODE>
   to be <CODE>c</CODE>. The exception <CODE>ColorsUndefined</CODE> is raised if no facet colors 
   have yet been attached to <CODE>qm</CODE>. It is a fatal error if <CODE>i</CODE> or <CODE>j</CODE> 
   specify an invalid quadrangle. {\em I should instead raise an exception!}
<P>
   {\em NOTES: (a) Points and colors should be exposed as properties. 
   Refer to the \interface{PolygonGO} interface for an idea about how to do that.
   (b) It should be possible to attach single color values; in this case,
   all cells with a missing color value are drawn in the color specified by
   <CODE>SurfaceGO.Colour</CODE>.} </EM></BLOCKQUOTE><PRE>

END QuadMeshGO.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
