<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/QuadMeshGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/QuadMeshGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P><PRE>UNSAFE MODULE <module>QuadMeshGO</module> EXPORTS <A HREF="QuadMeshGO.i3"><implements>QuadMeshGO</A></implements>, <A HREF="QuadMeshGOProxy.i3"><implements>QuadMeshGOProxy</A></implements>;

IMPORT <A HREF="AuxG.i3">AuxG</A>, <A HREF="BSphere.i3">BSphere</A>, <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="GO.i3">GO</A>, <A HREF="GOPrivate.i3">GOPrivate</A>, <A HREF="GraphicsState.i3">GraphicsState</A>, <A HREF="GraphicsStatePex.i3">GraphicsStatePex</A>,
       <A HREF="../../PEX/src/PEX.i3">PEX</A>, <A HREF="Point3.i3">Point3</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
    pts   : REF ARRAY OF ARRAY OF Point3.T;
    shape : INTEGER;
    cols  : REF ARRAY OF ARRAY OF Color.T;
    bs    : BSphere.T;
  OVERRIDES
    init              := Init;
    draw              := Draw;
    addFacetColors    := AddFacetColors;
    setColorOfFacet   := SetColorOfFacet;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T;
                READONLY pts : ARRAY OF ARRAY OF Point3.T;
                s : GO.Shape) : T =
  VAR
    min, max : Point3.T;
  BEGIN
    EVAL GO.T.init (self);
    self.pts := NEW (REF ARRAY OF ARRAY OF Point3.T,
                     NUMBER(pts), NUMBER(pts[0]));
    self.pts^ := pts;
    self.shape := AuxG.ConvertShape(s);
    self.cols := NIL;

    (* Compute a bounding sphere. Precision is not that relevant, as long as
       our guess is conservative (i.e. the sphere indeed contains the entire
       quad-mesh). *)

    (* First, compute a bounding box containing all points of the quadmesh. *)
    min := Point3.Max;
    max := Point3.Min;
    FOR i := FIRST (pts) TO LAST (pts) DO
      FOR j := FIRST (pts[i]) TO LAST (pts[i]) DO
        min.x := MIN (min.x, pts[i][j].x);
        min.y := MIN (min.y, pts[i][j].y);
        min.z := MIN (min.z, pts[i][j].z);
        max.x := MAX (max.x, pts[i][j].x);
        max.y := MAX (max.y, pts[i][j].y);
        max.z := MAX (max.z, pts[i][j].z);
      END;
    END;

    IF min # Point3.Max AND max # Point3.Min THEN
      (* Fit a bounding sphere around the bounding box. *)
      self.bs.center := Point3.MidPoint (min, max);
      self.bs.radius := Point3.Distance (min, max) / 2.0;
    END;

    IF MkProxyT # NIL AND self.proxy = NIL THEN
      MkProxyT (self);
    END;

    RETURN self;
  END Init;

PROCEDURE <A NAME="Draw"><procedure>Draw</procedure></A> (self : T; state : GraphicsState.T) =
  BEGIN
    IF self.damaged THEN
      self.damaged := FALSE;
      state.openDisplayList (self);
      state.push (self);

      IF NUMBER (self.pts^) &gt; 0 AND NUMBER (self.pts[0]) &gt; 0 THEN
        state.growBoundingVolume (self.bs.center, self.bs.radius);
      END;

      IF self.cols = NIL THEN
        PEX.PEXQuadMesh (state.oc, self.shape, 0, 0, NIL,
                         ADR(self.pts[0][0]),
                         NUMBER(self.pts^), NUMBER(self.pts[0]));
      ELSE
        PEX.PEXQuadMesh (state.oc, self.shape, PEX.PEXGAColour, 0,
                         ADR(self.cols[0][0]),
                         ADR(self.pts[0][0]),
                         NUMBER(self.pts^),
                         NUMBER(self.pts[0]));
      END;

      state.pop (self);
      state.closeDisplayList ();
    END;

    (*** Use the cache values ***)
    state.callDisplayList (self);
  END Draw;

PROCEDURE <A NAME="AddFacetColors"><procedure>AddFacetColors</procedure></A> (self : T; READONLY cols : ARRAY OF ARRAY OF Color.T)
    RAISES {BadSize} =
  BEGIN
    self.damaged := TRUE;
    IF NUMBER(cols) # NUMBER(self.pts^) - 1 OR
       NUMBER(cols[0]) # NUMBER(self.pts[0]) - 1 THEN
      RAISE BadSize;
    END;
    self.cols := NEW(REF ARRAY OF ARRAY OF Color.T,
                     NUMBER(cols), NUMBER(cols[0]));
    self.cols^ := cols;
  END AddFacetColors;

PROCEDURE <A NAME="SetColorOfFacet"><procedure>SetColorOfFacet</procedure></A> (self : T; i, j : INTEGER; c : Color.T)
    RAISES {ColorsUndefined} =
  BEGIN
    self.damaged := TRUE;
    IF self.cols = NIL THEN
      RAISE ColorsUndefined;
    END;
    self.cols[i][j] := c;
  END SetColorOfFacet;

BEGIN
END QuadMeshGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
