<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/Quaternion.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/Quaternion.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Tue Jun 21 16:14:58 PDT 1994 by najork                   

<P>
<P><PRE>INTERFACE <interface><A HREF="Quaternion.m3">Quaternion</A></interface>;

IMPORT <A HREF="Matrix4.i3">Matrix4</A>;

TYPE
  T = RECORD
    a, b, c, d : REAL;
  END;

PROCEDURE <A HREF="Quaternion.m3#FromMatrix4">FromMatrix4</A> (READONLY M : Matrix4.T) : T;
</PRE><BLOCKQUOTE><EM> <CODE>FromMatrix4(M)</CODE> takes an orthonormal matrix <CODE>M</CODE> and returns the 
   corresponding quaternion <CODE>q</CODE>. <CODE>q</CODE> will have unit norm. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Quaternion.m3#ToMatrix4">ToMatrix4</A> (q : T) : Matrix4.T;
</PRE><BLOCKQUOTE><EM> <CODE>ToMatrix4(q)</CODE> takes a unit norm quaternion and returns an orthonormal 
   matrix <CODE>M</CODE> that corresponds to this quaternion. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Quaternion.m3#Interpolate">Interpolate</A> (q : T; f : REAL) : T;
</PRE><BLOCKQUOTE><EM> <CODE>Interpolate (q,f)</CODE> takes a unit norm quaternion <CODE>q = (a,b,c,d)</CODE> and a real
   <CODE>f</CODE> between 0 and 1, and returns a unit norm quaternion. Mapping 
   <CODE>Interpolate</CODE> over the range [0,1] and applying <CODE>ToMatrix4</CODE> to the results 
   yields a series of matrices that describe a ``smooth'' rotation, with 
   <CODE>Matrix4.Id</CODE> as the initial matrix and <CODE>ToMatrix(q)</CODE> as the final matrix. </EM></BLOCKQUOTE><PRE>

END Quaternion.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
