<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/RealPropProxy.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/RealPropProxy.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Sun May 22 00:08:25 PDT 1994 by najork                   

<P>
<P><PRE>INTERFACE <interface><A HREF="RealProp.m3">RealPropProxy</A></interface>;

IMPORT <A HREF="Prop.i3">Prop</A>, <A HREF="ProxiedObj.i3">ProxiedObj</A>;

FROM <A HREF="RealProp.i3">RealProp</A> IMPORT Name, Val, ConstBeh, SyncBeh, AsyncBeh, DepBeh, Request;
</PRE> Proxy Maker (PM) procedures for the various proxied object types are 
   registered by assigning them to these variables. These variables could be 
   put in their own interface. 

<P><PRE>VAR
  NamePM     : PROCEDURE (x : Name)     := NIL;
  ValPM      : PROCEDURE (x : Val)      := NIL;
  ConstBehPM : PROCEDURE (x : ConstBeh) := NIL;
  SyncBehPM  : PROCEDURE (x : SyncBeh)  := NIL;
  AsyncBehPM : PROCEDURE (x : AsyncBeh) := NIL;
  DepBehPM   : PROCEDURE (x : DepBeh)   := NIL;
  RequestPM  : PROCEDURE (x : Request)  := NIL;
</PRE> The <CODE>AsyncBeh</CODE> and <CODE>DepBeh</CODE> types are abstract supertypes; concrete 
   asynchronous and dependent behaviors are created by overriding the <CODE>value</CODE> 
   method. We want to be able to do this not only from Modula-3, but also from 
   the embedded language (e.g. Obliq). This is achieved by providing special
   proxy types. 
<P>
   The <CODE>proxy</CODE> field of <CODE>AsyncBeh</CODE> and <CODE>DepBeh</CODE> must contain either NIL or 
   an object of type <CODE>AsyncBehProxy</CODE> or <CODE>DepBehProxy</CODE>. 


<P><PRE>TYPE
  AsyncBehProxy = ProxiedObj.Proxy OBJECT
  METHODS
    compute (time : LONGREAL) : REAL RAISES {Prop.BadMethod};
  END;

  DepBehProxy = ProxiedObj.Proxy OBJECT
  METHODS
    compute (time : LONGREAL) : REAL RAISES {Prop.BadMethod};
  END;

  RequestProxy = ProxiedObj.Proxy OBJECT
  METHODS
    value (startval : REAL; reltime : REAL) : REAL
        RAISES {Prop.BadMethod};
  END;

END RealPropProxy.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
