<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/RootGO.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/RootGO.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Fri Feb  4 15:42:17 PST 1994 by najork                   

<P>
<P> A <CODE>RootGO.T</CODE> is a geometric object that describes a scene (that is, 
   it is the root of a scene tree or DAG). <CODE>RootGO.T</CODE> is a subtype of
   \type{GroupGO}{T}. 

<P><PRE>INTERFACE <interface><A HREF="RootGO.m3">RootGO</A></interface>;

IMPORT <A HREF="BooleanProp.i3">BooleanProp</A>, <A HREF="CameraGO.i3">CameraGO</A>, <A HREF="ColorProp.i3">ColorProp</A>, <A HREF="GraphicsBase.i3">GraphicsBase</A>, <A HREF="GroupGO.i3">GroupGO</A>, <A HREF="RealProp.i3">RealProp</A>;

TYPE
  <A HREF="RootGO.m3#T">T</A> &lt;: Public;
  Public = GroupGO.T OBJECT
  METHODS
    init (cam : CameraGO.T; base : GraphicsBase.T) : T;
    changeCamera (cam : CameraGO.T);
  END;
</PRE><BLOCKQUOTE><EM> <CODE>r.init(cam,base)</CODE> initializes a new root object <CODE>r</CODE> and returns it.
   The scene (i.e.\ <CODE>r</CODE> and its descendants) will be viewed through the 
   camera <CODE>cam</CODE> (which may, but does not have to be a descendant of <CODE>r</CODE>).
   <CODE>base</CODE> provides a connection to the underlying window system (e.g.\ X)
   and graphics system (e.g.\ PEX). It also initializes the animation clock
   to a new \type{Clock}{T} (i.e.\ a real-time clock).
<P>
   <CODE>r.changeCamera(cam)</CODE> changes the camera through which the scene is viewed.
<P>
   <CODE>r.changeClock(clock)</CODE> changes the animation clock.
<P>
   <CODE>r.animate(ah)</CODE> starts the animation of all synchronized time-variant 
   property values that are currently tied to the animation handle <CODE>ah</CODE>.
   <CODE>r.animate(ah)</CODE> returns when all animations associated with <CODE>ah</CODE> are 
   completed. </EM></BLOCKQUOTE><PRE>
</PRE> {\em Note: Making a <CODE>RootGO.T</CODE> a child of another <CODE>GroupGO.T</CODE> is wrong, 
   and should raise an exception. Currently, we don't enforce this.} 

<P>
<P><PRE>PROCEDURE <A HREF="RootGO.m3#New">New</A> (cam : CameraGO.T; base : GraphicsBase.T) : T;
</PRE><BLOCKQUOTE><EM> A convenience procedure. The expression <CODE>New(cam,base)</CODE> is equivalent to
   <CODE>NEW(T).init(cam,base)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RootGO.m3#NewStd">NewStd</A> (base : GraphicsBase.T := NIL) : T;
</PRE><BLOCKQUOTE><EM> Creates and returns a new <CODE>RootGO.T</CODE>, which is set up in a ``reasonable''
   way. 
   \begin{itemize}
   \item The new root (<CODE>root</CODE>) uses a perspective camera, 
         which is looking at the origin.
   \item <CODE>root</CODE> contains two light sources, an ambient light source and a 
         vector light source with rays along the vector (-1,-1,-1). 
         Both sources are emitting white light.
   \item If no <CODE>base</CODE> is supplied, it creates a new X-PEX base entitled
         ``Anim3D Viewer''.
   \item The property <CODE>(GO.Transform,TransformProp.NewConst ())</CODE> is attached 
         to <CODE>root</CODE>. This property is used to allow the user to interactively
         manipulate the scene, and therefore should not be detached.
   \item Mouse and position callback objects are pushed onto <CODE>root</CODE>'s mouse
         and position callback stacks. These callback objects respond to
         ``mouse drags'' (possibly modified through the shift key) by
         translating, uniformly scaling, or rotating the scene described 
         by <CODE>root</CODE>.
   \end{itemize} </EM></BLOCKQUOTE><PRE>

VAR
  Background         : ColorProp.Name;
  DepthcueSwitch     : BooleanProp.Name;
  DepthcueColour     : ColorProp.Name;
  DepthcueFrontPlane : RealProp.Name;
  DepthcueBackPlane  : RealProp.Name;
  DepthcueFrontScale : RealProp.Name;
  DepthcueBackScale  : RealProp.Name;
</PRE><BLOCKQUOTE><EM> In addition to the properties observed by all \type{GO}{T}'s and 
   \type{GroupGO}{T}'s, there are some additional properties that are 
   observed by <CODE>RootGO.T</CODE>'s:
<P>
   <CODE>Background</CODE> is the name of a property that describes the background color
   of the scene. It associates with a \type{ColorProp}{Val}. By default, the 
   background is black.
<P>
   {\em Note: Alternatively, I could say that by default, the color shift 
   shall occur in the direction of the background color.}
<P>
   <CODE>DepthcueSwitch</CODE> is the name of a property that determines whether or not
   depth cueing (also called ``fog'') shall be used. It associates with a 
   \type{BooleanProp}{Val}. By default, depth cueing is switched off.
<P>
   <CODE>DepthcueColour</CODE> is the name of a property that determines the color
   of the ``fog'', i.e. the color shift objects that are far from the viewer 
   undergo. It associates with a \type{ColourProp}{Val}. By default (assuming 
   that depth cueing is activated) objects appear the darker the further they 
   are away from the viewer (i.e.\ their color is shifted towards black).
   <P>
   <CODE>DepthcueFrontPlane</CODE> and <CODE>DepthcueBackPlane</CODE> are the names of two 
   properties that determine within which distance range from the viewer 
   the color shift shall occur. They associate with \type{RealProp}{Val}'s. 
   Distances are specified in normalized projection coordinates.
<P>
   {\em Note: This concept might be to complicated for a casual user.
   I could hide the depth cueing front and back planes, and set them
   to be equal to the z-buffer clamps. The user could still adjust the
   amout of depth cueing by adjusting the front and back scale.}
<P>
   <CODE>DepthcueFrontScale</CODE> and <CODE>DepthcueBackScale</CODE> are the names of two 
   properties that determine how strong the color shift shall be at the 
   depth cueing front and back planes. They associate with 
   \type{RealProp}{Val}'s.
</EM></BLOCKQUOTE><PRE>

END RootGO.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
