<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/RootGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/RootGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Wed Feb 16 14:15:37 PST 1994 by najork                   

<P>
<P><PRE>UNSAFE MODULE <module>RootGO</module> EXPORTS <A HREF="RootGO.i3"><implements>RootGO</A></implements>, <A HREF="RootGOPrivate.i3"><implements>RootGOPrivate</A></implements>, <A HREF="RootGOProxy.i3"><implements>RootGOProxy</A></implements>;

IMPORT <A HREF="AuxG.i3">AuxG</A>, <A HREF="AmbientLightGO.i3">AmbientLightGO</A>, <A HREF="AnimServer.i3">AnimServer</A>, <A HREF="BooleanProp.i3">BooleanProp</A>, <A HREF="BooleanPropPrivate.i3">BooleanPropPrivate</A>,
       <A HREF="CameraGO.i3">CameraGO</A>, <A HREF="CameraGOPrivate.i3">CameraGOPrivate</A>, <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="ColorProp.i3">ColorProp</A>, <A HREF="ColorPropPrivate.i3">ColorPropPrivate</A>, <A HREF="../../C/src/Common/Ctypes.i3">Ctypes</A>,
       <A HREF="GO.i3">GO</A>, <A HREF="GOPrivate.i3">GOPrivate</A>, <A HREF="GraphicsBase.i3">GraphicsBase</A>, <A HREF="GraphicsBasePrivate.i3">GraphicsBasePrivate</A>, <A HREF="GraphicsState.i3">GraphicsState</A>,
       <A HREF="GraphicsStatePex.i3">GraphicsStatePex</A>, <A HREF="GroupGO.i3">GroupGO</A>, <A HREF="GroupGOPrivate.i3">GroupGOPrivate</A>, <A HREF="MouseCB.i3">MouseCB</A>, <A HREF="../../PEX/src/PEX.i3">PEX</A>, <A HREF="PerspCameraGO.i3">PerspCameraGO</A>,
       <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="Point3.i3">Point3</A>, <A HREF="PositionCB.i3">PositionCB</A>, <A HREF="Prop.i3">Prop</A>, <A HREF="RealProp.i3">RealProp</A>, <A HREF="RealPropPrivate.i3">RealPropPrivate</A>,
       <A HREF="TransformProp.i3">TransformProp</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="VectorLightGO.i3">VectorLightGO</A>, <A HREF="../../X11R4/src/Common/X.i3">X</A>, <A HREF="X_PEX_Base.i3">X_PEX_Base</A>;

&lt;* FATAL X.Error *&gt;   (* This FATAL should eventually move into X_PEX_Base *)

REVEAL
  <A NAME="T">T</A> = Private BRANDED OBJECT
    backgroundColor : Color.T;  (* cached background color *)
  OVERRIDES
    init              := Init;
    changeCamera      := ChangeCamera;
    findName          := FindName;
    adjust            := Adjust;
    draw              := Draw;
    damageIfDependent := DamageIfDependent;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T; cam : CameraGO.T; base : GraphicsBase.T) : T =
  BEGIN
    EVAL GroupGO.T.init (self);
    self.cam   := cam;
    self.base  := base;

    base.root := self;

    (* set the background color to a sentinel value, thereby triggering
       an initial damage repair, i.e. proper background initialization ***)
    self.backgroundColor := Color.T {-1.0, -1.0, -1.0};

    (* Register to root with the animation server *)
    AnimServer.RegisterRootGO (self);

    IF MkProxyT # NIL THEN
      MkProxyT (self);
    END;

    RETURN self;
  END Init;

PROCEDURE <A NAME="ChangeCamera"><procedure>ChangeCamera</procedure></A> (self : T; cam : CameraGO.T) =
  BEGIN
    (*** Must be protected from interference with the animation server ***)
    LOCK AnimServer.internalLock DO
      self.cam := cam;

      (*** damage the root, forcing a redraw ***)
      self.damaged := TRUE;
    END;
  END ChangeCamera;

PROCEDURE <A NAME="FindName"><procedure>FindName</procedure></A> (self : T; name : TEXT) : GO.T =
  BEGIN
    IF self.cam.findName (name) # NIL THEN
      RETURN self.cam;
    ELSE
      RETURN GroupGO.T.findName (self, name);
    END;
  END FindName;

PROCEDURE <A NAME="Adjust"><procedure>Adjust</procedure></A> (self : T; time : LONGREAL) =
  BEGIN
    (*** Adjust self like any other root ... ***)
    GroupGO.T.adjust (self, time);

    (*** ... but also adjust the active camera ... ***)
    self.cam.adjust (time);

    (*** ... and propagate its damage up. ***)
    IF self.cam.damaged THEN
      self.damaged := TRUE;
    END;
  END Adjust;

PROCEDURE <A NAME="Draw"><procedure>Draw</procedure></A> (self : T; state : GraphicsState.T) =
  VAR
    dc : PEX.pxlDepthCueEntry;
  BEGIN
    state.push (self);

    (*** Take care of the background color ***)

    WITH col = Background.getState (state) DO
      IF self.backgroundColor # col THEN
        self.backgroundColor := col;
        state.base.setBackgroundColor (col);
      END;
    END;

    (*** Take care of depth cueing ***)

    WITH b = DepthcueSwitch.getState (state) DO
      VAR pexrep : Ctypes.int; BEGIN
        IF b THEN
          pexrep := PEX.PEXOn;
        ELSE
          pexrep := PEX.PEXOff;
        END;
        dc.mode := pexrep;
      END;
    END;
    dc.frontPlane := DepthcueFrontPlane.getState (state);
    dc.backPlane := DepthcueBackPlane.getState (state);
    dc.frontScaling := DepthcueFrontScale.getState (state);
    dc.backScaling := DepthcueBackScale.getState (state);
    WITH c = DepthcueColour.getState (state) DO
      dc.depthCueColour := AuxG.MkRgbFloatColour (c);
    END;
    PEX.PEXSetTableEntries (state.disp, state.depthCueLut,
                            PEX.PEXDepthCueLUT, 1, 1, ADR (dc));

    (*** Now do whatever has to be done for normal groups as well ***)

    FOR i := 0 TO self.last DO
      (* Calling draw may set self.damaged *)
      self.children[i].draw (state);
    END;

    (*** Indicate that the damages have been repaired ***)
    self.damaged := FALSE;

    state.pop (self);

    (* Test if the camera has been drawn (i.e. is part of the overall scene);
       if this is not the case, draw it now. *)
    IF NOT self.cam.flag THEN
      (* Note that the order of the arguments to OR matters here!! *)
      self.cam.draw (state);
    END;

    (*** As &quot;caller&quot; is NIL, we don't have to propagate self.damaged ***)
  END Draw;

PROCEDURE <A NAME="DamageIfDependent"><procedure>DamageIfDependent</procedure></A> (self : T; pn : Prop.Name) =
  BEGIN
    IF pn = Background OR pn = DepthcueSwitch OR pn = DepthcueColour OR
       pn = DepthcueFrontPlane OR pn = DepthcueBackPlane OR
       pn = DepthcueFrontScale OR pn = DepthcueBackScale THEN
      self.damaged := TRUE;
    END;
  END DamageIfDependent;
</PRE>***************************************************************************
 Construction procedures                                                   
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="New"><procedure>New</procedure></A> (cam : CameraGO.T; base : GraphicsBase.T) : T =
  BEGIN
    RETURN NEW(T).init(cam,base);
  END New;

PROCEDURE <A NAME="NewStd"><procedure>NewStd</procedure></A> (base : GraphicsBase.T) : T =
  VAR
    root : T;
    cam := PerspCameraGO.New (from := Point3.T{0.0, 0.0, 100.0},
                              to   := Point3.T{0.0, 0.0, 0.0},
                              up   := Point3.T{0.0, 1.0, 0.0},
                              fovy := 0.05);
  BEGIN
    IF base = NIL THEN
      base := NEW (X_PEX_Base.T).init (&quot;Anim3D Viewer&quot;);
    END;
    cam.setName (&quot;default-camera&quot;);
    root := NEW (T).init (cam, base);

    (* Attach two lights *)
    WITH light = AmbientLightGO.New (Color.White) DO
      light.setName (&quot;default-ambient-light&quot;);
      root.add (light);
    END;
    WITH light = VectorLightGO.New (Color.White, Point3.T{-1.0,-1.0,-1.0}) DO
      light.setName (&quot;default-vector-light&quot;);
      root.add (light);
    END;

    (* Attach mouse and position callbacks to the root *)
    root.setProp (GO.Transform.bind (TransformProp.NewConst ()));
    root.pushMouseCB (NEW (MyMouseCB, go := root, invoke := MouseInvoke).init());

    RETURN root;
  END NewStd;

TYPE
  MyPositionCB = PositionCB.T OBJECT
    go  : T;
    pos : Point.T;
    but : VBT.Button;
  OVERRIDES
    invoke := PositionInvoke;
  END;

  MyMouseCB = MouseCB.T OBJECT
    go : T;
  OVERRIDES
    invoke := MouseInvoke;
  END;

PROCEDURE <A NAME="PositionInvoke"><procedure>PositionInvoke</procedure></A> (self : MyPositionCB; pr : PositionCB.Rec) =
  &lt;* FATAL GO.PropUndefined *&gt;
  BEGIN
    WITH d   = Point.Sub (pr.pos2D, self.pos),
         dx  = FLOAT (d.h), dy = FLOAT (d.v),
         beh = NARROW (GO.GetTransform(self.go).beh, TransformProp.ConstBeh) DO
      IF VBT.Modifier.Shift IN pr.modifiers THEN
        CASE  self.but OF
        | VBT.Modifier.MouseL =&gt; beh.translate (dx * 0.01, -dy * 0.01, 0.0);
        | VBT.Modifier.MouseM =&gt; beh.scale (1.0 + dx * 0.01,
                                            1.0 + dx * 0.01,
                                            1.0 + dx * 0.01);
        | VBT.Modifier.MouseR =&gt; beh.translate (0.0, 0.0, dx * 0.01);
        ELSE
          (* Mice have only three buttons those days ... *)
        END;
      ELSE
        CASE  self.but OF
        | VBT.Modifier.MouseL =&gt; beh.rotateX (dx * 0.01);
        | VBT.Modifier.MouseM =&gt; beh.rotateY (dx * 0.01);
        | VBT.Modifier.MouseR =&gt; beh.rotateZ (dx * 0.01);
        ELSE
          (* Mice have only three buttons those days ... *)
        END;
      END;
    END;
    self.pos := pr.pos2D;
  END PositionInvoke;

PROCEDURE <A NAME="MouseInvoke"><procedure>MouseInvoke</procedure></A> (self : MyMouseCB; mr : MouseCB.Rec) =
  &lt;* FATAL GO.StackError *&gt;
  BEGIN
    IF mr.clickType = VBT.ClickType.FirstDown THEN
      self.go.pushPositionCB (NEW (MyPositionCB,
                                   go  := self.go,
                                   pos := mr.pos2D,
                                   but := mr.whatChanged).init());
    ELSIF mr.clickType = VBT.ClickType.LastUp THEN
      self.go.popPositionCB ();
    END;
  END MouseInvoke;
</PRE>***************************************************************************
 Module body                                                               
***************************************************************************

<P>
<P><PRE>BEGIN
  Background         := NEW (ColorProp.Name).init (Color.Black);
  DepthcueColour     := NEW (ColorProp.Name).init (Color.Black);
  DepthcueFrontPlane := NEW (RealProp.Name).init (1.0);
  DepthcueBackPlane  := NEW (RealProp.Name).init (0.0);
  DepthcueFrontScale := NEW (RealProp.Name).init (1.0);
  DepthcueBackScale  := NEW (RealProp.Name).init (0.0);
  DepthcueSwitch     := NEW (BooleanProp.Name).init (FALSE);
END RootGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
