<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/ShadingProp.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/ShadingProp.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Sun May 22 11:14:32 PDT 1994 by najork                   

<P>
<P><PRE>INTERFACE <interface><A HREF="ShadingProp.m3">ShadingProp</A></interface>;

IMPORT <A HREF="AnimHandle.i3">AnimHandle</A>, <A HREF="Prop.i3">Prop</A>;

TYPE
  Kind = {Flat, Gouraud};
</PRE> <CODE>Kind</CODE> enumerates the supported shading methods. Here is what they do, 
   straight from the PEX manual:
<P>
   <CODE>Flat</CODE>: The color resulting from a single light source computation
   is used for the entire surface. No interpolation will be preformed
   across surface interiors or edges. In PEXlib, this is called 
   PEXSurfaceInterpNone; in OpenGL, it is called GL_FLAT.
<P>
   <CODE>Gouraud</CODE>: The colors are computed at the vertices of the surface according
   to the current reflection model. These color values are then interpolated 
   across the interior of the surface or edges. In PEXlib, this is called 
   PEXSurfaceInterpColour; in OpenGL, it is called GL_SMOOTH.
<P>
   The PEX 5.0 standard provides two more shading methods, dot-product shading
   (PEXSurfaceInterpDotProduct) and Phong shading (PEXSurfaceInterpNormal).
   However, most existing implementations of PEX (including the ones available
   at SRC) do not support these two methods, and OpenGL does not provide them 
   at all. So, we chose not to include them into Anim3D. 

<P>
<P><PRE>TYPE
  <A HREF="ShadingProp.m3#Name">Name</A> &lt;: PublicName;
  PublicName = Prop.Name OBJECT
  METHODS
    bind (v : Val) : Prop.T;
  END;

  <A HREF="ShadingProp.m3#Val">Val</A> &lt;: PublicVal;
  PublicVal = Prop.Val OBJECT
    beh : Beh;
  METHODS
    init (beh : Beh) : Val;
    get () : Kind RAISES {Prop.BadMethod};
    value (time : LONGREAL) : Kind RAISES {Prop.BadMethod};
  END;

  <A HREF="ShadingProp.m3#Beh">Beh</A> &lt;: PublicBeh;
  PublicBeh = Prop.Beh OBJECT
  METHODS
    init () : Beh;
  END;

  <A HREF="ShadingProp.m3#ConstBeh">ConstBeh</A> &lt;: PublicConstBeh;
  PublicConstBeh = Beh OBJECT
  METHODS
    init (p : Kind) : ConstBeh;
    set (p : Kind);
  END;

  <A HREF="ShadingProp.m3#SyncBeh">SyncBeh</A> &lt;: PublicSyncBeh;
  PublicSyncBeh = Beh OBJECT
  METHODS
    init (ah : AnimHandle.T; p : Kind) : SyncBeh;
    addRequest (r : Request) RAISES {Prop.BadInterval};
  (* shortcuts for particular instances of &quot;addRequest&quot; *)
    change (p : Kind; start := 0.0) RAISES {Prop.BadInterval};
  END;

  <A HREF="ShadingProp.m3#AsyncBeh">AsyncBeh</A> &lt;: PublicAsyncBeh;
  PublicAsyncBeh = Beh OBJECT
  METHODS
    init () : AsyncBeh;
    compute (time : LONGREAL) : Kind RAISES {Prop.BadMethod};
  END;

  <A HREF="ShadingProp.m3#DepBeh">DepBeh</A> &lt;: PublicDepBeh;
  PublicDepBeh = Beh OBJECT
  METHODS
    init () : DepBeh;
    compute (time : LONGREAL) : Kind RAISES {Prop.BadMethod};
  END;

  <A HREF="ShadingProp.m3#Request">Request</A> &lt;: PublicRequest;
  PublicRequest = Prop.Request OBJECT
  METHODS
    init (start, dur : REAL) : Request;
    value (startkind : Kind; reltime : REAL) : Kind RAISES {Prop.BadMethod};
  END;

PROCEDURE <A HREF="ShadingProp.m3#NewConst">NewConst</A> (p : Kind) : Val;
PROCEDURE <A HREF="ShadingProp.m3#NewSync">NewSync</A> (ah : AnimHandle.T; p : Kind) : Val;
PROCEDURE <A HREF="ShadingProp.m3#NewAsync">NewAsync</A> (b : AsyncBeh) : Val;
PROCEDURE <A HREF="ShadingProp.m3#NewDep">NewDep</A> (b : DepBeh) : Val;

END ShadingProp.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
