<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/ShadingProp.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/ShadingProp.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Sun May 22 11:34:26 PDT 1994 by najork                   

<P>
<P><PRE>MODULE <module>ShadingProp</module> EXPORTS <A HREF="ShadingProp.i3"><implements>ShadingProp</A></implements>, <A HREF="ShadingPropPrivate.i3"><implements>ShadingPropPrivate</A></implements>, <A HREF="ShadingPropProxy.i3"><implements>ShadingPropProxy</A></implements>;

IMPORT <A HREF="Anim3D.i3">Anim3D</A>, <A HREF="AnimHandle.i3">AnimHandle</A>, <A HREF="AnimHandlePrivate.i3">AnimHandlePrivate</A>, <A HREF="AnimRequestQueue.i3">AnimRequestQueue</A>,
       <A HREF="AnimRequestQueuePrivate.i3">AnimRequestQueuePrivate</A>, <A HREF="AnimServer.i3">AnimServer</A>, <A HREF="GraphicsState.i3">GraphicsState</A>,
       <A HREF="GraphicsStatePrivate.i3">GraphicsStatePrivate</A>, <A HREF="Prop.i3">Prop</A>, <A HREF="PropPrivate.i3">PropPrivate</A>;
</PRE>***************************************************************************
 Type <CODE>Name</CODE>                                                               
***************************************************************************

<P><PRE>REVEAL
  <A NAME="Name">Name</A> = PrivateName BRANDED OBJECT
    default : Kind;
  OVERRIDES
    init      := InitName;
    bind      := BindName;
    makeProxy := MakeProxyName;
    push      := PushName;
    pop       := PopName;
    newStack  := NewStack;
    getState  := GetState;
  END;

PROCEDURE <A NAME="InitName"><procedure>InitName</procedure></A> (self : Name; default : Kind) : Name =
  BEGIN
    EVAL Prop.Name.init (self);
    self.default := default;
    IF NamePM # NIL THEN
      NamePM (self);
    END;
    RETURN self;
  END InitName;

PROCEDURE <A NAME="BindName"><procedure>BindName</procedure></A> (self : Name; val : Val) : Prop.T =
  BEGIN
    RETURN NEW (Prop.T).init (self, val);
  END BindName;

PROCEDURE <A NAME="MakeProxyName"><procedure>MakeProxyName</procedure></A> (self : Name) =
  BEGIN
    IF self.proxy = NIL AND NamePM # NIL THEN
      NamePM (self);
    END;
  END MakeProxyName;

PROCEDURE <A NAME="PushName"><procedure>PushName</procedure></A> (self : Name; state : GraphicsState.T; pv : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], Stack),
         val   = NARROW (pv, Val).val DO
      stack.push (val);
    END;
  END PushName;

PROCEDURE <A NAME="PopName"><procedure>PopName</procedure></A> (self : Name; state : GraphicsState.T) =
  BEGIN
    EVAL NARROW (state.stacks[self.id], Stack).pop ();
  END PopName;

PROCEDURE <A NAME="NewStack"><procedure>NewStack</procedure></A> (self : Name) : PropPrivate.Stack =
  BEGIN
    RETURN NEW (Stack).init (self.default);
  END NewStack;

PROCEDURE <A NAME="GetState"><procedure>GetState</procedure></A> (self: Name; state : GraphicsState.T) : Kind =
  BEGIN
    RETURN NARROW (state.stacks[self.id], Stack).top;
  END GetState;
</PRE>***************************************************************************
 Type <CODE>Val</CODE>                                                                
***************************************************************************

<P><PRE>REVEAL
  <A NAME="Val">Val</A> = PrivateVal BRANDED OBJECT
  OVERRIDES
    init     := InitVal;
    get      := GetVal;
    value    := ValueVal;
    adjust   := AdjustVal;
  END;

PROCEDURE <A NAME="InitVal"><procedure>InitVal</procedure></A> (self : Val; beh : Beh) : Val =
  BEGIN
    self.beh  := beh;
    self.time := Anim3D.Now () - 10.0d0;

    IF ValPM # NIL THEN
      ValPM (self);
    END;
    RETURN self;
  END InitVal;

PROCEDURE <A NAME="GetVal"><procedure>GetVal</procedure></A> (self : Val) : Kind RAISES {Prop.BadMethod} =
  BEGIN
    RETURN self.beh.value (Anim3D.Now ());
  END GetVal;

PROCEDURE <A NAME="ValueVal"><procedure>ValueVal</procedure></A> (self : Val; time : LONGREAL) : Kind
    RAISES {Prop.BadMethod} =
  BEGIN
    IF time = self.time THEN
      RETURN self.val;
    ELSE
      RETURN self.beh.value (time);
    END;
  END ValueVal;

PROCEDURE <A NAME="AdjustVal"><procedure>AdjustVal</procedure></A> (self : Val; time : LONGREAL) : BOOLEAN
    RAISES {Prop.BadMethod} =
  BEGIN
    IF time # self.time THEN
      WITH val = self.beh.value (time) DO
        self.damaged := val # self.val;
        self.time    := time;
        self.val     := val;
      END;
    END;
    RETURN self.damaged;
  END AdjustVal;
</PRE>***************************************************************************
 Type <CODE>Beh</CODE>                                                                
***************************************************************************

<P><PRE>REVEAL
  <A NAME="Beh">Beh</A> = PrivateBeh BRANDED OBJECT
  OVERRIDES
    init := InitBeh;
  END;

PROCEDURE <A NAME="InitBeh"><procedure>InitBeh</procedure></A> (self : Beh) : Beh =
  BEGIN
    RETURN self;
  END InitBeh;
</PRE>***************************************************************************
 Type <CODE>ConstBeh</CODE>                                                           
***************************************************************************

<P><PRE>REVEAL
  <A NAME="ConstBeh">ConstBeh</A> = PublicConstBeh BRANDED OBJECT
    kind : Kind;
  OVERRIDES
    init   := InitConstBeh;
    set    := SetConstBeh;
    value  := ValueConstBeh;
  END;

PROCEDURE <A NAME="InitConstBeh"><procedure>InitConstBeh</procedure></A> (self : ConstBeh; kind : Kind) : ConstBeh =
  BEGIN
    EVAL Beh.init (self);
    self.kind := kind;
    IF ConstBehPM # NIL THEN
      ConstBehPM (self);
    END;
    RETURN self;
  END InitConstBeh;

PROCEDURE <A NAME="SetConstBeh"><procedure>SetConstBeh</procedure></A> (self : ConstBeh; kind : Kind) =
  BEGIN
    self.kind := kind;
  END SetConstBeh;

PROCEDURE <A NAME="ValueConstBeh"><procedure>ValueConstBeh</procedure></A> (             self : ConstBeh;
                         &lt;* UNUSED *&gt; time : LONGREAL) : Kind =
  BEGIN
    RETURN self.kind;
  END ValueConstBeh;

PROCEDURE <A NAME="NewConst"><procedure>NewConst</procedure></A> (kind : Kind) : Val =
  BEGIN
    RETURN NEW (Val).init (NEW (ConstBeh).init (kind));
  END NewConst;
</PRE>***************************************************************************
 Type <CODE>AsyncBeh</CODE>                                                           
***************************************************************************

<P><PRE>REVEAL
  <A NAME="AsyncBeh">AsyncBeh</A> = PublicAsyncBeh BRANDED OBJECT
  OVERRIDES
    init    := InitAsyncBeh;
    value   := ValueAsyncBeh;
    compute := ComputeAsyncBeh;
  END;

PROCEDURE <A NAME="InitAsyncBeh"><procedure>InitAsyncBeh</procedure></A> (self : AsyncBeh) : AsyncBeh =
  BEGIN
    EVAL Beh.init (self);
    IF AsyncBehPM # NIL THEN
      AsyncBehPM (self);
    END;
    RETURN self;
  END InitAsyncBeh;

PROCEDURE <A NAME="ValueAsyncBeh"><procedure>ValueAsyncBeh</procedure></A> (self : AsyncBeh; time : LONGREAL) : Kind
    RAISES {Prop.BadMethod} =
  BEGIN
    RETURN self.compute (time);
  END ValueAsyncBeh;

PROCEDURE <A NAME="ComputeAsyncBeh"><procedure>ComputeAsyncBeh</procedure></A> (self : AsyncBeh; time : LONGREAL) : Kind
    RAISES {Prop.BadMethod} =
  BEGIN
    IF self.proxy # NIL THEN
      RETURN NARROW (self.proxy, AsyncBehProxy).compute (time);
    ELSE
      RAISE Prop.BadMethod(&quot;ShadingProp.AsyncBeh.compute method is undefined&quot;);
    END;
  END ComputeAsyncBeh;

PROCEDURE <A NAME="NewAsync"><procedure>NewAsync</procedure></A> (b : AsyncBeh) : Val =
  BEGIN
    RETURN NEW (Val).init (b);
  END NewAsync;
</PRE>***************************************************************************
 Type <CODE>DepBeh</CODE>                                                             
***************************************************************************

<P><PRE>REVEAL
  <A NAME="DepBeh">DepBeh</A> = PublicDepBeh BRANDED OBJECT
    hot : BOOLEAN;
  OVERRIDES
    init    := InitDepBeh;
    value   := ValueDepBeh;
    compute := ComputeDepBeh;
  END;

PROCEDURE <A NAME="InitDepBeh"><procedure>InitDepBeh</procedure></A> (self : DepBeh) : DepBeh =
  BEGIN
    EVAL Beh.init (self);
    self.hot := FALSE;
    IF DepBehPM # NIL THEN
      DepBehPM (self);
    END;
    RETURN self;
  END InitDepBeh;

PROCEDURE <A NAME="ValueDepBeh"><procedure>ValueDepBeh</procedure></A> (self : DepBeh; time : LONGREAL) : Kind
    RAISES {Prop.BadMethod} =
  BEGIN
    (* &quot;hot&quot; is set to true while the value of the behavior is computed.
       So, if &quot;hot&quot; is currently true, we have cyclic dependencies.
       If unchecked, this would lead to an infinite recursion.
       We raise an exception instead. *)
    IF self.hot THEN
      RAISE Prop.BadMethod(&quot;ShadingProp.DepBeh occurs in a dependency cycle&quot;);
    END;

    TRY
      self.hot := TRUE;
      RETURN self.compute (time);
    FINALLY
      self.hot := FALSE;
    END;
  END ValueDepBeh;

PROCEDURE <A NAME="ComputeDepBeh"><procedure>ComputeDepBeh</procedure></A> (self : DepBeh; time : LONGREAL) : Kind
    RAISES {Prop.BadMethod} =
  BEGIN
    IF self.proxy # NIL THEN
      RETURN NARROW (self.proxy, DepBehProxy).compute (time);
    ELSE
      RAISE Prop.BadMethod(&quot;ShadingProp.DepBeh.compute method is undefined&quot;);
    END;
  END ComputeDepBeh;

PROCEDURE <A NAME="NewDep"><procedure>NewDep</procedure></A> (b : DepBeh) : Val =
  BEGIN
    RETURN NEW (Val).init (b);
  END NewDep;
</PRE>***************************************************************************
 Type <CODE>SyncBeh</CODE>                                                            
***************************************************************************

<P><PRE>REVEAL
  <A NAME="SyncBeh">SyncBeh</A> = PublicSyncBeh BRANDED OBJECT
    queue : MyAnimRequestQueue;
  OVERRIDES
    init        := InitSyncBeh;
    value       := ValueSyncBeh;
    addRequest  := AddRequest;
    change      := Change;
  END;

PROCEDURE <A NAME="InitSyncBeh"><procedure>InitSyncBeh</procedure></A> (self : SyncBeh;
                       ah   : AnimHandle.T;
                       kind : Kind) : SyncBeh =
  BEGIN
    EVAL Beh.init (self);
    self.queue := NEW (MyAnimRequestQueue).init (ah, kind);

    IF SyncBehPM # NIL THEN
      SyncBehPM (self);
    END;
    RETURN self;
  END InitSyncBeh;

PROCEDURE <A NAME="ValueSyncBeh"><procedure>ValueSyncBeh</procedure></A> (self : SyncBeh; time : LONGREAL) : Kind
    RAISES {Prop.BadMethod} =
  BEGIN
    RETURN self.queue.value (time);
  END ValueSyncBeh;

PROCEDURE <A NAME="AddRequest"><procedure>AddRequest</procedure></A> (self : SyncBeh; r : Request) RAISES {Prop.BadInterval} =
  BEGIN
    self.queue.insert (r);
  END AddRequest;

PROCEDURE <A NAME="Change"><procedure>Change</procedure></A> (self : SyncBeh; kind : Kind; start : REAL)
    RAISES {Prop.BadInterval} =
  BEGIN
    self.queue.insert (NEW (ChangeReq).init (start, 0.0, kind));
  END Change;

PROCEDURE <A NAME="NewSync"><procedure>NewSync</procedure></A> (ah : AnimHandle.T; kind : Kind) : Val =
  BEGIN
    RETURN NEW (Val).init (NEW (SyncBeh).init (ah, kind));
  END NewSync;
</PRE>***************************************************************************
 Request Subtypes                                                          
***************************************************************************

<P>
<P><PRE>REVEAL
  <A NAME="Request">Request</A> = PublicRequest BRANDED OBJECT
  OVERRIDES
    init  := InitRequest;
    value := ValueRequest;
  END;

PROCEDURE <A NAME="InitRequest"><procedure>InitRequest</procedure></A> (self : Request; start, dur : REAL) : Request =
  BEGIN
    EVAL Prop.Request.init (self, start, dur);
    IF RequestPM # NIL THEN
      RequestPM (self);
    END;
    RETURN self;
  END InitRequest;

PROCEDURE <A NAME="ValueRequest"><procedure>ValueRequest</procedure></A> (self     : Request;
                        startval : Kind;
                        reltime  : REAL) : Kind RAISES {Prop.BadMethod} =
  BEGIN
    IF self.proxy # NIL THEN
      RETURN NARROW (self.proxy, RequestProxy).value (startval, reltime);
    ELSE
      RAISE Prop.BadMethod(&quot;ShadingProp.Request.value method is undefined&quot;);
    END;
  END ValueRequest;

TYPE
  ChangeReq = Request BRANDED OBJECT
    kind : Kind;
  METHODS
    init (start, dur : REAL; val : Kind) : ChangeReq := ChangeReqInit;
  OVERRIDES
    value := ChangeReqValue;
  END;

PROCEDURE <A NAME="ChangeReqInit"><procedure>ChangeReqInit</procedure></A> (self       : ChangeReq;
                         start, dur : REAL;
                         val        : Kind) : ChangeReq =
  BEGIN
    EVAL Request.init (self, start, dur);
    self.kind := val;
    RETURN self;
  END ChangeReqInit;

PROCEDURE <A NAME="ChangeReqValue"><procedure>ChangeReqValue</procedure></A> (             self      : ChangeReq;
                          &lt;* UNUSED *&gt; startkind : Kind;
                                       reltime   : REAL) : Kind =
  BEGIN
    &lt;* ASSERT reltime &gt;= self.start AND reltime &lt;= self.start + self.dur *&gt;
    RETURN self.kind;
  END ChangeReqValue;
</PRE>***************************************************************************
 Animation queue for synchronous shading property value behavior           
***************************************************************************

<P>
<P><PRE>TYPE
  MyAnimRequestQueue = AnimRequestQueue.T BRANDED OBJECT
    kind : Kind;  (* The initial value of the pv *)
  METHODS
    init (ah : AnimHandle.T; kind : Kind) : MyAnimRequestQueue
      := MyAnimRequestQueue_Init;
    value (time : LONGREAL) : Kind RAISES {Prop.BadMethod}
      := MyAnimRequestQueue_Value;
  OVERRIDES
    flush := MyAnimRequestQueue_Flush;
  END;

PROCEDURE <A NAME="MyAnimRequestQueue_Init"><procedure>MyAnimRequestQueue_Init</procedure></A> (self : MyAnimRequestQueue;
                                   ah   : AnimHandle.T;
                                   kind : Kind) : MyAnimRequestQueue =
  BEGIN
    EVAL AnimRequestQueue.T.init (self, ah);
    self.kind := kind;
    RETURN self;
  END MyAnimRequestQueue_Init;

PROCEDURE <A NAME="MyAnimRequestQueue_Value"><procedure>MyAnimRequestQueue_Value</procedure></A> (self : MyAnimRequestQueue;
                                    time : LONGREAL) : Kind
    RAISES {Prop.BadMethod} =
  VAR
    l       := self.list;
    req     : Request;
    kind    : Kind;
    reltime : REAL;
  BEGIN
    IF self.ah.activated THEN
      reltime := FLOAT (time - self.ah.starttime);
      kind := self.kind;
      WHILE l # NIL DO
        req := l.req;
        IF reltime &lt; req.start  THEN
          RETURN kind;
        ELSIF reltime &lt; req.start + req.dur THEN
          RETURN req.value (kind, reltime);
        ELSE
          kind := req.value (kind, req.start + req.dur);
          l := l.next;
        END;
      END;
      RETURN kind;
    ELSE
      RETURN self.kind;
    END;
  END MyAnimRequestQueue_Value;

PROCEDURE <A NAME="MyAnimRequestQueue_Flush"><procedure>MyAnimRequestQueue_Flush</procedure></A> (self : MyAnimRequestQueue) =
  VAR
    req : Request;
  BEGIN
    WHILE self.list # NIL DO
      req := self.list.req;
      TRY
        self.kind := req.value (self.kind, req.start + req.dur);
      EXCEPT
        Prop.BadMethod (msg) =&gt; AnimServer.ReportError (msg);
      END;
      self.list := self.list.next;
    END;
  END MyAnimRequestQueue_Flush;
</PRE>***************************************************************************
 Stack                                                                     
***************************************************************************

<P><PRE>REVEAL
  <A NAME="Stack">Stack</A> = PublicStack BRANDED OBJECT
    cnt  : INTEGER;
    vals : REF ARRAY OF Kind;
  METHODS
    init (top : Kind) : Stack := InitStack;
  OVERRIDES
    push := PushStack;
    pop  := PopStack;
  END;

PROCEDURE <A NAME="InitStack"><procedure>InitStack</procedure></A> (self : Stack; top : Kind) : Stack =
  BEGIN
    self.cnt  := 0;
    self.vals := NEW (REF ARRAY OF Kind, 10);
    self.top  := top;
    RETURN self;
  END InitStack;

PROCEDURE <A NAME="PushStack"><procedure>PushStack</procedure></A> (self : Stack; val : Kind) =
  BEGIN
    IF self.cnt &gt;= LAST (self.vals^) THEN
      WITH tmp = NEW (REF ARRAY OF Kind, 2 * NUMBER (self.vals^)) DO
        SUBARRAY (tmp^, 0, NUMBER (self.vals^)) := self.vals^;
        self.vals := tmp;
      END;
    END;
    self.vals[self.cnt] := self.top;
    self.top := val;
    INC (self.cnt);
  END PushStack;

PROCEDURE <A NAME="PopStack"><procedure>PopStack</procedure></A> (self : Stack) : Kind =
  BEGIN
    DEC (self.cnt);
    self.top := self.vals[self.cnt];
    RETURN self.top;
  END PopStack;

BEGIN
END ShadingProp.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
