<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/SphereGO.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/SphereGO.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P> A <CODE>SphereGO.T</CODE> is a geometric object describing a sphere. 

<P><PRE>INTERFACE <interface><A HREF="SphereGO.m3">SphereGO</A></interface>;

IMPORT <A HREF="GO.i3">GO</A>, <A HREF="Point3.i3">Point3</A>, <A HREF="PointProp.i3">PointProp</A>, <A HREF="RealProp.i3">RealProp</A>, <A HREF="SurfaceGO.i3">SurfaceGO</A>;

TYPE
  <A HREF="SphereGO.m3#T">T</A> &lt;: Public;
  Public = SurfaceGO.T OBJECT
  METHODS
    init (prec := 30) : T;
  END;
</PRE><BLOCKQUOTE><EM> <CODE>sph.init(prec)</CODE> initializes a new sphere <CODE>sph</CODE>, whose surface is composed
   of <CODE>prec</CODE> strips of <CODE>prec</CODE> triangles,  and returns it. The location and 
   radius of the sphere are determined by the two properties <CODE>Center</CODE> and 
   <CODE>Radius</CODE>. </EM></BLOCKQUOTE><PRE>

VAR
  Center : PointProp.Name;
  Radius : RealProp.Name;
</PRE> In addition to the properties observed by all \type{GO}{T}'s and
   \type{SurfaceGO}{T}'s, there are two additional properties that 
   are observed by <CODE>SphereGO.T</CODE>'s:
<P>
   <CODE>Center</CODE> is the name of a property that describes the center of the sphere.
   It associates with a \type{PointProp}{Val}. If no <CODE>Center</CODE> property
   is specified, the sphere is centered at the origin.
<P>
   <CODE>Radius</CODE> is the name of a property that describes the radius of the sphere.
   It associates with a \type{RealProp}{Val}. If no <CODE>Radius</CODE> property
   is specified, the sphere has a radius of 1. 

<P>
<P><PRE>PROCEDURE <A HREF="SphereGO.m3#New">New</A> (center : Point3.T; radius : REAL; prec := 30) : T;
</PRE><BLOCKQUOTE><EM> <CODE>New(center,radius,prec)</CODE> creates a new sphere, whose surface is composed of
   <CODE>prec</CODE> strips of <CODE>prec</CODE> triangles, and returns it. It also attaches the 
   following properties to the new sphere:
   \begin{verbatim}
     (Center,PointProp.NewConst(center))
     (Radius,RealProp.NewConst(radius))
   \end{verbatim}
</EM></BLOCKQUOTE><PRE>
</PRE> The following two procedures provide sugaring to attach 
   <CODE>Center</CODE> and <CODE>Radius</CODE> properties with non-animated 
   property values to geometric objects: 

<P><PRE>PROCEDURE <A HREF="SphereGO.m3#SetCenter">SetCenter</A> (o : GO.T; center : Point3.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetCenter(o,p)</CODE> is equivalent to
   <CODE>o.setProp(Center.bind(PointProp.NewConst(p))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SphereGO.m3#SetRadius">SetRadius</A> (o : GO.T; radius : REAL);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetRadius(o,r)</CODE>is equivalent to
   <CODE>o.setProp(Radius.bind(RealProp.NewConst(r)))</CODE>. </EM></BLOCKQUOTE><PRE>

END SphereGO.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
