<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/SphereGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/SphereGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P><PRE>MODULE <module>SphereGO</module> EXPORTS <A HREF="SphereGO.i3"><implements>SphereGO</A></implements>, <A HREF="SphereGOProxy.i3"><implements>SphereGOProxy</A></implements>;

IMPORT <A HREF="GO.i3">GO</A>, <A HREF="GOPrivate.i3">GOPrivate</A>, <A HREF="GraphicsState.i3">GraphicsState</A>, <A HREF="Matrix4.i3">Matrix4</A>, <A HREF="Point3.i3">Point3</A>, <A HREF="PointProp.i3">PointProp</A>,
       <A HREF="PointPropPrivate.i3">PointPropPrivate</A>, <A HREF="Prop.i3">Prop</A>, <A HREF="RealProp.i3">RealProp</A>, <A HREF="RealPropPrivate.i3">RealPropPrivate</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
    prec   : INTEGER;    (* desired precision *)
    matrix : Matrix4.T;  (* transforms unit sphere into desired sphere *)
    center : Point3.T;   (* center achieved through matrix *)
    radius : REAL;       (* radius achieved through matrix *)
  OVERRIDES
    init              := Init;
    draw              := Draw;
    damageIfDependent := DamageIfDependent;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>(self : T; prec : INTEGER) : T =
  BEGIN
    EVAL GO.T.init (self);
    self.prec   := prec;
    self.matrix := Matrix4.Id;
    self.center := Point3.Origin;
    self.radius := 1.0;

   IF MkProxyT # NIL AND self.proxy = NIL THEN
      MkProxyT (self);
    END;

    RETURN self;
  END Init;

PROCEDURE <A NAME="DamageIfDependent"><procedure>DamageIfDependent</procedure></A> (self : T; pn : Prop.Name) =
  BEGIN
    IF pn = Center OR pn = Radius THEN
      self.damaged := TRUE;
    END;
  END DamageIfDependent;

PROCEDURE <A NAME="Draw"><procedure>Draw</procedure></A> (self : T; state : GraphicsState.T) =
  BEGIN
    state.push (self);
    WITH center = Center.getState (state),
         radius = Radius.getState (state) DO

      IF center # self.center OR radius # self.radius THEN
        self.center := center;
        self.radius := radius;
        self.matrix := Matrix4.Scale (Matrix4.Id, radius, radius, radius);
        self.matrix := Matrix4.Translate (self.matrix,
                                          center.x, center.y, center.z);
      END;

      state.pushMatrix (self.matrix);
      state.drawProtoSphere (self.prec);
      state.popMatrix ();
      state.growBoundingVolume (center, radius);
    END;

    self.damaged := FALSE;
    state.pop (self);
  END Draw;
</PRE>***************************************************************************
 Convenience Procedures                                                    
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="New"><procedure>New</procedure></A> (center : Point3.T; radius : REAL; prec : INTEGER) : T =
  VAR
    sphere := NEW (T).init (prec);
  BEGIN
    SetCenter (sphere, center);
    SetRadius (sphere, radius);
    RETURN sphere;
  END New;

PROCEDURE <A NAME="SetCenter"><procedure>SetCenter</procedure></A> (o : GO.T; v : Point3.T) =
  BEGIN
    o.setProp (Center.bind (PointProp.NewConst (v)));
  END SetCenter;

PROCEDURE <A NAME="SetRadius"><procedure>SetRadius</procedure></A> (o : GO.T; v : REAL) =
  BEGIN
    o.setProp (Radius.bind (RealProp.NewConst (v)));
  END SetRadius;

BEGIN
  Center := NEW (PointProp.Name).init (Point3.T {0.0, 0.0, 0.0});
  Radius := NEW (RealProp.Name).init (1.0);
END SphereGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
