<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/SpotLightGO.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/SpotLightGO.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Fri Feb  4 15:33:05 PST 1994 by najork                   

<P> A <CODE>SpotLightGO.T</CODE> is a geometric object that describes a light source which
   is emitting a cone of colored light.
<P>
   The amount of light that falls onto another geometric object depends on the 
   distance between this object and the light source. This phenomenon is 
   referred to as {\em attenuation}. Refer to the description of the 
   \interface{PointLightGO} interface for details.
<P>
   The geometry of the light cone is described by three parameters: 
   The location or {\em origin} of the light source (i.e.\ the tip of the
   cone), the direction vector (going out of the center of the cone),
   and $\alpha$, the angle between the center vector of the cone and 
   its walls. 
<P>
   The concentration $\gamma$ describes how the light intensity is distributed
   within the cone. By definition, the intensity in the center of the cone is
   1. Let $\beta$ be the angle between a particular ray of light within the 
   cone and the center of the cone. Then the intensity of this ray is 
   ${\rm cos}^\gamma(\beta)$. So, if $\gamma$ is 0, the intensity is uniform 
   all over the cone (modulo attenuation). 

<P><PRE>INTERFACE <interface><A HREF="SpotLightGO.m3">SpotLightGO</A></interface>;

IMPORT <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="GO.i3">GO</A>, <A HREF="LightGO.i3">LightGO</A>, <A HREF="PointProp.i3">PointProp</A>, <A HREF="Point3.i3">Point3</A>, <A HREF="RealProp.i3">RealProp</A>;

TYPE
  <A HREF="SpotLightGO.m3#T">T</A> &lt;: Public;
  Public = LightGO.T OBJECT
  METHODS
    init () : T;
  END;
</PRE><BLOCKQUOTE><EM> <CODE>l.init()</CODE> initializes a new spot light source <CODE>l</CODE> and returns it. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SpotLightGO.m3#New">New</A> (c : Color.T;  orig, dir : Point3.T;
               conc, spread, att0, att1 : REAL) : T;
</PRE><BLOCKQUOTE><EM> <CODE>l.init(c,orig,dir,conc,spread,att0,att1)</CODE> initializes a new spot light 
   source <CODE>l</CODE> and returns it. It also attaches the following properties to <CODE>l</CODE>:
   \begin{verbatim}
      (LightGO.Colour,ColourProp.NewConst(c)) 
      (LightGO.Switch,BooleanProp.NewConst(TRUE))
      (Origin,PointProp.NewConst(dir))
      (Direction,PointProp.NewConst(dir))
      (Concentration,RealProp.NewConst(conc))
      (SpreadAngle,RealProp.NewConst(spread))
      (Attenuation0,RealProp.NewConst(att0))
      (Attenuation1,RealProp.NewConst(att1))
   \end{verbatim}
</EM></BLOCKQUOTE><PRE>

VAR
  Origin        : PointProp.Name;
  Direction     : PointProp.Name;
  Concentration : RealProp.Name;
  SpreadAngle   : RealProp.Name;
  Attenuation0  : RealProp.Name;
  Attenuation1  : RealProp.Name;
</PRE><BLOCKQUOTE><EM> In addition to the properties observed by all \type{GO}{T}'s and 
   \type{LightGO}{T}'s, there are six additional properties that are 
   observed by <CODE>SpotLightGO.T</CODE>'s. 
<P>
   <CODE>Origin</CODE> is the name of a property that determines the origin 
   of the light emitted by the light sources; it associates with a property 
   value of type \type{PointProp}{Val}. 
<P>
   <CODE>Direction</CODE> is the name of a property that determines the direction 
   of the light emitted by the light sources; it associates with a property 
   value of type \type{PointProp}{Val}. 
   <P>
   <CODE>Concentration</CODE> is a property that determines the intensity distribution 
   within the light cone emitted by the spot light; it associates with a 
   property value of type \type{RealProp}{Val}. 
<P>
   <CODE>SpreadAngle</CODE> is a property that determines the angle (in radians) between 
   the center of the light cone and its walls; it associates with a property 
   value of type \type{RealProp}{Val}. 
<P>
   <CODE>Attenuation0</CODE> is the name of a property that determines the constant 
   attenuation coefficient $C_0$; it associates with a property value of type 
   \type{RealProp}{Val}. 
<P>
   <CODE>Attenuation1</CODE> is the name of a property that determines the linear
   attenuation coefficient $C_1$; it associates with a property value of type 
   \type{RealProp}{Val}. 
</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SpotLightGO.m3#SetOrigin">SetOrigin</A> (o : GO.T; origin : Point3.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetOrigin(o,origin)</CODE> is equivalent to 
   <CODE>o.setProp(Origin.bind(PointProp.NewConst(origin)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SpotLightGO.m3#SetDirection">SetDirection</A> (o : GO.T; dir : Point3.T);
</PRE><BLOCKQUOTE><EM> <CODE>SetDirection</CODE> is a convenience procedure. The expression 
   <CODE>SetDirection(o,dir)</CODE> is equivalent to 
   <CODE>o.setProp(Direction.bind(PointProp.NewConst(dir)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SpotLightGO.m3#SetConcentration">SetConcentration</A> (o : GO.T; conc : REAL);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetConcentration(o,conc)</CODE> is equivalent to 
   <CODE>o.setProp(Concentration.bind(RealProp.NewConst(conc)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SpotLightGO.m3#SetSpreadAngle">SetSpreadAngle</A> (o : GO.T; spread : REAL);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetSpreadAngle(o,spread)</CODE> is equivalent to 
   <CODE>o.setProp(SpreadAngle.bind(RealProp.NewConst(spread)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SpotLightGO.m3#SetAttenuation0">SetAttenuation0</A> (o : GO.T; att : REAL);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetAttenuation1(o,att)</CODE> is equivalent to 
   <CODE>o.setProp(Attenuation0.bind(RealProp.NewConst(att)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SpotLightGO.m3#SetAttenuation1">SetAttenuation1</A> (o : GO.T; att : REAL);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetAttenuation0(o,att)</CODE> is equivalent to 
   <CODE>o.setProp(Attenuation1.bind(RealProp.NewConst(att)))</CODE>. </EM></BLOCKQUOTE><PRE>

END SpotLightGO.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
