<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/SurfaceGO.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/SurfaceGO.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P> A <CODE>SurfaceGO.T</CODE> is a geometric objects which is composed of surfaces
   (as opposed to lines). Surfaces differ from non-surfaces in a number of 
   ways:
   \begin{itemize}
   \item Surfaces interact with light sources, non-surfaces don't
   \item Surfaces can be transparent, non-surfaces are always opaque
   \end{itemize}


<P><PRE>INTERFACE <interface><A HREF="SurfaceGO.m3">SurfaceGO</A></interface>;

IMPORT <A HREF="BooleanProp.i3">BooleanProp</A>, <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="ColorProp.i3">ColorProp</A>, <A HREF="GO.i3">GO</A>, <A HREF="LineTypeProp.i3">LineTypeProp</A>, <A HREF="RasterModeProp.i3">RasterModeProp</A>,
       <A HREF="RealProp.i3">RealProp</A>, <A HREF="ShadingProp.i3">ShadingProp</A>;

TYPE <A HREF="SurfaceGO.m3#T">T</A> &lt;: GO.T;
</PRE><BLOCKQUOTE><EM> A <CODE>SurfaceGO.T</CODE> is a subtype of \type{GO}{T}. No additional fields or 
   methods are revealed to the user. </EM></BLOCKQUOTE><PRE>

VAR
  DistinguishFacets        : BooleanProp.Name;
  Colour                   : ColorProp.Name;
  RasterMode               : RasterModeProp.Name;
  AmbientReflectionCoeff   : RealProp.Name;
  DiffuseReflectionCoeff   : RealProp.Name;
  SpecularReflectionCoeff  : RealProp.Name;
  SpecularReflectionConc   : RealProp.Name;
  TransmissionCoeff        : RealProp.Name;
  SpecularReflectionColour : ColorProp.Name;
  Lighting                 : BooleanProp.Name;
  Shading                  : ShadingProp.Name;
  EdgeVisibility           : BooleanProp.Name;
  EdgeColour               : ColorProp.Name;
  EdgeType                 : LineTypeProp.Name;
  EdgeWidth                : RealProp.Name;
</PRE> In addition to the properties observed by all \type{GO}{T}'s, there are 
   various additional properties that are observed by <CODE>SurfaceGO.T</CODE>'s:
<P>
   <CODE>DistinguishFacets</CODE> is the name of a boolean property that decides whether 
   front- and back-faces of surfaces should be distinguished. If this property
   is not specified, front- and back-faces are not distinguished. 
<P>
   {\em NOTE: In order for this property to make sense, I should introduce
   other surface-related properties: All properties from <CODE>Colour</CODE> to
   <CODE>Shading</CODE> could have backface analogs.}
<P>
   <CODE>Color</CODE> is the name of a color property that specifies the color of the 
   surface. If this property is not specified, the surface is drawn in white.
<P>
   <CODE>RasterMode</CODE> is the name of an raster mode property that specifies what 
   rasterization technique is used to draw the surface (solid, hollow, or 
   empty). If this property is not specified, the surface is drawn solid.
<P>
   <CODE>AmbientReflectionCoeff</CODE> is the name of a real property that specifies the
   ambient reflection coefficient of the surface. If this property is not 
   specified, the ambient reflection coefficient is taken to be 0.5.
<P>
   <CODE>DiffuseReflectionCoeff</CODE> is the name of a real property that specifies the
   diffuse reflection coefficient of the surface. If this property is not 
   specified, the diffuse reflection coefficient is taken to be 1.
<P>
   <CODE>SpecularReflectionCoeff</CODE> is the name of a real property that specifies the
   specular reflection coefficient of the surface. If this property is not 
   specified, the specular reflection coefficient is taken to be 0.
<P>
   <CODE>SpecularReflectionConc</CODE> is the name of a real property that specifies the 
   specular reflection concentration of the surface. If this property is not
   specified, the specular reflection concentration is taken to be 0.
<P>
   <CODE>TransmissionCoeff</CODE> is the name of a real property that specifies the 
   transparency of the surface (with 0 being completely opaque and 1 being 
   completely transparent). If this property is not specified, the 
   transmission coefficient is taken to be 0.
<P>
   <CODE>SpecularReflectionColour</CODE> is the name of a color property that specifies 
   the color of specular reflected light. If this property is not specified, 
   the specular reflection color is taken to be white.
<P>
   <CODE>Lighting</CODE> is the name of a boolean property that decides whether or not 
   lighting and shading computations shall be performed. If this property is 
   not specified, lighting and shading computations are performed.
<P>
   <CODE>Shading</CODE> is the name of a shading property that specifies what shading 
   method shall be used. If this property is not specified, flat shading is 
   used.
<P>
   <CODE>EdgeVisibility</CODE> is the name of a boolean property that specifies whether
   or not the edges of the individual polygons of the surface shall be 
   outlined. If this property is not specified, no surface edges will be drawn.
<P>
   <CODE>EdgeColour</CODE> is the name of a color property that determines the color
   of the surface edges (if they are visible). If this property is not 
   specified and edges are visible, they are drawn in white.
<P>
   <CODE>EdgeType</CODE> is the name of a line type property that determines the line
   type of the surface edges (provided they are visible). If this property 
   is not specified and edges are visible, they are drawn solid.
<P>
   <CODE>EdgeWidth</CODE> is the name of a real property that determines the width of the 
   surface edges (provided they are visible). If this property is not specified
   and edges are visible, they are drawn with a width of 1. 
<P>
   The following procedures provide sugaring to attach surface-related 
   properties to geometric objects: 

<P><PRE>PROCEDURE <A HREF="SurfaceGO.m3#SetDistinguishFacets">SetDistinguishFacets</A> (o : GO.T; v : BOOLEAN);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetDistinguishFacets(o,v)</CODE> is equivalent to
   <CODE>o.setProp(DistinguishFacets.bind(BooleanProp.NewConst(v)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SurfaceGO.m3#SetColour">SetColour</A> (o : GO.T; v : Color.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetColour(o,v)</CODE> is equivalent to
   <CODE>o.setProp(Colour.bind(ColorProp.NewConst(v)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SurfaceGO.m3#SetRasterMode">SetRasterMode</A> (o : GO.T; v : RasterModeProp.Kind);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetRasterMode(o,v)</CODE> is equivalent to
   <CODE>o.setProp(RasterMode.bind(RasterModeProp.NewConst(v)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SurfaceGO.m3#SetAmbientReflectionCoeff">SetAmbientReflectionCoeff</A> (o : GO.T; v : REAL);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetAmbientReflectionCoeff(o,v)</CODE> is equivalent to
   <CODE>o.setProp(AmbientReflectionCoeff.bind(RealProp.NewConst(v)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SurfaceGO.m3#SetDiffuseReflectionCoeff">SetDiffuseReflectionCoeff</A> (o : GO.T; v : REAL);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetDiffuseReflectionCoeff(o,v)</CODE> is equivalent to
   <CODE>o.setProp(DiffuseReflectionCoeff.bind(RealProp.NewConst(v)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SurfaceGO.m3#SetSpecularReflectionCoeff">SetSpecularReflectionCoeff</A> (o : GO.T; v : REAL);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetSpecularReflectionCoeff(o,v)</CODE> is equivalent to
   <CODE>o.setProp(SpecularReflectionCoeff.bind(RealProp.NewConst(v)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SurfaceGO.m3#SetSpecularReflectionConc">SetSpecularReflectionConc</A> (o : GO.T; v : REAL);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetSpecularReflectionConc(o,v)</CODE> is equivalent to
   <CODE>o.setProp(SpecularReflectionConc.bind(RealProp.NewConst(v)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SurfaceGO.m3#SetTransmissionCoeff">SetTransmissionCoeff</A> (o : GO.T; v : REAL);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetTransmissionCoeff(o,v)</CODE> is equivalent to
   <CODE>o.setProp(TransmissionCoeff.bind(RealProp.NewConst(v)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SurfaceGO.m3#SetSpecularReflectionColour">SetSpecularReflectionColour</A> (o : GO.T; v : Color.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetSpecularReflectionColour(o,v)</CODE> is equivalent to
   <CODE>o.setProp(SpecularReflectionColour.bind(ColorProp.NewConst(v)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SurfaceGO.m3#SetLighting">SetLighting</A> (o : GO.T; v : BOOLEAN);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetLighting(o,v)</CODE> is equivalent to
   <CODE>o.setProp(Lighting.bind(BooleanProp.NewConst(v)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SurfaceGO.m3#SetShading">SetShading</A> (o : GO.T; v : ShadingProp.Kind);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetShading(o,v)</CODE> is equivalent to
   <CODE>o.setProp(Shading.bind(ShadingProp.NewConst(v)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SurfaceGO.m3#SetEdgeVisibility">SetEdgeVisibility</A> (o : GO.T; v : BOOLEAN);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetEdgeVisibility(o,v)</CODE> is equivalent to
   <CODE>o.setProp(EdgeVisibility.bind(BooleanProp.NewConst(v)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SurfaceGO.m3#SetEdgeColour">SetEdgeColour</A> (o : GO.T; v : Color.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetEdgeColour(o,v)</CODE> is equivalent to
   <CODE>o.setProp(EdgeColour.bind(ColorProp.NewConst(v)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SurfaceGO.m3#SetEdgeType">SetEdgeType</A> (o : GO.T; v : LineTypeProp.Kind);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetEdgeType(o,v)</CODE> is equivalent to
   <CODE>o.setProp(EdgeType.bind(LineTypeProp.NewConst(v)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SurfaceGO.m3#SetEdgeWidth">SetEdgeWidth</A> (o : GO.T; v : REAL);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetEdgeWidth(o,v)</CODE> is equivalent to
   <CODE>o.setProp(EdgeWidth.bind(RealProp.NewConst(v)))</CODE>. </EM></BLOCKQUOTE><PRE>

END SurfaceGO.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
