<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/SurfaceGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/SurfaceGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P><PRE>MODULE <module><implements><A HREF="SurfaceGO.i3">SurfaceGO</A></implements></module>;

IMPORT <A HREF="BooleanProp.i3">BooleanProp</A>, <A HREF="BooleanPropPrivate.i3">BooleanPropPrivate</A>, <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="ColorProp.i3">ColorProp</A>, <A HREF="ColorPropPrivate.i3">ColorPropPrivate</A>,
       <A HREF="GO.i3">GO</A>, <A HREF="GOPrivate.i3">GOPrivate</A>, <A HREF="GraphicsState.i3">GraphicsState</A>, <A HREF="GraphicsStatePrivate.i3">GraphicsStatePrivate</A>, <A HREF="LineTypeProp.i3">LineTypeProp</A>,
       <A HREF="LineTypePropPrivate.i3">LineTypePropPrivate</A>, <A HREF="Prop.i3">Prop</A>, <A HREF="PropPrivate.i3">PropPrivate</A>, <A HREF="RasterModeProp.i3">RasterModeProp</A>,
       <A HREF="RasterModePropPrivate.i3">RasterModePropPrivate</A>, <A HREF="RealProp.i3">RealProp</A>, <A HREF="RealPropPrivate.i3">RealPropPrivate</A>, <A HREF="ShadingProp.i3">ShadingProp</A>,
       <A HREF="ShadingPropPrivate.i3">ShadingPropPrivate</A>;

REVEAL
  <A NAME="T">T</A> = GO.T BRANDED OBJECT
  OVERRIDES
    needsTransparency := NeedsTransparency;
  END;

PROCEDURE <A NAME="NeedsTransparency"><procedure>NeedsTransparency</procedure></A> (self : T; t : REAL) : BOOLEAN =
  BEGIN
    IF self.trans # FIRST(REAL) THEN
      t := self.trans;
    END;
    RETURN t &gt; 0.0;
  END NeedsTransparency;
</PRE>***************************************************************************
 DistinguishFacets_PN                                                      
***************************************************************************

<P><PRE>TYPE
  DistinguishFacets_PN = BooleanProp.Name OBJECT
  OVERRIDES
    damage := DamageDistinguishFacets;
    push   := PushDistinguishFacets;
    pop    := PopDistinguishFacets;
  END;

PROCEDURE <A NAME="DamageDistinguishFacets"><procedure>DamageDistinguishFacets</procedure></A> (&lt;* UNUSED *&gt; self   : DistinguishFacets_PN;
                                                caller : GO.T) =
  BEGIN
    caller.damaged := TRUE;
  END DamageDistinguishFacets;

PROCEDURE <A NAME="PushDistinguishFacets"><procedure>PushDistinguishFacets</procedure></A> (self  : DistinguishFacets_PN;
                                 state : GraphicsState.T;
                                 pv    : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], BooleanPropPrivate.Stack),
         val   = NARROW (pv, BooleanProp.Val).val DO
      IF stack.top # val THEN
        state.setDistinguishFacetsFlag (val);
      END;
      stack.push (val);
    END;
  END PushDistinguishFacets;

PROCEDURE <A NAME="PopDistinguishFacets"><procedure>PopDistinguishFacets</procedure></A> (self  : DistinguishFacets_PN;
                                state : GraphicsState.T) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], BooleanPropPrivate.Stack) DO
      state.setDistinguishFacetsFlag (stack.pop ());
    END;
  END PopDistinguishFacets;
</PRE>***************************************************************************
 Colour_PN                                                                 
***************************************************************************

<P><PRE>TYPE
  Colour_PN = ColorProp.Name OBJECT
  OVERRIDES
    damage := DamageColour;
    push   := PushColour;
    pop    := PopColour;
  END;

PROCEDURE <A NAME="DamageColour"><procedure>DamageColour</procedure></A> (&lt;* UNUSED *&gt; self : Colour_PN; caller : GO.T) =
  BEGIN
    caller.damaged := TRUE;
  END DamageColour;

PROCEDURE <A NAME="PushColour"><procedure>PushColour</procedure></A> (self  : Colour_PN;
                      state : GraphicsState.T;
                      pv    : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], ColorPropPrivate.Stack),
         val   = NARROW (pv, ColorProp.Val).val DO
      IF stack.top # val THEN
        state.setSurfaceColor (val);
      END;
      stack.push (val);
    END;
  END PushColour;

PROCEDURE <A NAME="PopColour"><procedure>PopColour</procedure></A> (self  : Colour_PN;
                     state : GraphicsState.T) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], ColorPropPrivate.Stack) DO
      state.setSurfaceColor (stack.pop ());
    END;
  END PopColour;
</PRE>***************************************************************************
 RasterMode_PN                                                             
***************************************************************************

<P><PRE>TYPE
  RasterMode_PN = RasterModeProp.Name OBJECT
  OVERRIDES
    damage := DamageRasterMode;
    push   := PushRasterMode;
    pop    := PopRasterMode;
  END;

PROCEDURE <A NAME="DamageRasterMode"><procedure>DamageRasterMode</procedure></A> (&lt;* UNUSED *&gt; self   : RasterMode_PN;
                                         caller : GO.T) =
  BEGIN
    caller.damaged := TRUE;
  END DamageRasterMode;

PROCEDURE <A NAME="PushRasterMode"><procedure>PushRasterMode</procedure></A> (self  : RasterMode_PN;
                          state : GraphicsState.T;
                          pv    : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], RasterModePropPrivate.Stack),
         val   = NARROW (pv, RasterModeProp.Val).val DO
      IF stack.top # val THEN
        state.setRasterMode (val);
      END;
      stack.push (val);
    END;
  END PushRasterMode;

PROCEDURE <A NAME="PopRasterMode"><procedure>PopRasterMode</procedure></A> (self  : RasterMode_PN;
                         state : GraphicsState.T) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], RasterModePropPrivate.Stack) DO
      state.setRasterMode (stack.pop ());
    END;
  END PopRasterMode;
</PRE>***************************************************************************
 AmbientReflectionCoeff_PN                                                 
***************************************************************************

<P><PRE>TYPE
  AmbientReflectionCoeff_PN = RealProp.Name OBJECT
  OVERRIDES
    damage := DamageAmbientReflectionCoeff;
    push   := PushAmbientReflectionCoeff;
    pop    := PopAmbientReflectionCoeff;
  END;

PROCEDURE <A NAME="DamageAmbientReflectionCoeff"><procedure>DamageAmbientReflectionCoeff</procedure></A> (
    &lt;* UNUSED *&gt; self   : AmbientReflectionCoeff_PN;
                 caller : GO.T) =
  BEGIN
    caller.damaged := TRUE;
  END DamageAmbientReflectionCoeff;

PROCEDURE <A NAME="PushAmbientReflectionCoeff"><procedure>PushAmbientReflectionCoeff</procedure></A> (self  : AmbientReflectionCoeff_PN;
                                      state : GraphicsState.T;
                                      pv    : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], RealPropPrivate.Stack),
         val   = NARROW (pv, RealProp.Val).val DO
      IF stack.top # val THEN
        state.setAmbientReflCoeff (val);
      END;
      stack.push (val);
    END;
  END PushAmbientReflectionCoeff;

PROCEDURE <A NAME="PopAmbientReflectionCoeff"><procedure>PopAmbientReflectionCoeff</procedure></A> (self  : AmbientReflectionCoeff_PN;
                                     state : GraphicsState.T) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], RealPropPrivate.Stack) DO
      state.setAmbientReflCoeff (stack.pop ());
    END;
  END PopAmbientReflectionCoeff;
</PRE>***************************************************************************
 DiffuseReflectionCoeff_PN                                                 
***************************************************************************

<P><PRE>TYPE
  DiffuseReflectionCoeff_PN = RealProp.Name OBJECT
  OVERRIDES
    damage := DamageDiffuseReflectionCoeff;
    push   := PushDiffuseReflectionCoeff;
    pop    := PopDiffuseReflectionCoeff;
  END;

PROCEDURE <A NAME="DamageDiffuseReflectionCoeff"><procedure>DamageDiffuseReflectionCoeff</procedure></A> (
    &lt;* UNUSED *&gt; self   : DiffuseReflectionCoeff_PN;
                 caller : GO.T) =
  BEGIN
    caller.damaged := TRUE;
  END DamageDiffuseReflectionCoeff;

PROCEDURE <A NAME="PushDiffuseReflectionCoeff"><procedure>PushDiffuseReflectionCoeff</procedure></A> (self  : DiffuseReflectionCoeff_PN;
                                      state : GraphicsState.T;
                                      pv    : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], RealPropPrivate.Stack),
         val   = NARROW (pv, RealProp.Val).val DO
      IF stack.top # val THEN
        state.setDiffuseReflCoeff (val);
      END;
      stack.push (val);
    END;
  END PushDiffuseReflectionCoeff;

PROCEDURE <A NAME="PopDiffuseReflectionCoeff"><procedure>PopDiffuseReflectionCoeff</procedure></A> (self  : DiffuseReflectionCoeff_PN;
                                     state : GraphicsState.T) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], RealPropPrivate.Stack) DO
      state.setDiffuseReflCoeff (stack.pop ());
    END;
  END PopDiffuseReflectionCoeff;
</PRE>***************************************************************************
 SpecularReflectionCoeff_PN                                                
***************************************************************************

<P><PRE>TYPE
  SpecularReflectionCoeff_PN = RealProp.Name OBJECT
  OVERRIDES
    damage := DamageSpecularReflectionCoeff;
    push   := PushSpecularReflectionCoeff;
    pop    := PopSpecularReflectionCoeff;
  END;

PROCEDURE <A NAME="DamageSpecularReflectionCoeff"><procedure>DamageSpecularReflectionCoeff</procedure></A> (
    &lt;* UNUSED *&gt; self   : SpecularReflectionCoeff_PN;
                 caller : GO.T) =
  BEGIN
    caller.damaged := TRUE;
  END DamageSpecularReflectionCoeff;

PROCEDURE <A NAME="PushSpecularReflectionCoeff"><procedure>PushSpecularReflectionCoeff</procedure></A> (self  : SpecularReflectionCoeff_PN;
                                       state : GraphicsState.T;
                                       pv    : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], RealPropPrivate.Stack),
         val   = NARROW (pv, RealProp.Val).val DO
      IF stack.top # val THEN
        state.setSpecularReflCoeff (val);
      END;
      stack.push (val);
    END;
  END PushSpecularReflectionCoeff;

PROCEDURE <A NAME="PopSpecularReflectionCoeff"><procedure>PopSpecularReflectionCoeff</procedure></A> (self  : SpecularReflectionCoeff_PN;
                                      state : GraphicsState.T) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], RealPropPrivate.Stack) DO
      state.setSpecularReflCoeff (stack.pop ());
    END;
  END PopSpecularReflectionCoeff;
</PRE>***************************************************************************
 SpecularReflectionConcPN                                                  
***************************************************************************

<P><PRE>TYPE
  SpecularReflectionConcPN = RealProp.Name OBJECT
  OVERRIDES
    damage := DamageSpecularReflectionConc;
    push   := PushSpecularReflectionConc;
    pop    := PopSpecularReflectionConc;
  END;

PROCEDURE <A NAME="DamageSpecularReflectionConc"><procedure>DamageSpecularReflectionConc</procedure></A> (
    &lt;* UNUSED *&gt; self   : SpecularReflectionConcPN;
                 caller : GO.T) =
  BEGIN
    caller.damaged := TRUE;
  END DamageSpecularReflectionConc;

PROCEDURE <A NAME="PushSpecularReflectionConc"><procedure>PushSpecularReflectionConc</procedure></A> (self  : SpecularReflectionConcPN;
                                      state : GraphicsState.T;
                                      pv    : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], RealPropPrivate.Stack),
         val   = NARROW (pv, RealProp.Val).val DO
      IF stack.top # val THEN
        state.setSpecularReflConc (val);
      END;
      stack.push (val);
    END;
  END PushSpecularReflectionConc;

PROCEDURE <A NAME="PopSpecularReflectionConc"><procedure>PopSpecularReflectionConc</procedure></A> (self  : SpecularReflectionConcPN;
                                     state : GraphicsState.T) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], RealPropPrivate.Stack) DO
      state.setSpecularReflConc (stack.pop ());
    END;
  END PopSpecularReflectionConc;
</PRE>***************************************************************************
 TransmissionCoeff_PN                                                      
***************************************************************************

<P><PRE>TYPE
  TransmissionCoeff_PN = RealProp.Name OBJECT
  OVERRIDES
    damage := DamageTransmissionCoeff;
    push   := PushTransmissionCoeff;
    pop    := PopTransmissionCoeff;
  END;

PROCEDURE <A NAME="DamageTransmissionCoeff"><procedure>DamageTransmissionCoeff</procedure></A> (
    &lt;* UNUSED *&gt; self   : TransmissionCoeff_PN;
                 caller : GO.T) =
  BEGIN
    caller.damaged := TRUE;
  END DamageTransmissionCoeff;

PROCEDURE <A NAME="PushTransmissionCoeff"><procedure>PushTransmissionCoeff</procedure></A> (self  : TransmissionCoeff_PN;
                                 state : GraphicsState.T;
                                 pv    : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], RealPropPrivate.Stack),
         val   = NARROW (pv, RealProp.Val).val DO
      IF stack.top # val THEN
        state.setTransmissionCoeff (val);
      END;
      stack.push (val);
    END;
  END PushTransmissionCoeff;

PROCEDURE <A NAME="PopTransmissionCoeff"><procedure>PopTransmissionCoeff</procedure></A> (self  : TransmissionCoeff_PN;
                                state : GraphicsState.T) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], RealPropPrivate.Stack) DO
      state.setTransmissionCoeff (stack.pop ());
    END;
  END PopTransmissionCoeff;
</PRE>***************************************************************************
 SpecularReflectionColour_PN                                               
***************************************************************************

<P><PRE>TYPE
  SpecularReflectionColour_PN = ColorProp.Name OBJECT
  OVERRIDES
    damage := DamageSpecularReflectionColour;
    push   := PushSpecularReflectionColour;
    pop    := PopSpecularReflectionColour;
  END;

PROCEDURE <A NAME="DamageSpecularReflectionColour"><procedure>DamageSpecularReflectionColour</procedure></A> (
    &lt;* UNUSED *&gt; self   : SpecularReflectionColour_PN;
                 caller : GO.T) =
  BEGIN
    caller.damaged := TRUE;
  END DamageSpecularReflectionColour;

PROCEDURE <A NAME="PushSpecularReflectionColour"><procedure>PushSpecularReflectionColour</procedure></A> (self  : SpecularReflectionColour_PN;
                                        state : GraphicsState.T;
                                        pv    : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], ColorPropPrivate.Stack),
         val   = NARROW (pv, ColorProp.Val).val DO
      IF stack.top # val THEN
        state.setSpecularReflColor (val);
      END;
      stack.push (val);
    END;
  END PushSpecularReflectionColour;

PROCEDURE <A NAME="PopSpecularReflectionColour"><procedure>PopSpecularReflectionColour</procedure></A> (self  : SpecularReflectionColour_PN;
                                       state : GraphicsState.T) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], ColorPropPrivate.Stack) DO
      state.setSpecularReflColor (stack.pop ());
    END;
  END PopSpecularReflectionColour;
</PRE>***************************************************************************
 Lighting_PN                                                               
***************************************************************************

<P><PRE>TYPE
  Lighting_PN = BooleanProp.Name OBJECT
  OVERRIDES
    damage := DamageLighting;
    push   := PushLighting;
    pop    := PopLighting;
  END;

PROCEDURE <A NAME="DamageLighting"><procedure>DamageLighting</procedure></A> (&lt;* UNUSED *&gt; self   : Lighting_PN;
                                              caller : GO.T) =
  BEGIN
    caller.damaged := TRUE;
  END DamageLighting;

PROCEDURE <A NAME="PushLighting"><procedure>PushLighting</procedure></A> (self  : Lighting_PN;
                               state : GraphicsState.T;
                               pv    : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], BooleanPropPrivate.Stack),
         val   = NARROW (pv, BooleanProp.Val).val DO
      IF stack.top # val THEN
        state.setLighting (val);
      END;
      stack.push (val);
    END;
  END PushLighting;

PROCEDURE <A NAME="PopLighting"><procedure>PopLighting</procedure></A> (self  : Lighting_PN;
                              state : GraphicsState.T) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], BooleanPropPrivate.Stack) DO
      state.setLighting (stack.pop ());
    END;
  END PopLighting;
</PRE>***************************************************************************
 Shading_PN                                                                
***************************************************************************

<P><PRE>TYPE
  Shading_PN = ShadingProp.Name OBJECT
  OVERRIDES
    damage := DamageShading;
    push   := PushShading;
    pop    := PopShading;
  END;

PROCEDURE <A NAME="DamageShading"><procedure>DamageShading</procedure></A> (&lt;* UNUSED *&gt; self : Shading_PN; caller : GO.T) =
  BEGIN
    caller.damaged := TRUE;
  END DamageShading;

PROCEDURE <A NAME="PushShading"><procedure>PushShading</procedure></A> (self  : Shading_PN;
                       state : GraphicsState.T;
                       pv    : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], ShadingPropPrivate.Stack),
         val   = NARROW (pv, ShadingProp.Val).val DO
      IF stack.top # val THEN
        state.setShading (val);
      END;
      stack.push (val);
    END;
  END PushShading;

PROCEDURE <A NAME="PopShading"><procedure>PopShading</procedure></A> (self : Shading_PN; state : GraphicsState.T) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], ShadingPropPrivate.Stack) DO
      state.setShading (stack.pop ());
    END;
  END PopShading;
</PRE>***************************************************************************
 EdgeVisibility_PN                                                         
***************************************************************************

<P><PRE>TYPE
  EdgeVisibility_PN = BooleanProp.Name OBJECT
  OVERRIDES
    damage := DamageEdgeVisibility;
    push   := PushEdgeVisibility;
    pop    := PopEdgeVisibility;
  END;

PROCEDURE <A NAME="DamageEdgeVisibility"><procedure>DamageEdgeVisibility</procedure></A> (&lt;* UNUSED *&gt; self   : EdgeVisibility_PN;
                                             caller : GO.T) =
  BEGIN
    caller.damaged := TRUE;
  END DamageEdgeVisibility;

PROCEDURE <A NAME="PushEdgeVisibility"><procedure>PushEdgeVisibility</procedure></A> (self  : EdgeVisibility_PN;
                              state : GraphicsState.T;
                              pv    : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], BooleanPropPrivate.Stack),
         val   = NARROW (pv, BooleanProp.Val).val DO
      IF stack.top # val THEN
        state.setSurfaceEdgeFlag (val);
      END;
      stack.push (val);
    END;
  END PushEdgeVisibility;

PROCEDURE <A NAME="PopEdgeVisibility"><procedure>PopEdgeVisibility</procedure></A> (self  : EdgeVisibility_PN;
                             state : GraphicsState.T) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], BooleanPropPrivate.Stack) DO
      state.setSurfaceEdgeFlag (stack.pop ());
    END;
  END PopEdgeVisibility;
</PRE>***************************************************************************
 EdgeColour_PN                                                             
***************************************************************************

<P>
<P><PRE>TYPE
  EdgeColour_PN = ColorProp.Name OBJECT
  OVERRIDES
    damage := DamageEdgeColour;
    push   := PushEdgeColour;
    pop    := PopEdgeColour;
  END;

PROCEDURE <A NAME="DamageEdgeColour"><procedure>DamageEdgeColour</procedure></A> (&lt;* UNUSED *&gt; self   : EdgeColour_PN;
                                         caller : GO.T) =
  BEGIN
    caller.damaged := TRUE;
  END DamageEdgeColour;

PROCEDURE <A NAME="PushEdgeColour"><procedure>PushEdgeColour</procedure></A> (self  : EdgeColour_PN;
                          state : GraphicsState.T;
                          pv    : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], ColorPropPrivate.Stack),
         val   = NARROW (pv, ColorProp.Val).val DO
      IF stack.top # val THEN
        state.setSurfaceEdgeColor (val);
      END;
      stack.push (val);
    END;
  END PushEdgeColour;

PROCEDURE <A NAME="PopEdgeColour"><procedure>PopEdgeColour</procedure></A> (self : EdgeColour_PN; state : GraphicsState.T) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], ColorPropPrivate.Stack) DO
      state.setSurfaceEdgeColor (stack.pop ());
    END;
  END PopEdgeColour;
</PRE>***************************************************************************
 EdgeType_PN                                                               
***************************************************************************

<P><PRE>TYPE
  EdgeType_PN = LineTypeProp.Name OBJECT
  OVERRIDES
    damage := DamageEdgeType;
    push   := PushEdgeType;
    pop    := PopEdgeType;
  END;

PROCEDURE <A NAME="DamageEdgeType"><procedure>DamageEdgeType</procedure></A> (&lt;* UNUSED *&gt; self   : EdgeType_PN;
                                       caller : GO.T) =
  BEGIN
    caller.damaged := TRUE;
  END DamageEdgeType;

PROCEDURE <A NAME="PushEdgeType"><procedure>PushEdgeType</procedure></A> (self  : EdgeType_PN;
                        state : GraphicsState.T;
                        pv    : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], LineTypePropPrivate.Stack),
         val   = NARROW (pv, LineTypeProp.Val).val DO
      IF stack.top # val THEN
        state.setSurfaceEdgeType (val);
      END;
      stack.push (val);
    END;
  END PushEdgeType;

PROCEDURE <A NAME="PopEdgeType"><procedure>PopEdgeType</procedure></A> (self : EdgeType_PN; state : GraphicsState.T) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], LineTypePropPrivate.Stack) DO
      state.setSurfaceEdgeType (stack.pop ());
    END;
  END PopEdgeType;
</PRE>***************************************************************************
 EdgeWidth_PN                                                              
***************************************************************************

<P><PRE>TYPE
  EdgeWidth_PN = RealProp.Name OBJECT
  OVERRIDES
    damage := DamageEdgeWidth;
    push   := PushEdgeWidth;
    pop    := PopEdgeWidth;
  END;

PROCEDURE <A NAME="DamageEdgeWidth"><procedure>DamageEdgeWidth</procedure></A> (&lt;* UNUSED *&gt; self   : EdgeWidth_PN;
                                        caller : GO.T) =
  BEGIN
    caller.damaged := TRUE;
  END DamageEdgeWidth;

PROCEDURE <A NAME="PushEdgeWidth"><procedure>PushEdgeWidth</procedure></A> (self  : EdgeWidth_PN;
                         state : GraphicsState.T;
                         pv    : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], RealPropPrivate.Stack),
         val   = NARROW (pv, RealProp.Val).val DO
      IF stack.top # val THEN
        state.setSurfaceEdgeWidth (val);
      END;
      stack.push (val);
    END;
  END PushEdgeWidth;

PROCEDURE <A NAME="PopEdgeWidth"><procedure>PopEdgeWidth</procedure></A> (self : EdgeWidth_PN; state : GraphicsState.T) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], RealPropPrivate.Stack) DO
      state.setSurfaceEdgeWidth (stack.pop ());
    END;
  END PopEdgeWidth;
</PRE>***************************************************************************
 Convenience Procedures                                                    
***************************************************************************

<P><PRE>PROCEDURE <A NAME="SetDistinguishFacets"><procedure>SetDistinguishFacets</procedure></A> (o : GO.T; v : BOOLEAN) =
  BEGIN
    o.setProp (DistinguishFacets.bind (BooleanProp.NewConst (v)));
  END SetDistinguishFacets;

PROCEDURE <A NAME="SetColour"><procedure>SetColour</procedure></A> (o : GO.T; v : Color.T) =
  BEGIN
    o.setProp (Colour.bind (ColorProp.NewConst (v)));
  END SetColour;

PROCEDURE <A NAME="SetRasterMode"><procedure>SetRasterMode</procedure></A> (o : GO.T; v : RasterModeProp.Kind) =
  BEGIN
    o.setProp (RasterMode.bind (RasterModeProp.NewConst (v)));
  END SetRasterMode;

PROCEDURE <A NAME="SetAmbientReflectionCoeff"><procedure>SetAmbientReflectionCoeff</procedure></A>  (o : GO.T; v : REAL) =
  BEGIN
    o.setProp (AmbientReflectionCoeff.bind (RealProp.NewConst (v)));
  END SetAmbientReflectionCoeff;

PROCEDURE <A NAME="SetDiffuseReflectionCoeff"><procedure>SetDiffuseReflectionCoeff</procedure></A>  (o : GO.T; v : REAL) =
  BEGIN
    o.setProp (DiffuseReflectionCoeff.bind (RealProp.NewConst (v)));
  END SetDiffuseReflectionCoeff;

PROCEDURE <A NAME="SetSpecularReflectionCoeff"><procedure>SetSpecularReflectionCoeff</procedure></A> (o : GO.T; v : REAL) =
  BEGIN
    o.setProp (SpecularReflectionCoeff.bind (RealProp.NewConst (v)));
  END SetSpecularReflectionCoeff;

PROCEDURE <A NAME="SetSpecularReflectionConc"><procedure>SetSpecularReflectionConc</procedure></A> (o : GO.T; v : REAL) =
  BEGIN
    o.setProp (SpecularReflectionConc.bind (RealProp.NewConst (v)));
  END SetSpecularReflectionConc;

PROCEDURE <A NAME="SetTransmissionCoeff"><procedure>SetTransmissionCoeff</procedure></A> (o : GO.T; v : REAL) =
  BEGIN
    o.setProp (TransmissionCoeff.bind (RealProp.NewConst (v)));
  END SetTransmissionCoeff;

PROCEDURE <A NAME="SetSpecularReflectionColour"><procedure>SetSpecularReflectionColour</procedure></A> (o : GO.T; v : Color.T) =
  BEGIN
    o.setProp (SpecularReflectionColour.bind (ColorProp.NewConst (v)));
  END SetSpecularReflectionColour;

PROCEDURE <A NAME="SetLighting"><procedure>SetLighting</procedure></A> (o : GO.T; v : BOOLEAN) =
  BEGIN
    o.setProp (Lighting.bind (BooleanProp.NewConst (v)));
  END SetLighting;

PROCEDURE <A NAME="SetShading"><procedure>SetShading</procedure></A> (o : GO.T; v : ShadingProp.Kind) =
  BEGIN
    o.setProp (Shading.bind (ShadingProp.NewConst (v)));
  END SetShading;

PROCEDURE <A NAME="SetEdgeVisibility"><procedure>SetEdgeVisibility</procedure></A> (o : GO.T; v : BOOLEAN) =
  BEGIN
    o.setProp (EdgeVisibility.bind (BooleanProp.NewConst (v)));
  END SetEdgeVisibility;

PROCEDURE <A NAME="SetEdgeColour"><procedure>SetEdgeColour</procedure></A> (o : GO.T; v : Color.T) =
  BEGIN
    o.setProp (EdgeColour.bind (ColorProp.NewConst (v)));
  END SetEdgeColour;

PROCEDURE <A NAME="SetEdgeType"><procedure>SetEdgeType</procedure></A> (o : GO.T; v : LineTypeProp.Kind) =
  BEGIN
    o.setProp (EdgeType.bind (LineTypeProp.NewConst (v)));
  END SetEdgeType;

PROCEDURE <A NAME="SetEdgeWidth"><procedure>SetEdgeWidth</procedure></A> (o : GO.T; v : REAL) =
  BEGIN
    o.setProp (EdgeWidth.bind (RealProp.NewConst (v)));
  END SetEdgeWidth;
</PRE>***************************************************************************
 Main body                                                                 
***************************************************************************

<P><PRE>BEGIN
  DistinguishFacets :=
      NEW (DistinguishFacets_PN).init (FALSE);
  Colour :=
      NEW (Colour_PN).init (Color.White);
  RasterMode :=
      NEW (RasterMode_PN).init (RasterModeProp.Kind.Solid);
  AmbientReflectionCoeff :=
      NEW (AmbientReflectionCoeff_PN).init (0.5);
  DiffuseReflectionCoeff :=
      NEW (DiffuseReflectionCoeff_PN).init (1.0);
  SpecularReflectionCoeff :=
      NEW (SpecularReflectionCoeff_PN).init (0.0);
  SpecularReflectionConc :=
      NEW (SpecularReflectionConcPN).init (0.0);
  TransmissionCoeff :=
      NEW (TransmissionCoeff_PN).init (0.0);        (* DIFFERS FROM MANUAL *)
  SpecularReflectionColour :=
      NEW (SpecularReflectionColour_PN).init (Color.White);
  Lighting :=
      NEW (Lighting_PN).init (TRUE);
  Shading :=
      NEW (Shading_PN).init (ShadingProp.Kind.Flat);
  EdgeVisibility :=
      NEW (EdgeVisibility_PN).init (FALSE);
  EdgeColour :=
      NEW (EdgeColour_PN).init (Color.White);
  EdgeType :=
      NEW (EdgeType_PN).init (LineTypeProp.Kind.Solid);
  EdgeWidth :=
      NEW (EdgeWidth_PN).init (1.0);
END SurfaceGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
