<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/TorusGO.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/TorusGO.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P> A <CODE>TorusGO.T</CODE> is a geometric object describing a torus. 
   A torus can be described by one major and an infinite set of minor circles.
   <P>
   The major circle of the torus is centerest at point <CODE>center</CODE>, its radius
   is <CODE>rad</CODE>, and its normal vector is <CODE>normal</CODE>. The minor circles (which 
   together make up the surface of the torus) are centered around the perimeter
   of the mayor circle, their radius is <CODE>rad2</CODE>, and their normal vector is 
   parallel to the circumference of the major circle in their center point. 
<P>
   The following picture tries to illustrate the roles of the various 
   parameters:
   \begin{center}
   \begin{tabular}{c}
   \psfig{figure=images/TorusGO.ps,width=3in,silent=}
   \end{tabular}
   \end{center} 

<P><PRE>INTERFACE <interface><A HREF="TorusGO.m3">TorusGO</A></interface>;

IMPORT <A HREF="GO.i3">GO</A>, <A HREF="Point3.i3">Point3</A>, <A HREF="PointProp.i3">PointProp</A>, <A HREF="RealProp.i3">RealProp</A>, <A HREF="SurfaceGO.i3">SurfaceGO</A>;

TYPE
  <A HREF="TorusGO.m3#T">T</A> &lt;: Public;
  Public = SurfaceGO.T OBJECT
  METHODS
    init (prec := 30) : T;
  END;
</PRE><BLOCKQUOTE><EM> <CODE>tor.init(prec)</CODE> initializes a new torus <CODE>tor</CODE>, composed of <CODE>prec</CODE> strips 
   of <CODE>prec</CODE> trapezoids, and returns it. 
   The location, orientation, and size of the torus is determined by the
   <CODE>Center</CODE>, <CODE>Normal</CODE>, <CODE>Radius1</CODE>, and <CODE>Radius2</CODE> property values. </EM></BLOCKQUOTE><PRE>

VAR
  Center  : PointProp.Name;
  Normal  : PointProp.Name;
  Radius1 : RealProp.Name;
  Radius2 : RealProp.Name;
</PRE><BLOCKQUOTE><EM> In addition to the properties observed by all \type{GO}{T}'s and
   \type{SurfaceGO}{T}'s, there are four additional properties that 
   are observed by <CODE>TorusGO.T</CODE>'s:
<P>
   <CODE>Center</CODE> is the name of a property that describes the center 
   of the torus. It associates with a \type{PointProp}{Val}. If no <CODE>Center</CODE> 
   property is specified, the center of the torus lies at the origin.
<P>
   <CODE>Normal</CODE> is the name of a property that describes the normal vector of 
   the torus. It associates with a \type{PointProp}{Val}. If no <CODE>Normal</CODE>
   property is specified, the normal vector is taken to be (0,0,1).
   <P>
   <CODE>Radius1</CODE> is the name of a property that describes the radius of the 
   major circle of the torus. It associates with a \type{RealProp}{Val}. 
   If no <CODE>Radius1</CODE> property is specified, the torus has a major radius of 1. 
<P>
   <CODE>Radius2</CODE> is the name of a property that describes the radius of the 
   minor circle of the torus. It associates with a \type{RealProp}{Val}. 
   If no <CODE>Radius2</CODE> property is specified, the torus has a minor radius 
   of 0.1. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TorusGO.m3#New">New</A> (center, normal   : Point3.T;
               radius1, radius2 : REAL;
               prec := 30) : T;
</PRE><BLOCKQUOTE><EM> <CODE>New(center,normal,radius1, radius2,prec)</CODE> creates a new torus,
   whose surface is composed of <CODE>prec</CODE> strips of <CODE>prec</CODE> trapezoids,
   and returns it. It also attaches the following properties
   to the new torus:
   \begin{verbatim}
     (Center,PointProp.NewConst(center))
     (Normal,PointProp.NewConst(normal))
     (Radius1,RealProp.NewConst(rad1))
     (Radius2,RealProp.NewConst(rad2))
   \end{verbatim} </EM></BLOCKQUOTE><PRE>
</PRE> The following three procedures provide sugaring to attach <CODE>Center</CODE>, 
   <CODE>Normal</CODE>, <CODE>Radius1</CODE>, and <CODE>Radius2</CODE> properties (where the property 
   values have constant behaviors) to geometric objects: 

<P><PRE>PROCEDURE <A HREF="TorusGO.m3#SetCenter">SetCenter</A> (o : GO.T; p : Point3.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetCenter(o,p)</CODE> is equivalent to
   <CODE>o.setProp(Center.bind(PointProp.NewConst(p)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TorusGO.m3#SetNormal">SetNormal</A> (o : GO.T; p : Point3.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetNormal(o,p)</CODE> is equivalent to
   <CODE>o.setProp(Normal.bind(PointProp.NewConst(p)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TorusGO.m3#SetRadius1">SetRadius1</A> (o : GO.T; r : REAL);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetRadius1(o,r)</CODE>is equivalent to
   <CODE>o.setProp(Radius1.bind(RealProp.NewConst(r)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TorusGO.m3#SetRadius2">SetRadius2</A> (o : GO.T; r : REAL);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetRadius2(o,r)</CODE>is equivalent to
   <CODE>o.setProp(Radius2.bind(RealProp.NewConst(r)))</CODE>. </EM></BLOCKQUOTE><PRE>

END TorusGO.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
