<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/TorusGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/TorusGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P><PRE>MODULE <module>TorusGO</module> EXPORTS <A HREF="TorusGO.i3"><implements>TorusGO</A></implements>, <A HREF="TorusGOProxy.i3"><implements>TorusGOProxy</A></implements>;

IMPORT <A HREF="GO.i3">GO</A>, <A HREF="GOPrivate.i3">GOPrivate</A>, <A HREF="GraphicsState.i3">GraphicsState</A>, <A HREF="Matrix4.i3">Matrix4</A>, <A HREF="Point3.i3">Point3</A>, <A HREF="PointProp.i3">PointProp</A>,
       <A HREF="PointPropPrivate.i3">PointPropPrivate</A>, <A HREF="Prop.i3">Prop</A>, <A HREF="RealProp.i3">RealProp</A>, <A HREF="RealPropPrivate.i3">RealPropPrivate</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
    prec    : INTEGER;
    center  : Point3.T;
    normal  : Point3.T;
    radius1 : REAL;
    matrix  : Matrix4.T;
  OVERRIDES
    init              := Init;
    draw              := Draw;
    damageIfDependent := DamageIfDependent;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T; prec : INTEGER) : T =
  BEGIN
    EVAL GO.T.init (self);
    self.prec    := prec;
    self.center  := Point3.Origin;
    self.normal  := Point3.T {0.0, 0.0, 1.0};
    self.radius1 := 1.0;
    self.matrix  := Matrix4.Id;

    IF MkProxyT # NIL AND self.proxy = NIL THEN
      MkProxyT (self);
    END;

    RETURN self;
  END Init;

PROCEDURE <A NAME="DamageIfDependent"><procedure>DamageIfDependent</procedure></A> (self : T; pn : Prop.Name) =
  BEGIN
    IF pn = Center OR pn = Normal OR pn = Radius1 OR pn = Radius2 THEN
      self.damaged := TRUE;
    END;
  END DamageIfDependent;

PROCEDURE <A NAME="Draw"><procedure>Draw</procedure></A> (self : T; state : GraphicsState.T) =
  BEGIN
    state.push (self);

    WITH center  = Center.getState (state),
         normal  = Normal.getState (state),
         radius1 = Radius1.getState (state),
         radius2 = Radius2.getState (state) DO

      IF center # self.center OR normal # self.normal OR radius1 # self.radius1
      THEN
        self.center  := center;
        self.normal  := normal;
        self.radius1 := radius1;

        WITH s = Point3.OrthoVector (normal),
             t = Point3.CrossProduct (normal, s),
             a = Point3.Plus (center, Point3.ScaleToLen (s, radius1)),
             b = Point3.Plus (center, Point3.ScaleToLen (t, radius1)),
             c = Point3.Plus (center, Point3.ScaleToLen (normal, radius1)) DO
          self.matrix := Matrix4.TransformUnitCube (center, a, b, c);
        END;
      END;

      state.pushMatrix (self.matrix);
      state.drawProtoTorus (self.prec, radius2 / self.radius1);
      state.popMatrix ();
      state.growBoundingVolume (center, radius1 + radius2);
    END;

    self.damaged := FALSE;
    state.pop (self);
  END Draw;
</PRE>***************************************************************************
 Convenience Procedures                                                    
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="New"><procedure>New</procedure></A> (center, normal   : Point3.T;
               radius1, radius2 : REAL;
               prec : INTEGER)  : T =
  VAR
    torus := NEW (T).init (prec);
  BEGIN
    SetCenter (torus, center);
    SetNormal (torus, normal);
    SetRadius1 (torus, radius1);
    SetRadius2 (torus, radius2);
    RETURN torus;
  END New;

PROCEDURE <A NAME="SetCenter"><procedure>SetCenter</procedure></A> (o : GO.T; v : Point3.T) =
  BEGIN
    o.setProp (Center.bind (PointProp.NewConst (v)));
  END SetCenter;

PROCEDURE <A NAME="SetNormal"><procedure>SetNormal</procedure></A> (o : GO.T; v : Point3.T) =
  BEGIN
    o.setProp (Normal.bind (PointProp.NewConst (v)));
  END SetNormal;

PROCEDURE <A NAME="SetRadius1"><procedure>SetRadius1</procedure></A> (o : GO.T; v : REAL) =
  BEGIN
    o.setProp (Radius1.bind (RealProp.NewConst (v)));
  END SetRadius1;

PROCEDURE <A NAME="SetRadius2"><procedure>SetRadius2</procedure></A> (o : GO.T; v : REAL) =
  BEGIN
    o.setProp (Radius2.bind (RealProp.NewConst (v)));
  END SetRadius2;

BEGIN
  Center  := NEW (PointProp.Name).init (Point3.T {0.0, 0.0, 0.0});
  Normal  := NEW (PointProp.Name).init (Point3.T {0.0, 0.0, 1.0});
  Radius1 := NEW (RealProp.Name).init (1.0);
  Radius2 := NEW (RealProp.Name).init (0.1);
END TorusGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
