<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/TransformProp.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/TransformProp.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Sun May 22 11:14:01 PDT 1994 by najork                   

<P>
<P><PRE>INTERFACE <interface><A HREF="TransformProp.m3">TransformProp</A></interface>;

IMPORT <A HREF="AnimHandle.i3">AnimHandle</A>, <A HREF="Matrix4.i3">Matrix4</A>, <A HREF="Prop.i3">Prop</A>;

TYPE Base = Matrix4.T;

TYPE
  <A HREF="TransformProp.m3#Name">Name</A> &lt;: PublicName;
  PublicName = Prop.Name OBJECT
  METHODS
    bind (v : Val) : Prop.T;
  END;

  <A HREF="TransformProp.m3#Val">Val</A> &lt;: PublicVal;
  PublicVal = Prop.Val OBJECT
    beh : Beh;
  METHODS
    init (beh : Beh) : Val;
    get () : Base RAISES {Prop.BadMethod};
    value (time : LONGREAL) : Base RAISES {Prop.BadMethod};
  END;

  <A HREF="TransformProp.m3#Beh">Beh</A> &lt;: PublicBeh;
  PublicBeh = Prop.Beh OBJECT
  METHODS
    init () : Beh;
  END;

  <A HREF="TransformProp.m3#ConstBeh">ConstBeh</A> &lt;: PublicConstBeh;
  PublicConstBeh = Beh OBJECT
  METHODS
    init (READONLY m := Matrix4.Id) : ConstBeh;
    set (READONLY m : Base);
    compose (READONLY m : Base);
  (* shortcuts for particular cases of &quot;set&quot; and &quot;compose&quot; *)
    reset ();
    translate (x, y, z : REAL);
    scale (x, y, z : REAL);
    rotateX (a : REAL);
    rotateY (a : REAL);
    rotateZ (a : REAL);
  END;

  <A HREF="TransformProp.m3#SyncBeh">SyncBeh</A> &lt;: PublicSyncBeh;
  PublicSyncBeh = Beh OBJECT
  METHODS
    init (ah : AnimHandle.T; READONLY m := Matrix4.Id) : SyncBeh;
    addRequest (r : Request) RAISES {Prop.BadInterval};
  (* shortcuts for particular instances of &quot;addRequest&quot; *)
    reset (start := 0.0) RAISES {Prop.BadInterval};
    changeTo (READONLY m : Base; start := 0.0; dur := 0.0)
        RAISES {Prop.BadInterval};
    translate (x, y, z : REAL; start := 0.0; dur := 0.0)
        RAISES {Prop.BadInterval};
    scale (x, y, z : REAL; start := 0.0; dur := 0.0) RAISES {Prop.BadInterval};
    rotateX (a : REAL; start := 0.0; dur := 0.0) RAISES {Prop.BadInterval};
    rotateY (a : REAL; start := 0.0; dur := 0.0) RAISES {Prop.BadInterval};
    rotateZ (a : REAL; start := 0.0; dur := 0.0) RAISES {Prop.BadInterval};
  END;

  <A HREF="TransformProp.m3#AsyncBeh">AsyncBeh</A> &lt;: PublicAsyncBeh;
  PublicAsyncBeh = Beh OBJECT
  METHODS
    init () : AsyncBeh;
    compute (time : LONGREAL) : Base RAISES {Prop.BadMethod};
  END;

  <A HREF="TransformProp.m3#DepBeh">DepBeh</A> &lt;: PublicDepBeh;
  PublicDepBeh = Beh OBJECT
  METHODS
    init () : DepBeh;
    compute (time : LONGREAL) : Base RAISES {Prop.BadMethod};
  END;

  <A HREF="TransformProp.m3#Request">Request</A> &lt;: PublicRequest;
  PublicRequest = Prop.Request OBJECT
  METHODS
    init (start, dur : REAL) : Request;
    value (READONLY startval : Base; reltime : REAL) : Base
      RAISES {Prop.BadMethod};
  END;

PROCEDURE <A HREF="TransformProp.m3#NewConst">NewConst</A> (READONLY m := Matrix4.Id) : Val;
PROCEDURE <A HREF="TransformProp.m3#NewSync">NewSync</A> (ah : AnimHandle.T; READONLY m := Matrix4.Id) : Val;
PROCEDURE <A HREF="TransformProp.m3#NewAsync">NewAsync</A> (b : AsyncBeh) : Val;
PROCEDURE <A HREF="TransformProp.m3#NewDep">NewDep</A> (b : DepBeh) : Val;

END TransformProp.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
