<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/TransformProp.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/TransformProp.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Sun May 22 12:22:36 PDT 1994 by najork                   

<P>
<P><PRE>MODULE <module>TransformProp</module> EXPORTS <A HREF="TransformProp.i3"><implements>TransformProp</A></implements>,
                             <A HREF="TransformPropPrivate.i3"><implements>TransformPropPrivate</A></implements>,
                             <A HREF="TransformPropProxy.i3"><implements>TransformPropProxy</A></implements>;

IMPORT <A HREF="Anim3D.i3">Anim3D</A>, <A HREF="AnimHandle.i3">AnimHandle</A>, <A HREF="AnimHandlePrivate.i3">AnimHandlePrivate</A>, <A HREF="AnimRequestQueue.i3">AnimRequestQueue</A>,
       <A HREF="AnimRequestQueuePrivate.i3">AnimRequestQueuePrivate</A>, <A HREF="AnimServer.i3">AnimServer</A>, <A HREF="GraphicsState.i3">GraphicsState</A>,
       <A HREF="GraphicsStatePrivate.i3">GraphicsStatePrivate</A>, <A HREF="Matrix4.i3">Matrix4</A>, <A HREF="Prop.i3">Prop</A>, <A HREF="PropPrivate.i3">PropPrivate</A>, <A HREF="Quaternion.i3">Quaternion</A>;
</PRE>***************************************************************************
 Type <CODE>Name</CODE>                                                               
***************************************************************************

<P><PRE>REVEAL
  <A NAME="Name">Name</A> = PrivateName BRANDED OBJECT
    default : Base;
  OVERRIDES
    init      := InitName;
    bind      := BindName;
    makeProxy := MakeProxyName;
    push      := PushName;
    pop       := PopName;
    newStack  := NewStack;
    getState  := GetState;
  END;

PROCEDURE <A NAME="InitName"><procedure>InitName</procedure></A> (self : Name; READONLY default : Base) : Name =
  BEGIN
    EVAL Prop.Name.init (self);
    self.default := default;
    IF NamePM # NIL THEN
      NamePM (self);
    END;
    RETURN self;
  END InitName;

PROCEDURE <A NAME="BindName"><procedure>BindName</procedure></A> (self : Name; val : Val) : Prop.T =
  BEGIN
    RETURN NEW (Prop.T).init (self, val);
  END BindName;

PROCEDURE <A NAME="MakeProxyName"><procedure>MakeProxyName</procedure></A> (self : Name) =
  BEGIN
    IF self.proxy = NIL AND NamePM # NIL THEN
      NamePM (self);
    END;
  END MakeProxyName;

PROCEDURE <A NAME="PushName"><procedure>PushName</procedure></A> (self : Name; state : GraphicsState.T; pv : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], Stack),
         val   = NARROW (pv, Val).val DO
      stack.push (val);
    END;
  END PushName;

PROCEDURE <A NAME="PopName"><procedure>PopName</procedure></A> (self : Name; state : GraphicsState.T) =
  BEGIN
    EVAL NARROW (state.stacks[self.id], Stack).pop ();
  END PopName;

PROCEDURE <A NAME="NewStack"><procedure>NewStack</procedure></A> (self : Name) : PropPrivate.Stack =
  BEGIN
    RETURN NEW (Stack).init (self.default);
  END NewStack;

PROCEDURE <A NAME="GetState"><procedure>GetState</procedure></A> (self : Name; state : GraphicsState.T) : Base =
  BEGIN
    RETURN NARROW (state.stacks[self.id], Stack).top;
  END GetState;
</PRE>***************************************************************************
 Type <CODE>Val</CODE>                                                                
***************************************************************************

<P><PRE>REVEAL
  <A NAME="Val">Val</A> = PrivateVal BRANDED OBJECT
  OVERRIDES
    init   := InitVal;
    get    := GetVal;
    value  := ValueVal;
    adjust := AdjustVal;
  END;

PROCEDURE <A NAME="InitVal"><procedure>InitVal</procedure></A> (self : Val; beh : Beh) : Val =
  BEGIN
    self.beh  := beh;
    self.time := Anim3D.Now () - 10.0d0;

    IF ValPM # NIL THEN
      ValPM (self);
    END;

    RETURN self;
  END InitVal;

PROCEDURE <A NAME="GetVal"><procedure>GetVal</procedure></A> (self : Val) : Matrix4.T RAISES {Prop.BadMethod} =
  BEGIN
    RETURN self.beh.value (Anim3D.Now ());
  END GetVal;

PROCEDURE <A NAME="ValueVal"><procedure>ValueVal</procedure></A> (self : Val; time : LONGREAL) : Matrix4.T
    RAISES {Prop.BadMethod} =
  BEGIN
    IF time = self.time THEN
      RETURN self.val;
    ELSE
      RETURN self.beh.value (time);
    END;
  END ValueVal;

PROCEDURE <A NAME="AdjustVal"><procedure>AdjustVal</procedure></A> (self : Val; time : LONGREAL) : BOOLEAN
    RAISES {Prop.BadMethod} =
  BEGIN
    IF time # self.time THEN
      WITH val = self.beh.value (time) DO
        self.damaged := val # self.val;
        self.time    := time;
        self.val     := val;
      END;
    END;
    RETURN self.damaged;
  END AdjustVal;
</PRE>***************************************************************************
 Type <CODE>Beh</CODE>                                                                
***************************************************************************

<P><PRE>REVEAL
  <A NAME="Beh">Beh</A> = PrivateBeh BRANDED OBJECT
  OVERRIDES
    init := InitBeh;
  END;

PROCEDURE <A NAME="InitBeh"><procedure>InitBeh</procedure></A> (self : Beh) : Beh =
  BEGIN
    RETURN self;
  END InitBeh;
</PRE>***************************************************************************
 Type <CODE>ConstBeh</CODE>                                                           
***************************************************************************

<P><PRE>REVEAL
  <A NAME="ConstBeh">ConstBeh</A> = PublicConstBeh BRANDED OBJECT
    matrix : Matrix4.T;
  OVERRIDES
    init      := InitConstBeh;
    value     := ValueConstBeh;
    set       := SetConstBeh;
    compose   := ComposeConstBeh;
    reset     := ResetConstBeh;
    translate := TranslateConstBeh;
    scale     := ScaleConstBeh;
    rotateX   := RotateXConstBeh;
    rotateY   := RotateYConstBeh;
    rotateZ   := RotateZConstBeh;
  END;

PROCEDURE <A NAME="InitConstBeh"><procedure>InitConstBeh</procedure></A> (         self : ConstBeh;
                        READONLY matrix : Matrix4.T) : ConstBeh =
  BEGIN
    EVAL Beh.init (self);
    self.matrix := matrix;
    IF ConstBehPM # NIL THEN
      ConstBehPM (self);
    END;
    RETURN self;
  END InitConstBeh;

PROCEDURE <A NAME="ValueConstBeh"><procedure>ValueConstBeh</procedure></A> (             self : ConstBeh;
                         &lt;* UNUSED *&gt; time : LONGREAL) : Matrix4.T =
  BEGIN
    RETURN self.matrix;
  END ValueConstBeh;

PROCEDURE <A NAME="SetConstBeh"><procedure>SetConstBeh</procedure></A> (self : ConstBeh; READONLY matrix : Matrix4.T) =
  BEGIN
    self.matrix := matrix;
  END SetConstBeh;

PROCEDURE <A NAME="ComposeConstBeh"><procedure>ComposeConstBeh</procedure></A> (self : ConstBeh; READONLY matrix : Matrix4.T) =
  BEGIN
    self.matrix := Matrix4.Multiply (matrix, self.matrix);
  END ComposeConstBeh;

PROCEDURE <A NAME="ResetConstBeh"><procedure>ResetConstBeh</procedure></A> (self : ConstBeh) =
  BEGIN
    self.matrix := Matrix4.Id;
  END ResetConstBeh;

PROCEDURE <A NAME="TranslateConstBeh"><procedure>TranslateConstBeh</procedure></A> (self : ConstBeh; x, y, z : REAL) =
  BEGIN
    self.matrix := Matrix4.Translate (self.matrix, x, y, z);
  END TranslateConstBeh;

PROCEDURE <A NAME="ScaleConstBeh"><procedure>ScaleConstBeh</procedure></A> (self : ConstBeh; x, y, z : REAL) =
  BEGIN
    self.matrix := Matrix4.Scale (self.matrix, x, y, z);
  END ScaleConstBeh;

PROCEDURE <A NAME="RotateXConstBeh"><procedure>RotateXConstBeh</procedure></A> (self : ConstBeh; a : REAL) =
  BEGIN
    self.matrix := Matrix4.RotateX (self.matrix, a);
  END RotateXConstBeh;

PROCEDURE <A NAME="RotateYConstBeh"><procedure>RotateYConstBeh</procedure></A> (self : ConstBeh; a : REAL) =
  BEGIN
    self.matrix := Matrix4.RotateY (self.matrix, a);
  END RotateYConstBeh;

PROCEDURE <A NAME="RotateZConstBeh"><procedure>RotateZConstBeh</procedure></A> (self : ConstBeh; a : REAL) =
  BEGIN
    self.matrix := Matrix4.RotateZ (self.matrix, a);
  END RotateZConstBeh;

PROCEDURE <A NAME="NewConst"><procedure>NewConst</procedure></A> (READONLY matrix : Matrix4.T) : Val =
  BEGIN
    RETURN NEW (Val).init (NEW (ConstBeh).init (matrix));
  END NewConst;
</PRE>***************************************************************************
 Type <CODE>AsyncBeh</CODE>                                                           
***************************************************************************

<P><PRE>REVEAL
  <A NAME="AsyncBeh">AsyncBeh</A> = PublicAsyncBeh BRANDED OBJECT
  OVERRIDES
    init    := InitAsyncBeh;
    value   := ValueAsyncBeh;
    compute := ComputeAsyncBeh;
  END;

PROCEDURE <A NAME="InitAsyncBeh"><procedure>InitAsyncBeh</procedure></A> (self : AsyncBeh) : AsyncBeh =
  BEGIN
    EVAL Beh.init (self);
    IF AsyncBehPM # NIL THEN
      AsyncBehPM (self);
    END;
    RETURN self;
  END InitAsyncBeh;

PROCEDURE <A NAME="ValueAsyncBeh"><procedure>ValueAsyncBeh</procedure></A> (self : AsyncBeh; time : LONGREAL) : Matrix4.T
    RAISES {Prop.BadMethod} =
  BEGIN
    RETURN self.compute (time);
  END ValueAsyncBeh;

PROCEDURE <A NAME="ComputeAsyncBeh"><procedure>ComputeAsyncBeh</procedure></A> (self : AsyncBeh; time : LONGREAL) : Matrix4.T
    RAISES {Prop.BadMethod} =
  BEGIN
    IF self.proxy # NIL THEN
      RETURN NARROW (self.proxy, AsyncBehProxy).compute (time);
    ELSE
      RAISE Prop.BadMethod(&quot;TransformProp.AsyncBeh.compute method is undefined&quot;);
    END;
  END ComputeAsyncBeh;

PROCEDURE <A NAME="NewAsync"><procedure>NewAsync</procedure></A> (b : AsyncBeh) : Val =
  BEGIN
    RETURN NEW (Val).init (b);
  END NewAsync;
</PRE>***************************************************************************
 Type <CODE>DepBeh</CODE>                                                             
***************************************************************************

<P><PRE>REVEAL
  <A NAME="DepBeh">DepBeh</A> = PublicDepBeh BRANDED OBJECT
    hot : BOOLEAN := FALSE;
  OVERRIDES
    init    := InitDepBeh;
    value   := ValueDepBeh;
    compute := ComputeDepBeh;
  END;

PROCEDURE <A NAME="InitDepBeh"><procedure>InitDepBeh</procedure></A> (self : DepBeh) : DepBeh =
  BEGIN
    EVAL Beh.init (self);
    self.hot := FALSE;
    IF DepBehPM # NIL THEN
      DepBehPM (self);
    END;
    RETURN self;
  END InitDepBeh;

PROCEDURE <A NAME="ValueDepBeh"><procedure>ValueDepBeh</procedure></A> (self : DepBeh; time : LONGREAL) : Matrix4.T
    RAISES {Prop.BadMethod} =
  BEGIN
    (* &quot;hot&quot; is set to true while the value of the behavior is computed.
       So, if &quot;hot&quot; is currently true, we have cyclic dependencies.
       If unchecked, this would lead to an infinite recursion.
       We raise an exception instead. *)
    IF self.hot THEN
      RAISE Prop.BadMethod(&quot;TransformProp.DepBeh occurs in a dependency cycle&quot;);
    END;

    TRY
      self.hot := TRUE;
      RETURN self.compute (time);
    FINALLY
      self.hot := FALSE;
    END;
  END ValueDepBeh;

PROCEDURE <A NAME="ComputeDepBeh"><procedure>ComputeDepBeh</procedure></A> (self : DepBeh; time : LONGREAL) : Matrix4.T
    RAISES {Prop.BadMethod} =
  BEGIN
    IF self.proxy # NIL THEN
      RETURN NARROW (self.proxy, DepBehProxy).compute (time);
    ELSE
      RAISE Prop.BadMethod(&quot;TransformProp.DepBeh.compute method is undefined&quot;);
    END;
  END ComputeDepBeh;

PROCEDURE <A NAME="NewDep"><procedure>NewDep</procedure></A> (b : DepBeh) : Val =
  BEGIN
    RETURN NEW (Val).init (b);
  END NewDep;
</PRE>***************************************************************************
 Type <CODE>SyncBeh</CODE>                                                            
***************************************************************************

<P><PRE>REVEAL
  <A NAME="SyncBeh">SyncBeh</A> = PublicSyncBeh BRANDED OBJECT
    queue  : MyAnimRequestQueue;
  OVERRIDES
    init       := InitSyncBeh;
    value      := ValueSyncBeh;
    addRequest := AddRequest;
    reset      := ResetSyncBeh;
    changeTo   := ChangeToSyncBeh;
    translate  := TranslateSyncBeh;
    scale      := ScaleSyncBeh;
    rotateX    := RotateXSyncBeh;
    rotateY    := RotateYSyncBeh;
    rotateZ    := RotateZSyncBeh;
  END;

PROCEDURE <A NAME="InitSyncBeh"><procedure>InitSyncBeh</procedure></A> (self            : SyncBeh;
                       ah              : AnimHandle.T;
                       READONLY matrix : Matrix4.T) : SyncBeh =
  BEGIN
    EVAL Beh.init (self);
    self.queue  := NEW (MyAnimRequestQueue).init (ah, matrix);

    IF SyncBehPM # NIL THEN
      SyncBehPM (self);
    END;
    RETURN self;
  END InitSyncBeh;

PROCEDURE <A NAME="ValueSyncBeh"><procedure>ValueSyncBeh</procedure></A> (self : SyncBeh; time : LONGREAL) : Matrix4.T
    RAISES {Prop.BadMethod}=
  BEGIN
    RETURN self.queue.value (time);
  END ValueSyncBeh;

PROCEDURE <A NAME="AddRequest"><procedure>AddRequest</procedure></A> (self : SyncBeh; r : Request) RAISES {Prop.BadInterval} =
  BEGIN
    self.queue.insert (r);
  END AddRequest;

PROCEDURE <A NAME="ResetSyncBeh"><procedure>ResetSyncBeh</procedure></A> (self : SyncBeh; start : REAL)
    RAISES {Prop.BadInterval} =
  BEGIN
    self.queue.insert (NEW (ResetReq).init (start, 0.0));
  END ResetSyncBeh;

PROCEDURE <A NAME="ChangeToSyncBeh"><procedure>ChangeToSyncBeh</procedure></A> (self       : SyncBeh;
                           READONLY m : Matrix4.T;
                           start, dur : REAL)
    RAISES {Prop.BadInterval} =
  BEGIN
    self.queue.insert (NEW (ChangeToReq).init (start, dur, m));
  END ChangeToSyncBeh;

PROCEDURE <A NAME="TranslateSyncBeh"><procedure>TranslateSyncBeh</procedure></A> (self : SyncBeh; x, y, z : REAL; start, dur : REAL)
        RAISES {Prop.BadInterval} =
  BEGIN
    self.queue.insert (NEW (TranslateReq).init (start, dur, x, y, z));
  END TranslateSyncBeh;

PROCEDURE <A NAME="ScaleSyncBeh"><procedure>ScaleSyncBeh</procedure></A> (self : SyncBeh; x, y, z : REAL; start, dur : REAL)
        RAISES {Prop.BadInterval} =
  BEGIN
    self.queue.insert (NEW (ScaleReq).init (start, dur, x, y, z));
  END ScaleSyncBeh;

PROCEDURE <A NAME="RotateXSyncBeh"><procedure>RotateXSyncBeh</procedure></A> (self : SyncBeh; a : REAL; start, dur : REAL)
        RAISES {Prop.BadInterval} =
  BEGIN
    self.queue.insert (NEW (RotateXReq).init (start, dur, a));
  END RotateXSyncBeh;

PROCEDURE <A NAME="RotateYSyncBeh"><procedure>RotateYSyncBeh</procedure></A> (self : SyncBeh; a : REAL; start, dur : REAL)
        RAISES {Prop.BadInterval} =
  BEGIN
    self.queue.insert (NEW (RotateYReq).init (start, dur, a));
  END RotateYSyncBeh;

PROCEDURE <A NAME="RotateZSyncBeh"><procedure>RotateZSyncBeh</procedure></A> (self : SyncBeh; a : REAL; start, dur : REAL)
        RAISES {Prop.BadInterval} =
  BEGIN
    self.queue.insert (NEW (RotateZReq).init (start, dur, a));
  END RotateZSyncBeh;

PROCEDURE <A NAME="NewSync"><procedure>NewSync</procedure></A> (ah : AnimHandle.T; READONLY matrix : Matrix4.T) : Val =
  BEGIN
    RETURN NEW (Val).init (NEW (SyncBeh).init (ah, matrix));
  END NewSync;
</PRE>***************************************************************************
 Request Subtypes                                                          
***************************************************************************

<P>
<P><PRE>REVEAL
  <A NAME="Request">Request</A> = PublicRequest BRANDED OBJECT
  OVERRIDES
    init  := InitRequest;
    value := ValueRequest;
  END;

PROCEDURE <A NAME="InitRequest"><procedure>InitRequest</procedure></A> (self : Request; start, dur : REAL) : Request =
  BEGIN
    EVAL Prop.Request.init (self, start, dur);
    IF RequestPM # NIL THEN
      RequestPM (self);
    END;
    RETURN self;
  END InitRequest;

PROCEDURE <A NAME="ValueRequest"><procedure>ValueRequest</procedure></A> (self              : Request;
                        READONLY startval : Matrix4.T;
                        reltime           : REAL) : Matrix4.T
    RAISES {Prop.BadMethod} =
  BEGIN
    IF self.proxy # NIL THEN
      RETURN NARROW (self.proxy, RequestProxy).value (startval, reltime);
    ELSE
      RAISE Prop.BadMethod(&quot;TransformProp.Request.value method is undefined&quot;);
    END;
  END ValueRequest;

TYPE
  ResetReq = Request BRANDED OBJECT
  METHODS
    init (start, dur : REAL) : ResetReq := ResetReqInit;
  OVERRIDES
    value := ResetReqValue;
  END;

PROCEDURE <A NAME="ResetReqInit"><procedure>ResetReqInit</procedure></A> (self : ResetReq; start, dur : REAL) : ResetReq =
  BEGIN
    EVAL Request.init (self, start, dur);
    RETURN self;
  END ResetReqInit;

PROCEDURE <A NAME="ResetReqValue"><procedure>ResetReqValue</procedure></A> (                      self     : ResetReq;
                         &lt;* UNUSED *&gt; READONLY startval : Matrix4.T;
                                               reltime  : REAL) : Matrix4.T =
  BEGIN
    &lt;* ASSERT reltime &gt;= self.start AND reltime &lt;= self.start + self.dur *&gt;
    RETURN Matrix4.Id;
  END ResetReqValue;
</PRE><P>
TYPE 
  ChangeToReq = Request BRANDED OBJECT
    validcache := FALSE;
    tx0, ty0, tz0, s0, ax0, ay0, az0 : REAL;
    tx1, ty1, tz1, s1, ax1, ay1, az1 : REAL;
    delta_ax, delta_ay, delta_az : REAL;
    m : Matrix4.T;
  OVERRIDES
    value := ChangeToReqValue;
  END;
<P>
<P>
PROCEDURE ChangeToReqValue (self              : ChangeToReq; 
                            READONLY startval : Matrix4.T;
                            reltime           : REAL) : Matrix4.T =
<P>
  PROCEDURE NormalizeAngle (a : REAL) : REAL =
    BEGIN
      WHILE a &gt; Math.Pi DO
        a := a - 2.0 * Math.Pi;
      END;
      WHILE a &lt; -Math.Pi DO
        a := a + 2.0 * Math.Pi;
      END;
      RETURN a;
    END NormalizeAngle;
<P>
  VAR
    f : REAL;
    M := Matrix4.Id;
  BEGIN
    IF NOT self.validcache THEN
      self.validcache := TRUE;
      Matrix4.Decompose (startval, self.tx0, self.ty0, self.tz0, self.s0, 
                         self.ax0, self.ay0, self.az0);
      Matrix4.Decompose (self.m, self.tx1, self.ty1, self.tz1, self.s1, 
                         self.ax1, self.ay1, self.az1);
      self.delta_ax := NormalizeAngle (self.ax1 - self.ax0);
      self.delta_ay := NormalizeAngle (self.ay1 - self.ay0);
      self.delta_az := NormalizeAngle (self.az1 - self.az0);
    END;
<P>
    IF self.dur # 0.0 THEN
      f := (reltime - self.start) / self.dur;
    ELSE
      f := 1.0;
    END;
<P>
    WITH tx = self.tx0 + (self.tx1 - self.tx0) * f,
         ty = self.ty0 + (self.ty1 - self.ty0) * f,
         tz = self.tz0 + (self.tz1 - self.tz0) * f,
         s  = self.s0  + (self.s1  - self.s0 ) * f,
         ax = self.ax0 + self.delta_ax * f,
         ay = self.ay0 + self.delta_ay * f,
         az = self.az0 + self.delta_az * f DO
      M := Matrix4.Scale (M, s, s, s);
      M := Matrix4.RotateX (M, ax);
      M := Matrix4.RotateY (M, ay);
      M := Matrix4.RotateZ (M, az);
      M := Matrix4.Translate (M, tx, ty, tz);
    END;
    RETURN M;
  END ChangeToReqValue;


<P><PRE>TYPE
  ChangeToReq = Request BRANDED OBJECT
    m : Matrix4.T;
  (*** the rest gets filled in upon the first call to &quot;self.value&quot; ***)
    validcache := FALSE;
    tx0, ty0, tz0, s0 : REAL;
    tx1, ty1, tz1, s1 : REAL;
    q : Quaternion.T;
    A : Matrix4.T;
  METHODS
    init (start, dur : REAL; READONLY m : Matrix4.T) : ChangeToReq :=
        ChangeToReqInit;
  OVERRIDES
    value := ChangeToReqValue;
  END;

PROCEDURE <A NAME="ChangeToReqInit"><procedure>ChangeToReqInit</procedure></A> (self         : ChangeToReq;
                           start, dur   : REAL;
                           READONLY val : Matrix4.T) : ChangeToReq =
  BEGIN
    EVAL Request.init (self, start, dur);
    self.m := val;
    RETURN self;
  END ChangeToReqInit;

PROCEDURE <A NAME="ChangeToReqValue"><procedure>ChangeToReqValue</procedure></A> (self              : ChangeToReq;
                            READONLY startval : Matrix4.T;
                            reltime           : REAL) : Matrix4.T =
  VAR
    f : REAL;
    M := Matrix4.Id;
  BEGIN
    TRY
      IF NOT self.validcache THEN
        WITH A = Matrix4.Decomp(startval,self.tx0,self.ty0,self.tz0,self.s0),
             B = Matrix4.Decomp(self.m,  self.tx1,self.ty1,self.tz1,self.s1),
                (* We use the fact that &quot;A&quot; is an orthogonal matrix,
                   and that for orthogonal matrices, inverse and transpose
                   are the same. *)
             R = Matrix4.Multiply (B, Matrix4.Transpose (A)) DO
          self.A := A;
          self.q := Quaternion.FromMatrix4 (R);
          self.validcache := TRUE;
        END;
      END;

      IF  self.dur # 0.0 THEN
        f := (reltime - self.start) / self.dur;
      ELSE
        f := 1.0;
      END;

      WITH tx = self.tx0 + (self.tx1 - self.tx0) * f,
           ty = self.ty0 + (self.ty1 - self.ty0) * f,
           tz = self.tz0 + (self.tz1 - self.tz0) * f,
           s  = self.s0  + (self.s1  - self.s0 ) * f,
           R  = Quaternion.ToMatrix4 (Quaternion.Interpolate (self.q, f)) DO
        M := Matrix4.Multiply (R, self.A);
        M := Matrix4.Scale (M, s, s, s);
        M := Matrix4.Translate (M, tx, ty, tz);
      END;
      RETURN M;
    EXCEPT
    | Matrix4.Error =&gt;
      AnimServer.ReportError (
          &quot;TransformProp.SyncBeh.change involves nonuniformly scaled matrix&quot;);
      RETURN startval;
    END;
  END ChangeToReqValue;

TYPE
  TranslateReq = Request BRANDED OBJECT
    x, y, z : REAL;
  METHODS
    init (start, dur : REAL; x, y, z : REAL) : TranslateReq :=
        TranslateReqInit;
  OVERRIDES
    value := TranslateReqValue;
  END;

PROCEDURE <A NAME="TranslateReqInit"><procedure>TranslateReqInit</procedure></A> (self       : TranslateReq;
                            start, dur : REAL;
                            x, y, z    : REAL) : TranslateReq =
  BEGIN
    EVAL Request.init (self, start, dur);
    self.x := x;
    self.y := y;
    self.z := z;
    RETURN self;
  END TranslateReqInit;

PROCEDURE <A NAME="TranslateReqValue"><procedure>TranslateReqValue</procedure></A> (self              : TranslateReq;
                             READONLY startval : Matrix4.T;
                             reltime           : REAL) : Matrix4.T =
  VAR
    f : REAL;
  BEGIN
    IF self.dur # 0.0 THEN
      f := (reltime - self.start) / self.dur;
    ELSE
      f := 1.0;
    END;
    RETURN Matrix4.Translate (startval, self.x * f, self.y * f, self.z * f);
  END TranslateReqValue;

TYPE
  ScaleReq = Request BRANDED OBJECT
    x, y, z : REAL;
  METHODS
    init (start, dur : REAL; x, y, z : REAL) : ScaleReq := ScaleReqInit;
  OVERRIDES
    value := ScaleReqValue;
  END;

PROCEDURE <A NAME="ScaleReqInit"><procedure>ScaleReqInit</procedure></A> (self       : ScaleReq;
                        start, dur : REAL;
                        x, y, z    : REAL) : ScaleReq =
  BEGIN
    EVAL Request.init (self, start, dur);
    self.x := x;
    self.y := y;
    self.z := z;
    RETURN self;
  END ScaleReqInit;

PROCEDURE <A NAME="ScaleReqValue"><procedure>ScaleReqValue</procedure></A> (self              : ScaleReq;
                         READONLY startval : Matrix4.T;
                         reltime           : REAL) : Matrix4.T =
  VAR
    f : REAL;
  BEGIN
    IF self.dur # 0.0 THEN
      f := (reltime - self.start) / self.dur;
    ELSE
      f := 1.0;
    END;
    RETURN Matrix4.Scale (startval, 1.0 + (self.x - 1.0) * f,
                                    1.0 + (self.y - 1.0) * f,
                                    1.0 + (self.z - 1.0) * f);
  END ScaleReqValue;

TYPE
  RotateRequest = Request BRANDED OBJECT
    a : REAL;
  METHODS
    init (start, dur : REAL; a : REAL) : RotateRequest := RotateRequestInit;
  END;

PROCEDURE <A NAME="RotateRequestInit"><procedure>RotateRequestInit</procedure></A> (self       : RotateRequest;
                             start, dur : REAL;
                             a          : REAL) : RotateRequest =
  BEGIN
    EVAL Request.init (self, start, dur);
    self.a := a;
    RETURN self;
  END RotateRequestInit;

TYPE
  RotateXReq = RotateRequest BRANDED OBJECT
  OVERRIDES
    value := RotateXReqValue;
  END;

PROCEDURE <A NAME="RotateXReqValue"><procedure>RotateXReqValue</procedure></A> (self              : RotateXReq;
                           READONLY startval : Matrix4.T;
                           reltime           : REAL) : Matrix4.T =
  VAR
    f : REAL;
  BEGIN
    IF self.dur # 0.0 THEN
      f := (reltime - self.start) / self.dur;
    ELSE
      f := 1.0;
    END;
    RETURN Matrix4.RotateX (startval, self.a * f);
  END RotateXReqValue;

TYPE
  RotateYReq = RotateRequest BRANDED OBJECT
  OVERRIDES
    value := RotateYReqValue;
  END;

PROCEDURE <A NAME="RotateYReqValue"><procedure>RotateYReqValue</procedure></A> (self              : RotateYReq;
                           READONLY startval : Matrix4.T;
                           reltime           : REAL) : Matrix4.T =
  VAR
    f : REAL;
  BEGIN
    IF self.dur # 0.0 THEN
      f := (reltime - self.start) / self.dur;
    ELSE
      f := 1.0;
    END;
    RETURN Matrix4.RotateY (startval, self.a * f);
  END RotateYReqValue;

TYPE
  RotateZReq = RotateRequest BRANDED OBJECT
  OVERRIDES
    value := RotateZReqValue;
  END;

PROCEDURE <A NAME="RotateZReqValue"><procedure>RotateZReqValue</procedure></A> (self              : RotateZReq;
                           READONLY startval : Matrix4.T;
                           reltime           : REAL) : Matrix4.T =
  VAR
    f : REAL;
  BEGIN
    IF self.dur # 0.0 THEN
      f := (reltime - self.start) / self.dur;
    ELSE
      f := 1.0;
    END;
    RETURN Matrix4.RotateZ (startval, self.a * f);
  END RotateZReqValue;
</PRE>***************************************************************************
 Animation queue for synchronous point property value behavior             
***************************************************************************

<P>
<P><PRE>TYPE
  MyAnimRequestQueue = AnimRequestQueue.T BRANDED OBJECT
    matrix : Matrix4.T;  (* The initial value of the pv *)
  METHODS
    init (ah : AnimHandle.T; READONLY matrix : Matrix4.T) : MyAnimRequestQueue
      := MyAnimRequestQueue_Init;
    value (time : LONGREAL) : Matrix4.T RAISES {Prop.BadMethod}
      := MyAnimRequestQueue_Value;
  OVERRIDES
    flush := MyAnimRequestQueue_Flush;
  END;

PROCEDURE <A NAME="MyAnimRequestQueue_Init"><procedure>MyAnimRequestQueue_Init</procedure></A> (self            : MyAnimRequestQueue;
                                   ah              : AnimHandle.T;
                                   READONLY matrix : Matrix4.T) : MyAnimRequestQueue =
  BEGIN
    EVAL AnimRequestQueue.T.init (self, ah);
    self.matrix := matrix;
    RETURN self;
  END MyAnimRequestQueue_Init;

PROCEDURE <A NAME="MyAnimRequestQueue_Value"><procedure>MyAnimRequestQueue_Value</procedure></A> (self : MyAnimRequestQueue;
                                    time : LONGREAL) : Matrix4.T
    RAISES {Prop.BadMethod} =
  VAR
    l       := self.list;
    req     : Request;
    matrix  : Matrix4.T;
    reltime : REAL;
  BEGIN
    IF self.ah.activated THEN
      reltime := FLOAT (time - self.ah.starttime);
      matrix := self.matrix;
      WHILE l # NIL DO
        req := l.req;
        IF reltime &lt; req.start  THEN
          RETURN matrix;
        ELSIF reltime &lt; req.start + req.dur THEN
          RETURN req.value (matrix, reltime);
        ELSE
          matrix := req.value (matrix, req.start + req.dur);
          l := l.next;
        END;
      END;
      RETURN matrix;
    ELSE
      RETURN self.matrix;
    END;
  END MyAnimRequestQueue_Value;

PROCEDURE <A NAME="MyAnimRequestQueue_Flush"><procedure>MyAnimRequestQueue_Flush</procedure></A> (self : MyAnimRequestQueue) =
  VAR
    req : Request;
  BEGIN
    WHILE self.list # NIL DO
      req := self.list.req;
      TRY
        self.matrix := req.value (self.matrix, req.start + req.dur);
      EXCEPT
        Prop.BadMethod (msg) =&gt; AnimServer.ReportError (msg);
      END;
      self.list := self.list.next;
    END;
  END MyAnimRequestQueue_Flush;
</PRE>***************************************************************************
 Stack                                                                     
***************************************************************************

<P><PRE>REVEAL
  <A NAME="Stack">Stack</A> = PublicStack BRANDED OBJECT
    cnt  : INTEGER;
    vals : REF ARRAY OF Base;
  METHODS
    init (READONLY top : Base) : Stack := InitStack;
  OVERRIDES
    push := PushStack;
    pop  := PopStack;
  END;

PROCEDURE <A NAME="InitStack"><procedure>InitStack</procedure></A> (self : Stack; READONLY top : Base) : Stack =
  BEGIN
    self.cnt  := 0;
    self.vals := NEW (REF ARRAY OF Base, 10);
    self.top  := top;
    RETURN self;
  END InitStack;

PROCEDURE <A NAME="PushStack"><procedure>PushStack</procedure></A> (self : Stack; READONLY val : Base) =
  BEGIN
    IF self.cnt &gt;= LAST (self.vals^) THEN
      WITH tmp = NEW (REF ARRAY OF Base, 2 * NUMBER (self.vals^)) DO
        SUBARRAY (tmp^, 0, NUMBER (self.vals^)) := self.vals^;
        self.vals := tmp;
      END;
    END;
    self.vals[self.cnt] := self.top;
    self.top := val;
    INC (self.cnt);
  END PushStack;

PROCEDURE <A NAME="PopStack"><procedure>PopStack</procedure></A> (self : Stack) : Base =
  BEGIN
    DEC (self.cnt);
    self.top := self.vals[self.cnt];
    RETURN self.top;
  END PopStack;

BEGIN
END TransformProp.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
