<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/Trestle_PEX_Base.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/Trestle_PEX_Base.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Tue Aug 30 09:47:29 PDT 1994 by najork                   

<P>
<P><PRE>UNSAFE MODULE <module>Trestle_PEX_Base</module> EXPORTS <A HREF="Trestle_PEX_Base.i3"><implements>Trestle_PEX_Base</A></implements>, <A HREF="Trestle_PEX_BaseProxy.i3"><implements>Trestle_PEX_BaseProxy</A></implements>;

&lt;* PRAGMA LL *&gt;

IMPORT <A HREF="CameraGOPrivate.i3">CameraGOPrivate</A>, <A HREF="GOPrivate.i3">GOPrivate</A>, <A HREF="GraphicsBasePrivate.i3">GraphicsBasePrivate</A>, <A HREF="GraphicsState.i3">GraphicsState</A>,
       <A HREF="GraphicsStatePex.i3">GraphicsStatePex</A>, <A HREF="KeyCB.i3">KeyCB</A>, <A HREF="MouseCB.i3">MouseCB</A>, <A HREF="../../PEX/src/PEX.i3">PEX</A>, <A HREF="PositionCB.i3">PositionCB</A>, <A HREF="../../geometry/src/Region.i3">Region</A>,
       <A HREF="RootGOPrivate.i3">RootGOPrivate</A>, <A HREF="../../ui/src/vbt/Trestle.i3">Trestle</A>, <A HREF="../../ui/src/xvbt/TrestleOnX.i3">TrestleOnX</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

IMPORT <A HREF="../../rw/src/Common/IO.i3">IO</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
    vv : VisibleVBT;
      (* The on-screen VBT. Created once; installed by client,
         doesn't change. *)
    vh : VBT.Leaf;
      (* The hidden (off-screen) VBT. Created (and deleted) whenever the
         size or the screentype of the on-screen VBT changes.
         Notification through the reshape method. *)
    trsl : Trestle.T;
      (* The Trestle WS connection. Derived from the on-screen VBT.
         May change; notification through the rescreen method. *)
    dpy : X.DisplayStar;
      (* Derived from trsl. Notification of change through the rescreen or
         reshape method. *)
    drawable : X.Drawable;
      (* The X drawable onto which PEX draws. Starts out as X.None.
         Derived from the offscreen VBT. *)
    vinfo : X.XVisualInfo;
      (* The visual info structure of the drawable. Contains undefined data
         if drawable is X.None. Might change when drawable changes, but
         does not have to. *)
    cmap_info : X.XStandardColormap;
      (* Computed from the visual. Changes whenever the visual changes.
         NOT CLEAR HOW TO CONVINCE vv AND vh TO USE THIS COLOR MAP. *)
    capx_info : PEX.pxlColourApproxEntry;
      (* Computed from the visual, together with the color map. It might be
         that I can derive a capx_info from visual and ANY color map, in which
         case I could use the color map that comes with the off-screen
         window. *)
    rd : PEX.pexRenderer;
      (* The PEX renderer. Changes when the display changes, or when the
         depth or the root of the drawable change. *)
    depthCueLut : PEX.pxlLookupTable;
      (* The depth cue lookup table. Initially set to X.None. Changes when
         the display changes,  or when the depth or the root of the drawable
         change. *)
    lightLut : PEX.pxlLookupTable;
      (* The light lookup table. Initially set to X.None. Changes when the
         display changes, or when the depth or the root of the drawable
         change. *)
    viewLut : PEX.pxlLookupTable;
      (* The view lookup table. Initially set to X.None. Changes when the
         display changes, or when the depth or the root of the drawable
         change. *)
    capxLut : PEX.pxlLookupTable;
      (* The color approximation lookup table. Initially set to X.None.
         Changes when the display changes, or when the depth or the root of
         the drawable change. *)
    dim : Point.T;
      (* Dimensions of &quot;vh&quot;. Notification of change through reshape method. *)
    state : GraphicsState.T;
      (* The graphics state. A relict. Contains various oc buffers, which
         should change whenever the renderer changes. *)
  (*** variables used to communicate with the render thread ***)
    transflag : BOOLEAN;
  OVERRIDES
    init               := Init;
    getVBT             := GetVBT;
  (*** GraphicsBase.T methods ***)
</PRE><BLOCKQUOTE><EM>    setBackgroundColor := SetBackgroundColor;</EM></BLOCKQUOTE><PRE>
  (*** called only by the animation server thread ***)
    processEvents      := ProcessEvents;
    repair             := Repair;
</PRE><BLOCKQUOTE><EM>    unmap              := Unmap;</EM></BLOCKQUOTE><PRE>
  END;
</PRE> Init creates a VBT for displaying a 3D scene. It is up to the
   client to install this VBT into Trestle. Until the VBT is installed,
   none of the associated X resources (display, window, colormap, etc)
   can be determined. So, all the PEX initialization is handled by the 
   animation server thread, once the VBT is installed and the root got 
   damaged. 

<P>
<P><PRE>PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T) : T =
  BEGIN
    self.vv       := NEW (VisibleVBT, base := self);

    (*** All the other fields are set to default values ***)
    self.vh       := NIL;
    self.dim      := Point.Origin;
    self.trsl     := NIL;
    self.dpy      := NIL;
    self.drawable := X.None;

    RETURN self;
  END Init;

PROCEDURE <A NAME="GetVBT"><procedure>GetVBT</procedure></A> (self : T) : VBT.T =
  BEGIN
    RETURN self.vv;
  END GetVBT;

PROCEDURE <A NAME="DiscardBase"><procedure>DiscardBase</procedure></A> (self : T) =
  BEGIN
    self.vv := NIL;

    (*** Delete the hidden VBT ***)
    IF self.vh # NIL THEN
      Trestle.Delete (self.vh);
      self.vh := NIL;
    END;
  END DiscardBase;

PROCEDURE <A NAME="ProcessEvents"><procedure>ProcessEvents</procedure></A> (&lt;* UNUSED *&gt; self : T) =
  BEGIN
    (* do nothing *)
  END ProcessEvents;

PROCEDURE <A NAME="Repair"><procedure>Repair</procedure></A> (self : T; VAR damaged : BOOLEAN) =

  PROCEDURE FillOcBuffer () =
    BEGIN
      (* In the new regime, I should not need the locks &quot;man&quot; and &quot;self.state&quot;.
         &quot;X_PEX_Base&quot; still uses them (but should not need to ...). *)

      (*** Lock the display connection ***)
      TrestleOnX.Enter (self.trsl);

      (*** determine the object's current transparency ***)
      self.transflag := self.root.needsTransparency(0.0);
                                   (* 0.0 is the default transmission coeff *)

      (*** flush and initialize OC buffers ***)
      PEX.PEXFlushOCBuffer   (self.state.camOcBuf);
      PEX.PEXFlushOCBuffer   (self.state.lightOcBuf);
      PEX.PEXFlushOCBuffer   (self.state.oc);

      self.state.setup ();
      PEX.PEXSetDepthCueIndex(self.state.oc, 1);

      (*** draw the object into the oc buffer ***)
      self.root.draw (self.state, NIL);

      (*** now set up the camera ***)
      self.root.cam.view (self.state, self.root);

      self.state.establishLights ();

      (*** show the result of the drawing ***)
      ShowWindow (self);

      (*** Release the display connection. ***)
      TrestleOnX.Exit (self.trsl);
    END FillOcBuffer;

  BEGIN
    IF self.root # NIL THEN

      (* If &quot;self.vh&quot; is &quot;NIL&quot;, then the X and PEX resources are not
         yet available, so no damage repair is performed. *)

      IF self.vh = NIL THEN
        RETURN;
      END;

      (*** Redraw the scene only if it was damaged ***)
      IF self.root.damaged THEN
        damaged := TRUE;
        (* Fill the output command buffer. We could inline this call. *)
        FillOcBuffer ();
      END;
    END;

  END Repair;

TYPE
  DrawableRec = RECORD
    vbt  : VBT.Leaf;
    id   : X.Drawable;
    root : X.Window;
    depth: Ctypes.Int;
    vinfo: X.XVisualInfo;
  END;

PROCEDURE <A NAME="UpdateDrawableRec"><procedure>UpdateDrawableRec</procedure></A> (dpy : X.DisplayStar;
                             drw : X.Drawable) : DrawableRec =
  VAR
    xwinattrs : X.XWindowAttributes;
    num       : Ctypes.int;
    result    : DrawableRec;
  BEGIN
    result.drw   := drw;
    EVAL XGetWindowAttributes (dpy, drw, ADR (xwinattrs));
    result.depth := xwinattrs.depth;
    result.root  := xwinattrs.root;
    WITH list = LOOPHOLE (X.XGetVisualInfo (dpy, X.VisualNoMask, NIL,
                                            ADR (num)),
                          UNTRACED REF ARRAY [1..1000] OF X.XVisualInfo) DO
      FOR i := 0 TO num - 1 DO
        IF list[i].visual = xwinattrs.visual THEN
          result.vinfo := list[i];
          X.XFree (list);
          EXIT;
        END;
      END;
    END;
  END UpdateDrawableRec;

PROCEDURE <A NAME="CreateHiddenVBT"><procedure>CreateHiddenVBT</procedure></A> (self : T) =
  VAR
    dpyChanged : BOOLEAN;
    screenrec : Trestle.ScreenOfRec;
    dom := VBT.Domain (self.vv);
    dim := Point.T {dom.east - dom.west, dom.south - dom.north};
  BEGIN
    (*** Determine the Trestle ***)
    screenrec := Trestle.ScreenOf (viewer, Point.T {0, 0});
    IF screenrec.trsl = NIL THEN
      IO.Put (&quot;Warning: No Trestle allocated!\n&quot;);
      RETURN;
    END;
    self.trsl := screenrec.trsl;

    (*** Determine the X display ***)
    WITH dpy = TrestleOnX.Dpy (screenrec.trsl) DO
      IF dpy = NIL THEN
        IO.Put (&quot;Warning: Cannot determine X display!\n&quot;);
        RETURN;
      END;
      IF dpy # self.dpy THEN
        dpyChanged := TRUE;
        self.dpy := dpy;
      ELSE
        dpyChanged := FALSE;
      END;
    END;

    (*** Allocate all the resources that depend on the X display ***)

    (*** OMITTING Visual ***)

    (*** OMITTING ColorMap ***)

    (*** If the size of &quot;self.vv&quot; has changed, we delete &quot;self.vh&quot;. ***)
    IF self.vh # NIL AND self.dim # dim AND dim # Point.Origin THEN
      haveOldDraw := TRUE;
      oldDrw := self.drw;
      Trestle.Delete (self.vh);
      self.vh := NIL;
    END;

    (*** If necessary, create the offscreen VBT ***)
    IF self.vh = NIL AND dim # Point.Origin THEN
      self.vh := NEW (VBT.Leaf);
      self.dim := dim;
      Trestle.Attach (self.vh);
      Trestle.InstallOffscreen (self.vh, dim.h, dim.v, VBT.ScreenTypeOf (v));
      self.drw := UpdateDrawableRec (self.dpy, TrestleOnX.Drawable (self.vh));

      (* Determine the visual of &quot;self.drawable&quot;, create color map
         and color approximation table if needed. *)
      IF self.novisual OR oldDrw.vinfo # self.drw.vinfo THEN
        self.novisual := FALSE;
        CreateColorMap (self.dpy, self.drw.vinfo, cmap_info, self.capx_info);
      END;

      (*** Create the PEX lookup tables ***)
</PRE><BLOCKQUOTE><EM><P>
       We need to create lookup tables in 4 cases:
       (1) If they have not been created before
       (2) If the display has changed
       (3) If the root of the drawable has changed
       (4) If the depth of the drawable has changed
       In cases (2) - (4), we should delete the old lookup tables first.
<P>
       We need to create a new renderer in exacly the same cases.
</EM></BLOCKQUOTE><PRE>

      IF dpyChanged OR (haveOldDrw AND (oldDrw.root # drw.root OR
                                        oldDrw.depth # drw.depth)) THEN
        IF

      self.viewLut := PEX.PEXCreateLookupTable (self.dpy, self.drawable,
                                                PEX.PEXViewLUT);
      self.lightLut := PEX.PEXCreateLookupTable (self.dpy, self.drawable,
                                                 PEX.PEXLightLUT);
      self.depthCueLut := PEX.PEXCreateLookupTable (self.dpy, self.drawable,
                                                    PEX.PEXDepthCueLUT);

      (*** create the PEX renderer ***)
      rmask := PEX.PEXRDClipList;

      attribs.hlhsrMode := PEX.PEXHlhsrZBuffer;
      rmask := Word.Or (rmask, PEX.PEXRDHlhsrMode);

      attribs.viewTable := self.viewLut;
      rmask := Word.Or (rmask, PEX.PEXRDViewTable);

      attribs.lightTable := self.lightLut;
      rmask := Word.Or (rmask, PEX.PEXRDLightTable);

      attribs.depthCueTable := self.depthCueLut;
      rmask := Word.Or (rmask, PEX.PEXRDDepthCueTable);

  END CreateHiddenVBT;

PROCEDURE <A NAME="ShowWindow"><procedure>ShowWindow</procedure></A> (self : T) =
  BEGIN
  END ShowWindow;
</PRE>***************************************************************************
 VisibleVBT                                                                
***************************************************************************

<P>
<P><PRE>TYPE
  VisibleVBT = VBT.Leaf BRANDED OBJECT
    base : T;
  OVERRIDES
    rescreen  := Rescreen;
    redisplay := Redisplay;
    repaint   := Repaint;
    reshape   := Reshape;
    mouse     := Mouse;
    position  := Position;
    key       := Key;
    discard   := Discard;
  END;

PROCEDURE <A NAME="Redisplay"><procedure>Redisplay</procedure></A> (self : VisibleVBT) =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
    IO.Put (&quot;Redisplay called\n&quot;);
    VBT.Leaf.redisplay (self);
  END Redisplay;

PROCEDURE <A NAME="Rescreen"><procedure>Rescreen</procedure></A> (self : VisibleVBT; READONLY cd : VBT.RescreenRec) =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
    IO.Put (&quot;Rescreen called\n&quot;);
    VBT.Leaf.rescreen (self, cd);
  END Rescreen;

PROCEDURE <A NAME="Reshape"><procedure>Reshape</procedure></A> (self : VisibleVBT; READONLY cd : VBT.ReshapeRec) =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
    IO.Put (&quot;Reshape called\n&quot;);
    VBT.Leaf.reshape (self, cd);
  END Reshape;

PROCEDURE <A NAME="Repaint"><procedure>Repaint</procedure></A> (self : VisibleVBT; READONLY rgn: Region.T) =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
    IO.Put (&quot;Repaint called\n&quot;);
    VBT.Leaf.repaint (self, rgn);
  END Repaint;

PROCEDURE <A NAME="Mouse"><procedure>Mouse</procedure></A> (self : VisibleVBT; READONLY cd : VBT.MouseRec) =
  BEGIN
    WITH mr = MouseCB.Rec {pos2D       := cd.cp.pt,
                           whatChanged := cd.whatChanged,
                           modifiers   := cd.modifiers,
                           clickType   := cd.clickType} DO
      self.base.root.invokeMouseCB (mr);
    END;
  END Mouse;

PROCEDURE <A NAME="Position"><procedure>Position</procedure></A> (self : VisibleVBT; READONLY cd: VBT.PositionRec) =
  BEGIN
    WITH pr = PositionCB.Rec {pos2D := cd.cp.pt,
                              modifiers := cd.modifiers} DO
      self.base.root.invokePositionCB (pr);
    END;
  END Position;
</PRE> Note: In order for a VBT to receive key events, we have to 
   <CODE>grab the focus</CODE> first.  I defer this for now ... 
<PRE>PROCEDURE <A NAME="Key"><procedure>Key</procedure></A> (self : VisibleVBT; READONLY cd: VBT.KeyRec) =
  BEGIN
    WITH kr = KeyCB.Rec {whatChanged := cd.whatChanged,
                         wentDown    := cd.wentDown,
                         modifiers   := cd.modifiers} DO
      self.base.root.invokeKeyCB (kr);
    END;
  END Key;
</PRE> The <CODE>discard</CODE> method is called by Trestle when the VBT <CODE>self</CODE> gets deleted.
   We need to notify <CODE>base</CODE> to perform some cleanup. 

<P><PRE>PROCEDURE <A NAME="Discard"><procedure>Discard</procedure></A> (self : VisibleVBT) =
  BEGIN
    DiscardBase (self.base);
  END Discard;

BEGIN
END Trestle_PEX_Base.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
