<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/VectorLightGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/VectorLightGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Wed Feb  9 17:14:29 PST 1994 by najork                   

<P>
<P><PRE>UNSAFE MODULE <module>VectorLightGO</module> EXPORTS <A HREF="VectorLightGO.i3"><implements>VectorLightGO</A></implements>, <A HREF="VectorLightGOProxy.i3"><implements>VectorLightGOProxy</A></implements>;

IMPORT <A HREF="AuxG.i3">AuxG</A>, <A HREF="BooleanPropPrivate.i3">BooleanPropPrivate</A>, <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="ColorPropPrivate.i3">ColorPropPrivate</A>, <A HREF="GO.i3">GO</A>, <A HREF="GOPrivate.i3">GOPrivate</A>,
       <A HREF="GraphicsState.i3">GraphicsState</A>, <A HREF="GraphicsStatePex.i3">GraphicsStatePex</A>, <A HREF="LightGO.i3">LightGO</A>, <A HREF="Matrix4.i3">Matrix4</A>, <A HREF="../../PEX/src/PEX.i3">PEX</A>, <A HREF="Point3.i3">Point3</A>,
       <A HREF="PointProp.i3">PointProp</A>, <A HREF="PointPropPrivate.i3">PointPropPrivate</A>, <A HREF="Prop.i3">Prop</A>, <A HREF="TransformPropPrivate.i3">TransformPropPrivate</A>;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (c : Color.T; dir : Point3.T) : T =
  VAR
    light := NEW (T).init ();
  BEGIN
    LightGO.SetColour (light, c);
    LightGO.SetSwitch (light, TRUE);
    SetDirection (light, dir);
    RETURN light;
  END New;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
  OVERRIDES
    init              := Init;
    draw              := Draw;
    damageIfDependent := DamageIfDependent;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T) : T =
  BEGIN
    EVAL GO.T.init (self);

    IF MkProxyT # NIL AND self.proxy = NIL THEN
      MkProxyT (self);
    END;

    RETURN self;
  END Init;

PROCEDURE <A NAME="DamageIfDependent"><procedure>DamageIfDependent</procedure></A> (self : T; pn : Prop.Name) =
  BEGIN
    IF pn = LightGO.Switch OR pn = LightGO.Colour OR
       pn = Direction OR pn = GO.Transform THEN
      self.damaged := TRUE;
    END;
  END DamageIfDependent;

PROCEDURE <A NAME="Draw"><procedure>Draw</procedure></A> (self : T; state : GraphicsState.T) =
  VAR
    color : Color.T;
    dir   : Point3.T;
    light : PEX.pxlLightEntry;
    tm    : Matrix4.T;
  BEGIN
    state.push (self);

    (* Get the current light status from the state. If the switch is off,
       we don't need to do anything *)
    IF LightGO.Switch.getState (state) THEN

      (* Get the current light color from the state *)
      color := LightGO.Colour.getState (state);

      (* Get the current direction from the state *)
      dir := Direction.getState (state);

      (* Get the current transformation matrix. *)
      tm := GO.Transform.getState (state);

      (* Transform dir into world coordinate space. Mask out any translations.
         We don't care about scalings. We do care about rotations. *)

      &lt;* ASSERT tm[3][0] = 0.0 AND tm[3][1] = 0.0 AND
                tm[3][2] = 0.0 AND tm[3][3] = 1.0 *&gt;

      dir := Point3.T {
                 tm[0][0] * dir.x + tm[0][1] * dir.y + tm[0][2] * dir.z,
                 tm[1][0] * dir.x + tm[1][1] * dir.y + tm[1][2] * dir.z,
                 tm[2][0] * dir.x + tm[2][1] * dir.y + tm[2][2] * dir.z};

      (* Build a PEX light structure *)
      light.lightType := PEX.PEXLightWcsVector;
      light.lightColour := AuxG.MkRgbFloatColour (color);
      light.direction := dir;

      (* Add the light to the graphics state's light set *)
      state.addLight (light);
    END;

    self.damaged := FALSE;
    state.pop (self);
  END Draw;
</PRE>***************************************************************************
 Convenience Procedures                                                    
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetDirection"><procedure>SetDirection</procedure></A> (o : GO.T; v : Point3.T) =
  BEGIN
    o.setProp (Direction.bind (PointProp.NewConst (v)));
  END SetDirection;

BEGIN
  Direction := NEW (PointProp.Name).init (Point3.T {1.0, 1.0, 1.0});
END VectorLightGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
