<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/X_PEX_Base.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/X_PEX_Base.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Wed Feb 16 17:12:53 PST 1994 by najork                   

<P> <CODE>X_PEX_Base.T</CODE> is a subtype of \type{GraphicsBase}{T}. An object of 
   this type provides an abstract interface to X windows and PEX. 

<P><PRE>INTERFACE <interface><A HREF="X_PEX_Base.m3">X_PEX_Base</A></interface>;

IMPORT <A HREF="GraphicsBase.i3">GraphicsBase</A>;

EXCEPTION Failure;

TYPE
  <A HREF="X_PEX_Base.m3#T">T</A> &lt;: Public;
  Public = GraphicsBase.T OBJECT
  METHODS
    init (title : TEXT; win_x, win_y := 10; win_w, win_h := 500) : T
        RAISES {Failure};
    changeTitle (title : TEXT);
    awaitDelete ();
    destroy ();
  END;
</PRE> <CODE>gb.init</CODE> initializes a new graphics base and returns it. As a side
   effect, it creates a window <CODE>win_w</CODE> by <CODE>win_h</CODE> pixels in size, and
   <CODE>win_x</CODE>,<CODE>win_y</CODE> pixels offset from the upper left corner of the screen. 
<P>
   <CODE>gb.changeTitle(title)</CODE> changes the title of the X window associated
   with <CODE>gb</CODE> to <CODE>title</CODE>. 
<P>
   Calling <CODE>gb.awaitDelete ()</CODE> suspends the calling thread until the window
   associated with <CODE>gb</CODE> gets destroyed. 
<P>
   Calling <CODE>gb.destroy()</CODE> destroys the X window. 

<P><PRE>PROCEDURE <A HREF="X_PEX_Base.m3#Available">Available</A> () : BOOLEAN;
</PRE><BLOCKQUOTE><EM> <CODE>Available()</CODE> returns <CODE>TRUE</CODE> if PEX is supported by the current X server. </EM></BLOCKQUOTE><PRE>

END X_PEX_Base.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
