<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/X_PEX_Base.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/X_PEX_Base.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Wed Feb 16 17:15:31 PST 1994 by najork                   

<P>
<P><PRE>UNSAFE MODULE <module>X_PEX_Base</module> EXPORTS <A HREF="X_PEX_Base.i3"><implements>X_PEX_Base</A></implements>, <A HREF="X_PEX_BaseProxy.i3"><implements>X_PEX_BaseProxy</A></implements>;

IMPORT <A HREF="AnimServer.i3">AnimServer</A>, <A HREF="AuxG.i3">AuxG</A>, <A HREF="CameraGOPrivate.i3">CameraGOPrivate</A>, <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="GOPrivate.i3">GOPrivate</A>,
       <A HREF="GraphicsBasePrivate.i3">GraphicsBasePrivate</A>, <A HREF="GraphicsState.i3">GraphicsState</A>, <A HREF="GraphicsStatePex.i3">GraphicsStatePex</A>, <A HREF="KeyCB.i3">KeyCB</A>,
       <A HREF="../../ui/src/vbt/KeyboardKey.i3">KeyboardKey</A>, <A HREF="../../C/src/Common/M3toC.i3">M3toC</A>, <A HREF="../../arith/src/Math.i3">Math</A>, <A HREF="MouseCB.i3">MouseCB</A>, <A HREF="../../PEX/src/PEX.i3">PEX</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="PositionCB.i3">PositionCB</A>, <A HREF="../../os/src/Common/Process.i3">Process</A>,
       <A HREF="RootGOPrivate.i3">RootGOPrivate</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../word/src/Word.i3">Word</A>, <A HREF="../../X11R4/src/Common/X.i3">X</A>, <A HREF="../../X11R4/src/Common/Xatom.i3">Xatom</A>, <A HREF="../../X11R4/src/Common/Xmbuf.i3">Xmbuf</A>;

IMPORT <A HREF="../../rw/src/Common/FileRd.i3">FileRd</A>, <A HREF="#x1">FloatMode</A>, <A HREF="../../fmtlex/src/Lex.i3">Lex</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../parseparams/src/ParseParams.i3">ParseParams</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/Stdio.i3">Stdio</A>;

&lt;* FATAL X.Error *&gt;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
  (*** all of this should eventually be hidden ***)
    window              : X.Window;
    capx_info           : PEX.pxlColourApproxEntry;
    xmbBuffers          : ARRAY BOOLEAN OF X.XID;
    curBuf              := FALSE;
    rd                  : PEX.pexRenderer;
    depthCueLut         : PEX.pxlLookupTable;
    lightLut            : PEX.pxlLookupTable;
    viewLut             : PEX.pxlLookupTable;
    dc                  : PEX.pxlDepthCueEntry;
    state               : GraphicsState.T;
    oc_ma               : PEX.pxlOCBufStar;
    oc_mutex            : MUTEX;      (* protects oc_ma *)
  (*** variables used to communicate with the render thread ***)
    transflag           : BOOLEAN;
  (*** variables for event handling ***)
    modifiers           : VBT.Modifiers;
    buttonDownCount     : INTEGER;
  (*** main thread suspension ***)
    awaitDeleteMu       : Thread.Mutex;      (*** useless except for Wait ***)
    awaitDeleteCV       : Thread.Condition;
  OVERRIDES
    init               := Init;
    changeTitle        := ChangeTitle;
    awaitDelete        := AwaitDelete;
    setBackgroundColor := SetBackgroundColor;
    destroy            := Destroy;
  (*** called only by the animation server thread ***)
    processEvents      := ProcessEvents;
    repair             := Repair;
    unmap              := Unmap;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self  : T;
                title : TEXT;
                win_x, win_y, win_w, win_h : INTEGER) : T RAISES {Failure} =
  CONST
    ocsize   = 8192;
    bw       = 1;                               (* window border width *)
  VAR
    attribs   : PEX.pxlRendererAttributes;	(* renderer attributes *)
    rmask     : Ctypes.unsigned_int;            (* renderer attribute mask *)
    mpexRA    : PEX.mpxlRendererAttributes;
    visual    : X.XVisualInfo;
    cmap_info : X.XStandardColormap;
    capx_info : PEX.pxlColourApproxEntry;
    wattrs    : X.XSetWindowAttributes;         (* window attributes *)
    wmask     : Ctypes.unsigned_long;           (* window attribute mask *)
  BEGIN
    (*** First, ensure that there is a display connection ***)
    IF man = NIL THEN
      man := NEW (Manager).init ();
    END;

    (*** Initialize awaitDeleteCV ***)
    self.awaitDeleteMu := NEW (Thread.Mutex);
    self.awaitDeleteCV := NEW (Thread.Condition);

    WITH disp = man.disp, window = self.window, xmbBuffers = self.xmbBuffers,
         curBuf = self.curBuf, rd = self.rd DO
      LOCK man DO

        (*** Create and initialize a window ***)
        visual := FindBestVisual (disp);
        CreateColorMap (disp, visual, cmap_info, capx_info);
        self.capx_info := capx_info;

        (*** create and initialize a window ***)

        (* Create the output window. *)
        wmask := 0;

        wattrs.background_pixel := X.XBlackPixel(disp, X.XDefaultScreen(disp));
        wmask := Word.Or (wmask, X.CWBackPixel);

        wattrs.border_pixel := X.XWhitePixel (disp, X.XDefaultScreen(disp));
        wmask := Word.Or (wmask, X.CWBorderPixel);

        wattrs.colormap := cmap_info.colormap;
        wmask := Word.Or (wmask, X.CWColormap);

        window := X.XCreateWindow (disp, X.XRootWindow (disp, visual.screen),
                                   win_x, win_y, win_w, win_h, bw,
                                   visual.depth, X.InputOutput,
                                   visual.visual, wmask, ADR (wattrs));

        IF NOT TestEnumAvailable (self,
                                  PEX.PEXETColourType,
                                  PEX.PEXRgbFloatColour) THEN
          RAISE Failure;
        END;

        X.XSelectInput(
                    disp, window,
                    Word.Or(X.ExposureMask,
                     Word.Or(X.StructureNotifyMask,
                      Word.Or(X.KeyPressMask,
                       Word.Or(X.KeyReleaseMask,
                        Word.Or(X.ButtonPressMask,
                         Word.Or(X.ButtonReleaseMask,X.PointerMotionMask)))))));

        (*** set the window's title ***)

        X.XChangeProperty(disp, window, Xatom.XA_WM_NAME, Xatom.XA_STRING, 8,
                          X.PropModeReplace,
                          LOOPHOLE (M3toC.TtoS (title),
                                    Ctypes.unsigned_char_star),
                          Text.Length (title));

        (*** ask the WM to send ClientMessage events when f.kill is chosen ***)

        EVAL X.XSetWMProtocols (disp, window, ADR (man.wm_delete_window), 1);

        (*** map the window ***)

        X.XMapWindow(disp, window);

        (*** create a pixmap for double buffering ***)

        EVAL Xmbuf.XmbufCreateBuffers(disp, window, 2,
                                      Xmbuf.MultibufferActionCopied,
                                      Xmbuf.MultibufferHintFrequent,
                                      ADR (xmbBuffers));
        curBuf := FALSE;

        (*** create the lookup tables ***)

        self.viewLut :=
                    PEX.PEXCreateLookupTable(disp, window, PEX.PEXViewLUT);
        self.lightLut :=
                    PEX.PEXCreateLookupTable(disp, window, PEX.PEXLightLUT);
        self.depthCueLut :=
                    PEX.PEXCreateLookupTable(disp, window, PEX.PEXDepthCueLUT);

        (*** create the renderer ***)

        rmask := PEX.PEXRDClipList;

        attribs.hlhsrMode := PEX.PEXHlhsrZBuffer;
        rmask := Word.Or (rmask, PEX.PEXRDHlhsrMode);

        attribs.viewTable := self.viewLut;
        rmask := Word.Or (rmask, PEX.PEXRDViewTable);

        attribs.lightTable := self.lightLut;
        rmask := Word.Or (rmask, PEX.PEXRDLightTable);

        attribs.depthCueTable := self.depthCueLut;
        rmask := Word.Or (rmask, PEX.PEXRDDepthCueTable);

        (* Create a color approximation table and set the default entry,
           entry 0, to the colormap approximation specified. *)

        rmask := Word.Or (rmask, PEX.PEXRDColourApproxTable);
        attribs.colourApproxTable :=
            PEX.PEXCreateLookupTable (disp, window, PEX.PEXColourApproxLUT);
        PEX.PEXSetTableEntries (disp, attribs.colourApproxTable,
                                PEX.PEXColourApproxLUT, 0, 1, ADR (capx_info));

        rd := PEX.PEXCreateRenderer (disp, window, rmask, ADR (attribs));

        (********** crucial for MIT double buffering **********)

        mpexRA.backgroundPixel := X.XBlackPixel (disp, X.XDefaultScreen(disp));
        mpexRA.clearI := PEX.PEXOn;
        mpexRA.clearZ := PEX.PEXOn;
        PEX.MPEXChangeNewRenderer(disp, rd,
                                   Word.Or(PEX.MPEXNRAClearI,
                                    Word.Or(PEX.MPEXNRAClearZ,
                                            PEX.MPEXNRABackgroundPixel)),
                                   ADR(mpexRA));

        (*** create the output command buffers ***)

        self.state := NEW (GraphicsState.T).init (
                    PEX.PEXAllocateRetainedOCBuffer(
                                   disp,PEX.pxlRenderImmediate,
                                   rd, PEX.PEXDefaultOCError, ocsize));

        (*** hacks ***)
        self.state.base := self;
        self.state.disp := disp;
        self.state.viewLut := self.viewLut;
        self.state.lightLut := self.lightLut;
        self.state.depthCueLut := self.depthCueLut;
        self.state.lightOcBuf := PEX.PEXAllocateRetainedOCBuffer(
                                     disp,PEX.pxlRenderImmediate,
                                     rd, PEX.PEXDefaultOCError, ocsize);
        self.state.camOcBuf := PEX.PEXAllocateRetainedOCBuffer(
                                     disp,PEX.pxlRenderImmediate,
                                     rd, PEX.PEXDefaultOCError, ocsize);

        self.oc_mutex := NEW (MUTEX);
        self.oc_ma := PEX.PEXAllocateRetainedOCBuffer(
                                   disp,PEX.pxlRenderImmediate,
                                   rd, PEX.PEXDefaultOCError, ocsize);

        (*** initialize depth cueing with default values ***)

        self.dc.mode         := PEX.PEXOff;
        self.dc.frontPlane   := 1.0;
        self.dc.backPlane    := 0.0;
        self.dc.frontScaling := 1.0;
        self.dc.backScaling  := 0.0;
        self.dc.depthCueColour := AuxG.MkRgbFloatColour(Color.Black);
        PEX.PEXSetTableEntries (man.disp, self.depthCueLut, PEX.PEXDepthCueLUT,
                                1, 1, ADR (self.dc));

      END; (* release the display lock *)
    END;

    self.modifiers := VBT.Modifiers {};
    self.buttonDownCount := 0;

    self.status := GraphicsBasePrivate.Status.Mapped;

    WITH pp = NEW(ParseParams.T).init(Stdio.stderr) DO
      IF pp.keywordPresent(&quot;-largeCursor&quot;) THEN
        LargeCursor(self);
      END;
    END;

    IF MkProxyT # NIL THEN
      MkProxyT (self);
    END;

    RETURN self;
  END Init;

PROCEDURE <A NAME="LargeCursor"><procedure>LargeCursor</procedure></A> (self : T) =
  VAR
    pm := X.XCreatePixmap (man.disp, self.window, 64, 64, 1);
    fg, bg : X.XColor;
    hot : X.XPoint;
    pts : REF ARRAY OF X.XPoint;
    bg_gcv, fg_gcv : X.XGCValues;
    bg_gc, fg_gc : X.GC;
  BEGIN
    bg_gcv.function := X.GXclear;
    bg_gc := X.XCreateGC(man.disp, pm, X.GCFunction, ADR(bg_gcv));
    fg_gcv.function := X.GXset;
    fg_gc := X.XCreateGC(man.disp, pm, X.GCFunction, ADR(fg_gcv));

    TRY
      WITH rd = FileRd.Open(&quot;cursordata&quot;),
           n  = Lex.Int(rd) DO
        pts := NEW (REF ARRAY OF X.XPoint, n);
        FOR i := FIRST(pts^) TO LAST(pts^) DO
          pts[i].x := Lex.Int(rd); pts[i].y := Lex.Int(rd);
        END;
        hot.x := Lex.Int(rd); hot.y := Lex.Int(rd);
        fg.red := Lex.Int(rd); fg.green := Lex.Int(rd); fg.blue := Lex.Int(rd);
        bg.red := Lex.Int(rd); bg.green := Lex.Int(rd); bg.blue := Lex.Int(rd);
      END;
    EXCEPT
    | OSError.E, FloatMode.Trap, Lex.Error, Rd.Failure, Thread.Alerted =&gt;
      pts := NEW (REF ARRAY OF X.XPoint, 7);
      pts^ := ARRAY OF X.XPoint{X.XPoint{0,0},
                                X.XPoint{45,15},
                                X.XPoint{35,25},
                                X.XPoint{63,53},
                                X.XPoint{53,63},
                                X.XPoint{25,35},
                                X.XPoint{15,45}};
      hot.x := 0; hot.y := 0;
      fg.red := 65535; fg.green := 0; fg.blue := 0; (* red *)
      bg.red := 0;     bg.green := 0; bg.blue := 0; (* black *)
    END;

    X.XFillRectangle (man.disp, pm, bg_gc, 0, 0, 64, 64);
    X.XFillPolygon (man.disp, pm, fg_gc,
                    ADR(pts[0]), NUMBER(pts^),
                    X.Nonconvex,  X.CoordModeOrigin);
    WITH cursor = X.XCreatePixmapCursor(man.disp, pm, pm,
                                        ADR(fg), ADR(bg),
                                        hot.x, hot.y) DO
      X.XDefineCursor (man.disp, self.window, cursor);
    END;
  END LargeCursor;

PROCEDURE <A NAME="ChangeTitle"><procedure>ChangeTitle</procedure></A> (self: T; title : TEXT) =
  BEGIN
    LOCK man DO
      X.XChangeProperty (man.disp,
                         self.window,
                         Xatom.XA_WM_NAME,
                         Xatom.XA_STRING,
                         8,
                         X.PropModeReplace,
                         LOOPHOLE (M3toC.TtoS (title),
                                   Ctypes.unsigned_char_star),
                         Text.Length (title));
    END;
  END ChangeTitle;
</PRE> <CODE>SetBackgroundColor</CODE> is called by <CODE>RootGO.Draw</CODE>. The locking level is
   {AnimServer.internalLock, AnimServer.externalLock} 

<P><PRE>PROCEDURE <A NAME="SetBackgroundColor"><procedure>SetBackgroundColor</procedure></A> (self : T; color : Color.T) =
  VAR
    mpexRA : PEX.mpxlRendererAttributes;
  BEGIN
    WITH ca = self.capx_info,
         r = ca.mult1 * ROUND (FLOAT (ca.max1) * color.r),
         g = ca.mult2 * ROUND (FLOAT (ca.max2) * color.g),
         b = ca.mult3 * ROUND (FLOAT (ca.max3) * color.b) DO
      mpexRA.backgroundPixel := ca.basePixel + r + g + b;
      PEX.MPEXChangeNewRenderer (man.disp, self.rd, PEX.MPEXNRABackgroundPixel,
                                 ADR (mpexRA));
    END;
  END SetBackgroundColor;

PROCEDURE <A NAME="AwaitDelete"><procedure>AwaitDelete</procedure></A> (self : T) =
  BEGIN
    LOCK self.awaitDeleteMu DO
      Thread.Wait (self.awaitDeleteMu, self.awaitDeleteCV);
    END;
  END AwaitDelete;

PROCEDURE <A NAME="Destroy"><procedure>Destroy</procedure></A> (self : T) =
  BEGIN
    LOCK AnimServer.internalLock DO
      self.status := GraphicsBasePrivate.Status.Destroyed;
    END;
  END Destroy;

PROCEDURE <A NAME="Unmap"><procedure>Unmap</procedure></A> (self : T) =
  BEGIN
    (*** Destroy the window ***)
    X.XDestroyWindow (man.disp, self.window);
    X.XSync (man.disp, X.False);
    self.window := X.None;
    self.status := GraphicsBasePrivate.Status.Unmapped;

    (*** signal all threads that are blocked ***)
    Thread.Broadcast (self.awaitDeleteCV);
  END Unmap;

PROCEDURE <A NAME="Available"><procedure>Available</procedure></A> () : BOOLEAN =
  BEGIN
    IF man = NIL THEN
      man := NEW (Manager).init ();
    END;
    RETURN man.avail;
  END Available;
</PRE> Caller must hold man and self.state 

<P><PRE>PROCEDURE <A NAME="ShowWindow"><procedure>ShowWindow</procedure></A> (self : T) =
  VAR
    first : INTEGER;
  BEGIN
    WITH disp = man.disp, pixmap = self.xmbBuffers[self.curBuf], rd = self.rd DO
      (*** The thread must hold state before accessing state.oc,
           and oc_mutex before accessing oc_ma ***)
      LOCK self.oc_mutex DO
        IF self.transflag THEN
          first := X.True;
          REPEAT
            PEX.MPEXBeginTransparencyRendering(disp, pixmap, rd, first);
            PEX.PEXSendOCBuffer (self.oc_ma);
            PEX.PEXSendOCBuffer (self.state.camOcBuf);
            PEX.PEXSendOCBuffer (self.state.lightOcBuf);
            PEX.PEXSendOCBuffer (self.state.oc);
            first := X.False;
          UNTIL PEX.MPEXEndTransparencyRendering(disp, rd, X.True) = 0;
          PEX.PEXFlushOCBuffer(self.oc_ma);
        ELSE
          PEX.PEXBeginRendering(disp, pixmap, rd);
          PEX.PEXFlushOCBuffer(self.oc_ma);
          PEX.PEXSendOCBuffer (self.state.camOcBuf);
          PEX.PEXSendOCBuffer (self.state.lightOcBuf);
          PEX.PEXSendOCBuffer (self.state.oc);
          PEX.PEXEndRendering (disp, rd, X.True);
        END;
        Xmbuf.XmbufDisplayBuffers(disp, 1, ADR(pixmap), 0, 0);
        self.curBuf := NOT self.curBuf;

        X.XSync (disp, X.False);

      END;
    END;
  END ShowWindow;

PROCEDURE <A NAME="TestEnumAvailable"><procedure>TestEnumAvailable</procedure></A> (self : T;
                             enumType : Ctypes.int;
                             enumVal  : Ctypes.short) : BOOLEAN =
  TYPE
    T = UNTRACED REF ARRAY [0 .. 1000000] OF PEX.pxlEnumTypeDescList;
  VAR
    status : Ctypes.int;
    values : PEX.pxlEnumTypeDescListStar;
    count  : Ctypes.int;
  BEGIN
    status := PEX.PEXGetEnumTypeInfo (man.disp, self.window,
                                      enumType, PEX.PEXETIndex,
                                      ADR (values), ADR (count));
    &lt;* ASSERT status = 0 *&gt;
    WITH v = LOOPHOLE (values, T) DO
      FOR i := 0 TO count - 1 DO
        IF v[i].enumVal = enumVal THEN
          RETURN TRUE;
        END;
      END;
    END;
    RETURN FALSE;
  END TestEnumAvailable;
</PRE>***************************************************************************
 Event handling                                                            
***************************************************************************

<P><PRE>PROCEDURE <A NAME="ProcessEvents"><procedure>ProcessEvents</procedure></A> (self : T) =

  PROCEDURE CheckTypedWindowEvent (self : T;
                                   type : Ctypes.int;
                                   VAR event : X.XEvent) : X.Bool =
    BEGIN
      LOCK man DO
        RETURN X.XCheckTypedWindowEvent (man.disp, self.window, type, ADR (event));
      END;
    END CheckTypedWindowEvent;

  PROCEDURE CheckWindowEvent (self : T;
                              mask : Ctypes.long;
                              VAR event : X.XEvent) : X.Bool =
    BEGIN
      LOCK man DO
        RETURN X.XCheckWindowEvent (man.disp, self.window, mask, ADR (event));
      END;
    END CheckWindowEvent;

  VAR
    ev        : X.XEvent;
    button    : VBT.Button;
    clickType : VBT.ClickType;
    mask      : Ctypes.long;
  BEGIN
    (*** Set up the mask for events we are interested in. ***)

    mask := 0;
    mask := Word.Or (mask, X.ExposureMask);
    mask := Word.Or (mask, X.PointerMotionMask);   (* every motion! *)
    mask := Word.Or (mask, X.ButtonPressMask);
    mask := Word.Or (mask, X.ButtonReleaseMask);
    mask := Word.Or (mask, X.KeyPressMask);
    mask := Word.Or (mask, X.KeyReleaseMask);

    (*
     * For some reason, ClientMessage events are not picked up by
     * X.XCheckWindowEvent, so I take care of them here.
     *)

    IF CheckTypedWindowEvent (self, X.ClientMessage, ev) = X.True THEN
      WITH e = ClientMessageEvent(ev) DO
        IF e.message_type = man.wm_protocols AND e.format = 32 THEN
          WITH data = LOOPHOLE (e.data, ARRAY [0 .. 4] OF Ctypes.long) DO
            IF data[0] = man.wm_delete_window THEN
              self.destroy ();
              RETURN;
            END;
          END;
        END;
      END;
    END;

    (*
     * If there is no ClientMessage event indicating a &quot;delete window&quot;
     * request by the window manager, I look for other events pending:
     *)

    WHILE CheckWindowEvent (self, mask, ev) = X.True DO
      CASE ButtonEvent(ev).type OF
      | X.Expose =&gt;
        LOCK man DO
          LOCK self.state DO
            ShowWindow (self);
          END;
        END;
      | X.MotionNotify =&gt;
        (*** If several motions in queue, jump to last ***)
        WHILE CheckWindowEvent (self, X.PointerMotionMask, ev) # X.False DO END;

        WITH mev    = MotionEvent (ev),
             posrec = PositionCB.Rec {pos2D := Point.T {mev.x, mev.y},
                                      modifiers := self.modifiers} DO
          self.root.invokePositionCB (posrec);
        END;
      | X.ButtonPress =&gt;
        WITH bev = ButtonEvent(ev) DO
          CASE bev.button OF
          | X.Button1 =&gt; button := VBT.Modifier.MouseL;
          | X.Button2 =&gt; button := VBT.Modifier.MouseM;
          | X.Button3 =&gt; button := VBT.Modifier.MouseR;
          ELSE
            Process.Crash (&quot;G.WaitForEvent: Unknown button event&quot;);
          END;
          IF self.buttonDownCount = 0 THEN
            clickType := VBT.ClickType.FirstDown;
          ELSE
            clickType := VBT.ClickType.OtherDown;
          END;
          INC (self.buttonDownCount);
          WITH mouserec = MouseCB.Rec {pos2D       := Point.T {bev.x, bev.y},
                                       whatChanged := button,
                                       modifiers   := self.modifiers,
                                       clickType   := clickType} DO
            self.root.invokeMouseCB (mouserec);
            self.modifiers := self.modifiers + VBT.Modifiers {button};
          END;
        END;
      | X.ButtonRelease =&gt;
        WITH bev = ButtonEvent(ev) DO
          CASE bev.button OF
          | X.Button1 =&gt; button := VBT.Modifier.MouseL;
          | X.Button2 =&gt; button := VBT.Modifier.MouseM;
          | X.Button3 =&gt; button := VBT.Modifier.MouseR;
          ELSE
            Process.Crash (&quot;G.WaitForEvent: Unknown button event&quot;);
          END;
          DEC (self.buttonDownCount);
          IF self.buttonDownCount = 0 THEN
            clickType := VBT.ClickType.LastUp;
          ELSE
            clickType := VBT.ClickType.OtherUp;
          END;
          WITH mouserec = MouseCB.Rec {pos2D       := Point.T {bev.x, bev.y},
                                       whatChanged := button,
                                       modifiers   := self.modifiers,
                                       clickType   := clickType} DO
            self.root.invokeMouseCB (mouserec);
            self.modifiers := self.modifiers - VBT.Modifiers {button};
          END;
        END;
      | X.KeyPress =&gt;
        WITH keysym = GetKeySym (ev),
             keyrec = KeyCB.Rec {
                            whatChanged := keysym,
                            wentDown    := TRUE,
                            modifiers   := self.modifiers} DO
          self.root.invokeKeyCB (keyrec);
          self.modifiers := self.modifiers + KeySymToModifierSet (keysym);
        END;
      | X.KeyRelease =&gt;
        WITH keysym = GetKeySym (ev),
             keyrec = KeyCB.Rec {
                            whatChanged := keysym,
                            wentDown    := FALSE,
                            modifiers   := self.modifiers} DO
          self.root.invokeKeyCB (keyrec);
          self.modifiers := self.modifiers - KeySymToModifierSet (keysym);
        END;
      ELSE
        (* some other X event *)
      END;

    END;

  END ProcessEvents;

PROCEDURE <A NAME="KeySymToModifierSet"><procedure>KeySymToModifierSet</procedure></A> (keysym : VBT.KeySym) : VBT.Modifiers =
  BEGIN
    CASE keysym OF
    | KeyboardKey.Shift_L, KeyboardKey.Shift_R =&gt;
      RETURN VBT.Modifiers {VBT.Modifier.Shift};
    | KeyboardKey.Shift_Lock =&gt;
      RETURN VBT.Modifiers {VBT.Modifier.Lock};
    | KeyboardKey.Control_L, KeyboardKey.Control_R =&gt;
      RETURN VBT.Modifiers {VBT.Modifier.Control};
    | KeyboardKey.Meta_L, KeyboardKey.Meta_R =&gt;
      RETURN VBT.Modifiers {VBT.Modifier.Option};
    ELSE
      RETURN VBT.Modifiers {};
    END;
  END KeySymToModifierSet;

&lt;* INLINE *&gt;
PROCEDURE <A NAME="GetKeySym"><procedure>GetKeySym</procedure></A> (VAR ev : X.XEvent) : VBT.KeySym =
  BEGIN
    RETURN X.XLookupKeysym (LOOPHOLE (ADR (ev), X.XKeyEventStar), 0);
  END GetKeySym;

&lt;* INLINE *&gt;
PROCEDURE <A NAME="MotionEvent"><procedure>MotionEvent</procedure></A>(VAR ev : X.XEvent) : X.XMotionEvent =
  BEGIN
    RETURN LOOPHOLE (ADR (ev), X.XMotionEventStar)^;
  END MotionEvent;

&lt;* INLINE *&gt;
PROCEDURE <A NAME="ButtonEvent"><procedure>ButtonEvent</procedure></A>(VAR ev : X.XEvent) : X.XButtonEvent =
  BEGIN
    RETURN LOOPHOLE (ADR (ev), X.XButtonEventStar)^;
  END ButtonEvent;

&lt;* INLINE *&gt;
PROCEDURE <A NAME="ClientMessageEvent"><procedure>ClientMessageEvent</procedure></A>(VAR ev : X.XEvent) : X.XClientMessageEvent =
  BEGIN
    RETURN LOOPHOLE (ADR (ev), X.XClientMessageEventStar)^;
  END ClientMessageEvent;
</PRE>***************************************************************************
 Animation Server                                                          
***************************************************************************

<P><PRE>PROCEDURE <A NAME="Repair"><procedure>Repair</procedure></A> (self : T; VAR damaged : BOOLEAN) =

  PROCEDURE FillOcBuffer () =
    BEGIN
      (*** The thread must hold state in order to access state.oc ***)
      LOCK man DO
        LOCK self.state DO
          (*** determine the object's current transparency ***)
          self.transflag := self.root.needsTransparency(0.0);
                                   (* 0.0 is the default transmission coeff *)

          (*** flush and initialize OC buffers ***)
          PEX.PEXFlushOCBuffer   (self.state.camOcBuf);
          PEX.PEXFlushOCBuffer   (self.state.lightOcBuf);
          PEX.PEXFlushOCBuffer   (self.state.oc);

          self.state.setup ();
          PEX.PEXSetDepthCueIndex(self.state.oc, 1);

          (*** draw the object into the oc buffer ***)
          self.root.draw (self.state);

          (*** now set up the camera ***)
          self.root.cam.view (self.state);

          self.state.establishLights ();

          (*** show the result of the drawing ***)
          ShowWindow (self);
        END;
      END;
    END FillOcBuffer;

  BEGIN
    IF self.root # NIL THEN
      (*** Redraw the scene only if it was damaged ***)
      IF self.root.damaged THEN
        damaged := TRUE;
        (* Fill the output command buffer. We could inline this call. *)
        FillOcBuffer ();
      END;
    END;
  END Repair;
</PRE>***************************************************************************
 Manager                                                                   
***************************************************************************

<P>
<P><PRE>TYPE
  Manager = MUTEX OBJECT              (* mutex synchronizes access to disp *)
    mu               : MUTEX;
    disp             : X.DisplayStar;
    avail            : BOOLEAN;
    wm_protocols     : X.Atom;
    wm_delete_window : X.Atom;
  METHODS
    init () : Manager := InitManager;
  END;

PROCEDURE <A NAME="InitManager"><procedure>InitManager</procedure></A> (self : Manager) : Manager =
  VAR
    pexinfo : PEX.pxlInfoStar;       (* PEX initialization info *)
  BEGIN
    (*** open the display ***)

    self.disp := X.XOpenDisplay (NIL);
    IF self.disp = NIL THEN
      Process.Crash (&quot;Could not open display&quot;);
    END;

    (*** &quot;internalize&quot; some X atoms ***)

    self.wm_protocols :=
       X.XInternAtom(self.disp,M3toC.TtoS (&quot;WM_PROTOCOLS&quot;), X.False);
    self.wm_delete_window :=
       X.XInternAtom(self.disp,M3toC.TtoS (&quot;WM_DELETE_WINDOW&quot;), X.False);

    (*** initialize PEX ***)

    IF PEX.PEXInitialize (self.disp, ADR (pexinfo)) # 0 THEN
      self.avail := FALSE;
    ELSE
      self.avail := TRUE;
    END;

    (*** perform non-window-specific PEX initializations ***)

    PEX.PEXSetColourType (PEX.PEXRgbFloatColour);

    RETURN self;

  END InitManager;
</PRE>*****************************************************************************
 The following procedures are based on the C functions accompanying the
 <CODE>PEXlib Programming Manual</CODE> by O'Reilly &amp; Associates. Here is their copyright 
 notice:
<P>
    Copyright 1992, 1993 O'Reilly and Associates, Inc.  Permission to
    use, copy, and modify this program is hereby granted, as long as
    this copyright notice appears in each copy of the program source
    code.
<P>
*****************************************************************************

<P>
<P>
 * Find the best visual. The best visual is the visual that supports the most
 * colors. If two visuals support the same number of colors, we prefer 
 * TrueColor over DirectColor over PseudoColor over StaticColor over GrayScale
 * over StaticGray.
 
<PRE>PROCEDURE <A NAME="FindBestVisual"><procedure>FindBestVisual</procedure></A> (dpy : X.DisplayStar) : X.XVisualInfo =

  PROCEDURE Ranking8 (class : Ctypes.int) : INTEGER =
    BEGIN
      CASE class OF
      | -1            =&gt; RETURN -1;
      | X.StaticGray  =&gt; RETURN 1;
      | X.GrayScale   =&gt; RETURN 2;
      | X.StaticColor =&gt; RETURN 3;
      | X.DirectColor =&gt; RETURN 4;
      | X.TrueColor   =&gt; RETURN 5;
      | X.PseudoColor =&gt; RETURN 6;
      ELSE
        &lt;* ASSERT FALSE *&gt;
      END;
    END Ranking8;

  PROCEDURE Ranking (class : Ctypes.int) : INTEGER =
    BEGIN
      CASE class OF
      | -1            =&gt; RETURN -1;
      | X.StaticGray  =&gt; RETURN 1;
      | X.GrayScale   =&gt; RETURN 2;
      | X.StaticColor =&gt; RETURN 3;
      | X.PseudoColor =&gt; RETURN 4;
      | X.DirectColor =&gt; RETURN 5;
      | X.TrueColor   =&gt; RETURN 6;
      END;
    END Ranking;

  VAR
    vis_templ  : X.XVisualInfo; (* input-template for XGetVisualInfo *)
    numVisuals : Ctypes.int;    (* number of visuals supported by the screen *)
    size       : INTEGER;       (* no. of colors supported by current visual *)
    bestVisual : X.XVisualInfo; (* the &quot;best&quot; visual *)
    bestSize   : INTEGER;       (* number of colors supported by bestVisual *)
    maxDepth   := 0;
  BEGIN
    (* Get all the visuals for the screen. *)
    vis_templ.screen := X.XDefaultScreen (dpy);
    WITH
      visListPtr = X.XGetVisualInfo (dpy, X.VisualScreenMask,
                                     (* IN *)  ADR (vis_templ),
                                     (* OUT *) ADR (numVisuals)),
      visListRef = LOOPHOLE (visListPtr,
                             UNTRACED REF ARRAY [1 .. 1000] OF X.XVisualInfo),
      visuals = SUBARRAY (visListRef^, 0, numVisuals) DO

      (* Determine the max. depth of all the visuals. *)
      FOR i := FIRST (visuals) TO LAST (visuals) DO
        maxDepth := MAX (maxDepth, visuals[i].depth);
      END;

      (* Determine the best visual available.  The best one is the *)
      (* one with the most colors and highest capabilities. *)
      bestSize := 0;
      bestVisual.class := -1;
      FOR i := FIRST (visuals) TO LAST (visuals) DO
        (* Determine the number of colors supported by visuals[i] *)
        CASE visuals[i].class OF
        | X.TrueColor, X.DirectColor =&gt;
          size := Word.Or (visuals[i].red_mask,
                           Word.Or (visuals[i].green_mask,
                                    visuals[i].blue_mask)) + 1;
        ELSE
          size := visuals[i].colormap_size;
        END;

        (* Choose this one if it is better. *)
        IF size &gt; bestSize THEN
          bestVisual := visuals[i];
          bestSize := size;
        ELSIF size = bestSize THEN
          IF maxDepth = 8 THEN
            IF Ranking8 (visuals[i].class) &gt;= Ranking8 (bestVisual.class) THEN
              bestVisual := visuals[i];
              bestSize := size;
            END;
          ELSE
            IF Ranking (visuals[i].class) &gt;= Ranking (bestVisual.class) THEN
              bestVisual := visuals[i];
              bestSize := size;
            END;
          END;
        END;
      END;
      RETURN bestVisual;
    END;
  END FindBestVisual;

EXCEPTION CmapAllocError;

PROCEDURE <A NAME="CreateColorMap"><procedure>CreateColorMap</procedure></A> (dpy                     : X.DisplayStar;
                          READONLY visual         : X.XVisualInfo;
                          (* OUT *) VAR cmap_info : X.XStandardColormap;
                          (* OUT *) VAR capx_info : PEX.pexColourApproxEntry)
    RAISES {CmapAllocError} =
  BEGIN
    CASE visual.class OF
    | X.DirectColor =&gt;
      (* Create the largest possible equal-length ramps. *)
      CreateDirectMap (dpy, visual, cmap_info, capx_info);
    | X.PseudoColor =&gt;
      (* Create the largest NxNxN color sampling. *)
      WITH n = TRUNC (Math.pow (FLOAT (visual.colormap_size - 1, LONGREAL),
                                1.0d0 / 3.0d0)) DO
        CreatePseudoMap (dpy, visual, n, n, n, cmap_info, capx_info);
      END;
    | X.GrayScale =&gt;
      (* Create a GrayScale colormap with max number of grays. *)
      (* (but leave one empty spot for the background color.) *)
      CreateGrayMap (dpy, visual, visual.colormap_size - 1,
                     cmap_info, capx_info);
    | X.TrueColor, X.StaticColor, X.StaticGray =&gt;
      CreateReadOnlyMap (dpy, visual, cmap_info, capx_info );
    ELSE
      &lt;* ASSERT FALSE *&gt;
    END;
  END CreateColorMap;

PROCEDURE <A NAME="CreateDirectMap"><procedure>CreateDirectMap</procedure></A> (dpy                     : X.DisplayStar;
                           READONLY visual         : X.XVisualInfo;
                           (* OUT *) VAR cmap_info : X.XStandardColormap;
                           (* OUT *) VAR capx_info : PEX.pexColourApproxEntry)
    RAISES {CmapAllocError} =
  VAR
    red_planes, green_planes, blue_planes       : Ctypes.int;
    i                                           : Ctypes.unsigned_long;
    num_reds, num_greens, num_blues, num_colors : Ctypes.unsigned_long;
    rshift, gshift, bshift                      : Ctypes.unsigned_long;
    rmask, gmask, bmask                         : Ctypes.unsigned_long;
  BEGIN
    (* Create the colormap. *)
    cmap_info.visualid := visual.visualid;
    cmap_info.colormap := X.XCreateColormap (
                              dpy,
                              X.XRootWindow (dpy, X.XDefaultScreen (dpy)),
                              visual.visual,
                              X.AllocNone );

    (* Determine the number of red, green, and blue planes and the *)
    (* maximum possible number of color values for each. *)
    red_planes := 0;
    num_reds := 1;
    i := visual.red_mask;
    WHILE i &gt; 0 DO
      IF Word.And (i, 1) # 0 THEN
        INC (red_planes);
        num_reds := num_reds * 2;
      END;
      i := Word.RightShift (i, 1);
    END;
    cmap_info.red_max := num_reds - 1;
	
    green_planes := 0;
    num_greens := 1;
    i := visual.green_mask;
    WHILE i &gt; 0 DO
      IF Word.And (i, 1) # 0 THEN
        INC (green_planes);
        num_greens := num_greens * 2;
      END;
      i := Word.RightShift (i, 1);
    END;
    cmap_info.green_max := num_greens - 1;
	
    blue_planes := 0;
    num_blues := 1;
    i := visual.blue_mask;
    WHILE i &gt; 0 DO
      IF Word.And (i, 1) # 0 THEN
        INC (blue_planes);
        num_blues := num_blues * 2;
      END;
      i := Word.RightShift (i, 1);
    END;
    cmap_info.blue_max := num_blues - 1;
	
    (* Allocate the planes. *)
    IF X.XAllocColorPlanes (dpy, cmap_info.colormap, X.True,
                            ADR (cmap_info.base_pixel), 1,
                            red_planes, green_planes, blue_planes,
                            ADR (rmask), ADR (gmask), ADR (bmask)) = 0 THEN
      RAISE CmapAllocError;
    END;

    (* Determine the red, green, and blue multipliers by finding the first
       bit set in each mask. *)

    rshift := 0;
    WHILE Word.And (rmask, Word.LeftShift (1, rshift)) = 0 DO
      INC (rshift);
    END;
    cmap_info.red_mult := Word.LeftShift (1, rshift);

    gshift := 0;
    WHILE Word.And (rmask, Word.LeftShift (1, gshift)) = 0 DO
      INC (gshift);
    END;
    cmap_info.green_mult := Word.LeftShift (1, gshift);

    bshift := 0;
    WHILE Word.And (rmask, Word.LeftShift (1, bshift)) = 0 DO
      INC (bshift);
    END;
    cmap_info.blue_mult := Word.LeftShift (1, bshift);

    (* Store the colors in the colormap. *)
    num_colors := visual.colormap_size;
    WITH colors = NEW (REF ARRAY OF X.XColor, num_colors)^ DO
      FOR i := FIRST (colors) TO LAST (colors) DO
        WITH color = colors[i] DO
          colors[i].flags := 0;
          colors[i].pixel := cmap_info.base_pixel;
          IF i &lt; cmap_info.red_max THEN
            colors[i].flags := Word.Or (colors[i].flags, X.DoRed);
            colors[i].pixel := Word.Or (colors[i].pixel,
                                        Word.LeftShift (i, rshift));
            colors[i].red := (i * 65535) DIV cmap_info.red_max;
          END;
          IF i &lt; cmap_info.green_max THEN
            colors[i].flags := Word.Or (colors[i].flags, X.DoGreen);
            colors[i].pixel := Word.Or (colors[i].pixel,
                                        Word.LeftShift (i, gshift));
            colors[i].green := (i * 65535) DIV cmap_info.green_max;
          END;
          IF i &lt; cmap_info.blue_max THEN
            colors[i].flags := Word.Or (colors[i].flags, X.DoBlue);
            colors[i].pixel := Word.Or (colors[i].pixel,
                                        Word.LeftShift (i, bshift));
            colors[i].blue := (i * 65535) DIV cmap_info.blue_max;
          END;
        END;
      END;
      X.XStoreColors (dpy, cmap_info.colormap, ADR (colors[0]), num_colors );
    END;

    (* Fill in the color approximation information. *)
    capx_info.approxType  := PEX.PEXColourSpace;
    capx_info.approxModel := PEX.PEXColourApproxRGB;
    capx_info.dither      := PEX.PEXOn;
    capx_info.basePixel   := cmap_info.base_pixel;
    capx_info.max1        := cmap_info.red_max;
    capx_info.max2        := cmap_info.green_max;
    capx_info.max3        := cmap_info.blue_max;
    capx_info.weight1     := 0.0; (* not used by PEXColorSpace *)
    capx_info.weight2     := 0.0; (* not used by PEXColorSpace *)
    capx_info.weight3     := 0.0; (* not used by PEXColorSpace *)
    capx_info.mult1       := cmap_info.red_mult;
    capx_info.mult2       := cmap_info.green_mult;
    capx_info.mult3       := cmap_info.blue_mult;
  END CreateDirectMap;

PROCEDURE <A NAME="CreatePseudoMap"><procedure>CreatePseudoMap</procedure></A> (dpy                     : X.DisplayStar;
                           READONLY visual         : X.XVisualInfo;
                           nr, ng, nb              : INTEGER;
                           (* OUT *) VAR cmap_info : X.XStandardColormap;
                           (* OUT *) VAR capx_info : PEX.pexColourApproxEntry)
    RAISES {CmapAllocError} =
  VAR
    num_colors, idx, p : INTEGER;
  BEGIN
    (* Create the colormap and fill in the standard cmap info. *)
    cmap_info.colormap := X.XCreateColormap (
                               dpy,
                               X.XRootWindow (dpy, X.XDefaultScreen (dpy)),
                               visual.visual,
                               X.AllocNone);
    cmap_info.visualid := visual.visualid;
    cmap_info.blue_max := nb - 1;	
    cmap_info.blue_mult := 1;
    cmap_info.green_max := ng - 1;	
    cmap_info.green_mult := nb;
    cmap_info.red_max := nr - 1;	
    cmap_info.red_mult := nb * ng;

    num_colors := nr * ng * nb;
    WITH pixels = NEW (REF ARRAY OF Ctypes.unsigned_long, num_colors)^ DO
      IF X.XAllocColorCells (dpy, cmap_info.colormap, X.True, NIL,
                             0, ADR (pixels[0]), num_colors) = 0 THEN
        RAISE CmapAllocError;
      END;
      cmap_info.base_pixel := pixels[0];
    END;

    WITH colors = NEW (REF ARRAY OF X.XColor, num_colors)^ DO
      p := cmap_info.base_pixel;
      idx := 0;
      FOR i := 0 TO nr - 1 DO
        FOR j := 0 TO ng - 1 DO
          FOR k := 0 TO nb - 1 DO
            WITH color = colors[idx] DO
              color.flags := Word.Or (X.DoRed, Word.Or (X.DoGreen, X.DoBlue));
              color.pixel := p;
              INC (p);
              color.red   := (i * 65535) DIV cmap_info.red_max;
              color.green := (j * 65535) DIV cmap_info.green_max;
              color.blue  := (k * 65535) DIV cmap_info.blue_max;
              INC (idx);
            END;
          END;
        END;
      END;
      X.XStoreColors (dpy, cmap_info.colormap, ADR (colors[0]), num_colors);
    END;

    (* Fill in the color approximation information. *)
    capx_info.approxType  := PEX.PEXColourSpace;
    capx_info.approxModel := PEX.PEXColourApproxRGB;
    capx_info.dither      := PEX.PEXOn;
    capx_info.basePixel   := cmap_info.base_pixel;
    capx_info.max1        := cmap_info.red_max;
    capx_info.max2        := cmap_info.green_max;
    capx_info.max3        := cmap_info.blue_max;
    capx_info.weight1     := 0.0; (* not used by PEXColorSpace *)
    capx_info.weight2     := 0.0; (* not used by PEXColorSpace *)
    capx_info.weight3     := 0.0; (* not used by PEXColorSpace *)
    capx_info.mult1       := cmap_info.red_mult;
    capx_info.mult2       := cmap_info.green_mult;
    capx_info.mult3       := cmap_info.blue_mult;
  END CreatePseudoMap;

PROCEDURE <A NAME="CreateGrayMap"><procedure>CreateGrayMap</procedure></A> (dpy                     : X.DisplayStar;
                         READONLY visual         : X.XVisualInfo;
                         num_grays               : INTEGER;
                         (* OUT *) VAR cmap_info : X.XStandardColormap;
                         (* OUT *) VAR capx_info : PEX.pexColourApproxEntry)
    RAISES {CmapAllocError} =
  VAR
    p : Ctypes.unsigned_long;
  BEGIN
    cmap_info.visualid := visual.visualid;
    cmap_info.colormap := X.XCreateColormap (
                              dpy,
                              X.XRootWindow (dpy, X.XDefaultScreen (dpy)),
                              visual.visual,
                              X.AllocNone);
    cmap_info.red_max  := num_grays - 1;
    cmap_info.red_mult := 1;

    WITH pixels = NEW (REF ARRAY OF Ctypes.unsigned_long, num_grays)^ DO
      IF X.XAllocColorCells (dpy, cmap_info.colormap, X.True,
                             NIL, 0, ADR (pixels[0]), num_grays) = 0 THEN
        RAISE CmapAllocError;
      END;
      cmap_info.base_pixel := pixels[0];
    END;
	
    (* Fill in the RGB color values. *)
    WITH colors = NEW (REF ARRAY OF X.XColor, num_grays)^ DO
      p := cmap_info.base_pixel;
      FOR i := FIRST (colors) TO LAST (colors) DO
        WITH color = colors[i] DO
          color.flags := Word.Or (X.DoRed, Word.Or (X.DoGreen, X.DoBlue));
          color.pixel := p;
          INC (p);
          (* R, G, and B are the same intensity within a cell. *)
          color.red := (i * 65535) DIV (num_grays - 1);
          color.green := color.red;
          color.blue  := color.red;
	END;
      END;
      X.XStoreColors (dpy, cmap_info.colormap, ADR (colors[0]), num_grays);
    END;

    (* Fill in the color approximation information. *)
    capx_info.approxType  := PEX.PEXColourRange;
    capx_info.approxModel := PEX.PEXColourApproxRGB;
    capx_info.dither      := PEX.PEXOn;
    capx_info.basePixel   := cmap_info.base_pixel;
    capx_info.max1        := num_grays - 1;
    capx_info.max2        := 0; (* not used by PEXColorRange *)
    capx_info.max3        := 0; (* not used by PEXColorRange *)
    (* Give the weights the NTSC intensity coefficients. *)
    capx_info.weight1     := 0.299;
    capx_info.weight2     := 0.587;
    capx_info.weight3     := 0.114;
    capx_info.mult1       := 1;
    capx_info.mult2       := 0;
    capx_info.mult3       := 0;
  END CreateGrayMap;

PROCEDURE <A NAME="CreateReadOnlyMap"><procedure>CreateReadOnlyMap</procedure></A> (dpy                     : X.DisplayStar;
                             READONLY visual         : X.XVisualInfo;
                             (* OUT *) VAR cmap_info : X.XStandardColormap;
                             (* OUT *) VAR capx_info : PEX.pexColourApproxEntry)
    RAISES {CmapAllocError} =
  BEGIN
    (* Create the colormap. *)
    cmap_info.colormap := X.XCreateColormap (
                              dpy,
                              X.XRootWindow (dpy, X.XDefaultScreen (dpy)),
                              visual.visual, X.AllocNone);

    (* Set up the colormap and color approximation info. *)
    cmap_info.base_pixel := 0;
    cmap_info.visualid := visual.visualid;

    (* The rest depends on the visual class. *)
    CASE visual.class OF
    | X.TrueColor, X.StaticColor =&gt;
      cmap_info.red_max := visual.red_mask;
      cmap_info.red_mult := 1;
      WHILE Word.And (cmap_info.red_max, 1) = 0 DO
        cmap_info.red_max := Word.RightShift (cmap_info.red_max, 1);
        cmap_info.red_mult := Word.LeftShift (cmap_info.red_mult, 1);
      END;
      cmap_info.green_max := visual.green_mask;
      cmap_info.green_mult := 1;
      WHILE Word.And (cmap_info.green_max, 1) = 0 DO
        cmap_info.green_max := Word.RightShift (cmap_info.green_max, 1);
        cmap_info.green_mult := Word.LeftShift (cmap_info.green_mult, 1);
      END;
      cmap_info.blue_max := visual.blue_mask;
      cmap_info.blue_mult := 1;
      WHILE Word.And (cmap_info.blue_max, 1) = 0 DO
	cmap_info.blue_max := Word.RightShift (cmap_info.blue_max, 1);
        cmap_info.blue_mult := Word.LeftShift (cmap_info.blue_mult, 1);
      END;

      capx_info.approxType  := PEX.PEXColourSpace;
      capx_info.approxModel := PEX.PEXColourApproxRGB;
      capx_info.dither      := PEX.PEXOn;
      capx_info.basePixel   := cmap_info.base_pixel;
      capx_info.max1        := cmap_info.red_max;
      capx_info.max2        := cmap_info.green_max;
      capx_info.max3        := cmap_info.blue_max;
      capx_info.weight1     := 0.0; (* not used by PEXColorSpace *)
      capx_info.weight2     := 0.0; (* not used by PEXColorSpace *)
      capx_info.weight3     := 0.0; (* not used by PEXColorSpace *)
      capx_info.mult1       := cmap_info.red_mult;
      capx_info.mult2       := cmap_info.green_mult;
      capx_info.mult3       := cmap_info.blue_mult;

    | X.StaticGray =&gt;
      cmap_info.red_max  := visual.colormap_size - 1;
      cmap_info.red_mult := 1;
	
      capx_info.approxType  := PEX.PEXColourRange;
      capx_info.approxModel := PEX.PEXColourApproxRGB;
      capx_info.dither      := PEX.PEXOn;
      capx_info.basePixel   := cmap_info.base_pixel;
      capx_info.max1        := cmap_info.red_max;
      capx_info.max2        := 0; (* not used by PEXColorRange *)
      capx_info.max3        := 0; (* not used by PEXColorRange *)
      (* Give the weights the NTSC intensity coefficients. *)
      capx_info.weight1     := 0.299;
      capx_info.weight2     := 0.587;
      capx_info.weight3     := 0.114;
      capx_info.mult1       := cmap_info.red_mult;
      capx_info.mult2       := 0;
      capx_info.mult3       := 0;
    ELSE
      &lt;* ASSERT FALSE *&gt;
    END;
  END CreateReadOnlyMap;

VAR
  man : Manager := NIL;

BEGIN
END X_PEX_Base.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface FloatMode is in:
</A><UL>
<LI><A HREF="../../float/src/DS3100/FloatMode.i3#0TOP0">float/src/DS3100/FloatMode.i3</A>
<LI><A HREF="../../float/src/IEEE-default/FloatMode.i3#0TOP0">float/src/IEEE-default/FloatMode.i3</A>
<LI><A HREF="../../float/src/IRIX5/FloatMode.i3#0TOP0">float/src/IRIX5/FloatMode.i3</A>
<LI><A HREF="../../float/src/SOLsun/FloatMode.i3#0TOP0">float/src/SOLsun/FloatMode.i3</A>
<LI><A HREF="../../float/src/SPARC/FloatMode.i3#0TOP0">float/src/SPARC/FloatMode.i3</A>
<LI><A HREF="../../float/src/SUN386/FloatMode.i3#0TOP0">float/src/SUN386/FloatMode.i3</A>
<LI><A HREF="../../float/src/VAX/FloatMode.i3#0TOP0">float/src/VAX/FloatMode.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
