<HTML>
<HEAD>
<TITLE>SRC Modula-3: arith/src/Math.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>arith/src/Math.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="Math.m3">Math</A></interface>;
</PRE> An interface to the C math library
<P>
   Programs that call any of these routines must be linked
   with the math library <CODE>-lm</CODE>.
<P>
   The detailed semantics of these procedures are defined by
   your local C math library.  To learn the full story about
   any of these functions (e.g. their domains, ranges and
   accuracies), see the appropriate man page.
<P>
   Index: floating point, C math interface; 
          C programming, interface to C math library 


<P>---- miscellaneous useful constants ----

<P><PRE>CONST
  Pi     = 3.1415926535897932384626433833;
  LogPi  = 1.1447298858494001741434273514;
  SqrtPi = 1.7724538509055160272981674833;
  E      = 2.7182818284590452353602874714;
  Degree = 0.017453292519943295769236907684;  (* One degree in radians *)
</PRE>---- Exponential and Logarithm functions ----

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE exp (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns E^x. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE expm1 (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns (E^x)-1, even for small x. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE log (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the natural logarithm of x (base E). </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE log10 (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the base 10 logarithm of x. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE log1p (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns log(1+x), even for small x. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE pow (x, y: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns x^y. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE sqrt (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the square root of x. </EM></BLOCKQUOTE><PRE>
</PRE>---- Trigonometric functions ----

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE cos (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the cosine of x radians. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE sin (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the sine of x radians. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE tan (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the tangent of x radians. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE acos (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the arc cosine of x in radians. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE asin (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the arc sine of x in radians. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE atan (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the arc tangent of x in radians. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE atan2 (y, x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the arc tangent of y/x in radians. </EM></BLOCKQUOTE><PRE>
</PRE>---- Hyperbolic trigonometric functions ----

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE sinh (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the hyperbolic sine of x. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE cosh (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the hyperbolic cosine of x. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE tanh (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the hyperbolic tangent of x. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE asinh (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the inverse hyperbolic sine of x </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE acosh (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the inverse hyperbolic cosine of x </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE atanh (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the inverse hyperbolic tangent of x </EM></BLOCKQUOTE><PRE>
</PRE>---- Rounding functions ----

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE ceil (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the least integer not less than x.
   Note: use the builtin Modula-3 function CEILING. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE floor (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the greatest integer not greater than x.
   Note: use the builtin Modula-3 function FLOOR. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE rint (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the nearest integer value to x.
   Note: the Modula-3 function ROUND may  be appropriate. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE fabs (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the absolute value of x.
   Note: use the builtin Modula-3 function ABS. </EM></BLOCKQUOTE><PRE>
</PRE>---- Euclidean distance functions ----

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE hypot (x, y: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns sqrt (x*x + y*y). </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE cabs (z: Complex): LONGREAL;
TYPE Complex = RECORD x, y: LONGREAL END;
</PRE><BLOCKQUOTE><EM> returns sqrt (z.x*z.x + z.y*z.y) </EM></BLOCKQUOTE><PRE>
</PRE>---- Floating point representations ----

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE frexp (x: LONGREAL;  VAR exp: INTEGER): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns a value y and sets exp such that x = y * 2^exp,
    where ABS(X) is in the interval [0.5, 1). </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE ldexp (x: LONGREAL; exp: INTEGER): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns x * 2^exp. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE modf (x: LONGREAL; VAR exp: INTEGER): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the positive fractional part of x and sets exp to
   the remaining integer part. </EM></BLOCKQUOTE><PRE>
</PRE>---- Error functions ----

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE erf (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the <CODE>error</CODE> function of x. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE erfc (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns 1.0 - erf(x), even for large x. </EM></BLOCKQUOTE><PRE>
</PRE>---- Gamma function ----

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE gamma (x: LONGREAL): LONGREAL;
&lt;*EXTERNAL*&gt; VAR signgam: INTEGER;
</PRE><BLOCKQUOTE><EM> returns log(ABS(Gamma(ABS(x)))).  The sign of Gamma(ABS(X))
   is returned in signgam. </EM></BLOCKQUOTE><PRE>
</PRE>---- Bessel functions ----

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE j0 (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the zero-order Bessel function of first kind on x. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE j1 (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the first-order Bessel function of first kind on x. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE jn (n: INTEGER;  x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the n th-order Bessel function of first kind on x. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE y0 (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the zero-order Bessel function of second kind on x. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE y1 (x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the first-order Bessel function of second kind on x. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL*&gt; PROCEDURE yn (n, x: LONGREAL): LONGREAL;
</PRE><BLOCKQUOTE><EM> returns the n th-order Bessel function of second kind on x. </EM></BLOCKQUOTE><PRE>

END Math.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
