<HTML>
<HEAD>
<TITLE>SRC Modula-3: atom/src/Atom.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>atom/src/Atom.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                          </EM></BLOCKQUOTE><PRE>
</PRE> Last modified on Thu Mar 10 16:10:31 PST 1994
 by kalsow  

<P><PRE>MODULE <module><implements><A HREF="Atom.i3">Atom</A></implements></module>;

IMPORT <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../libm3/derived/AtomAtomTbl.i3">AtomAtomTbl</A>;

REVEAL
  <A NAME="T">T</A> = BRANDED Brand REF RECORD
        text : TEXT;
        hash : INTEGER;
      END;

TYPE
  NewAtomTbl = AtomAtomTbl.Default OBJECT OVERRIDES
    keyEqual := TblEqual;
  END;

VAR
  mutex := NEW(MUTEX);
  table := NEW(NewAtomTbl).init();
  next  : T := NIL;  (* the next atom to be returned by FromText *)

PROCEDURE <A NAME="FromText"><procedure>FromText</procedure></A>(t: TEXT): T =
  VAR a: T;
  BEGIN
    LOCK mutex DO
      IF (next = NIL) THEN next := NEW (T) END;
      next.text := t;
      next.hash := Text.Hash (t);
      IF NOT table.get(next, a) THEN
        a := next;
        next := NIL;
        EVAL table.put(a, a)
      END
    END;
    RETURN a
  END FromText;

PROCEDURE <A NAME="ToText"><procedure>ToText</procedure></A>(a: T): TEXT =
  BEGIN
    RETURN a.text
  END ToText;

PROCEDURE <A NAME="Hash"><procedure>Hash</procedure></A>(a: T): INTEGER =
  BEGIN
    RETURN a.hash
  END Hash;

PROCEDURE <A NAME="TblEqual"><procedure>TblEqual</procedure></A>(&lt;*UNUSED*&gt;self: NewAtomTbl;  READONLY a1, a2: T): BOOLEAN =
  (* This procedure is only used as the &quot;keyEqual&quot; method
     of the internal atom table.  It cannot rely on REF
     equality.  *)
  BEGIN
    RETURN (a1 = a2)
        OR ((a1.hash = a2.hash) AND Text.Equal (a1.text, a2.text));
  END TblEqual;

PROCEDURE <A NAME="Equal"><procedure>Equal</procedure></A>(a1, a2: T): BOOLEAN =
  BEGIN
    RETURN a1 = a2
  END Equal;

EXCEPTION Error; &lt;*FATAL Error*&gt;

PROCEDURE <A NAME="Compare"><procedure>Compare</procedure></A>(&lt;*UNUSED*&gt; a1, a2: T): [-1..1] =
  BEGIN RAISE Error END Compare;

BEGIN
END Atom.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
