<HTML>
<HEAD>
<TITLE>SRC Modula-3: bicycle/src/Card.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>bicycle/src/Card.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="#x1">Card</A></interface>;
</PRE> This interfaces paints and moves playing cards, in a way suitable for
   many kinds of solitaire games, and maybe other things.  The cards are
   all children of a provided ZSplit.
<P>
   The card layout is adjusted automatically when a card is detached from
   the top of a stack.  Attaching one card to the top of another stack of
   cards makes the new card the top of the stack, and positions the new
   card.  If the bottom-most card in the stack has value Min, the cards
   are stacked directly on top of one another.  Otherwise, the cards are
   stacked with a vertical spacing of Overlap if the card immediately
   underneath is face up, and OverlapDown if the card below is face down.
   A stack whose only elements have value Min, Max, or Talon paints as
   an empty card.  Almost always, you should have a Min, Max, or Talon
   at the bottom of a stack of cards.
<P>
   Game play proceeds when the user clicks on a card, or drags a card to
   another card.  The five procedures attachable, play, obvious, trivial,
   and stupid control the behavior.  The attachable procedure should return
   TRUE if the first card can be legally played on the second.  The play
   procedure should return TRUE, and set the out parameters, if there is
   a forced play.  The obvious, trivial, and stupid procedures are bound
   to clicking on the left, middle, and right buttons.  By convention, the
   obvious procedures offers a move for the selected card which, whether
   or not it is currently legal, would be progress towards solving the game.
   The trivial procedure suggests a legal move which isn't necessarily
   on the shortest path towards a solution, but may be a useful move if you
   can't think of anything else to do.  The stupid procedure suggests a
   move which is generally illegal, because it shows you what you might
   move onto this card to make progress.
   <P>
   This interface always keeps a log of the moves that have been made.
   No standard user interface for undo and redo is provided, since in
   some games it might be considered cheating.
<P>
   In addition, the interface supports creating cards without stacking 
   semantics, which can be used when rectangular cards are good enough.
   This is the type <CODE>Card</CODE>.
<P>

     
<P><PRE>IMPORT <A HREF="../../ui/src/split/TwoTone.i3">TwoTone</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../ui/src/split/ZSplit.i3">ZSplit</A>, <A HREF="../../geometry/src/Point.i3">Point</A>;

CONST
  Width = 79; (* width of a card, in pixels *)
  Height = 123; (* height of card, in pixels *)
  OverlapPercentage = 25;
  OverlapDownPercentage = 10;
  Overlap = (OverlapPercentage * Height + 50) DIV 100;
  OverlapDown = (OverlapDownPercentage * Height + 50) DIV 100;

VAR (* READONLY *)
  felt: TwoTone.T; (* color of the background; you have to put the
  TextureVBT in the background of your ZSplit for everything to work. *)

TYPE
  Value =
    {Min, Ace, Deuce, Three, Four, Five, Six, Seven, Eight, Nine, Ten, Jack,
     Queen, King, Max, Talon};
  Rank = [Value.Ace..Value.King];
  Family = {Any, Spades, Hearts, Diamonds, Clubs};
  Suit = [Family.Spades..Family.Clubs];
  <A HREF="Card.m3#Private">Private</A> &lt;: VBT.T;
  Public = Private OBJECT
    value: Value;
    family: Family;
    faceUp := TRUE;
    above, below: T := NIL
  END;
  <A HREF="Card.m3#T">T</A> &lt;: Public;
  StandardDeck = ARRAY [0 .. 51] OF T;
  CardPublic = VBT.Leaf OBJECT
    value: Value;
    family: Family;
    faceUp := TRUE;
  END;
  <A HREF="Card.m3#Card">Card</A> &lt;: CardPublic;
</PRE> All procedures in this interface have LL = VBT.mu 

<P><PRE>PROCEDURE <A HREF="Card.m3#InitializeStandardDeck">InitializeStandardDeck</A>(VAR deck: StandardDeck; zSplit: ZSplit.T);
</PRE><BLOCKQUOTE><EM> Create a full deck of cards, all face up at the origin. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Card.m3#Shuffle">Shuffle</A>(VAR deck: ARRAY OF T);
</PRE><BLOCKQUOTE><EM> Randomly reorder the elements of the deck </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Card.m3#New">New</A>(
    value: Value;
    suit: Family;
    READONLY loc: Point.T;
    zSplit: ZSplit.T;
    faceUp: BOOLEAN := TRUE)
    : T;
</PRE><BLOCKQUOTE><EM> Create a single card. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Card.m3#NewCard">NewCard</A> (value: Value; suit: Family; faceUp := TRUE): Card;
</PRE><BLOCKQUOTE><EM> Create a single rectangular card; equivalent to NEW(Card, value :=
   value, family := suit, faceUp := faceUp). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Card.m3#Detach">Detach</A>(c: T);
</PRE><BLOCKQUOTE><EM> Remove c from its stack; the cards above c are not altered.
   If c is not at the top of its stack, you won't much like the
   results, unless you're detaching all the cards in order
   to reset the game. </EM></BLOCKQUOTE><PRE>

EXCEPTION BadDeal;

PROCEDURE <A HREF="Card.m3#Attach">Attach</A>(c, p: T) RAISES {BadDeal};
</PRE><BLOCKQUOTE><EM> c is placed on top of p.  If p is in a stack with a Min at the base, c is
placed directly on top of p. Otherwise, c is shifted down by Overlap,
unless p is itself the unreal card at the base of the stack.  Cards
played on top of down-facing cards are offset by OverlapDown instead.
All cards above c are moved as well.  If p is in the same stack as c, 
BadDeal is raised, unless c is atop p. If p has any real card above it 
other than c, BadDeal is raised. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Card.m3#StartUndoLog">StartUndoLog</A>();
</PRE><BLOCKQUOTE><EM> Clear the undo and redo logs </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Card.m3#Undo">Undo</A>(): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Undo a move (including all forced moves that followed it) and return TRUE;
   if at beginning of log, return FALSE </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Card.m3#Redo">Redo</A>(slowly := FALSE): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Redo a move and return TRUE; if at end of log, return FALSE.  By
   setting slowly, you can make the redo pause briefly after each
   forced card is moved, so that the user can see what is going on. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Card.m3#Flip">Flip</A>(c: T; up: BOOLEAN);
</PRE><BLOCKQUOTE><EM> Make c face <CODE>up</CODE>, and mark <CODE>c</CODE> for redisplay </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Card.m3#FlipCard">FlipCard</A>(c: Card; up: BOOLEAN);
</PRE><BLOCKQUOTE><EM> Make c face <CODE>up</CODE>, and mark <CODE>c</CODE> for redisplay </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Card.m3#Real">Real</A>(c: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return TRUE if c's value is a Rank and c's family is a Suit. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Card.m3#RealCard">RealCard</A>(c: Card): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return TRUE if c's value is a Rank and c's family is a Suit. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Card.m3#Top">Top</A>(c: T): T;
</PRE><BLOCKQUOTE><EM> Return the card on top of c's stack </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Card.m3#Bottom">Bottom</A>(c: T): T;
</PRE><BLOCKQUOTE><EM> Return the (generally unreal) card at the bottom of c's stack </EM></BLOCKQUOTE><PRE>

TYPE
  AttachProc = PROCEDURE(a, b: T): BOOLEAN;
  (* Can first card can be played on second *)
  PlayProc = PROCEDURE(VAR a, b: T): BOOLEAN;
  (* Returns a forced play and TRUE, else FALSE.  Playing a card
     on itself flips the card. *)
  MoveProc = PROCEDURE(a: T): T;
  (* Returns a card on which to play the argument, else NIL *)

VAR

  attachable: AttachProc;
  play: PlayProc;
  obvious, trivial, stupid: MoveProc;
  (* return the obvious move, if it exists (button 1 action);
     return the trivial move, if it exists (button 2 action);
     return a stupid but informative move  (button 3 action) *)

PROCEDURE <A HREF="Card.m3#EnableTracking">EnableTracking</A>(enable: BOOLEAN);
  (* When Tracking is turned on, Card automatically highlights
     the position returned by obvious.  Tracking defaults to FALSE. *)

PROCEDURE <A HREF="Card.m3#EnableHighlight">EnableHighlight</A>(enable: BOOLEAN; chain: INTEGER);
  (* When true, pressing a mouse button highlights the selected
     target card.  If chain is non-negative, every chain milliseconds,
     the next card is also highlighted.  These default to TRUE and 1000 *)

END Card.
</PRE>
</inInterface>
<HR>
<A NAME="x1">Card's implementation  is in:
</A><UL>
<LI><A HREF="Card.m3#0TOP0">bicycle/src/Card.m3</A>
<LI><A HREF="../../m3front/src/builtinTypes/Card.m3#0TOP0">m3front/src/builtinTypes/Card.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
