<HTML>
<HEAD>
<TITLE>SRC Modula-3: bicycle/src/CardRank.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>bicycle/src/CardRank.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Copyright 1990 David Lemke and Network Computing Devices             </EM></BLOCKQUOTE><PRE>
</PRE> Copyright (c) 1989, Donald R. Woods and Sun Microsystems, Inc.       

<P>
<P><PRE>MODULE <module><implements><A HREF="CardRank.i3">CardRank</A></implements></module>;

IMPORT <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="PixmapFromXData.i3">PixmapFromXData</A>;

FROM <A HREF="#x1">Card</A> IMPORT Rank;

VAR
  mu := NEW(MUTEX);
  inited := FALSE;
  pix: ARRAY Rank OF Pixmap.T;
  xip: ARRAY Rank OF Pixmap.T;

TYPE RankData = ARRAY Rank OF PixmapFromXData.T;

CONST
  Data = RankData{Ace, Deuce, Trey, Four, Five, Six, Seven,
    Eight, Nine, Ten, Jack, Queen, King};

PROCEDURE <A NAME="Pix"><procedure>Pix</procedure></A>(r: Rank): Pixmap.T =
  BEGIN
    LOCK mu DO
      IF NOT inited THEN Init() END;
      RETURN pix[r]
    END
  END Pix;

PROCEDURE <A NAME="Xip"><procedure>Xip</procedure></A>(r: Rank): Pixmap.T =
  BEGIN
    LOCK mu DO
      IF NOT inited THEN Init() END;
      RETURN xip[r]
    END
  END Xip;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>() =
  BEGIN
    FOR r := FIRST(Rank) TO LAST(Rank) DO
      pix[r] := PixmapFromXData.P(Data[r]);
      xip[r] := PixmapFromXData.Flip(Data[r])
    END;
    inited := TRUE
  END Init;

CONST Ace = PixmapFromXData.T{9, 14,
  &quot;38 00 38 00 38 00 6c 00 6c 00 6c 00 &quot; &amp;
  &quot;6c 00 c6 00 fe 00 fe 00 c6 00 83 01 &quot; &amp;
  &quot;83 01 83 01 &quot;};

CONST Deuce = PixmapFromXData.T{9, 14,
  &quot;7c 00 fe 00 c7 01 83 01 80 01 c0 01 &quot; &amp;
  &quot;e0 00 70 00 38 00 1c 00 0e 00 87 01 &quot; &amp;
  &quot;ff 01 ff 01 &quot;};

CONST Trey = PixmapFromXData.T{9, 14,
  &quot;ff 01 ff 01 c3 01 e0 00 70 00 78 00 &quot; &amp;
  &quot;fc 00 c8 01 80 01 80 01 82 01 c7 01 &quot; &amp;
  &quot;fe 00 7c 00 &quot;};

CONST Four = PixmapFromXData.T{9, 14,
  &quot;e0 00 f0 00 f0 00 d8 00 d8 00 cc 00 &quot; &amp;
  &quot;cc 00 c6 00 c6 00 ff 01 ff 01 c0 00 &quot; &amp;
  &quot;e0 01 e0 01 &quot;};

CONST Five = PixmapFromXData.T{9, 14,
  &quot;ff 00 ff 00 03 00 03 00 7b 00 ff 00 &quot; &amp;
  &quot;c7 01 82 01 80 01 80 01 82 01 c7 01 &quot; &amp;
  &quot;fe 00 7c 00 &quot;};

CONST Six = PixmapFromXData.T{9, 14,
  &quot;7c 00 fe 00 c7 01 83 00 03 00 7b 00 &quot; &amp;
  &quot;ff 00 c7 01 83 01 83 01 83 01 c7 01 &quot; &amp;
  &quot;fe 00 7c 00 &quot;};

CONST Seven = PixmapFromXData.T{9, 14,
  &quot;ff 01 ff 01 83 01 c0 00 c0 00 60 00 &quot; &amp;
  &quot;60 00 30 00 30 00 30 00 18 00 18 00 &quot; &amp;
  &quot;18 00 18 00 &quot;};

CONST Eight = PixmapFromXData.T{9, 14,
  &quot;7c 00 fe 00 c7 01 83 01 c7 01 fe 00 &quot; &amp;
  &quot;7c 00 fe 00 c7 01 83 01 83 01 c7 01 &quot; &amp;
  &quot;fe 00 7c 00 &quot;};

CONST Nine = PixmapFromXData.T{9, 14,
  &quot;7c 00 fe 00 c7 01 83 01 83 01 83 01 &quot; &amp;
  &quot;c7 01 fe 01 bc 01 80 01 82 01 c7 01 &quot; &amp;
  &quot;fe 00 7c 00 &quot;};

CONST Ten = PixmapFromXData.T{9, 14,
  &quot;f3 00 fb 01 9b 01 9b 01 9b 01 9b 01 &quot; &amp;
  &quot;9b 01 9b 01 9b 01 9b 01 9b 01 9b 01 &quot; &amp;
  &quot;fb 01 f3 00 &quot;};

CONST Jack = PixmapFromXData.T{9, 14,
  &quot;e0 01 e0 01 c0 00 c0 00 c0 00 c0 00 &quot; &amp;
  &quot;c0 00 c0 00 c0 00 c3 00 c3 00 e7 00 &quot; &amp;
  &quot;7e 00 3c 00 &quot;};

CONST Queen = PixmapFromXData.T{9, 14,
  &quot;38 00 7c 00 ee 00 c6 00 c6 00 c6 00 &quot; &amp;
  &quot;c6 00 c6 00 df 00 ff 00 f6 00 ee 00 &quot; &amp;
  &quot;fc 01 b8 00 &quot;};

CONST King = PixmapFromXData.T{9, 14,
  &quot;ef 01 ef 01 e6 00 76 00 3e 00 1e 00 &quot; &amp;
  &quot;1e 00 3e 00 36 00 76 00 66 00 e6 00 &quot; &amp;
  &quot;ef 01 ef 01 &quot;};

BEGIN END CardRank.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Card is in:
</A><UL>
<LI><A HREF="Card.i3#0TOP0">bicycle/src/Card.i3</A>
<LI><A HREF="../../m3front/src/builtinTypes/Card.i3#0TOP0">m3front/src/builtinTypes/Card.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
