<HTML>
<HEAD>
<TITLE>SRC Modula-3: bicycle/src/CardSuit.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>bicycle/src/CardSuit.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Copyright 1990 David Lemke and Network Computing Devices             </EM></BLOCKQUOTE><PRE>
</PRE> Copyright (c) 1989, Donald R. Woods and Sun Microsystems, Inc.       

<P>
<P><PRE>MODULE <module><implements><A HREF="CardSuit.i3">CardSuit</A></implements></module>;

IMPORT <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="PixmapFromXData.i3">PixmapFromXData</A>;

FROM <A HREF="#x1">Card</A> IMPORT Suit, Family;

VAR
  mu := NEW(MUTEX);
  inited := FALSE;
  acepix, rankpix, pippix, rankxip, pipxip: ARRAY Suit OF Pixmap.T;

TYPE SuitData = ARRAY Suit OF PixmapFromXData.T;

CONST
  PipData = SuitData{Spade, Heart, Diamond, Club};
  RankData = SuitData{SmallSpade, SmallHeart, SmallDiamond, SmallClub};

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>() =
  BEGIN
    FOR s := FIRST(Suit) TO LAST(Suit) DO
      VAR halftone := s = Family.Hearts OR s = Family.Diamonds; BEGIN
        rankpix[s] := PixmapFromXData.P(RankData[s], halftone);
        rankxip[s] := PixmapFromXData.Flip(RankData[s], halftone);
        pippix[s] := PixmapFromXData.P(PipData[s], halftone);
        pipxip[s] := PixmapFromXData.Flip(PipData[s], halftone)
      END;
      IF s = Family.Spades THEN
        acepix[s] := PixmapFromXData.P(BigSpade)
      ELSE
        acepix[s] := pippix[s]
      END
    END;
    inited := TRUE
  END Init;

PROCEDURE <A NAME="AcePix"><procedure>AcePix</procedure></A>(s: Suit): Pixmap.T =
  BEGIN
    LOCK mu DO
      IF NOT inited THEN Init() END;
      RETURN acepix[s]
    END
  END AcePix;

PROCEDURE <A NAME="RankPix"><procedure>RankPix</procedure></A>(s: Suit): Pixmap.T =
  BEGIN
    LOCK mu DO
      IF NOT inited THEN Init() END;
      RETURN rankpix[s]
    END
  END RankPix;

PROCEDURE <A NAME="RankXip"><procedure>RankXip</procedure></A>(s: Suit): Pixmap.T =
  BEGIN
    LOCK mu DO
      IF NOT inited THEN Init() END;
      RETURN rankxip[s]
    END
  END RankXip;

PROCEDURE <A NAME="PipPix"><procedure>PipPix</procedure></A>(s: Suit): Pixmap.T =
  BEGIN
    LOCK mu DO
      IF NOT inited THEN Init() END;
      RETURN pippix[s]
    END
  END PipPix;

PROCEDURE <A NAME="PipXip"><procedure>PipXip</procedure></A>(s: Suit): Pixmap.T =
  BEGIN
    LOCK mu DO
      IF NOT inited THEN Init() END;
      RETURN pipxip[s]
    END
  END PipXip;

CONST Spade = PixmapFromXData.T{15, 19,
  &quot;80 00 80 00 c0 01 c0 01 e0 03 f0 07 &quot; &amp;
  &quot;f0 07 f8 0f fc 1f fe 3f fe 3f ff 7f &quot; &amp;
  &quot;ff 7f ff 7f ff 7f be 3e 9c 1c c0 01 &quot; &amp;
  &quot;e0 03 &quot;};

CONST BigSpade = PixmapFromXData.T{39, 52,
  &quot;00 00 08 00 00 00 00 08 00 00 00 00 &quot; &amp;
  &quot;08 00 00 00 00 1c 00 00 00 00 1c 00 &quot; &amp;
  &quot;00 00 00 1c 00 00 00 00 3e 00 00 00 &quot; &amp;
  &quot;00 3e 00 00 00 00 7f 00 00 00 00 7f &quot; &amp;
  &quot;00 00 00 80 ff 00 00 00 c0 ff 01 00 &quot; &amp;
  &quot;00 c0 ff 01 00 00 e0 ff 03 00 00 f0 &quot; &amp;
  &quot;ff 07 00 00 f0 ff 07 00 00 f8 ff 0f &quot; &amp;
  &quot;00 00 fc ff 1f 00 00 fe ff 3f 00 00 &quot; &amp;
  &quot;ff ff 7f 00 80 ff ff ff 00 c0 ff ff &quot; &amp;
  &quot;ff 01 e0 ff ff ff 03 f0 ff ff ff 07 &quot; &amp;
  &quot;f8 ff ff ff 0f f8 ff ff ff 0f fc ff &quot; &amp;
  &quot;ff ff 1f fc ff ff ff 1f fe ff ff ff &quot; &amp;
  &quot;3f fe ff ff ff 3f fe ff ff ff 3f ff &quot; &amp;
  &quot;ff ff ff 7f ff ff ff ff 7f ff ff ff &quot; &amp;
  &quot;ff 7f ff ff ff ff 7f ff ff ff ff 7f &quot; &amp;
  &quot;fe ff ff ff 3f fe ff ff ff 3f fc ff &quot; &amp;
  &quot;be ff 1f fc 7f 1c ff 1f f8 3f 1c fe &quot; &amp;
  &quot;0f f0 1f 1c fc 07 c0 07 1c f0 01 00 &quot; &amp;
  &quot;00 1c 00 00 00 00 3e 00 00 00 00 3e &quot; &amp;
  &quot;00 00 00 00 7f 00 00 00 00 7f 00 00 &quot; &amp;
  &quot;00 80 ff 00 00 00 c0 ff 01 00 00 e0 &quot; &amp;
  &quot;ff 03 00 00 f0 ff 07 00 &quot;};

CONST SmallSpade = PixmapFromXData.T{9, 12,
  &quot;10 00 10 00 38 00 38 00 7c 00 fe 00 &quot; &amp;
  &quot;ff 01 ff 01 ff 01 d6 00 10 00 38 00 &quot;};

CONST Heart = PixmapFromXData.T{15, 17,
  &quot;1c 1c 3e 3e 7f 7f 7f 7f ff 7f ff 7f &quot; &amp;
  &quot;fe 3f fe 3f fc 1f f8 0f f0 07 f0 07 &quot; &amp;
  &quot;e0 03 c0 01 c0 01 80 00 80 00 &quot;};

CONST SmallHeart = PixmapFromXData.T{9, 11,
  &quot;c6 00 ef 01 ff 01 ff 01 fe 00 fe 00 &quot; &amp;
  &quot;7c 00 38 00 38 00 10 00 10 00 &quot;};

CONST Club = PixmapFromXData.T{15, 16,
  &quot;c0 81 e0 83 f0 87 f0 87 f0 87 e0 83 &quot; &amp;
  &quot;dc 9d fe bf ff ff ff ff ff ff be 3e &quot; &amp;
  &quot;9c 1c c0 81 c0 81 e0 83 &quot;};

CONST SmallClub = PixmapFromXData.T{9, 11,
  &quot;38 00 7c 00 7c 00 38 00 d6 00 ff 81 &quot; &amp;
  &quot;ff 81 ff 81 d6 00 00 00 38 00 &quot;};

CONST Diamond = PixmapFromXData.T{13, 19,
  &quot;40 00 40 00 e0 00 e0 00 f0 01 f8 03 &quot; &amp;
  &quot;f8 03 fc 07 fe 0f ff 1f fe 0f fc 07 &quot; &amp;
  &quot;f8 03 f8 03 f0 01 e0 00 e0 00 40 00 &quot; &amp;
  &quot;40 00 &quot;};

CONST SmallDiamond = PixmapFromXData.T{7, 12,
  &quot;08 08 1c 1c 3e 7f 3e 1c 1c 08 08 00 &quot;};

BEGIN
  PixWidth[Family.Spades] := Spade.width;
  PixWidth[Family.Hearts] := Heart.width;
  PixWidth[Family.Diamonds] := Diamond.width;
  PixWidth[Family.Clubs] := Club.width;
  PixHeight[Family.Spades] := Spade.height;
  PixHeight[Family.Hearts] := Heart.height;
  PixHeight[Family.Diamonds] := Diamond.height;
  PixHeight[Family.Clubs] := Club.height;
END CardSuit.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Card is in:
</A><UL>
<LI><A HREF="Card.i3#0TOP0">bicycle/src/Card.i3</A>
<LI><A HREF="../../m3front/src/builtinTypes/Card.i3#0TOP0">m3front/src/builtinTypes/Card.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
