<HTML>
<HEAD>
<TITLE>SRC Modula-3: bicycle/src/PixmapFromXData.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>bicycle/src/PixmapFromXData.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="PixmapFromXData.i3">PixmapFromXData</A></implements></module>;

IMPORT <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../ui/src/vbt/ScrnPixmap.i3">ScrnPixmap</A>, <A HREF="../../rw/src/Common/TextRd.i3">TextRd</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../word/src/Word.i3">Word</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../ui/src/vbt/Palette.i3">Palette</A>,
  <A HREF="../../ui/src/vbt/ScreenType.i3">ScreenType</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

&lt;* FATAL Rd.Failure, Rd.EndOfFile, Thread.Alerted *&gt;

PROCEDURE <A NAME="NextByte"><procedure>NextByte</procedure></A>(rd: Rd.T): Word.T =
  VAR res := 0; ch := Rd.GetChar(rd); BEGIN
    WHILE ch = ' ' OR ch = '\n' OR ch = '\t' OR ch = ',' DO
      ch := Rd.GetChar(rd)
    END;
    CASE ch OF
      '0','1','2','3','4','5','6','7','8','9' =&gt;
        res := ORD(ch) - ORD('0')
    | 'a','b','c','d','e','f' =&gt;
        res := ORD(ch) - ORD('a') + 10
    | 'A','B','C','D','E','F' =&gt;
        res := ORD(ch) - ORD('A') + 10
    ELSE &lt;* ASSERT FALSE *&gt;
    END;
    TRY
      LOOP
        ch := Rd.GetChar(rd);
        CASE ch OF
          '0','1','2','3','4','5','6','7','8','9' =&gt;
            res := 16 * res + ORD(ch) - ORD('0')
        | 'a','b','c','d','e','f' =&gt;
            res := 16 * res + ORD(ch) - ORD('a') + 10
        | 'A','B','C','D','E','F' =&gt;
            res := 16 * res + ORD(ch) - ORD('A') + 10
        | 'x','X'=&gt; res := 0
        ELSE EXIT
        END
      END;
    EXCEPT Rd.EndOfFile =&gt;
    END;
    RETURN res
  END NextByte;

PROCEDURE <A NAME="P"><procedure>P</procedure></A>(t: T; halftone: BOOLEAN): Pixmap.T =
  VAR
    r := ScrnPixmap.NewRaw(1, Rect.FromSize(t.width, t.height));
    rd := TextRd.New(t.t);
    word, mask: Word.T;
    res: Pixmap.T;
  BEGIN
    FOR v := 0 TO t.height - 1 DO
      IF halftone THEN
        IF v MOD 2 = 0 THEN
          mask := 16_EE
        ELSE
          mask := 16_BB
        END
      END;
      FOR h := 0 TO t.width - 1 DO
        IF h MOD 8 = 0 THEN
          word := NextByte(rd);
          IF halftone THEN word := Word.And(word, mask) END
        END;
        r.set(Point.T{h, v}, Word.And(word, 1));
        word := Word.RightShift(word, 1)
      END
    END;
    Rd.Close(rd);
    res := Pixmap.FromBitmap(r);
    IF halftone THEN
      RETURN TwoTone(res, P(t, FALSE))
    ELSE
      RETURN res
    END
  END P;

PROCEDURE <A NAME="Flip"><procedure>Flip</procedure></A>(t: T; halftone: BOOLEAN): Pixmap.T =
  VAR
    r := ScrnPixmap.NewRaw(1, Rect.FromSize(t.width, t.height));
    rd := TextRd.New(t.t);
    word, mask: Word.T;
    res: Pixmap.T;
  BEGIN
    FOR v := 0 TO t.height - 1 DO
      IF halftone THEN
        IF v MOD 2 = 0 THEN
          mask := 16_EE
        ELSE
          mask := 16_BB
        END
      END;
      FOR h := 0 TO t.width - 1 DO
        IF h MOD 8 = 0 THEN
          word := NextByte(rd);
          IF halftone THEN word := Word.And(word, mask) END
        END;
        r.set(Point.T{t.width - 1 - h, t.height - 1 - v}, Word.And(word, 1));
        word := Word.RightShift(word, 1)
      END
    END;
    Rd.Close(rd);
    res := Pixmap.FromBitmap(r);
    IF halftone THEN
      RETURN TwoTone(res, Flip(t, FALSE))
    ELSE
      RETURN res
    END
  END Flip;

PROCEDURE <A NAME="TwoTone"><procedure>TwoTone</procedure></A>(bw, color: Pixmap.T): Pixmap.T =
</PRE><BLOCKQUOTE><EM> Return the pixmap which is <CODE>pm</CODE> on a black-and-white display,
   and <CODE>Pixmap.Solid</CODE> otherwise. </EM></BLOCKQUOTE><PRE>
   BEGIN
    RETURN Palette.FromPixmapClosure(NEW(TTClosure, bw := bw, color := color))
   END TwoTone;

TYPE TTClosure = Palette.PixmapClosure OBJECT
    bw, color: Pixmap.T
  OVERRIDES
    apply := TTApply
  END;

PROCEDURE <A NAME="TTApply"><procedure>TTApply</procedure></A>(cl: TTClosure; st: ScreenType.T): ScrnPixmap.T =
  BEGIN
    IF st.depth = 1 THEN
      RETURN Palette.ResolvePixmap(st, cl.bw)
    ELSE
      RETURN Palette.ResolvePixmap(st, cl.color)
    END
  END TTApply;

BEGIN END PixmapFromXData.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
