<HTML>
<HEAD>
<TITLE>SRC Modula-3: codeview/src/CodeView.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>codeview/src/CodeView.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="CodeView.i3">CodeView</A></implements></module>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/split/BorderedVBT.i3">BorderedVBT</A>, <A HREF="../../types/src/ASCII.i3">ASCII</A>, <A HREF="../../color/src/ColorName.i3">ColorName</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="#x1">FloatMode</A>, <A HREF="../../ui/src/vbt/Font.i3">Font</A>, <A HREF="IntRef.i3">IntRef</A>,
       <A HREF="IntRefSort.i3">IntRefSort</A>, <A HREF="../../libm3/derived/IntRefTbl.i3">IntRefTbl</A>, <A HREF="../../fmtlex/src/Lex.i3">Lex</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>,
       <A HREF="../../formsvbt/src/RefListUtils.i3">RefListUtils</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../ui/src/split/Split.i3">Split</A>, <A HREF="../../rw/src/Common/Stdio.i3">Stdio</A>, <A HREF="../../etext/src/TextPort.i3">TextPort</A>, <A HREF="../../libm3/derived/TextRefTbl.i3">TextRefTbl</A>, <A HREF="../../text/src/Text.i3">Text</A>,
       <A HREF="TextRef.i3">TextRef</A>, <A HREF="TextRefSort.i3">TextRefSort</A>, <A HREF="../../rw/src/Common/TextRd.i3">TextRd</A>, <A HREF="../../rw/src/Common/TextWr.i3">TextWr</A>, <A HREF="../../ui/src/split/TextureVBT.i3">TextureVBT</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>,
       <A HREF="../../vtext/src/VText.i3">VText</A>, <A HREF="../../vtext/src/VTDef.i3">VTDef</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../ui/src/split/ZSplit.i3">ZSplit</A>;

&lt;* FATAL Rd.Failure, Wr.Failure, Thread.Alerted, Rd.EndOfFile *&gt;
&lt;* FATAL Lex.Error, FloatMode.Trap *&gt;
&lt;* FATAL VTDef.Error, Split.NotAChild *&gt;

TYPE
  ProcInfo = REF RECORD
                   source : TEXT;
                   offsets: IntRefTbl.T;
                 END;
  Position = REF RECORD start, end: CARDINAL;  END;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        procTable: TextRefTbl.T;
        font     : Font.T;
        delta    : CARDINAL;
      OVERRIDES
        shape       := ZShape;
        enter       := Enter;
        exit        := Exit;
        at          := At;
        event       := Event;
        exitAll     := ExitAll;
        listNames   := ListNames;
        listRegions := ListRegions;
        init        := Init;
      END;

TYPE
  AlgVBT = TextPort.T OBJECT
             interval: VText.Interval;
             proc    : ProcInfo;
           OVERRIDES
             shape := Shape;
           END;

&lt;* FATAL ColorName.NotFound *&gt;
VAR
  highlightStyle := VText.MakeIntervalOptions (
                      VText.IntervalStyle.InverseStyle,
                      PaintOp.MakeColorScheme (
                        PaintOp.Fg, PaintOp.FromRGB (
                                        ColorName.ToRGB (&quot;LightGreen&quot;).r,
                                        ColorName.ToRGB (&quot;LightGreen&quot;).g,
                                        ColorName.ToRGB (&quot;LightGreen&quot;).b)),
                      PaintOp.bgFg, PaintOp.Bg);

PROCEDURE <A NAME="ZShape"><procedure>ZShape</procedure></A> (v: VBT.T; ax: Axis.T; n: CARDINAL): VBT.SizeRange =
  VAR res := ZSplit.T.shape (v, ax, n);
  BEGIN
    IF res.pref &lt; 100 THEN
      IF ax = Axis.T.Ver THEN res.pref := 200 ELSE res.pref := 400 END;
      IF res.pref &gt;= res.hi THEN res.hi := res.pref + 1; END;
    END;
    RETURN res;
  END ZShape;

PROCEDURE <A NAME="Shape"><procedure>Shape</procedure></A> (&lt;*UNUSED*&gt; v : VBT.T;
                 &lt;*UNUSED*&gt; ax: Axis.T;
                 &lt;*UNUSED*&gt; n : CARDINAL): VBT.SizeRange =
  VAR res: VBT.SizeRange;
  BEGIN
    res.pref := 2000;
    res.lo := res.pref;
    res.hi := res.lo + 1;
    RETURN res;
  END Shape;

PROCEDURE <A NAME="Enter"><procedure>Enter</procedure></A> (t: T; procedureName: TEXT; pauseTime := -1) =
  VAR
    algVBT: AlgVBT;
    point : Point.T;
    depth : INTEGER;
    pos   : Position;
    refany: REFANY;
  BEGIN
    IF NOT t.procTable.get (procedureName, refany) THEN RETURN; END;
    algVBT := NewAlgVBT (t, refany);
    depth := Split.NumChildren (t) - 1;
    point := Point.Add (
               Rect.NorthWest (ZSplit.GetParentDomain (t)),
               Point.FromCoords (t.delta * depth, t.delta * depth));
    ZSplit.InsertAt (t, BorderedVBT.New (algVBT, 0.5), point);
    IF algVBT.proc.offsets.get (0, refany) THEN
      pos := refany;
      VText.MoveInterval (algVBT.interval, pos.start, pos.end);
      VBT.Mark (algVBT);
      IF pauseTime &lt; 0 THEN pauseTime := t.pauseTime; END;
      Thread.Pause (FLOAT(pauseTime, LONGREAL));
    END;
  END Enter;

PROCEDURE <A NAME="Exit"><procedure>Exit</procedure></A> (t: T; pauseTime := -1) =
  BEGIN
    IF Split.NumChildren (t) &lt; 2 THEN RETURN; END;
    Split.Delete (t, Split.Succ (t, NIL));
    IF pauseTime &lt; 0 THEN pauseTime := t.pauseTime; END;
    Thread.Pause (FLOAT(pauseTime, LONGREAL));
  END Exit;

PROCEDURE <A NAME="At"><procedure>At</procedure></A> (t: T; highlight: CARDINAL; pauseTime := -1) =
  VAR
    algVBT: AlgVBT;
    pos   : Position;
    refany: REFANY;
  BEGIN
    IF Split.NumChildren (t) &lt; 2 THEN RETURN; END;
    algVBT := Split.Succ (Split.Succ (t, NIL), NIL);
    IF algVBT.proc.offsets.get (highlight, refany) THEN
      pos := refany;
      VText.MoveInterval (algVBT.interval, pos.start, pos.end);
      VBT.Mark (algVBT);
      IF pauseTime &lt; 0 THEN pauseTime := t.pauseTime; END;
      Thread.Pause (FLOAT(pauseTime, LONGREAL));
    END;
  END At;

PROCEDURE <A NAME="Event"><procedure>Event</procedure></A> (t            : T;
                 highlight           := 0;
                 pauseTime           := -1;
                 procedureName: TEXT := NIL ) =
  BEGIN
    IF procedureName # NIL THEN
      t.enter (procedureName, pauseTime);
    ELSIF highlight &lt; 0 THEN
      t.exit (pauseTime);
    ELSE
      t.at (highlight, pauseTime);
    END;
  END Event;

PROCEDURE <A NAME="ExitAll"><procedure>ExitAll</procedure></A> (t: T) =
  VAR
    bg := Split.Pred (t, NIL);
    ch := Split.Pred (t, bg);
  BEGIN
    WHILE ch # NIL DO Split.Delete (t, ch); ch := Split.Pred (t, bg); END;
  END ExitAll;

PROCEDURE <A NAME="NewAlgVBT"><procedure>NewAlgVBT</procedure></A> (t: T; proc: ProcInfo): AlgVBT =
  VAR
    vbt: AlgVBT;
    vt : VText.T;
  BEGIN
    vbt := NEW (AlgVBT).init (wrap := FALSE, font := t.font);
    TextPort.SetText (vbt, proc.source);
    vbt.setReadOnly(TRUE);  (* replaces TextPort.SetReadOnly (vbt, TRUE);*)
    vt := TextPort.GetVText (vbt);
    vbt.interval := VText.CreateInterval (vt, 0, 0, highlightStyle);
    VText.SwitchInterval (vbt.interval, VText.OnOffState.On);
    vbt.proc := proc;
    RETURN vbt;
  END NewAlgVBT;

PROCEDURE <A NAME="Dump"><procedure>Dump</procedure></A> (source: Rd.T; wr: Wr.T; errorWr: Wr.T := NIL) =
  VAR
    procList: RefList.T;
    assoc   : RefList.T;
    name    : TEXT;
    proc    : ProcInfo;
    posList : RefList.T;
    pos     : Position;
    line    : REF INTEGER;
  BEGIN
    procList := SortTextRefTbl(ParseAlg (source, errorWr));
    WHILE procList # NIL DO
      assoc := RefListUtils.Pop (procList);
      name := RefListUtils.Pop (assoc);
      proc := RefListUtils.Pop (assoc);
      Wr.PutText (wr, name &amp; &quot;\n&quot;);
      posList := SortIntRefTbl(proc.offsets);
      WHILE posList # NIL DO
        assoc := RefListUtils.Pop (posList);
        line := RefListUtils.Pop (assoc);
        pos := RefListUtils.Pop (assoc);
        Wr.PutText (wr, Fmt.F (&quot;%5s  %s\n&quot;, Fmt.Int (line^),
                               Text.Sub (proc.source, pos.start,
                                         pos.end - pos.start)));
      END;
      Wr.PutChar (wr, '\n');
    END;
  END Dump;

PROCEDURE <A NAME="ParseAlg"><procedure>ParseAlg</procedure></A> (rd: Rd.T; errorWr: Wr.T): TextRefTbl.T =
  TYPE
    State = {Top, TopAt, TopTag, InProc, ProcAt, ProcTag, StatTag, InStat,
             StatAt};
  VAR
    procTable           := NEW(TextRefTbl.Default).init();
    procWr              := TextWr.New ();
    tagWr               := TextWr.New ();
    state               := State.Top;
    c        : CHAR;
    name     : TEXT;
    tag      : TEXT;
    id       : CARDINAL;
    any      : REFANY;
    proc     : ProcInfo;
    pos      : Position;
  BEGIN
    IF errorWr = NIL THEN errorWr := Stdio.stderr; END;
    WHILE NOT Rd.EOF (rd) DO
      c := Rd.GetChar (rd);
      CASE state OF
      | State.Top =&gt; IF c = '@' THEN state := State.TopAt; END;
      | State.TopAt =&gt;
          IF c IN ASCII.AlphaNumerics THEN
            Wr.PutChar (tagWr, c);
            state := State.TopTag;
          ELSE
            state := State.Top;
          END;
      | State.TopTag =&gt;
          IF c IN ASCII.Punctuation + ASCII.Spaces THEN
            name := TextWr.ToText (tagWr);
            proc := NEW (ProcInfo);
            proc.offsets := NEW(IntRefTbl.Default).init(4);
            pos := NEW (Position);
            tag := &quot;0&quot;;
            id := 0;
            pos.start := Wr.Index (procWr);
            state := State.InStat;
          ELSE
            Wr.PutChar (tagWr, c);
          END;
      | State.InProc =&gt;
          IF c = '@' THEN
            state := State.ProcAt;
          ELSE
            Wr.PutChar (procWr, c);
          END;
      | State.ProcAt =&gt;
          IF c IN ASCII.Letters THEN
            Wr.PutChar (tagWr, c);
            state := State.ProcTag;
          ELSIF c IN ASCII.Digits THEN
            Wr.PutChar (tagWr, c);
            state := State.StatTag;
          ELSE
            state := State.InProc;
          END;
      | State.ProcTag =&gt;
          IF c IN ASCII.Punctuation + ASCII.Spaces THEN
            tag := TextWr.ToText (tagWr);
            IF NOT Text.Equal (tag, name) THEN
              Wr.PutText (
                errorWr,
                Fmt.F (
                  &quot;procedure trailer for '%s' does not match header\n&quot;,
                  name));
            END;
            proc.source := TextWr.ToText (procWr);
            EVAL procTable.put (name, proc);
            state := State.Top;
          ELSE
            Wr.PutChar (tagWr, c);
          END;
      | State.StatTag =&gt;
          IF c IN ASCII.Digits THEN
            Wr.PutChar (tagWr, c);
          ELSE
            tag := TextWr.ToText (tagWr);
            id := Lex.Int (TextRd.New (tag));
            IF proc.offsets.get (id, any) THEN
              Wr.PutText (
                errorWr,
                Fmt.F (
                  &quot;duplicate statement tag '@%s' at offsets %s and %s\n&quot;,
                  tag, Fmt.Int (pos.start), Fmt.Int (Rd.Index (rd))));
            END;
            pos := NEW (Position);
            pos.start := Wr.Index (procWr);
            state := State.InStat;
          END;
      | State.InStat =&gt;
          IF c = '@' THEN
            state := State.StatAt;
          ELSE
            Wr.PutChar (procWr, c);
          END;
      | State.StatAt =&gt;
          IF c = '@' THEN
            Wr.PutChar (procWr, c);
            state := State.InStat;
          ELSE
            pos.end := Wr.Index (procWr);
            EVAL proc.offsets.put (id, pos);
            Wr.PutChar (procWr, c);
            state := State.InProc;
          END;
      END;
    END;

    CASE state OF
    | State.TopTag =&gt;
        Wr.PutText (
          errorWr, &quot;unterminated procedure header (@name) at end-of-file\n&quot;);
    | State.InProc, State.ProcAt =&gt;
        Wr.PutText (errorWr,
                    Fmt.F (
                      &quot;unmatched procedure header (@%s) at end-of-file\n&quot;,
                      name));
    | State.ProcTag =&gt;
        Wr.PutText (
          errorWr,
          Fmt.F (
            &quot;unterminated procedure trailer for '%s' at end-of-file\n&quot;,
            name));
    | State.StatTag =&gt;
        Wr.PutText (
          errorWr,
          Fmt.F (&quot;unterminated statement tag for '%s' at end-of-file\n&quot;,
                 name));
    | State.InStat =&gt;
        Wr.PutText (
          errorWr,
          Fmt.F (&quot;unterminated statement marker ('@%s') at end-of-file\n&quot;,
                 tag));
        Wr.PutText (errorWr,
                    Fmt.F (
                      &quot;unmatched procedure header (@%s) at end-of-file\n&quot;,
                      name));
    | State.StatAt =&gt;
        pos.end := Wr.Index (procWr);
        EVAL proc.offsets.put (Lex.Int (TextRd.New (tag)), pos);
        Wr.PutText (errorWr,
                    Fmt.F (
                      &quot;unmatched procedure header (@%s) at end-of-file\n&quot;,
                      name));
    ELSE
    END;
    Wr.Flush (errorWr);
    RETURN procTable;
  END ParseAlg;

PROCEDURE <A NAME="ListNames"><procedure>ListNames</procedure></A> (t: T): RefList.T =
  VAR
    iter            := t.procTable.iterate();
    k   : TEXT;
    val : REFANY;
    res : RefList.T := NIL;
  BEGIN
    WHILE iter.next(k, val) DO res := RefList.Cons(k, res); END;
    RETURN res
  END ListNames;

PROCEDURE <A NAME="ListRegions"><procedure>ListRegions</procedure></A> (t: T; procedureName: TEXT): RefList.T =
  VAR
    refany: REFANY;
    proc  : ProcInfo;
    k     : INTEGER;
    ri    : REF INTEGER;
    val   : REFANY;
    res   : RefList.T   := NIL;
  BEGIN
    IF t.procTable.get(procedureName, refany) THEN
      proc := refany;
      WITH iter = proc.offsets.iterate() DO
        WHILE iter.next(k, val) DO
          ri := NEW(REF INTEGER);
          ri^ := k;
          res := RefList.Cons(ri, res);
        END;
      END;
      RETURN res
    ELSE
      RETURN NIL;
    END;
  END ListRegions;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (         t         : T;
                         source    : Rd.T;
                         errorWr   : Wr.T     := NIL;
                READONLY fontName             := DefaultFont;
                         paneOffset: CARDINAL := 20;
                         background: VBT.T    := NIL          ):
  T =
  BEGIN
    IF background = NIL THEN
      background :=
        BorderedVBT.New(TextureVBT.New(txt := Pixmap.Gray), 0.5);
    END;
    EVAL ZSplit.T.init(t, background);
    t.procTable := ParseAlg(source, errorWr);
    t.font := Font.FromName(fontName);
    t.delta := paneOffset;
    RETURN t;
  END Init;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (         source    : Rd.T;
                        errorWr   : Wr.T     := NIL;
               READONLY fontName             := DefaultFont;
                        paneOffset: CARDINAL := 20;
                        background: VBT.T    := NIL          ):
  T =
  BEGIN
    RETURN Init(NEW(T), source, errorWr, fontName, paneOffset,
                background);
  END New;

PROCEDURE <A NAME="SortTextRefTbl"><procedure>SortTextRefTbl</procedure></A>(tbl: TextRefTbl.T): RefList.T =
  VAR arr  := NEW(REF ARRAY OF TextRef.T, tbl.size());
      iter := tbl.iterate();
      k: TEXT;
      val: REFANY;
      res: RefList.T := NIL;
  BEGIN
    FOR i := 0 TO LAST(arr^) DO
      EVAL iter.next(k, val);
      arr[i] := TextRef.T{k, val};
    END;
    TextRefSort.Sort(arr^);
    FOR i := 0 TO LAST(arr^) DO
      res := RefList.Cons(RefList.List2(arr[i].key, arr[i].value), res);
    END;
    res := RefList.ReverseD(res);
    RETURN res;
  END SortTextRefTbl;

PROCEDURE <A NAME="SortIntRefTbl"><procedure>SortIntRefTbl</procedure></A> (tbl: IntRefTbl.T): RefList.T =
  VAR
    arr               := NEW(REF ARRAY OF IntRef.T, tbl.size());
    iter              := tbl.iterate();
    k   : INTEGER;
    ri  : REF INTEGER;
    val : REFANY;
    res : RefList.T   := NIL;
  BEGIN
    FOR i := 0 TO LAST(arr^) DO
      EVAL iter.next(k, val);
      arr[i] := IntRef.T{k, val};
    END;
    IntRefSort.Sort(arr^);
    FOR i := 0 TO LAST(arr^) DO
      ri := NEW(REF INTEGER);
      ri^ := arr[i].key;
      res := RefList.Cons(RefList.List2(ri, arr[i].value), res);
    END;
    res := RefList.ReverseD(res);
    RETURN res;
  END SortIntRefTbl;

BEGIN
END CodeView.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface FloatMode is in:
</A><UL>
<LI><A HREF="../../float/src/DS3100/FloatMode.i3#0TOP0">float/src/DS3100/FloatMode.i3</A>
<LI><A HREF="../../float/src/IEEE-default/FloatMode.i3#0TOP0">float/src/IEEE-default/FloatMode.i3</A>
<LI><A HREF="../../float/src/IRIX5/FloatMode.i3#0TOP0">float/src/IRIX5/FloatMode.i3</A>
<LI><A HREF="../../float/src/SOLsun/FloatMode.i3#0TOP0">float/src/SOLsun/FloatMode.i3</A>
<LI><A HREF="../../float/src/SPARC/FloatMode.i3#0TOP0">float/src/SPARC/FloatMode.i3</A>
<LI><A HREF="../../float/src/SUN386/FloatMode.i3#0TOP0">float/src/SUN386/FloatMode.i3</A>
<LI><A HREF="../../float/src/VAX/FloatMode.i3#0TOP0">float/src/VAX/FloatMode.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
