<HTML>
<HEAD>
<TITLE>SRC Modula-3: codeview/src/DataView.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>codeview/src/DataView.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="DataView.m3">DataView</A></interface>;
</PRE><P>
    A DataView.T provides simple display of variables.
    It is intended for - but not limited to - use with Zeus and the 
    Modula-3 compiler's TRACE pragma.
<P>
    The compiler will generate calls to user-specified trace routines
    with the initial value of a &lt;*TRACE*&gt;d variable and at every point
    where it may be modified.  From the compiler release notice:
<P>
    The modified pieces of M3 grammar:
<P>
        VariableDecl = IdList (<CODE>:</CODE> Type &amp; <CODE>:=</CODE> Expr) V_Trace.
        Formal       = [Mode] IdList (<CODE>:</CODE> Type &amp; <CODE>:=</CODE> ConstExpr) V_Trace.
        ForSt        = FOR Id V_Trace <CODE>:=</CODE> Expr TO Expr [BY Expr] DO S END.
        Handler      = QualId {<CODE>,</CODE> QualId} [<CODE>(</CODE> Id V_Trace <CODE>)</CODE>] <CODE>=&gt;</CODE> S.
        TCase        = Type {<CODE>,</CODE> Type} [<CODE>(</CODE> Id V_Trace <CODE>)</CODE>] <CODE>=&gt;</CODE> S.
        Binding      = Id V_Trace <CODE>=</CODE> Expr.
        V_Trace      = [ <CODE>&lt;*</CODE> TRACE  Expr <CODE>*&gt;</CODE> ].
<P>
    The 'Expr' specified in a V_Trace must evaluate to a procedure
    of two arguments.  The first argument is the name of the traced
    variable, a TEXT.  The second argument is the traced variable.
    Note that any of the formal passing modes may be used with the
    second argument.
<P>
    For example:
<P>
          MODULE M;
          VAR x: Foo &lt;*TRACE MyTrace.FooChanged*&gt;;
<P>
    will cause
<P>
          MyTrace.FooChanged (<CODE>M.x</CODE>, x)
<P>
    to be generated after each statement that modifies x.
    Variable aliasing is not tracked, so
<P>
          WITH  alias = x DO  INC(alias) END
<P>
    will not generate any tracing.
    <P>
    Here is an example of a traced Zeus algorithm procedure:    
<P>
        PROCEDURE Run (alg: T) RAISES {Thread.Alerted} =
          VAR
            B: INTEGER   &lt;* TRACE alg.varView.setIntegerL *&gt;;
            N: INTEGER   &lt;* TRACE alg.varView.setIntegerL *&gt;;
            wt: REAL     &lt;* TRACE alg.varView.setReal *&gt;;
            bin: INTEGER &lt;* TRACE alg.varView.setInteger *&gt;;
            bins: Bins;
          BEGIN
            LOCK VBT.mu DO
              N := FormsVBT.GetInteger(alg.data, <CODE>N</CODE>);
              B := FormsVBT.GetInteger(alg.data, <CODE>B</CODE>);
            END;
            BinpackIE.Setup(alg, B, N);
            bins := NEW(Bins, B);
            FOR b := 0 TO B-1 DO bins[b] := 0.0 END;
            FOR i := 1 TO N DO 
              wt := Random.Real();
              BinpackIE.NewWeight (alg, wt);
              bin := 0; 
              WHILE (bin &lt; B) AND (bins[bin] + wt &gt; 1.0) DO INC(bin) END;
              IF bin = B THEN 
                BinpackIE.Ignore(alg);
              ELSE  
                bins[bin] := bins[bin] + wt;
                BinpackIE.Pack(alg, bin, bins[bin]) 
              END
            END
          END Run;
<P>
    The fv expression that is made into a DataView.T must contain
    components with names corresponding to traced variable names.
    Here is one possible form for the example above:
<P>
          (Rim
            (Pen 10)
            (HBox
              (VBox
                (Text RightAlign <CODE># of bins: </CODE>)
                (Text RightAlign <CODE># of items: </CODE>)
                (Text RightAlign <CODE>current weight: </CODE>)
                (Text RightAlign <CODE>probing bin #: </CODE>))
              (VBox
                (TextArea ReadOnly %B)
                (TextArea ReadOnly %N)
                (TextArea ReadOnly %wt)
                (TextArea ReadOnly %bin))))
    <P>
    If using a DataView within Zeus, all you need to do is to 
    set the <CODE>varRsrc</CODE> field on the Algorithm.T to name a resource 
    containing a valid FormsVBT s-expression.
<P>


<P><PRE>IMPORT <A HREF="../../formsvbt/src/FormsVBT.i3">FormsVBT</A>;
</PRE> Basic types.  If you need something that isn't here, 
   don't hesitate to add it. 

<P><PRE>TYPE
  Integer = INTEGER;
  Boolean = BOOLEAN;
  Char = CHAR;
  Real = REAL;
  LongReal = LONGREAL;
  Text = TEXT;

  IntegerArray = ARRAY OF Integer;
  CharArray = ARRAY OF Char;
  BooleanArray = ARRAY OF Boolean;
  RealArray = ARRAY OF Real;
  LongRealArray = ARRAY OF LongReal;
  TextArray = ARRAY OF Text;

  IntegerArray2 = ARRAY OF IntegerArray;
  CharArray2 = ARRAY OF CharArray;
  BooleanArray2 = ARRAY OF BooleanArray;
  RealArray2 = ARRAY OF RealArray;
  LongRealArray2 = ARRAY OF LongRealArray;
  TextArray2 = ARRAY OF TextArray;

  IntegerPair = RECORD a, b: INTEGER END;
  IntegerPairArray = ARRAY OF IntegerPair;

  IntegerTriple = RECORD a, b, c: INTEGER END;
  IntegerTripleArray = ARRAY OF IntegerTriple;

  IntegerList = REF RECORD
                      i   : INTEGER;
                      next: IntegerList
                    END;
  IntegerListArray = ARRAY OF IntegerList;

  RealList = REF RECORD
                   r   : REAL;
                   next: RealList
                 END;
  RealListArray = ARRAY OF RealList;

  IntegerPairList = REF RECORD
                          a, b: INTEGER;
                          next: IntegerPairList
                        END;
  IntegerPairListArray = ARRAY OF IntegerPairList;

  IntegerTree = REF RECORD
                      i   : INTEGER;
                      l, r: IntegerTree
                    END;

TYPE
  <A HREF="DataView.m3#T">T</A> &lt;: Public;
  Public = FormsVBT.T OBJECT
    METHODS

      (* TRACE methods with LL &lt; VBT.mu *)
      setInteger  (var: TEXT; val: Integer);
      setBoolean  (var: TEXT; val: Boolean);
      setChar     (var: TEXT; val: Char);
      setReal     (var: TEXT; val: Real);
      setLongReal (var: TEXT; val: LongReal);
      setText     (var: TEXT; val: Text);

      setIntegerArray  (var: TEXT; READONLY val: IntegerArray);
      setBooleanArray  (var: TEXT; READONLY val: BooleanArray);
      setCharArray     (var: TEXT; READONLY val: CharArray);
      setRealArray     (var: TEXT; READONLY val: RealArray);
      setLongRealArray (var: TEXT; READONLY val: LongRealArray);
      setTextArray     (var: TEXT; READONLY val: TextArray);

      setIntegerArray2  (var: TEXT; READONLY val: IntegerArray2);
      setBooleanArray2  (var: TEXT; READONLY val: BooleanArray2);
      setCharArray2     (var: TEXT; READONLY val: CharArray2);
      setRealArray2     (var: TEXT; READONLY val: RealArray2);
      setLongRealArray2 (var: TEXT; READONLY val: LongRealArray2);
      setTextArray2     (var: TEXT; READONLY val: TextArray2);

      setIntegerPair      (var: TEXT; READONLY val: IntegerPair);
      setIntegerPairArray (var: TEXT; READONLY val: IntegerPairArray);

      setIntegerTriple      (var: TEXT; READONLY val: IntegerTriple);
      setIntegerTripleArray (var: TEXT; READONLY val: IntegerTripleArray);

      setIntegerList      (var: TEXT; val: IntegerList);
      setIntegerListArray (var: TEXT; READONLY val: IntegerListArray);

      setRealList      (var: TEXT; val: RealList);
      setRealListArray (var: TEXT; READONLY val: RealListArray);

      setIntegerPairList      (var: TEXT; val: IntegerPairList);
      setIntegerPairListArray (var: TEXT; READONLY val: IntegerPairListArray);

      setIntegerTree (var: TEXT; val: IntegerTree);

      (* TRACE methods with LL = VBT.mu *)
      setIntegerL  (var: TEXT; val: Integer);
      setBooleanL  (var: TEXT; val: Boolean);
      setCharL     (var: TEXT; val: Char);
      setRealL     (var: TEXT; val: Real);
      setLongRealL (var: TEXT; val: LongReal);
      setTextL     (var: TEXT; val: Text);

      setIntegerArrayL  (var: TEXT; READONLY val: IntegerArray);
      setBooleanArrayL  (var: TEXT; READONLY val: BooleanArray);
      setCharArrayL     (var: TEXT; READONLY val: CharArray);
      setRealArrayL     (var: TEXT; READONLY val: RealArray);
      setLongRealArrayL (var: TEXT; READONLY val: LongRealArray);
      setTextArrayL     (var: TEXT; READONLY val: TextArray);

      setIntegerArray2L  (var: TEXT; READONLY val: IntegerArray2);
      setBooleanArray2L  (var: TEXT; READONLY val: BooleanArray2);
      setCharArray2L     (var: TEXT; READONLY val: CharArray2);
      setRealArray2L     (var: TEXT; READONLY val: RealArray2);
      setLongRealArray2L (var: TEXT; READONLY val: LongRealArray2);
      setTextArray2L     (var: TEXT; READONLY val: TextArray2);

      setIntegerPairL      (var: TEXT; READONLY val: IntegerPair);
      setIntegerPairArrayL (var: TEXT; READONLY val: IntegerPairArray);

      setIntegerTripleL      (var: TEXT; READONLY val: IntegerTriple);
      setIntegerTripleArrayL (var: TEXT; READONLY val: IntegerTripleArray);

      setIntegerListL      (var: TEXT; val: IntegerList);
      setIntegerListArrayL (var: TEXT; READONLY val: IntegerListArray);

      setRealListL      (var: TEXT; val: RealList);
      setRealListArrayL (var: TEXT; READONLY val: RealListArray);

      setIntegerPairListL      (var: TEXT; val: IntegerPairList);
      setIntegerPairListArrayL (var: TEXT; READONLY val: IntegerPairListArray);

      setIntegerTreeL (var: TEXT; val: IntegerTree);
    END;

END DataView.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
