<HTML>
<HEAD>
<TITLE>SRC Modula-3: codeview/src/DataView.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>codeview/src/DataView.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="DataView.i3">DataView</A></implements></module>;

IMPORT <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../formsvbt/src/FormsVBT.i3">FormsVBT</A>, <A HREF="../../rw/src/Common/TextWr.i3">TextWr</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;
IMPORT <A HREF="../../text/src/Text.i3">Text</A> AS TextOps;

&lt;* FATAL Wr.Failure, Thread.Alerted, FormsVBT.Unimplemented *&gt;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
      OVERRIDES
        setInteger              := SetInteger;
        setBoolean              := SetBoolean;
        setChar                 := SetChar;
        setReal                 := SetReal;
        setLongReal             := SetLongReal;
        setText                 := SetText;
        setIntegerArray         := SetIntegerArray;
        setBooleanArray         := SetBooleanArray;
        setCharArray            := SetCharArray;
        setRealArray            := SetRealArray;
        setLongRealArray        := SetLongRealArray;
        setTextArray            := SetTextArray;
        setIntegerArray2        := SetIntegerArray2;
        setBooleanArray2        := SetBooleanArray2;
        setCharArray2           := SetCharArray2;
        setRealArray2           := SetRealArray2;
        setLongRealArray2       := SetLongRealArray2;
        setTextArray2           := SetTextArray2;
        setIntegerPair          := SetIntegerPair;
        setIntegerPairArray     := SetIntegerPairArray;
        setIntegerTriple        := SetIntegerTriple;
        setIntegerTripleArray   := SetIntegerTripleArray;
        setIntegerList          := SetIntegerList;
        setIntegerListArray     := SetIntegerListArray;
        setRealList             := SetRealList;
        setRealListArray        := SetRealListArray;
        setIntegerPairList      := SetIntegerPairList;
        setIntegerPairListArray := SetIntegerPairListArray;
        setIntegerTree          := SetIntegerTree;

        setIntegerL              := SetIntegerL;
        setBooleanL              := SetBooleanL;
        setCharL                 := SetCharL;
        setRealL                 := SetRealL;
        setLongRealL             := SetLongRealL;
        setTextL                 := SetTextL;
        setIntegerArrayL         := SetIntegerArrayL;
        setBooleanArrayL         := SetBooleanArrayL;
        setCharArrayL            := SetCharArrayL;
        setRealArrayL            := SetRealArrayL;
        setLongRealArrayL        := SetLongRealArrayL;
        setTextArrayL            := SetTextArrayL;
        setIntegerArray2L        := SetIntegerArray2L;
        setBooleanArray2L        := SetBooleanArray2L;
        setCharArray2L           := SetCharArray2L;
        setRealArray2L           := SetRealArray2L;
        setLongRealArray2L       := SetLongRealArray2L;
        setTextArray2L           := SetTextArray2L;
        setIntegerPairL          := SetIntegerPairL;
        setIntegerPairArrayL     := SetIntegerPairArrayL;
        setIntegerTripleL        := SetIntegerTripleL;
        setIntegerTripleArrayL   := SetIntegerTripleArrayL;
        setIntegerListL          := SetIntegerListL;
        setIntegerListArrayL     := SetIntegerListArrayL;
        setRealListL             := SetRealListL;
        setRealListArrayL        := SetRealListArrayL;
        setIntegerPairListL      := SetIntegerPairListL;
        setIntegerPairListArrayL := SetIntegerPairListArrayL;
        setIntegerTreeL          := SetIntegerTreeL;
      END;

PROCEDURE <A NAME="SetInteger"><procedure>SetInteger</procedure></A> (t: T; var: TEXT; val: Integer) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN Stuff (t, var, FmtInteger (val)); END;
  END SetInteger;

PROCEDURE <A NAME="SetBoolean"><procedure>SetBoolean</procedure></A> (t: T; var: TEXT; val: Boolean) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN Stuff (t, var, FmtBoolean (val)); END;
  END SetBoolean;

PROCEDURE <A NAME="SetChar"><procedure>SetChar</procedure></A> (t: T; var: TEXT; val: Char) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN Stuff (t, var, FmtChar (val)); END;
  END SetChar;

PROCEDURE <A NAME="SetReal"><procedure>SetReal</procedure></A> (t: T; var: TEXT; val: Real) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN Stuff (t, var, FmtReal (val)); END;
  END SetReal;

PROCEDURE <A NAME="SetLongReal"><procedure>SetLongReal</procedure></A> (t: T; var: TEXT; val: LongReal) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN Stuff (t, var, FmtLongReal (val)); END;
  END SetLongReal;

PROCEDURE <A NAME="SetText"><procedure>SetText</procedure></A> (t: T; var: TEXT; val: Text) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN Stuff (t, var, FmtText (val)); END;
  END SetText;

PROCEDURE <A NAME="SetIntegerArray"><procedure>SetIntegerArray</procedure></A> (t: T; var: TEXT; READONLY val: IntegerArray) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      Stuff (t, var, FmtIntegerArray (val));
    END;
  END SetIntegerArray;

PROCEDURE <A NAME="SetBooleanArray"><procedure>SetBooleanArray</procedure></A> (t: T; var: TEXT; READONLY val: BooleanArray) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      Stuff (t, var, FmtBooleanArray (val));
    END;
  END SetBooleanArray;

PROCEDURE <A NAME="SetCharArray"><procedure>SetCharArray</procedure></A> (t: T; var: TEXT; READONLY val: CharArray) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN Stuff (t, var, FmtCharArray (val)); END;
  END SetCharArray;

PROCEDURE <A NAME="SetRealArray"><procedure>SetRealArray</procedure></A> (t: T; var: TEXT; READONLY val: RealArray) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN Stuff (t, var, FmtRealArray (val)); END;
  END SetRealArray;

PROCEDURE <A NAME="SetLongRealArray"><procedure>SetLongRealArray</procedure></A> (t: T; var: TEXT; READONLY val: LongRealArray) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      Stuff (t, var, FmtLongRealArray (val));
    END;
  END SetLongRealArray;

PROCEDURE <A NAME="SetTextArray"><procedure>SetTextArray</procedure></A> (t: T; var: TEXT; READONLY val: TextArray) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN Stuff (t, var, FmtTextArray (val)); END;
  END SetTextArray;

PROCEDURE <A NAME="SetIntegerArray2"><procedure>SetIntegerArray2</procedure></A> (t: T; var: TEXT; READONLY val: IntegerArray2) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      Stuff (t, var, FmtIntegerArray2 (val));
    END;
  END SetIntegerArray2;

PROCEDURE <A NAME="SetBooleanArray2"><procedure>SetBooleanArray2</procedure></A> (t: T; var: TEXT; READONLY val: BooleanArray2) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      Stuff (t, var, FmtBooleanArray2 (val));
    END;
  END SetBooleanArray2;

PROCEDURE <A NAME="SetCharArray2"><procedure>SetCharArray2</procedure></A> (t: T; var: TEXT; READONLY val: CharArray2) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN Stuff (t, var, FmtCharArray2 (val)); END;
  END SetCharArray2;

PROCEDURE <A NAME="SetRealArray2"><procedure>SetRealArray2</procedure></A> (t: T; var: TEXT; READONLY val: RealArray2) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN Stuff (t, var, FmtRealArray2 (val)); END;
  END SetRealArray2;

PROCEDURE <A NAME="SetLongRealArray2"><procedure>SetLongRealArray2</procedure></A> (t: T; var: TEXT; READONLY val: LongRealArray2) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      Stuff (t, var, FmtLongRealArray2 (val));
    END;
  END SetLongRealArray2;

PROCEDURE <A NAME="SetTextArray2"><procedure>SetTextArray2</procedure></A> (t: T; var: TEXT; READONLY val: TextArray2) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN Stuff (t, var, FmtTextArray2 (val)); END;
  END SetTextArray2;

PROCEDURE <A NAME="SetIntegerPair"><procedure>SetIntegerPair</procedure></A> (t: T; var: TEXT; READONLY val: IntegerPair) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN Stuff (t, var, FmtIntegerPair (val)); END;
  END SetIntegerPair;

PROCEDURE <A NAME="SetIntegerPairArray"><procedure>SetIntegerPairArray</procedure></A> (t: T;
    var: TEXT; READONLY val: IntegerPairArray) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      Stuff (t, var, FmtIntegerPairArray (val));
    END;
  END SetIntegerPairArray;

PROCEDURE <A NAME="SetIntegerTriple"><procedure>SetIntegerTriple</procedure></A> (t: T; var: TEXT; READONLY val: IntegerTriple) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      Stuff (t, var, FmtIntegerTriple (val));
    END;
  END SetIntegerTriple;

PROCEDURE <A NAME="SetIntegerTripleArray"><procedure>SetIntegerTripleArray</procedure></A> (t: T;
    var: TEXT; READONLY val: IntegerTripleArray) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      Stuff (t, var, FmtIntegerTripleArray (val));
    END;
  END SetIntegerTripleArray;

PROCEDURE <A NAME="SetIntegerList"><procedure>SetIntegerList</procedure></A> (t: T; var: TEXT; val: IntegerList) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN Stuff (t, var, FmtIntegerList (val)); END;
  END SetIntegerList;

PROCEDURE <A NAME="SetIntegerListArray"><procedure>SetIntegerListArray</procedure></A> (t: T;
    var: TEXT; READONLY val: IntegerListArray) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      Stuff (t, var, FmtIntegerListArray (val));
    END;
  END SetIntegerListArray;

PROCEDURE <A NAME="SetRealList"><procedure>SetRealList</procedure></A> (t: T; var: TEXT; val: RealList) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN Stuff (t, var, FmtRealList (val)); END;
  END SetRealList;

PROCEDURE <A NAME="SetRealListArray"><procedure>SetRealListArray</procedure></A> (t: T; var: TEXT; READONLY val: RealListArray) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      Stuff (t, var, FmtRealListArray (val));
    END;
  END SetRealListArray;

PROCEDURE <A NAME="SetIntegerPairList"><procedure>SetIntegerPairList</procedure></A> (t: T; var: TEXT; val: IntegerPairList) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      Stuff (t, var, FmtIntegerPairList (val));
    END;
  END SetIntegerPairList;

PROCEDURE <A NAME="SetIntegerPairListArray"><procedure>SetIntegerPairListArray</procedure></A> (t  : T;
                                   var: TEXT;
                     READONLY val: IntegerPairListArray) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      Stuff (t, var, FmtIntegerPairListArray (val));
    END;
  END SetIntegerPairListArray;

PROCEDURE <A NAME="SetIntegerTree"><procedure>SetIntegerTree</procedure></A> (t: T; var: TEXT; val: IntegerTree) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN Stuff (t, var, FmtIntegerTree (val)); END;
  END SetIntegerTree;

PROCEDURE <A NAME="SetIntegerL"><procedure>SetIntegerL</procedure></A> (t: T; var: TEXT; val: Integer) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN StuffL (t, var, FmtInteger (val)); END;
  END SetIntegerL;

PROCEDURE <A NAME="SetBooleanL"><procedure>SetBooleanL</procedure></A> (t: T; var: TEXT; val: Boolean) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN StuffL (t, var, FmtBoolean (val)); END;
  END SetBooleanL;

PROCEDURE <A NAME="SetCharL"><procedure>SetCharL</procedure></A> (t: T; var: TEXT; val: Char) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN StuffL (t, var, FmtChar (val)); END;
  END SetCharL;

PROCEDURE <A NAME="SetRealL"><procedure>SetRealL</procedure></A> (t: T; var: TEXT; val: Real) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN StuffL (t, var, FmtReal (val)); END;
  END SetRealL;

PROCEDURE <A NAME="SetLongRealL"><procedure>SetLongRealL</procedure></A> (t: T; var: TEXT; val: LongReal) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN StuffL (t, var, FmtLongReal (val)); END;
  END SetLongRealL;

PROCEDURE <A NAME="SetTextL"><procedure>SetTextL</procedure></A> (t: T; var: TEXT; val: Text) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN StuffL (t, var, FmtText (val)); END;
  END SetTextL;

PROCEDURE <A NAME="SetIntegerArrayL"><procedure>SetIntegerArrayL</procedure></A> (t: T; var: TEXT; READONLY val: IntegerArray) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      StuffL (t, var, FmtIntegerArray (val));
    END;
  END SetIntegerArrayL;

PROCEDURE <A NAME="SetBooleanArrayL"><procedure>SetBooleanArrayL</procedure></A> (t: T; var: TEXT; READONLY val: BooleanArray) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      StuffL (t, var, FmtBooleanArray (val));
    END;
  END SetBooleanArrayL;

PROCEDURE <A NAME="SetCharArrayL"><procedure>SetCharArrayL</procedure></A> (t: T; var: TEXT; READONLY val: CharArray) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN StuffL (t, var, FmtCharArray (val)); END;
  END SetCharArrayL;

PROCEDURE <A NAME="SetRealArrayL"><procedure>SetRealArrayL</procedure></A> (t: T; var: TEXT; READONLY val: RealArray) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN StuffL (t, var, FmtRealArray (val)); END;
  END SetRealArrayL;

PROCEDURE <A NAME="SetLongRealArrayL"><procedure>SetLongRealArrayL</procedure></A> (t: T; var: TEXT; READONLY val: LongRealArray) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      StuffL (t, var, FmtLongRealArray (val));
    END;
  END SetLongRealArrayL;

PROCEDURE <A NAME="SetTextArrayL"><procedure>SetTextArrayL</procedure></A> (t: T; var: TEXT; READONLY val: TextArray) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN StuffL (t, var, FmtTextArray (val)); END;
  END SetTextArrayL;

PROCEDURE <A NAME="SetIntegerArray2L"><procedure>SetIntegerArray2L</procedure></A> (t: T; var: TEXT; READONLY val: IntegerArray2) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      StuffL (t, var, FmtIntegerArray2 (val));
    END;
  END SetIntegerArray2L;

PROCEDURE <A NAME="SetBooleanArray2L"><procedure>SetBooleanArray2L</procedure></A> (t: T; var: TEXT; READONLY val: BooleanArray2) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      StuffL (t, var, FmtBooleanArray2 (val));
    END;
  END SetBooleanArray2L;

PROCEDURE <A NAME="SetCharArray2L"><procedure>SetCharArray2L</procedure></A> (t: T; var: TEXT; READONLY val: CharArray2) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN StuffL (t, var, FmtCharArray2 (val)); END;
  END SetCharArray2L;

PROCEDURE <A NAME="SetRealArray2L"><procedure>SetRealArray2L</procedure></A> (t: T; var: TEXT; READONLY val: RealArray2) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN StuffL (t, var, FmtRealArray2 (val)); END;
  END SetRealArray2L;

PROCEDURE <A NAME="SetLongRealArray2L"><procedure>SetLongRealArray2L</procedure></A> (t: T; var: TEXT; READONLY val: LongRealArray2) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      StuffL (t, var, FmtLongRealArray2 (val));
    END;
  END SetLongRealArray2L;

PROCEDURE <A NAME="SetTextArray2L"><procedure>SetTextArray2L</procedure></A> (t: T; var: TEXT; READONLY val: TextArray2) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN StuffL (t, var, FmtTextArray2 (val)); END;
  END SetTextArray2L;

PROCEDURE <A NAME="SetIntegerPairL"><procedure>SetIntegerPairL</procedure></A> (t: T; var: TEXT; READONLY val: IntegerPair) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN StuffL (t, var, FmtIntegerPair (val)); END;
  END SetIntegerPairL;

PROCEDURE <A NAME="SetIntegerPairArrayL"><procedure>SetIntegerPairArrayL</procedure></A> (t: T; var: TEXT; READONLY val: IntegerPairArray) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      StuffL (t, var, FmtIntegerPairArray (val));
    END;
  END SetIntegerPairArrayL;

PROCEDURE <A NAME="SetIntegerTripleL"><procedure>SetIntegerTripleL</procedure></A> (t: T; var: TEXT; READONLY val: IntegerTriple) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      StuffL (t, var, FmtIntegerTriple (val));
    END;
  END SetIntegerTripleL;

PROCEDURE <A NAME="SetIntegerTripleArrayL"><procedure>SetIntegerTripleArrayL</procedure></A> (t: T;
    var: TEXT; READONLY val: IntegerTripleArray) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      StuffL (t, var, FmtIntegerTripleArray (val));
    END;
  END SetIntegerTripleArrayL;

PROCEDURE <A NAME="SetIntegerListL"><procedure>SetIntegerListL</procedure></A> (t: T; var: TEXT; val: IntegerList) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN StuffL (t, var, FmtIntegerList (val)); END;
  END SetIntegerListL;

PROCEDURE <A NAME="SetIntegerListArrayL"><procedure>SetIntegerListArrayL</procedure></A> (t: T; var: TEXT; READONLY val: IntegerListArray) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      StuffL (t, var, FmtIntegerListArray (val));
    END;
  END SetIntegerListArrayL;

PROCEDURE <A NAME="SetRealListL"><procedure>SetRealListL</procedure></A> (t: T; var: TEXT; val: RealList) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN StuffL (t, var, FmtRealList (val)); END;
  END SetRealListL;

PROCEDURE <A NAME="SetRealListArrayL"><procedure>SetRealListArrayL</procedure></A> (t: T; var: TEXT; READONLY val: RealListArray) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      StuffL (t, var, FmtRealListArray (val));
    END;
  END SetRealListArrayL;

PROCEDURE <A NAME="SetIntegerPairListL"><procedure>SetIntegerPairListL</procedure></A> (t: T; var: TEXT; val: IntegerPairList) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      StuffL (t, var, FmtIntegerPairList (val));
    END;
  END SetIntegerPairListL;

PROCEDURE <A NAME="SetIntegerPairListArrayL"><procedure>SetIntegerPairListArrayL</procedure></A> (t  : T;
                                   var: TEXT;
                          READONLY val: IntegerPairListArray) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN
      StuffL (t, var, FmtIntegerPairListArray (val));
    END;
  END SetIntegerPairListArrayL;

PROCEDURE <A NAME="SetIntegerTreeL"><procedure>SetIntegerTreeL</procedure></A> (t: T; var: TEXT; val: IntegerTree) =
  BEGIN
    IF VBT.Parent (t) # NIL THEN StuffL (t, var, FmtIntegerTree (val)); END;
  END SetIntegerTreeL;

PROCEDURE <A NAME="FmtInteger"><procedure>FmtInteger</procedure></A> (val: Integer): TEXT =
  BEGIN
    RETURN Fmt.Int (val);
  END FmtInteger;

PROCEDURE <A NAME="FmtBoolean"><procedure>FmtBoolean</procedure></A> (val: Boolean): TEXT =
  BEGIN
    RETURN Fmt.Bool (val);
  END FmtBoolean;

PROCEDURE <A NAME="FmtChar"><procedure>FmtChar</procedure></A> (val: Char): TEXT =
  BEGIN
    RETURN &quot;'&quot; &amp; Fmt.Char (val) &amp; &quot;'&quot;;
  END FmtChar;

PROCEDURE <A NAME="FmtReal"><procedure>FmtReal</procedure></A> (val: Real): TEXT =
  BEGIN
    RETURN Fmt.Real (val);
  END FmtReal;

PROCEDURE <A NAME="FmtLongReal"><procedure>FmtLongReal</procedure></A> (val: LongReal): TEXT =
  BEGIN
    RETURN Fmt.LongReal (val);
  END FmtLongReal;

PROCEDURE <A NAME="FmtText"><procedure>FmtText</procedure></A> (val: Text): TEXT =
  BEGIN
    IF val = NIL THEN RETURN &quot;&quot; ELSE RETURN val END;
  END FmtText;

PROCEDURE <A NAME="FmtIntegerPair"><procedure>FmtIntegerPair</procedure></A> (val: IntegerPair): TEXT =
  BEGIN
    RETURN Fmt.F (&quot;&lt;a = %t, b = %t&gt;&quot;, Fmt.Int (val.a), Fmt.Int (val.b));
  END FmtIntegerPair;

PROCEDURE <A NAME="FmtIntegerTriple"><procedure>FmtIntegerTriple</procedure></A> (val: IntegerTriple): TEXT =
  BEGIN
    RETURN Fmt.F (&quot;&lt;a = %t, b = %t, c = %t&gt;&quot;, Fmt.Int (val.a),
                  Fmt.Int (val.b), Fmt.Int (val.c));
  END FmtIntegerTriple;

PROCEDURE <A NAME="FmtIntegerArray"><procedure>FmtIntegerArray</procedure></A> (READONLY val: IntegerArray): TEXT =
  VAR wr := TextWr.New ();
  BEGIN
    FOR i := 0 TO LAST (val) DO
      IF i &gt; 0 THEN Wr.PutChar (wr, ' '); END;
      Wr.PutText (wr, FmtInteger (val [i]));
    END;
    RETURN TextWr.ToText (wr);
  END FmtIntegerArray;

PROCEDURE <A NAME="FmtBooleanArray"><procedure>FmtBooleanArray</procedure></A> (READONLY val: BooleanArray): TEXT =
  VAR wr := TextWr.New ();
  BEGIN
    FOR i := 0 TO LAST (val) DO
      IF i &gt; 0 THEN Wr.PutChar (wr, ' '); END;
      Wr.PutText (wr, FmtBoolean (val [i]));
    END;
    RETURN TextWr.ToText (wr);
  END FmtBooleanArray;

PROCEDURE <A NAME="FmtCharArray"><procedure>FmtCharArray</procedure></A> (READONLY val: CharArray): TEXT =
  BEGIN
    RETURN TextOps.FromChars (val);
  END FmtCharArray;

PROCEDURE <A NAME="FmtRealArray"><procedure>FmtRealArray</procedure></A> (READONLY val: RealArray): TEXT =
  VAR wr := TextWr.New ();
  BEGIN
    FOR i := 0 TO LAST (val) DO
      IF i &gt; 0 THEN Wr.PutChar (wr, ' '); END;
      Wr.PutText (wr, FmtReal (val [i]));
    END;
    RETURN TextWr.ToText (wr);
  END FmtRealArray;

PROCEDURE <A NAME="FmtLongRealArray"><procedure>FmtLongRealArray</procedure></A> (READONLY val: LongRealArray): TEXT =
  VAR wr := TextWr.New ();
  BEGIN
    FOR i := 0 TO LAST (val) DO
      IF i &gt; 0 THEN Wr.PutChar (wr, ' '); END;
      Wr.PutText (wr, FmtLongReal (val [i]));
    END;
    RETURN TextWr.ToText (wr);
  END FmtLongRealArray;

PROCEDURE <A NAME="FmtTextArray"><procedure>FmtTextArray</procedure></A> (READONLY val: TextArray): TEXT =
  VAR wr := TextWr.New ();
  BEGIN
    FOR i := 0 TO LAST (val) DO
      IF i &gt; 0 THEN Wr.PutChar (wr, ' '); END;
      Wr.PutText (wr, FmtText (val [i]));
    END;
    RETURN TextWr.ToText (wr);
  END FmtTextArray;

PROCEDURE <A NAME="FmtIntegerArray2"><procedure>FmtIntegerArray2</procedure></A> (READONLY val: IntegerArray2): TEXT =
  VAR wr := TextWr.New ();
  BEGIN
    FOR i := 0 TO LAST (val) DO
      IF i &gt; 0 THEN Wr.PutChar (wr, '\n'); END;
      Wr.PutText (wr, FmtIntegerArray (val [i]));
    END;
    RETURN TextWr.ToText (wr);
  END FmtIntegerArray2;

PROCEDURE <A NAME="FmtBooleanArray2"><procedure>FmtBooleanArray2</procedure></A> (READONLY val: BooleanArray2): TEXT =
  VAR wr := TextWr.New ();
  BEGIN
    FOR i := 0 TO LAST (val) DO
      IF i &gt; 0 THEN Wr.PutChar (wr, '\n'); END;
      Wr.PutText (wr, FmtBooleanArray (val [i]));
    END;
    RETURN TextWr.ToText (wr);
  END FmtBooleanArray2;

PROCEDURE <A NAME="FmtCharArray2"><procedure>FmtCharArray2</procedure></A> (READONLY val: CharArray2): TEXT =
  VAR wr := TextWr.New ();
  BEGIN
    FOR i := 0 TO LAST (val) DO
      IF i &gt; 0 THEN Wr.PutChar (wr, '\n'); END;
      Wr.PutText (wr, TextOps.FromChars (val [i]));
    END;
    RETURN TextWr.ToText (wr);
  END FmtCharArray2;

PROCEDURE <A NAME="FmtRealArray2"><procedure>FmtRealArray2</procedure></A> (READONLY val: RealArray2): TEXT =
  VAR wr := TextWr.New ();
  BEGIN
    FOR i := 0 TO LAST (val) DO
      IF i &gt; 0 THEN Wr.PutChar (wr, '\n'); END;
      Wr.PutText (wr, FmtRealArray (val [i]));
    END;
    RETURN TextWr.ToText (wr);
  END FmtRealArray2;

PROCEDURE <A NAME="FmtLongRealArray2"><procedure>FmtLongRealArray2</procedure></A> (READONLY val: LongRealArray2): TEXT =
  VAR wr := TextWr.New ();
  BEGIN
    FOR i := 0 TO LAST (val) DO
      IF i &gt; 0 THEN Wr.PutChar (wr, '\n'); END;
      Wr.PutText (wr, FmtLongRealArray (val [i]));
    END;
    RETURN TextWr.ToText (wr);
  END FmtLongRealArray2;

PROCEDURE <A NAME="FmtTextArray2"><procedure>FmtTextArray2</procedure></A> (READONLY val: TextArray2): TEXT =
  VAR wr := TextWr.New ();
  BEGIN
    FOR i := 0 TO LAST (val) DO
      IF i &gt; 0 THEN Wr.PutChar (wr, '\n'); END;
      Wr.PutText (wr, FmtTextArray (val [i]));
    END;
    RETURN TextWr.ToText (wr);
  END FmtTextArray2;

PROCEDURE <A NAME="FmtIntegerPairArray"><procedure>FmtIntegerPairArray</procedure></A> (READONLY val: IntegerPairArray): TEXT =
  VAR wr := TextWr.New ();
  BEGIN
    FOR i := 0 TO LAST (val) DO
      IF i &gt; 0 THEN Wr.PutChar (wr, ' '); END;
      Wr.PutText (wr, FmtIntegerPair (val [i]));
    END;
    RETURN TextWr.ToText (wr);
  END FmtIntegerPairArray;

PROCEDURE <A NAME="FmtIntegerTripleArray"><procedure>FmtIntegerTripleArray</procedure></A> (READONLY val: IntegerTripleArray): TEXT =
  VAR wr := TextWr.New ();
  BEGIN
    FOR i := 0 TO LAST (val) DO
      IF i &gt; 0 THEN Wr.PutChar (wr, ' '); END;
      Wr.PutText (wr, FmtIntegerTriple (val [i]));
    END;
    RETURN TextWr.ToText (wr);
  END FmtIntegerTripleArray;

PROCEDURE <A NAME="FmtIntegerListArray"><procedure>FmtIntegerListArray</procedure></A> (READONLY val: IntegerListArray): TEXT =
  VAR wr := TextWr.New ();
  BEGIN
    FOR i := 0 TO LAST (val) DO
      IF i &gt; 0 THEN Wr.PutChar (wr, ' '); END;
      Wr.PutText (wr, FmtIntegerList (val [i]));
    END;
    RETURN TextWr.ToText (wr);
  END FmtIntegerListArray;

PROCEDURE <A NAME="FmtRealListArray"><procedure>FmtRealListArray</procedure></A> (READONLY val: RealListArray): TEXT =
  VAR wr := TextWr.New ();
  BEGIN
    FOR i := 0 TO LAST (val) DO
      IF i &gt; 0 THEN Wr.PutChar (wr, ' '); END;
      Wr.PutText (wr, FmtRealList (val [i]));
    END;
    RETURN TextWr.ToText (wr);
  END FmtRealListArray;

PROCEDURE <A NAME="FmtIntegerPairListArray"><procedure>FmtIntegerPairListArray</procedure></A> (READONLY val: IntegerPairListArray): TEXT =
  VAR wr := TextWr.New ();
  BEGIN
    FOR i := 0 TO LAST (val) DO
      IF i &gt; 0 THEN Wr.PutChar (wr, ' '); END;
      Wr.PutText (wr, FmtIntegerPairList (val [i]));
    END;
    RETURN TextWr.ToText (wr);
  END FmtIntegerPairListArray;

PROCEDURE <A NAME="FmtIntegerList"><procedure>FmtIntegerList</procedure></A> (val: IntegerList): TEXT =
  VAR wr := TextWr.New ();
  BEGIN
    Wr.PutChar (wr, '(');
    IF val # NIL THEN
      Wr.PutText (wr, Fmt.Int (val.i));
      val := val.next;
      WHILE val # NIL DO
        Wr.PutChar (wr, ' ');
        Wr.PutText (wr, Fmt.Int (val.i));
        val := val.next;
      END;
    END;
    Wr.PutChar (wr, ')');
    RETURN TextWr.ToText (wr);
  END FmtIntegerList;

PROCEDURE <A NAME="FmtRealList"><procedure>FmtRealList</procedure></A> (val: RealList): TEXT =
  VAR wr := TextWr.New ();
  BEGIN
    Wr.PutChar (wr, '(');
    IF val # NIL THEN
      Wr.PutText (wr, Fmt.Real (val.r));
      val := val.next;
      WHILE val # NIL DO
        Wr.PutChar (wr, ' ');
        Wr.PutText (wr, Fmt.Real (val.r));
        val := val.next;
      END;
    END;
    Wr.PutChar (wr, ')');
    RETURN TextWr.ToText (wr);
  END FmtRealList;

PROCEDURE <A NAME="FmtIntegerPairList"><procedure>FmtIntegerPairList</procedure></A> (val: IntegerPairList): TEXT =
  VAR wr := TextWr.New ();
  BEGIN
    Wr.PutChar (wr, '(');
    IF val # NIL THEN
      Wr.PutText (
        wr, Fmt.F (&quot;&lt;a = %t, b = %t&gt;&quot;, Fmt.Int (val.a), Fmt.Int (val.b)));
      val := val.next;
      WHILE val # NIL DO
        Wr.PutChar (wr, ' ');
        Wr.PutText (
          wr, Fmt.F (&quot;&lt;a = %t, b = %t&gt;&quot;, Fmt.Int (val.a), Fmt.Int (val.b)));
        val := val.next;
      END;
    END;
    Wr.PutChar (wr, ')');
    RETURN TextWr.ToText (wr);
  END FmtIntegerPairList;

PROCEDURE <A NAME="FmtIntegerTree"><procedure>FmtIntegerTree</procedure></A> (val: IntegerTree): TEXT =
  VAR wr := TextWr.New ();
  BEGIN
    IF val = NIL THEN RETURN &quot;()&quot;; END;
    FmtIntegerTree1 (wr, val);
    RETURN TextWr.ToText (wr);
  END FmtIntegerTree;

PROCEDURE <A NAME="FmtIntegerTree1"><procedure>FmtIntegerTree1</procedure></A> (wr: Wr.T; val: IntegerTree) =
  BEGIN
    Wr.PutChar (wr, '(');
    IF val.l # NIL THEN
      FmtIntegerTree1 (wr, val.l);
      Wr.PutChar (wr, ' ');
    END;
    Wr.PutText (wr, Fmt.Int (val.i));
    IF val.r # NIL THEN
      Wr.PutChar (wr, ' ');
      FmtIntegerTree1 (wr, val.r);
    END;
    Wr.PutChar (wr, ')');
  END FmtIntegerTree1;

PROCEDURE <A NAME="Stuff"><procedure>Stuff</procedure></A> (t: T; var: TEXT; text: TEXT) =
  BEGIN
    LOCK VBT.mu DO StuffL (t, var, text) END;
  END Stuff;

PROCEDURE <A NAME="StuffL"><procedure>StuffL</procedure></A> (t: T; var: TEXT; text: TEXT) =
  BEGIN
    TRY
      FormsVBT.PutText (t, Tail (var), text);
    EXCEPT
      FormsVBT.Error =&gt;
    END;
  END StuffL;

PROCEDURE <A NAME="Tail"><procedure>Tail</procedure></A> (name: TEXT): TEXT =
  BEGIN
    WITH pos = TextOps.FindCharR (name, '.') DO
      IF pos &lt; 0 THEN
        RETURN name;
      ELSE
        RETURN TextOps.Sub (name, pos + 1, LAST (CARDINAL));
      END;
    END;
  END Tail;

BEGIN
END DataView.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
