<HTML>
<HEAD>
<TITLE>SRC Modula-3: color/src/Color.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>color/src/Color.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Created by stolfi on Mon Mar 28 20:52:56 1988 </EM></BLOCKQUOTE><PRE>
</PRE> A <CODE>Color.T</CODE> describes a color as a mixture of the three color TV
   primaries (Red, Green and Blue), in a linear scale
   (proportional to luminous power), where 0.0 = black and 1.0 =
   maximum screen intensity.
<P>
   The set of all colors with RGB coordinates in the range
   0.0--1.0 is the {\em unit RGB cube}.  The colors along the
   main diagonal of the unit cube (from (0,0,0) to (1,1,1))
   contain equal amounts of all three primaries; they represent
   gray levels.  RGB triples outside the unit cube cannot be
   displayed on typical color monitors, but are still legal as
   far as this interface is concerned, make perfect physical
   sense, and are useful in some color computations. 
<P>
   This interface also provides routines to convert colors between 
   the HSV (Hue, Saturation, Value) and RGB color models. 

<P><PRE>INTERFACE <interface><A HREF="Color.m3">Color</A></interface>;

TYPE
  T = RECORD r, g, b: REAL;  END;

CONST
  (* The vertices of the unit RGB cube: *)
  Black   = T{0.0, 0.0, 0.0};
  Red     = T{1.0, 0.0, 0.0};
  Green   = T{0.0, 1.0, 0.0};
  Blue    = T{0.0, 0.0, 1.0};
  Cyan    = T{0.0, 1.0, 1.0};
  Magenta = T{1.0, 0.0, 1.0};
  Yellow  = T{1.0, 1.0, 0.0};
  White   = T{1.0, 1.0, 1.0};
</PRE> The following procedures are useful for converting a color
   into a shade of gray: 

<P><PRE>PROCEDURE <A HREF="Color.m3#Brightness">Brightness</A> (READONLY rgb: T): REAL;
</PRE><BLOCKQUOTE><EM> Return the intensity of <CODE>rgb</CODE> in a linear scale.  The formula used is
<PRE>
       0.239 * rgb.r + 0.686 * rgb.g + 0.075 * rgb.b
   </PRE>
clipped to the range 0.0--1.0. </EM></BLOCKQUOTE><PRE>
</PRE> An <CODE>HSV</CODE> is a color represented as a (Hue, Saturation,
   Value) triple.  The HSV color model is somewhat more intuitive
   than the RGB color model.  It's based on mimicking the way
   that an artist mixes paint: ``He chooses a pure hue, or
   pigment and lightens it to a {\it tint\/} of that hue by
   adding white, or darkens it to a {\it shade\/} of that hue by
   adding black, or in general obtains a {\it tone\/} of that hue
   by adding some mixture of white and black.''
<P>
   So, varying hue corresponds to selecting a pure color along a
   color wheel where 0 is red, .167 is yellow, .333 is green, .5
   is cyan, .667 is blue, and .833 is magenta, and 1.0 is red
   again.  Decreasing the saturation (from 1 down to 0)
   corresponds to adding white.  Decreasing the value (from 1
   down to 0) corresponds to adding black.
<P>
   This interface provides procedures to map between RGB and HSV
   color models.  Note that white and black have indeterminate
   hue and saturation.  Pure colors have saturation=1 and
   value=1, whereas grey levels have saturation=0,
   value=brightness, and indeterminate hue. 

<P><PRE>TYPE
  HSV = RECORD h, s, v: REAL END;
</PRE> The following procedures convert between RGB and HSV color
   models: 

<P><PRE>PROCEDURE <A HREF="Color.m3#ToHSV">ToHSV</A> (READONLY rgb: T): HSV;
</PRE><BLOCKQUOTE><EM> Convert from RGB to HSV coordinates.  By convention, gray
   colors (including white and black) get hue=0.0.  In addition,
   black gets saturation=0.0. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Color.m3#FromHSV">FromHSV</A> (READONLY hsv: HSV): T;
</PRE><BLOCKQUOTE><EM> Convert from HSV to RGB coordinates.  If value=0 (black),
   saturation and hue are irrelevant.  If saturation=0 (gray),
   hue is irrelevant. </EM></BLOCKQUOTE><PRE>

END Color.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
