<HTML>
<HEAD>
<TITLE>SRC Modula-3: color/src/Color.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>color/src/Color.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> Created by stolfi on Mon Jun  6 20:44:08 PDT 1988           

<P><PRE>MODULE <module><implements><A HREF="Color.i3">Color</A></implements></module>;

PROCEDURE <A NAME="Brightness"><procedure>Brightness</procedure></A> (READONLY rgb: T): REAL =
  BEGIN
    RETURN MIN(1.0,
              MAX(0.0, 0.239 * rgb.r + 0.686 * rgb.g + 0.075 * rgb.b))
  END Brightness;

PROCEDURE <A NAME="ToHSV"><procedure>ToHSV</procedure></A> (READONLY rgb: T): HSV =
  VAR min, max, h, s, v: REAL;
  BEGIN
    max := MAX(MAX(rgb.r, rgb.g), rgb.b);
    min := MIN(MIN(rgb.r, rgb.g), rgb.b);
    v := max;
    IF max # 0.0 THEN s := (max - min) / max ELSE s := 0.0 END;
    IF s = 0.0 THEN
      h := 0.0
    ELSE
      IF rgb.r = max THEN
        h := (rgb.g - rgb.b) / (max - min)
      ELSIF rgb.g = max THEN
        h := 2.0 + (rgb.b - rgb.r) / (max - min)
      ELSE
        h := 4.0 + (rgb.r - rgb.g) / (max - min)
      END;
      h := h / 6.0;
      IF h &lt; 0.0 THEN h := h + 1.0 END;
    END;
    RETURN HSV{h, s, v}
  END ToHSV;

PROCEDURE <A NAME="FromHSV"><procedure>FromHSV</procedure></A> (READONLY hsv: HSV): T =
  VAR
    h := hsv.h;
    s := hsv.s;
    v := hsv.v;
  BEGIN
    IF v = 0.0 THEN
      RETURN Black
    ELSIF s = 0.0 THEN
      RETURN T{v, v, v}
    ELSE
      IF h = 1.0 THEN h := 0.0 END;
      VAR
        i := TRUNC(h * 6.0);
        f := h * 6.0 - FLOAT(i);
        p := v * (1.0 - s);
        q := v * (1.0 - s * f);
        t := v * (1.0 - s * (1.0 - f));
      BEGIN
        CASE i OF
        | 0 =&gt; RETURN T{v, t, p}
        | 1 =&gt; RETURN T{q, v, p}
        | 2 =&gt; RETURN T{p, v, t}
        | 3 =&gt; RETURN T{p, q, v}
        | 4 =&gt; RETURN T{t, p, v}
        | 5 =&gt; RETURN T{v, p, q}
        ELSE &lt;* ASSERT FALSE *&gt;
        END
      END
    END
  END FromHSV;

BEGIN
END Color.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
