<HTML>
<HEAD>
<TITLE>SRC Modula-3: color/src/ColorName.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>color/src/ColorName.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Created by stolfi on Wed Apr 19 01:33:17 1989                  </EM></BLOCKQUOTE><PRE>
</PRE> The <CODE>ColorName</CODE> interface provides a standard mapping between color
   names and linear RGB triples. The implementation recognizes
   the following names, based on those found in 
   <CODE>/usr/lib/X11/rgb.txt</CODE>: 
<P>
    \begin{center}
    \begin{tt}
    \begin{tabular}{llll}
<P>
    AliceBlue         &amp; ForestGreen    &amp; MintCream         &amp; SandyBrown \\
    AntiqueWhite \dag &amp; Gainsboro      &amp; MistyRose \dag    &amp; SeaGreen \dag \\
    Aquamarine \dag   &amp; GhostWhite     &amp; Moccasin          &amp; Seashell \dag \\
    Azure \dag        &amp; Gold \dag      &amp; NavajoWhite \dag  &amp; Sienna \dag \\
    Beige             &amp; Goldenrod \dag &amp; Navy              &amp; SkyBlue \dag \\
    Bisque            &amp; GoldenrodYellow&amp; NavyBlue          &amp; SlateBlue \dag \\
    Black             &amp; Gray \ddag     &amp; OldLace           &amp; SlateGray \dag \\
    BlanchedAlmond    &amp; Green \dag     &amp; OliveDrab \dag    &amp; SlateGrey \\
    Blue \dag         &amp; GreenYellow    &amp; OliveGreen \dag   &amp; Snow \dag \\
    BlueViolet        &amp; Grey \ddag     &amp; Orange \dag       &amp; SpringGreen\dag \\
    Brown \dag        &amp; Honeydew \dag  &amp; OrangeRed \dag    &amp; SteelBlue \dag \\
    Burlywood \dag    &amp; HotPink \dag   &amp; Orchid \dag       &amp; Tan \dag \\
    CadetBlue \dag    &amp; IndianRed \dag &amp; PapayaWhip        &amp; Thistle \dag \\
    Chartreuse \dag   &amp; Ivory \dag     &amp; PeachPuff \dag    &amp; Tomato \dag \\
    Chocolate \dag    &amp; Khaki \dag     &amp; Peru              &amp; Turquoise \dag \\
    Coral \dag        &amp; Lavender       &amp; Pink \dag         &amp; Violet \\
    CornflowerBlue    &amp; LavenderBlush \dag &amp; Plum \dag     &amp; VioletRed \dag \\
    Cornsilk \dag     &amp; LawnGreen          &amp; Powderblue    &amp; Wheat \dag \\
    Cyan \dag         &amp; LemonChiffon \dag  &amp; Purple \dag   &amp; White \\
    DeepPink \dag     &amp; LimeGreen          &amp; Red \dag      &amp; WhiteSmoke \\
    DeepSkyBlue \dag  &amp; Linen              &amp; RosyBrown\dag &amp; Yellow \dag \\
    DodgerBlue \dag   &amp; Magenta \dag       &amp; Royalblue\dag &amp; YellowGreen \\
    Firebrick \dag    &amp; Maroon \dag        &amp; SaddleBrown \\
    FloralWhite       &amp; MidnightBlue       &amp; Salmon \dag \\
<P>
    \end{tabular}
    \end{tt}
    \end{center}
<P>
    The dagger (\dag) indicates that the implementation recognizes
    a name along with the suffixes <CODE>1</CODE>--<CODE>4</CODE>; e.g., <CODE>Red</CODE>, <CODE>Red1</CODE>, <CODE>Red2</CODE>,
    <CODE>Red3</CODE>, and <CODE>Red4</CODE>.
    <P>
   The double dagger (\ddag) indicates that the 
   implementation also recognizes the names with the 
   suffixes <CODE>0</CODE> through <CODE>100</CODE>. That is, <CODE>Gray0</CODE>, <CODE>Gray1</CODE>, \dots,
   <CODE>Gray100</CODE>, as well as <CODE>Grey0</CODE>, <CODE>Grey1</CODE>, \dots, <CODE>Grey100</CODE>.
   <P>
   In addition, the name of a color $C$ from this list
   can be prefixed by one or more of the following modifiers:
<P>
<P>
\begin{center}
\begin{tabular}{l|l}
% 
  \it Term &amp; \it Meaning\\ \hline
<P>
  \strut\begin{tabular}[c]{l} 
  <CODE>Light</CODE> \\ 
  <CODE>Pale</CODE> 
  \end{tabular} 
    &amp;  1/3 of the way from $C$ to white \\ \hline
<P>
  \strut\begin{tabular}[c]{l} 
  <CODE>Dark</CODE> \\ 
  <CODE>Dim</CODE> 
  \end{tabular} 
    &amp;  1/3 of the way from $C$ to black \\ \hline
<P>
  \strut\begin{tabular}[c]{l} 
  <CODE>Drab</CODE> \\ 
  <CODE>Weak</CODE> \\ 
  <CODE>Dull</CODE> 
  \end{tabular} 
    &amp; $\vcenter{\hbox{ 1/3 of the way from $C$ to the gray\strut}
               \hbox{with the same brightness as $C$\strut}}$ \\ \hline
<P>
  \strut\begin{tabular}[c]{l} 
  <CODE>Vivid</CODE> \\ 
  <CODE>Strong</CODE> \\ 
  <CODE>Bright</CODE> 
  \end{tabular} 
    &amp; $\vcenter{\hbox{1/3 of the way from $C$ to the purest color\strut}
               \hbox{with the same hue as $C$\strut}}$ \\ \hline
<P>
  \strut\begin{tabular}[c]{l} 
  <CODE>Reddish</CODE> 
  \end{tabular}  
     &amp;  1/3 of the way from $C$ to red \\ \hline
<P>
  \strut\begin{tabular}[c]{l} 
  <CODE>Greenish</CODE> 
  \end{tabular}  
    &amp;  1/3 of the way from $C$ to green \\ \hline
<P>
  \strut\begin{tabular}[c]{l} 
  <CODE>Bluish</CODE> 
  \end{tabular}  
    &amp;  1/3 of the way from $C$ to blue \\ \hline
<P>
  \strut\begin{tabular}[c]{l} 
  <CODE>Yellowish</CODE> 
  \end{tabular}  
    &amp;  1/3 of the way from $C$ to yellow \\
%
\end{tabular}
\end{center}
<P>
   prefixes, which replace ``1/3 of the way'' by the indicated fraction:
<P>
   \begin{center}
   \begin{tabular}{l|l|l}
      \it Term             &amp; \it Degree        &amp; \it\% (approx.) \\ \hline
      <CODE>VeryVerySlightly</CODE>   &amp; 1/16 of the way   &amp;  6\% \\
      <CODE>VerySlightly</CODE>       &amp; 1/8 of the way    &amp; 13\% \\
      <CODE>Slightly</CODE>           &amp; 1/4 of the way    &amp; 25\% \\
      <CODE>Somewhat</CODE>           &amp; 3/8 of the way    &amp; 38\% \\ 
      <CODE>Rather</CODE>             &amp; 1/2 of the way    &amp; 50\% \\ 
      <CODE>Quite</CODE>              &amp; 5/8 of the way    &amp; 63\% \\
      <CODE>Very</CODE>               &amp; 3/4 of the way    &amp; 75\% \\
      <CODE>VeryVery</CODE>           &amp; 7/8 of the way    &amp; 88\% \\
      <CODE>VeryVeryVery</CODE>       &amp; 15/16 of the way  &amp; 94\% \\
   \end{tabular}
   \end{center}
<P>
   \noindent The modifier <CODE>Medium</CODE> is also recognized as a
   shorthand for <CODE>SlightlyDark</CODE>. (But you cannot use <CODE>VeryMedium</CODE>.)
<P>


<P><PRE>INTERFACE <interface><A HREF="ColorName.m3">ColorName</A></interface>;

IMPORT <A HREF="Color.i3">Color</A>, <A HREF="../../libm3/derived/TextList.i3">TextList</A>;

EXCEPTION NotFound;

PROCEDURE <A HREF="ColorName.m3#ToRGB">ToRGB</A> (name: TEXT): Color.T RAISES {NotFound};
</PRE><BLOCKQUOTE><EM> Give the <CODE>RGB.T</CODE> value described by <CODE>name</CODE>, ignoring case and
   whitespace.  A cache of unnormalized names is maintained, so
   this procedure should be pretty fast for repeated lookups of
   the same name. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ColorName.m3#NameList">NameList</A> (): TextList.T;
</PRE><BLOCKQUOTE><EM> Return a list of all the ``basic'' (unmodified) color names known
   to this module, as lower-case <CODE>TEXT</CODE>s, in alphabetical order. </EM></BLOCKQUOTE><PRE>

END ColorName.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
