<HTML>
<HEAD>
<TITLE>SRC Modula-3: color/src/ColorName.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>color/src/ColorName.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> Created by stolfi on Wed Apr 19 01:48:27 1989               

<P>
<P>
<P><PRE>MODULE <module>ColorName</module> EXPORTS <A HREF="ColorName.i3"><implements>ColorName</A></implements>, <A HREF="ColorNameF.i3"><implements>ColorNameF</A></implements>;

IMPORT <A HREF="Color.i3">Color</A>, <A HREF="../../etext/src/ISOChar.i3">ISOChar</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../text/src/TextF.i3">TextF</A>, <A HREF="../../libm3/derived/TextList.i3">TextList</A>, <A HREF="../../libm3/derived/TextListSort.i3">TextListSort</A>, <A HREF="../../libm3/derived/TextIntTbl.i3">TextIntTbl</A>,
       <A HREF="../../libm3/derived/TextRefTbl.i3">TextRefTbl</A>;

FROM <A HREF="ColorNameTable.i3">ColorNameTable</A> IMPORT Basic;

TYPE
  FrEntry = RECORD name: TEXT; val: REAL END;
  (* Entry of fraction table *)

CONST Fraction = ARRAY OF FrEntry{

    (* Fraction prefixes: *)
    (* Note: if A is a prefix of B, then A must come after B. *)
    (* Also the last prefix must be &quot;&quot; *)

    FrEntry {name := &quot;VeryVeryVery&quot;,     val := 15.0 / 16.0},
    FrEntry {name := &quot;VeryVerySlightly&quot;, val := 1.0 / 16.0 },
    FrEntry {name := &quot;VeryVery&quot;,         val := 7.0 / 8.0  },
    FrEntry {name := &quot;VerySlightly&quot;,     val := 1.0 / 8.0  },
    FrEntry {name := &quot;Very&quot;,             val := 3.0 / 4.0  },
    FrEntry {name := &quot;Slightly&quot;,         val := 1.0 / 4.0  },
    FrEntry {name := &quot;Somewhat&quot;,         val := 3.0 / 8.0  },
    FrEntry {name := &quot;Quite&quot;,            val := 5.0 / 8.0  },
    FrEntry {name := &quot;Rather&quot;,           val := 1.0 / 2.0  },
    FrEntry {name := &quot;&quot;,                 val := 1.0 / 3.0  }
  };

PROCEDURE <A NAME="IsPrefix"><procedure>IsPrefix</procedure></A> (a, b: TEXT; VAR (*OUT*) rest: TEXT): BOOLEAN =
  (*
    If /a/ is a prefix of /b/ (ignoring case), return TRUE and put rest
    of /b/ in /rest/.  Else return false and leave /rest/alone.  *)
  BEGIN
    &lt;* ASSERT a # NIL *&gt;
    &lt;* ASSERT b # NIL *&gt;
    WITH aa = a^,
         bb = b^  DO
      IF NUMBER (aa) &lt;= 1 THEN
        rest := b;
        RETURN TRUE
      ELSIF NUMBER (bb) &lt; NUMBER (aa) THEN
        RETURN FALSE
      ELSE
        FOR i := 0 TO LAST (aa) - 1 DO
          IF ISOChar.Lower [aa [i]] # ISOChar.Lower [bb [i]] THEN RETURN FALSE END
        END;
        rest := Text.FromChars (
                  SUBARRAY (bb, NUMBER (aa) - 1, NUMBER (bb) - NUMBER (aa)));
        RETURN TRUE
      END
    END
  END IsPrefix;

PROCEDURE <A NAME="NormalizeName"><procedure>NormalizeName</procedure></A> (a: TEXT): TEXT =
  (* Deletes all whitespace in /a/ and converts to lower case *)
  VAR
    b := NEW (REF ARRAY OF CHAR, Text.Length (a));
    j := 0;
  BEGIN
    IF NUMBER (b^) &gt; 0 THEN
      FOR i := 0 TO LAST (a^) - 1 DO
        IF NOT a [i] IN ISOChar.Spaces THEN
          b [j] := ISOChar.Lower [a [i]];
          INC (j)
        END
      END
    END;
    RETURN Text.FromChars (SUBARRAY (b^, 0, j))
  END NormalizeName;

PROCEDURE <A NAME="ToRGB"><procedure>ToRGB</procedure></A> (name: TEXT): Color.T RAISES {NotFound} =
  VAR
    value : REFANY;
    rgb   : Color.T;
    rgbRef: REF Color.T;
  PROCEDURE fail (&lt;* UNUSED *&gt; name: TEXT): Color.T RAISES {NotFound} =
    BEGIN
      RAISE NotFound
    END fail;
  BEGIN
    LOCK nameCache DO
      IF nameCache.table.get (name, value) THEN
        RETURN NARROW (value, REF Color.T)^
      END
    END;
    WITH normalized = NormalizeName (name) DO
      rgb := LowerCaseToRGB (normalized, fail)
    END;
    LOCK nameCache DO
      rgbRef := NEW (REF Color.T);
      rgbRef^ := rgb;
      EVAL nameCache.table.put (name, rgbRef);
    END;
    RETURN rgb
  END ToRGB;

PROCEDURE <A NAME="LowerCaseToRGB"><procedure>LowerCaseToRGB</procedure></A> (name: TEXT; p: NotInTable): Color.T
  RAISES {NotFound} =
  VAR
    f         : CARDINAL;
    index     : INTEGER;
    y, frac   : REAL;
    rgb       : Color.T;
    hsv       : Color.HSV;
    bare, rest: TEXT;
  BEGIN
    (* Strips fraction modifier: *)
    f := 0;
    WHILE NOT IsPrefix (Fraction [f].name, name, rest) DO INC (f) END;
    frac := Fraction [f].val;
    bare := rest;
    (* Strips color modifier: *)
    IF IsPrefix (&quot;dark&quot;, bare, rest) OR IsPrefix (&quot;dim&quot;, bare, rest) THEN
      rgb := LowerCaseToRGB (rest, p);
      RETURN Mix (Color.Black, frac, rgb, 1.0 - frac)

    ELSIF IsPrefix (&quot;pale&quot;, bare, rest) OR IsPrefix (&quot;light&quot;, bare, rest) THEN
      rgb := LowerCaseToRGB (rest, p);
      RETURN Mix (Color.White, frac, rgb, 1.0 - frac)

    ELSIF IsPrefix (&quot;medium&quot;, bare, rest) THEN
      (* There must be no fraction modifier: *)
      IF NOT Text.Equal (bare, name) THEN RAISE NotFound END;
      frac := 0.25;
      rgb := LowerCaseToRGB (rest, p);
      RETURN Mix (Color.Black, frac, rgb, 1.0 - frac)

    ELSIF IsPrefix (&quot;reddish&quot;, bare, rest) THEN
      rgb := LowerCaseToRGB (rest, p);
      RETURN Mix (Color.Red, frac, rgb, 1.0 - frac)

    ELSIF IsPrefix (&quot;greenish&quot;, bare, rest) THEN
      rgb := LowerCaseToRGB (rest, p);
      RETURN Mix (Color.Green, frac, rgb, 1.0 - frac)

    ELSIF IsPrefix (&quot;bluish&quot;, bare, rest) THEN
      rgb := LowerCaseToRGB (rest, p);
      RETURN Mix (Color.Blue, frac, rgb, 1.0 - frac)

    ELSIF IsPrefix (&quot;yellowish&quot;, bare, rest) THEN
      rgb := LowerCaseToRGB (rest, p);
      RETURN Mix (Color.Yellow, frac, rgb, 1.0 - frac)

    ELSIF IsPrefix (&quot;drab&quot;, bare, rest) OR IsPrefix (&quot;dull&quot;, bare, rest)
            OR IsPrefix (&quot;weak&quot;, bare, rest) THEN
      rgb := LowerCaseToRGB (rest, p);
      y := Color.Brightness (rgb);
      RETURN Mix (Color.T {y, y, y}, frac, rgb, 1.0 - frac)

    ELSIF IsPrefix (&quot;strong&quot;, bare, rest) OR IsPrefix (&quot;vivid&quot;, bare, rest)
            OR IsPrefix (&quot;bright&quot;, bare, rest) THEN
      rgb := LowerCaseToRGB (rest, p);
      hsv := Color.HSV {Color.ToHSV (rgb).h, 1.0, 1.0};
      RETURN Mix (Color.FromHSV (hsv), frac, rgb, 1.0 - frac)

    ELSE
      (* No color modifier -- there must be no fraction modifier: *)
      IF NOT Text.Equal (bare, name) THEN RAISE NotFound END;
      IF NOT table.get (name, index) THEN
        RETURN p (name)
      ELSE
        RETURN Basic [index].rgb
      END
    END
  END LowerCaseToRGB;

PROCEDURE <A NAME="Mix"><procedure>Mix</procedure></A> (READONLY a    : Color.T;
                        alpha: REAL;
               READONLY b    : Color.T;
                        beta : REAL   ): Color.T =
  BEGIN
    RETURN Color.T{r := alpha * a.r + beta * b.r, g :=
                 alpha * a.g + beta * b.g, b :=
                 alpha * a.b + beta * b.b}
  END Mix;

PROCEDURE <A NAME="NameList"><procedure>NameList</procedure></A> (): TextList.T =
  VAR list: TextList.T := NIL;
  BEGIN
    FOR i := FIRST (Basic) TO LAST (Basic) DO
      list := TextList.Cons (Basic [i].name, list);
    END;
    RETURN TextListSort.SortD (list)
  END NameList;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> () =
  BEGIN
    nameCache := NEW (Cache, table := NEW (TextRefTbl.Default).init (16));
    table := NEW (TextIntTbl.Default).init (NUMBER (Basic));
    FOR i := 0 TO LAST (Basic) DO
      IF table.put (NormalizeName (Basic [i].name), i) THEN
        (* ignore duplicates (case-variants) *)
      END;
    END
  END Init;

BEGIN
  Init ();
  &lt;* ASSERT Text.Empty (Fraction [LAST (Fraction)].name) *&gt;
END ColorName.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
