<HTML>
<HEAD>
<TITLE>SRC Modula-3: convert/src/Convert.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>convert/src/Convert.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                            </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="Convert.m3">Convert</A></interface>;
</PRE> Binary/ASCII conversions of numbers.
<P>
   This interface provides binary/ASCII conversions for
   INTEGERs, REALs and LONGREALs.
<P>
   Index: conversion;  numbers;  ASCII 

<P><PRE>TYPE
  Buffer = ARRAY OF CHAR;
  Base   = [2..16];

TYPE
  Style  = {Flo, AltFlo, Sci, AltSci, Mix};
  (* formatting styles for REALs:
         Flo:       xxx.yyy
         AltFlo:    xxx.yyy             (trailing zeros are suppressed)
         Sci:       xxx.yyy'E'exponent  ('D' for LONGREAL)
         AltSci:    xxx.yyy'E'exponent  (trailing zeros are suppressed)
         Mix:       == AltFlo unles AltSci is shorter;  if AltFlow is
                       selected and there are no zeros after the decimal
                       point, the decimal point is suppressed.
  *)

EXCEPTION Failed;
</PRE>---- Binary to ASCII conversions ----

<P> The <CODE>From</CODE> procedures convert binary values to ASCII character strings.
   Each procedure returns the number characters that resulted.  Extra
   space in the buffers is left unmodified.  Failed is raised if the
   supplied buffer is too small to hold the result. 

<P><PRE>PROCEDURE <A HREF="Convert.m3#FromInt">FromInt</A> (VAR buf    : Buffer;
                       value  : INTEGER;
                       base   : Base := 10;
                       prefix : BOOLEAN := FALSE): INTEGER RAISES {Failed};
</PRE><BLOCKQUOTE><EM> converts value to ASCII in the specified base and stores the result in buf.
   If prefix=TRUE, include the base prefix in the result. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Convert.m3#FromUnsigned">FromUnsigned</A> (VAR buf    : Buffer;
                            value  : INTEGER;
                            base   : Base := 10;
                            prefix : BOOLEAN := FALSE): INTEGER RAISES{Failed};
</PRE><BLOCKQUOTE><EM> treats value as an unsigned 32-bit number, converts it to ASCII in the
   specified base and stores the result in buf.  If prefix=TRUE, include
   the base prefix in the result. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Convert.m3#FromFloat">FromFloat</A> (VAR buf       : Buffer;
                         value     : REAL;
                         precision : INTEGER := 6;
                         style     := Style.Mix): INTEGER   RAISES {Failed};
</PRE><BLOCKQUOTE><EM> converts value to ASCII in the given style and stores the result in buf.
   The precision is the number of fractional digits.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Convert.m3#FromLongFloat">FromLongFloat</A> (VAR buf   : Buffer;
                         value     : LONGREAL;
                         precision : INTEGER := 6;
                         style     := Style.Mix): INTEGER   RAISES {Failed};
</PRE><BLOCKQUOTE><EM> converts value to ASCII in the given style and stores the result in buf.
   The precision is the number of fractional digits.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Convert.m3#FromExtended">FromExtended</A> (VAR buf   : Buffer;
                        value     : EXTENDED;
                        precision : INTEGER := 6;
                        style     := Style.Mix): INTEGER   RAISES {Failed};
</PRE><BLOCKQUOTE><EM> converts value to ASCII in the given style and stores the result in buf.
   The precision is the number of fractional digits.  </EM></BLOCKQUOTE><PRE>
</PRE>---- ASCII to binary conversions ---

<P> The <CODE>To</CODE> procedures convert ASCII character strings to their
   corresponding binary representations.  The procedures convert
   the maximum number of characters possible.  The number of characters
   actually used is returned in 'used'.  

<P><PRE>PROCEDURE <A HREF="Convert.m3#ToInt">ToInt</A> (READONLY buf  : Buffer;
                      VAR used : INTEGER;
                          base : Base := 10): INTEGER   RAISES {};
</PRE><BLOCKQUOTE><EM> converts an integer.  The characters are interpreted in the specified
   base unless an explicit base prefix is in the number. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Convert.m3#ToUnsigned">ToUnsigned</A> (READONLY buf  : Buffer;
                           VAR used : INTEGER;
                               base : Base := 10): INTEGER  RAISES {};
</PRE><BLOCKQUOTE><EM> converts an unsigned number. The characters are interpreted in the specified
   base unless an explicit base prefix is in the number. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Convert.m3#ToFloat">ToFloat</A> (READONLY buf  : Buffer;
                        VAR used : INTEGER): REAL  RAISES {Failed};
</PRE><BLOCKQUOTE><EM> converts a floating point number. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Convert.m3#ToLongFloat">ToLongFloat</A> (READONLY buf  : Buffer;
                        VAR used : INTEGER): LONGREAL  RAISES {Failed};
</PRE><BLOCKQUOTE><EM> converts a floating point number. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Convert.m3#ToExtended">ToExtended</A> (READONLY buf  : Buffer;
                      VAR used : INTEGER): EXTENDED  RAISES {Failed};
</PRE><BLOCKQUOTE><EM> converts a floating point number. </EM></BLOCKQUOTE><PRE>

END Convert.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
