<HTML>
<HEAD>
<TITLE>SRC Modula-3: dps/src/DPS.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>dps/src/DPS.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="DPS.m3">DPS</A></interface>;

IMPORT <A HREF="Fifo.i3">Fifo</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;

TYPE Button = { Left, Middle, Right };

TYPE Modifier = { Shift, Lock, Ctrl, Option };
TYPE Modifiers = SET OF Modifier;

TYPE ClickType = { FirstDown, OthersDown, Dragging, LastUp };
</PRE> TYPE XEvent = { XExpose, XButtonPress, XButtonRelease }; 

<P><PRE>CONST FullWidth = 1024; FullHeight = 1024;

CONST StandardFontPoints = 20.0;
</PRE><BLOCKQUOTE><EM> It boggles the mind, but <CODE>16.0</CODE>, above gives a PostScript. </EM></BLOCKQUOTE><PRE>
</PRE> complaint about the BuittonDLEDrawRoundedPath macro. <CODE>14.0</CODE> is OK. 

<P><PRE>EXCEPTION BadPostScript (TEXT);

TYPE Place = RECORD x, y: REAL; END;
CONST ZeroPlace = Place {0.0, 0.0};

TYPE Box = RECORD low, high: Place; END;
CONST ZeroBox = Box { Place{0.0,0.0}, Place{0.0,0.0} };
CONST EverywhereBox = Box { Place{-999999.0,-999999.0}, Place{999999.0,999999.0} };

TYPE FixedPoint = { nw, n, ne, w, c, e, sw, s, se };

TYPE MouseEvent = RECORD
  whatChanged: Button;
  place: Place;
  modifiers: Modifiers;
  clickType: ClickType;
  END;

TYPE KeyEvent = RECORD
  key: INTEGER;  (* Raw. See CharFromKey. *)
  modifiers: Modifiers;
  clickType: ClickType;
  END;

TYPE T = OBJECT
  (* Change with caution. Congruent definition in ccDisplayPS.c! *)
  dpy: INTEGER := 0; win: INTEGER := 0; fd: INTEGER := 0;
  ctx: INTEGER := 0; gc: INTEGER := 0; cursor: INTEGER := 0;
  xWidth: INTEGER; xHeight: INTEGER;
  ctm: ARRAY [0..5] OF REAL; (* Current transform via GetTransformWrap. *)
  invctm: ARRAY [0..5] OF REAL; (* Current transform via GetTransformWrap. *)
  xoffset: INTEGER; yoffset: INTEGER; (* Current via GetTransformWrap. *)
  planes: INTEGER := 255;
  desiredWidth: REAL := 0.0; desiredHeight: REAL := 0.0;
  yTranslationNeeded: REAL := 0.0;
  foundationList: REF ARRAY OF TEXT := NIL;
  backgroundTransformation: TEXT := &quot;&quot;;
  backgroundTransformationMaintainsSimilarity: BOOLEAN := TRUE;
  backgroundTransformationScaler: REAL := StandardFontPoints;
  (* ^^ Stepped by 1.0. *)
  currentTransformation: TEXT := &quot;&quot;;
  specialWriter: Wr.T := NIL;
  dirtyFifo: Fifo.T;
  alwaysNervous: BOOLEAN := FALSE;
 METHODS
  Create ( width, height: INTEGER := 600;
   color: BOOLEAN := TRUE; over: T := NIL ) := Create;
  Paint (box: Box; only: REFANY); (* Only via clean-dirty-stuff thread. *)
  Dirty (box: Box; only: REFANY) := Dirty;
  Mouse (event: MouseEvent): BOOLEAN;
  Char (char: CHAR): BOOLEAN;
  Key (event: KeyEvent);
  Send ( text: TEXT; regardlessOfCircumstance: BOOLEAN := FALSE;
   alreadyLocked: BOOLEAN := FALSE ) RAISES {BadPostScript}:= Send;
  SendClientTransformation (text: TEXT) := SendClientTransformation;
  SendFoundation (text: TEXT) := SendFoundation;
  SendSpecialFoundation (text: TEXT) := SendSpecialFoundation;
  UnsendFoundation (text: TEXT) := UnsendFoundation;
  Flush () := Flush;
  KillInputFocus () := KillInputFocus;
  END;

PROCEDURE <A HREF="DPS.m3#GSaveAndClip">GSaveAndClip</A> (box: Box): TEXT;
PROCEDURE <A HREF="DPS.m3#GSaveAndClipIf">GSaveAndClipIf</A> (box, containee: Box): TEXT;
PROCEDURE <A HREF="DPS.m3#GRestore">GRestore</A> (): TEXT;

PROCEDURE <A HREF="DPS.m3#NewPathBox">NewPathBox</A> (box: Box): TEXT;
PROCEDURE <A HREF="DPS.m3#BoxCoordsAsText">BoxCoordsAsText</A> (box: Box): TEXT;

PROCEDURE <A HREF="DPS.m3#BoxAlter">BoxAlter</A> (b: Box; fp: FixedPoint; w, h: REAL := -1.0): Box;

PROCEDURE <A HREF="DPS.m3#BoxesIntersect">BoxesIntersect</A> (b1, b2: Box): BOOLEAN;
PROCEDURE <A HREF="DPS.m3#ContainerContainee">ContainerContainee</A> (b1, b2: Box): BOOLEAN;
PROCEDURE <A HREF="DPS.m3#PlaceIsInBox">PlaceIsInBox</A> (p: Place; b: Box): BOOLEAN;
PROCEDURE <A HREF="DPS.m3#EdgedBoxClipAndPaint">EdgedBoxClipAndPaint</A> (box: Box; hue: REAL := -1.0): TEXT; (* Hue &lt; 0.0 =&gt; Grays. *)

PROCEDURE <A HREF="DPS.m3#EscapeText">EscapeText</A> (text: TEXT): TEXT; (* Fixes parens etc. for show. *)

PROCEDURE <A HREF="DPS.m3#IsAccent">IsAccent</A> (char: CHAR): BOOLEAN;
PROCEDURE <A HREF="DPS.m3#ContainsAccent">ContainsAccent</A> (text: TEXT): BOOLEAN;

PROCEDURE <A HREF="DPS.m3#ShowItAccentedPostScript">ShowItAccentedPostScript</A> (text: TEXT): TEXT;

PROCEDURE <A HREF="DPS.m3#PreferredFontName">PreferredFontName</A> (): TEXT;
PROCEDURE <A HREF="DPS.m3#SetPreferredFontName">SetPreferredFontName</A> (name: TEXT);

PROCEDURE <A HREF="DPS.m3#MeasureText">MeasureText</A> ( text: TEXT; window: T; fontName: TEXT;
 accentsHaveWidth: BOOLEAN := FALSE ): REF ARRAY OF REAL;
</PRE><BLOCKQUOTE><EM> Returns array of character widths. </EM></BLOCKQUOTE><PRE>
PROCEDURE <A HREF="DPS.m3#MeasureChar">MeasureChar</A> ( char: CHAR; window: T; fontName: TEXT;
 accentsHaveWidth: BOOLEAN := FALSE ): REAL;
PROCEDURE <A HREF="DPS.m3#TextWidth">TextWidth</A> ( text: TEXT; window: T; fontName: TEXT;
 accentsHaveWidth: BOOLEAN := FALSE ): REAL;

PROCEDURE <A HREF="DPS.m3#BoxUnion">BoxUnion</A> (b1, b2: Box): Box;

PROCEDURE <A HREF="DPS.m3#CharFromKey">CharFromKey</A> (key: INTEGER; modifiers: Modifiers): CHAR;

PROCEDURE <A HREF="DPS.m3#Create">Create</A> (t: T; width, height: INTEGER := 600; color: BOOLEAN := TRUE; over: T := NIL);

PROCEDURE <A HREF="DPS.m3#Dirty">Dirty</A> (t: T; box: Box; only: REFANY);

PROCEDURE <A HREF="DPS.m3#Send">Send</A> ( t: T; text: TEXT;
 regardlessOfCircumstance: BOOLEAN := FALSE;
 alreadyLocked: BOOLEAN := FALSE ) RAISES {BadPostScript};

PROCEDURE <A HREF="DPS.m3#SendNervously">SendNervously</A> ( t: T; text: TEXT;
 regardlessOfCircumstance: BOOLEAN := FALSE;
 alreadyLocked: BOOLEAN := FALSE ) RAISES {BadPostScript};

PROCEDURE <A HREF="DPS.m3#AcquireDPSMutex">AcquireDPSMutex</A> (); (* Used by wrap procedures. *)
PROCEDURE <A HREF="DPS.m3#ReleaseDPSMutex">ReleaseDPSMutex</A> ();

PROCEDURE <A HREF="DPS.m3#SendClientTransformation">SendClientTransformation</A> (t: T; text: TEXT);
PROCEDURE <A HREF="DPS.m3#SendFoundation">SendFoundation</A> (t: T; text: TEXT);
PROCEDURE <A HREF="DPS.m3#SendSpecialFoundation">SendSpecialFoundation</A> (t: T; text: TEXT);
PROCEDURE <A HREF="DPS.m3#UnsendFoundation">UnsendFoundation</A> (t: T; text: TEXT);

PROCEDURE <A HREF="DPS.m3#Flush">Flush</A> (t: T);
</PRE><BLOCKQUOTE><EM> Any thread that paints and can block should call Flush before blocking. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="DPS.m3#KillInputFocus">KillInputFocus</A> (t: T); (* Any existing focus is lost. *)
</PRE><BLOCKQUOTE><EM> And nothing remembered: can't get focus back <CODE>at the same place.</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="DPS.m3#PostscriptToWriter">PostscriptToWriter</A> (t: T; wr: Wr.T);
PROCEDURE <A HREF="DPS.m3#PostscriptToText">PostscriptToText</A> (t: T): TEXT;

PROCEDURE <A HREF="DPS.m3#PlaceToStderr">PlaceToStderr</A> (pre: TEXT; place: Place);
PROCEDURE <A HREF="DPS.m3#BoxToStderr">BoxToStderr</A> (pre: TEXT; box: Box);

  END DPS.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
