<HTML>
<HEAD>
<TITLE>SRC Modula-3: dps/src/Linked2List.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>dps/src/Linked2List.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="Linked2Tree.i3">Linked2Tree</A></implements></module>;

IMPORT <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (t: T) =
  BEGIN
  t.firstChild := NIL;
  t.lastChild := NIL;
  t.monitor := Thread.NewMutex();
  END Init;

PROCEDURE <A NAME="Prepend"><procedure>Prepend</procedure></A> (t: T; e: T) =
  BEGIN
  LOCK t.monitor DO PrependWhileLocked (t, e); END;
  END Prepend;

PROCEDURE <A NAME="PrependWhileLocked"><procedure>PrependWhileLocked</procedure></A> (t: T; e: T) =
  BEGIN
  &lt;* ASSERT (e.parent = NIL) *&gt;  e.parent := t;
  IF t.firstChild=NIL THEN
    t.firstChild := e; t.lastChild := e;
    e.nextSibling := NIL; e.previousSibling := NIL;
   ELSE
    t.firstChild.previousSibling := e; e.next := t.firstChild;
    e.previousSibling := NIL; t.firstChild := e;
    END;
  END PrependWhileLocked;

PROCEDURE <A NAME="Append"><procedure>Append</procedure></A> (t: T; e: T) =
  BEGIN
  LOCK t.monitor DO AppendWhileLocked (t, e); END;
  END Append;

PROCEDURE <A NAME="AppendWhileLocked"><procedure>AppendWhileLocked</procedure></A> (t: T; e: T) =
  BEGIN
  &lt;* ASSERT (e.parent = NIL) *&gt;  e.parent := t;
  IF t.first=NIL THEN
    t.firstChild := e; t.lastChild := e;
    e.nextSibling := NIL; e.previousSibling := NIL;
   ELSE
    t.last.nextSibling := e; e.previousSibling := t.lastChild;
    e.next := NIL; t.lastChild := e;
    END;
  END AppendWhileLocked;

PROCEDURE <A NAME="Remove"><procedure>Remove</procedure></A> (t: T; e: T) =
  BEGIN
  LOCK t.monitor DO RemoveWhileLocked (t, e); END;
  END Remove;

PROCEDURE <A NAME="RemoveWhileLocked"><procedure>RemoveWhileLocked</procedure></A> (t: T; e: T) =
 VAR done: BOOLEAN;
 VAR past: E;
  BEGIN
  e.parent := NIL;
  done := FALSE;
  IF t.firstChild=e THEN
    t.firstChild := e.next;
    IF t.firstChild#NIL THEN t.firstChild.previousSibling := NIL; END;
    done := TRUE;
    END;
  IF t.lastChild=e THEN
    t.lastChild := e.previousSibling;
    IF t.lastChild#NIL THEN t.lastChild.nextSibling := NIL; END;
    done := TRUE;
    END;
  IF NOT done THEN
    past := e.next;
    e.next.previousSibling := e.previousSibling;
    e.previousSibling.next := past;
    END;
  END RemoveWhileLocked;

PROCEDURE <A NAME="First"><procedure>First</procedure></A> (t: T): E =
  BEGIN
  LOCK t.monitor DO RETURN t.firstChild; END;
  END First;

PROCEDURE <A NAME="Next"><procedure>Next</procedure></A> (t: T; e: E): E =
  BEGIN
  LOCK t.monitor DO RETURN e.nextSibling; END;
  END Next;

PROCEDURE <A NAME="Last"><procedure>Last</procedure></A> (t: T): E =
  BEGIN
  LOCK t.monitor DO RETURN t.lastChild; END;
  END Last;

PROCEDURE <A NAME="Previous"><procedure>Previous</procedure></A> (t: T; e: E): E =
  BEGIN
  LOCK t.monitor DO RETURN e.previousSibling; END;
  END Previous;

PROCEDURE <A NAME="InternalMoveToFirst"><procedure>InternalMoveToFirst</procedure></A> (t: T; e: E): BOOLEAN =
  BEGIN
  LOCK t.monitor DO
    IF e = t.first THEN RETURN FALSE; END;
    RemoveWhileLocked (t, e);
    PrependWhileLocked (t, e);
    RETURN TRUE;
    END;
  END InternalMoveToFirst;

PROCEDURE <A NAME="InternalMoveToLast"><procedure>InternalMoveToLast</procedure></A> (t: T; e: T): BOOLEAN =
  BEGIN
  LOCK t.monitor DO
    IF e = t.last THEN RETURN FALSE; END;
    RemoveWhileLocked (t, e);
    AppendWhileLocked (t, e);
    RETURN TRUE;
    END;
  END InternalMoveToLast;

PROCEDURE <A NAME="MoveToFirst"><procedure>MoveToFirst</procedure></A> (e: T): BOOLEAN =
  BEGIN
  RETURN InternalMoveToFirst(e.parent, e);
  END MoveToFirst;

PROCEDURE <A NAME="MoveToLast"><procedure>MoveToLast</procedure></A> (e: T): BOOLEAN =
  BEGIN
  RETURN InternalMoveToLast(e.parent, e);
  END MoveToLast;

  BEGIN

  END Linked2List.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
