<HTML>
<HEAD>
<TITLE>SRC Modula-3: dps/src/Linked2Tree.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>dps/src/Linked2Tree.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="Linked2Tree.i3">Linked2Tree</A></implements></module>;

PROCEDURE <A NAME="Prepend"><procedure>Prepend</procedure></A> (t: T; e: E) =
  BEGIN
  LOCK t DO PrependWhileLocked (t, e); END;
  END Prepend;

PROCEDURE <A NAME="PrependWhileLocked"><procedure>PrependWhileLocked</procedure></A> (t: T; e: E) =
  BEGIN
  &lt;* ASSERT (e.parent = NIL) *&gt;  e.parent := t;
  IF t.firstChild=NIL THEN
    t.firstChild := e; t.lastChild := e;
    e.nextSibling := NIL; e.previousSibling := NIL;
   ELSE
    t.firstChild.previousSibling := e; e.nextSibling := t.firstChild;
    e.previousSibling := NIL; t.firstChild := e;
    END;
  END PrependWhileLocked;

PROCEDURE <A NAME="Append"><procedure>Append</procedure></A> (t: T; e: E) =
  BEGIN
  LOCK t DO AppendWhileLocked (t, e); END;
  END Append;

PROCEDURE <A NAME="AppendWhileLocked"><procedure>AppendWhileLocked</procedure></A> (t: T; e: E) =
  BEGIN
  &lt;* ASSERT (e.parent = NIL) *&gt;  e.parent := t;
  IF t.firstChild=NIL THEN
    t.firstChild := e; t.lastChild := e;
    e.nextSibling := NIL; e.previousSibling := NIL;
   ELSE
    t.lastChild.nextSibling := e; e.previousSibling := t.lastChild;
    e.nextSibling := NIL; t.lastChild := e;
    END;
  END AppendWhileLocked;

PROCEDURE <A NAME="InsertBefore"><procedure>InsertBefore</procedure></A> (t: T; e, before: E) =
  BEGIN
  LOCK t DO InsertBeforeWhileLocked (t, e, before); END;
  END InsertBefore;

PROCEDURE <A NAME="InsertBeforeWhileLocked"><procedure>InsertBeforeWhileLocked</procedure></A> (t: T; e, before: E) =
  BEGIN
  IF before = NIL THEN AppendWhileLocked (t, e); RETURN; END;
  &lt;* ASSERT (before.parent = t) *&gt;
  IF before.previousSibling=NIL THEN PrependWhileLocked (t, e); RETURN; END;
  &lt;* ASSERT (e.parent = NIL) *&gt;  e.parent := t;
  before.previousSibling.nextSibling := e;
  e.previousSibling := before.previousSibling; e.nextSibling := before;
  before.previousSibling := e;
  END InsertBeforeWhileLocked;

PROCEDURE <A NAME="InsertAfter"><procedure>InsertAfter</procedure></A> (t: T; e, after: E) =
  BEGIN
  LOCK t DO InsertAfterWhileLocked (t, e, after); END;
  END InsertAfter;

PROCEDURE <A NAME="InsertAfterWhileLocked"><procedure>InsertAfterWhileLocked</procedure></A> (t: T; e, after: E) =
  BEGIN
  IF after = NIL THEN AppendWhileLocked (t, e); RETURN; END;
  &lt;* ASSERT (after.parent = t) *&gt;
  IF after.nextSibling=NIL THEN AppendWhileLocked (t, e); RETURN; END;
  &lt;* ASSERT (e.parent = NIL) *&gt;  e.parent := t;
  after.nextSibling.previousSibling := e;
  e.previousSibling := after; e.nextSibling := after.nextSibling;
  after.nextSibling := e;
  END InsertAfterWhileLocked;

PROCEDURE <A NAME="Remove"><procedure>Remove</procedure></A> (e: E) =
 VAR t: T;
  BEGIN
  t := e.parent;
  t.RemoveChild (e);
  END Remove;

PROCEDURE <A NAME="RemoveChild"><procedure>RemoveChild</procedure></A> (t: T; e: E) =
  BEGIN
  RemoveInternal (t, e);
  END RemoveChild;

PROCEDURE <A NAME="RemoveInternal"><procedure>RemoveInternal</procedure></A> (t: T; e: E) =
  BEGIN
  LOCK t DO RemoveWhileLocked (t, e); END;
  END RemoveInternal;

PROCEDURE <A NAME="RemoveWhileLocked"><procedure>RemoveWhileLocked</procedure></A> (t: T; e: E) =
 VAR done: BOOLEAN;
 VAR past: E;
  BEGIN
  e.parent := NIL;
  done := FALSE;
  IF t.firstChild=e THEN
    t.firstChild := e.nextSibling;
    IF t.firstChild#NIL THEN t.firstChild.previousSibling := NIL; END;
    done := TRUE;
    END;
  IF t.lastChild=e THEN
    t.lastChild := e.previousSibling;
    IF t.lastChild#NIL THEN t.lastChild.nextSibling := NIL; END;
    done := TRUE;
    END;
  IF NOT done THEN
    past := e.nextSibling;
    e.nextSibling.previousSibling := e.previousSibling;
    e.previousSibling.nextSibling := past;
    END;
  END RemoveWhileLocked;

PROCEDURE <A NAME="First"><procedure>First</procedure></A> (t: T): E =
  BEGIN
  LOCK t DO RETURN t.firstChild; END;
  END First;

PROCEDURE <A NAME="Next"><procedure>Next</procedure></A> (e: E): E =
  BEGIN (* Should lock e.parent? *)
  LOCK e DO RETURN e.nextSibling; END;
  END Next;

PROCEDURE <A NAME="Last"><procedure>Last</procedure></A> (t: T): E =
  BEGIN
  LOCK t DO RETURN t.lastChild; END;
  END Last;

PROCEDURE <A NAME="Previous"><procedure>Previous</procedure></A> (e: E): E =
  BEGIN (* Should lock e.parent? *)
  LOCK e DO RETURN e.previousSibling; END;
  END Previous;

PROCEDURE <A NAME="InternalMoveToFirst"><procedure>InternalMoveToFirst</procedure></A> (t: T; e: E): E =
 BEGIN
  LOCK t DO
    IF e = t.firstChild THEN RETURN NIL; END;
    RemoveWhileLocked (t, e);
    PrependWhileLocked (t, e);
    RETURN e.parent; (* Hmmm. *)
    END;
  END InternalMoveToFirst;

PROCEDURE <A NAME="InternalMoveToLast"><procedure>InternalMoveToLast</procedure></A> (t: T; e: E): E =
  BEGIN
  LOCK t DO
    IF e = t.lastChild THEN RETURN NIL; END;
    RemoveWhileLocked (t, e);
    AppendWhileLocked (t, e);
    RETURN e;
    END;
  END InternalMoveToLast;

PROCEDURE <A NAME="MoveToFirst"><procedure>MoveToFirst</procedure></A> (e: E): E =
 VAR p: T;
  BEGIN
  p := e.parent;
  IF p=NIL THEN RETURN NIL; ELSE RETURN p.MakeChildFirst(e); END;
  END MoveToFirst;

PROCEDURE <A NAME="MakeChildFirst"><procedure>MakeChildFirst</procedure></A> (t: T; e: E): E =
  BEGIN
  RETURN InternalMoveToFirst(t, e);
  END MakeChildFirst;

PROCEDURE <A NAME="MoveToLast"><procedure>MoveToLast</procedure></A> (e: E): E =
 VAR p: T;
  BEGIN
  p := e.parent;
  IF p=NIL THEN RETURN NIL; ELSE RETURN p.MakeChildLast(e); END;
  END MoveToLast;

PROCEDURE <A NAME="MakeChildLast"><procedure>MakeChildLast</procedure></A> (t: T; e: E): E =
  BEGIN
  RETURN InternalMoveToLast(t, e);
  END MakeChildLast;

  BEGIN

  END Linked2Tree.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
