<HTML>
<HEAD>
<TITLE>SRC Modula-3: dps/src/OneSlideDLE.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>dps/src/OneSlideDLE.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="OneSlideDLE.i3">OneSlideDLE</A></implements></module>;

IMPORT <A HREF="DisplayList.i3">DisplayList</A>, <A HREF="DisplayListStack.i3">DisplayListStack</A>, <A HREF="DPS.i3">DPS</A>, <A HREF="DPSWindow.i3">DPSWindow</A>, <A HREF="../../rw/src/Common/FileWr.i3">FileWr</A>,
 <A HREF="Linked2Tree.i3">Linked2Tree</A>, <A HREF="PopupMenuDLE.i3">PopupMenuDLE</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="SlideLineDLE.i3">SlideLineDLE</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>,
 <A HREF="../../rw/src/Common/TextRd.i3">TextRd</A>, <A HREF="../../rw/src/Common/TextWr.i3">TextWr</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="TranslateDLE.i3">TranslateDLE</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>;

CONST AllowTranslation = TRUE;

CONST millisecond = 0.001d0;
CONST second      = 1.0d0;

CONST pointsDefault = 24.0;
CONST aboveLeadingDefault = 8.0;
CONST heightDefault = pointsDefault;
CONST belowLeadingDefault = 0.0;
</PRE><BLOCKQUOTE><EM> CONST lowLeadingDefault = 0.0; </EM></BLOCKQUOTE><PRE>
CONST leftLeadingDefault = 24.0;

CONST pointsDefaultTop = 30.0;
CONST aboveLeadingDefaultTop = 8.0;
CONST heightDefaultTop = pointsDefaultTop;
CONST belowLeadingDefaultTop = 16.0;
CONST leftLeadingDefaultTop = 0.0;

CONST TopMargin = 32.0;
CONST LeftMarginOfLines = 60.0; (* Alas has to factor in the boilerplate. *)
</PRE> CONST ItemsInitiallyVisible = 1;  Cannot be zero. Need to start stack. 

<P><PRE>CONST DecorationMarginLeft = 20.0;
CONST DecorationMarginRight = 20.0;
CONST DecorationMarginTop = 20.0;
CONST DecorationMarginBottom = 40.0;
</PRE><BLOCKQUOTE><EM> ^^ Because bottom of screen hard to see. </EM></BLOCKQUOTE><PRE>

CONST backgroundPostScript =
&quot; 20.0 ButtonDLEDrawRoundedPath 6.0 setlinewidth 0.5 0.5 0.5 setrgbcolor stroke &quot;;

PROCEDURE <A NAME="BoxFromXYWH"><procedure>BoxFromXYWH</procedure></A> (x, y: REAL; w, h: REAL := 0.0): DPS.Box =
 VAR box: DPS.Box;
  BEGIN
  box.low.x := x; box.high.x := x + w;
  box.low.y := y; box.high.y := y + h;
  RETURN box;
  END BoxFromXYWH;

PROCEDURE <A NAME="Repaint"><procedure>Repaint</procedure></A> (t: T; box: DPS.Box; only: REFANY): TEXT =
 VAR bkgBox: DPS.Box;
  BEGIN
  bkgBox.low.x := t.box.low.x + DecorationMarginLeft;
  bkgBox.high.x := t.box.high.x - DecorationMarginRight;
  bkgBox.low.y := t.box.low.y + DecorationMarginBottom;
  bkgBox.high.y := t.box.high.y - DecorationMarginTop;
  RETURN
    DPS.GSaveAndClip(box)
    &amp; &quot; gsave &quot;
    &amp; DPS.BoxCoordsAsText (bkgBox) &amp; &quot; 20.0 ButtonDLEDrawRoundedPath clip &quot;
    &amp; DisplayList.Repaint (t, box, only)
    &amp; &quot; grestore &quot;
    &amp; DPS.BoxCoordsAsText (bkgBox) &amp; backgroundPostScript
    &amp; DPS.GRestore();
    END Repaint;

PROCEDURE <A NAME="Clip"><procedure>Clip</procedure></A> (e: E; text: TEXT): TEXT =
 VAR bkgBox: DPS.Box;
  BEGIN
  bkgBox.low.x := e.box.low.x + DecorationMarginLeft;
  bkgBox.high.x := e.box.high.x - DecorationMarginRight;
  bkgBox.low.y := e.box.low.y + DecorationMarginBottom;
  bkgBox.high.y := e.box.high.y - DecorationMarginTop;
  RETURN
    &quot; gsave &quot;
    &amp; DPS.BoxCoordsAsText (bkgBox) &amp; &quot; 20.0 ButtonDLEDrawRoundedPath clip &quot;
    &amp; text
    &amp; &quot; grestore &quot;;
    END Clip;

PROCEDURE <A NAME="PostScriptToParentClipped"><procedure>PostScriptToParentClipped</procedure></A> (e: E; script: TEXT) =
 VAR p: DisplayList.T;
  BEGIN
  p := e.parent;
  IF p # NIL THEN
    p.ImmediatePostScript (Clip (e, script));
    END;
  END PostScriptToParentClipped;

PROCEDURE <A NAME="DirtyToParentClipped"><procedure>DirtyToParentClipped</procedure></A> (e: E; box: DPS.Box; only: DisplayList.T := NIL) =
 VAR p: DisplayList.T;
  BEGIN
  p := e.parent;
  IF p # NIL THEN
    p.Dirty (box, only);
    END;
  END DirtyToParentClipped;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (t: T; window: DPSWindow.T; content: Rd.T := NIL) =
  BEGIN
  IF t.initialized THEN RETURN; END;

  (* Later compute based on content: *)
  t.box.low.y := t.box.high.y - t.maximumHeight;

  t.window := window; (* Used in capturing PostSCript. *)
  t.backgroundPopup := NEW ( PopupMenuDLE.T,
   items := NEW (REF ARRAY OF PopupMenuDLE.Item, 5) );
  t.backgroundPopup.items^[0] := NEW ( PopupMenuDLE.Item,
    text := &quot;All Invisible&quot;, Proc := AllInvisiblePop, context := t );
  t.backgroundPopup.items^[1] := NEW ( PopupMenuDLE.Item,
    text := &quot;Next Visible&quot;, Proc := NextVisiblePop, context := t );
  t.backgroundPopup.items^[2] := NEW (PopupMenuDLE.Item,
    text := &quot;All Visible&quot;, Proc := AllVisiblePop, context := t);
  t.backgroundPopup.items^[3] := NEW (PopupMenuDLE.Item,
    text := &quot;Toggle Mouse -&gt; Child&quot;, Proc := ToggleMouseChildPop, context := t);
  t.backgroundPopup.items^[4] := NEW (PopupMenuDLE.Item,
    text := &quot;PostScript -&gt; /tmp/slide.ps&quot;, Proc := PSPop, context := t);
  t.initialized := TRUE;

  window.SendFoundation ( &quot; /ButtonDLEDrawRoundedPath &quot;
   &amp; &quot; { /r exch def /highy exch def /highx exch def &quot;
   &amp; &quot; /lowy exch def /lowx exch def &quot;
   &amp; &quot; newpath lowx lowy r add moveto &quot;
   &amp; &quot; lowx r add highy r sub r 180 90 arcn &quot;
   &amp; &quot; highx r sub highy r sub r 90 0 arcn &quot;
   &amp; &quot; highx r sub lowy r add r 0 270 arcn &quot;
   &amp; &quot; lowx r add lowy r add r 270 180 arcn &quot;
   &amp; &quot;  closepath } def &quot; );

  IF content # NIL THEN AddContent (t, window, content); END;
  END Init;

PROCEDURE <A NAME="RdDotGetLine"><procedure>RdDotGetLine</procedure></A> (r: Rd.T): TEXT RAISES {Rd.EndOfFile} =
</PRE><BLOCKQUOTE><EM> Rd.GetLine is buggy.  21aug91 </EM></BLOCKQUOTE><PRE>
 &lt;*FATAL Rd.Failure, Thread.Alerted*&gt;
 VAR c: CHAR;
 VAR line: TEXT := &quot;&quot;;
  BEGIN
  c := Rd.GetChar(r); (* Initial EOF propogates. *)
  IF c = '\n' THEN RETURN line; END;
  line := line &amp; Text.FromChar (c);
  WHILE NOT Rd.EOF(r) DO
    c := Rd.GetChar(r);
    IF c = '\n' THEN RETURN line; END;
    line := line &amp; Text.FromChar (c);
    END;
  RETURN line;
  END RdDotGetLine;

PROCEDURE <A NAME="AddContent"><procedure>AddContent</procedure></A> ( t: T; window: DPSWindow.T; data: Rd.T ) =
 VAR sle: SlideLineDLE.E;
 VAR line: TEXT;
 VAR itemIndex: INTEGER := 0;
 VAR invisible, newInvisible: BOOLEAN := FALSE;
 VAR xlate: TranslateDLE.T;
 VAR appendTo: DisplayList.T;
  BEGIN
  Init (t, window);
  t.fixed := NEW (DisplayList.T);
  t.visible := NEW ( DisplayListStack.T,
    MakeChildFirst := MakeChildFirstNOP, MakeChildLast := MakeChildLastNOP );
  t.invisible := NEW (Linked2Tree.T);
  IF AllowTranslation THEN
    xlate := NEW ( TranslateDLE.T,
      translationX := 0.0, translationY := 0.0,
      fixedX := TRUE,
      onlyIfShifted := FALSE );
    Linked2Tree.Append (t, xlate);
    appendTo := xlate;
   ELSE appendTo := t;
    END;
  Linked2Tree.Append (appendTo, t.fixed);
  Linked2Tree.Append (appendTo, t.visible);
  LOOP
    TRY
      line := RdDotGetLine (data);
      IF Text.Equal (&quot;/invisible&quot;, Text.Sub(line,0,10)) THEN
        invisible := TRUE;
        newInvisible := TRUE;
        IF sle # NIL THEN sle.togetherWithNext := FALSE; END;
       ELSIF Text.Equal (&quot;/half&quot;, Text.Sub(line,0,5)) THEN
        sle := NEW ( SlideLineDLE.E,
         box := BoxFromXYWH (LeftMarginOfLines, 0.0, 0.0, 0.0),
         typefacePoints := pointsDefault,
         aboveLeading := aboveLeadingDefault,
         height := heightDefault / 2.0,
         belowLeading := belowLeadingDefault,
         leftLeading := leftLeadingDefault,
         text := &quot; &quot;,
         togetherWithNext := TRUE );
        newInvisible := FALSE;
        SlideLineDLE.Init (sle, window);
        IF NOT invisible THEN t.visible.Append (sle);
         ELSE t.invisible.Append (sle);
          END;
        INC (itemIndex);
       ELSIF itemIndex &lt; 1 THEN
        sle := NEW ( SlideLineDLE.E,
         box := BoxFromXYWH (LeftMarginOfLines, 0.0, 0.0, 0.0),
         typefacePoints := pointsDefaultTop,
         aboveLeading := aboveLeadingDefaultTop,
         height := heightDefaultTop,
         belowLeading := belowLeadingDefaultTop,
         leftLeading := leftLeadingDefaultTop,
         text := ConvertOctals(line),
         togetherWithNext := TRUE );
        newInvisible := FALSE;
        SlideLineDLE.Init (sle, window);
        IF NOT invisible THEN t.visible.Append (sle);
         ELSE t.invisible.Append (sle);
          END;
        INC (itemIndex);
       ELSE
        sle := NEW ( SlideLineDLE.E,
         box := BoxFromXYWH (LeftMarginOfLines, 0.0, 0.0, 0.0),
         typefacePoints := pointsDefault,
         aboveLeading := aboveLeadingDefault,
         height := heightDefault,
         belowLeading := belowLeadingDefault,
         leftLeading := leftLeadingDefault,
         text := ConvertOctals(line),
         togetherWithNext := TRUE );
        newInvisible := FALSE;
        SlideLineDLE.Init (sle, window);
        IF NOT invisible THEN t.visible.Append (sle);
         ELSE t.invisible.Append (sle);
          END;
        INC (itemIndex);
        END;
     EXCEPT Rd.EndOfFile =&gt; EXIT;
      END;
    END;
  t.visible.Stack (t.box.high.y - TopMargin - pointsDefault);
  END AddContent;

PROCEDURE <A NAME="ConvertOctals"><procedure>ConvertOctals</procedure></A> (t: TEXT): TEXT =
 &lt;*FATAL Rd.Failure, Wr.Failure, Thread.Alerted*&gt;
 VAR j: INTEGER;
 VAR rd: Rd.T;
 VAR wr: Wr.T;
 VAR c, o1, o2, o3: CHAR;
  BEGIN
  j := Text.FindChar (t,'\\');
  rd := TextRd.New (t);
  wr := TextWr.New();
  LOOP
    TRY
      c := Rd.GetChar (rd);
      IF  c = '\\' THEN
        o1 := Rd.GetChar (rd);
        o2 := Rd.GetChar (rd);
        o3 := Rd.GetChar (rd);
        j := (ORD(o1)-48) * 64 + (ORD(o2)-48) * 8 + (ORD(o3)-48);
        j := MIN (j, 255); j := MAX (0, j);
        c := VAL (j, CHAR);
        END;
      Wr.PutChar (wr, c);
     EXCEPT Rd.EndOfFile =&gt; RETURN TextWr.ToText(wr);
      END;
    END;
  END ConvertOctals;

PROCEDURE <A NAME="Prepend"><procedure>Prepend</procedure></A> (t: T; e: Linked2Tree.E) =
  BEGIN
  Init (t, NIL);
  t.fixed.Prepend (e);
  END Prepend;

PROCEDURE <A NAME="Append"><procedure>Append</procedure></A> (t: T; e: Linked2Tree.E) =
  BEGIN
  Init (t, NIL);
  AppendVariable (t, e);
  END Append;

PROCEDURE <A NAME="AppendFixed"><procedure>AppendFixed</procedure></A> (t: T; e: Linked2Tree.E) =
  BEGIN
  Init (t, NIL);
  t.fixed.Append (e);
  END AppendFixed;

PROCEDURE <A NAME="AppendVariable"><procedure>AppendVariable</procedure></A> (t: T; e: Linked2Tree.E) =
  BEGIN
  t.visible.Append (e);
  t.visible.Stack (t.box.high.y - TopMargin - pointsDefault);
  END AppendVariable;

PROCEDURE <A NAME="InsertBefore"><procedure>InsertBefore</procedure></A> (t: T; e, before: Linked2Tree.E) =
  BEGIN
  Init (t, NIL);
  t.visible.InsertBefore (e, before);
  END InsertBefore;

PROCEDURE <A NAME="InsertAfter"><procedure>InsertAfter</procedure></A> (t: T; e, after: Linked2Tree.E) =
  BEGIN
  Init (t, NIL);
  t.visible.InsertAfter (e, after);
  END InsertAfter;

PROCEDURE <A NAME="PSPop"><procedure>PSPop</procedure></A> (p: PopupMenuDLE.Item) =
 &lt;*FATAL OSError.E, Wr.Failure, Thread.Alerted*&gt;
 VAR t: T;
 VAR wr: Wr.T;
  BEGIN
  t := NARROW (p.context, T);
  wr := FileWr.Open (&quot;/tmp/slide.ps&quot;);
  Wr.PutText (wr, &quot;%!IPS-Adobe-1.0\n&quot;);
  Wr.PutText (wr, &quot;%%Creator: Postscript Button in SlideX\n&quot;);
  Wr.PutText (wr, &quot;%%Title: Client Slides\n&quot;);
  Wr.PutText (wr, &quot;%%EndComments\n&quot;);
  Wr.PutText (wr, &quot;%%EndProlog\n\n&quot;);
  AllVisible (t);
  DPS.PostscriptToWriter (t.window, wr);
  Wr.PutText (wr, &quot;\nshowpage\n\n&quot;);
  Wr.PutText (wr, &quot;%%Trailer\n\n&quot;);
  Wr.Close(wr);
  END PSPop;

PROCEDURE <A NAME="ToggleMouseChildPop"><procedure>ToggleMouseChildPop</procedure></A> (p: PopupMenuDLE.Item) =
 VAR t: T;
  BEGIN
  t := NARROW (p.context, T);
  t.canMouseChildren := NOT t.canMouseChildren;
  END ToggleMouseChildPop;

PROCEDURE <A NAME="AllInvisiblePop"><procedure>AllInvisiblePop</procedure></A> (p: PopupMenuDLE.Item) =
  BEGIN
  AllInvisible (NARROW(p.context, T));
  END AllInvisiblePop;

PROCEDURE <A NAME="NextVisiblePop"><procedure>NextVisiblePop</procedure></A> (p: PopupMenuDLE.Item) =
  BEGIN
  NextVisible (NARROW(p.context, T));
  END NextVisiblePop;

PROCEDURE <A NAME="AllVisiblePop"><procedure>AllVisiblePop</procedure></A> (p: PopupMenuDLE.Item) =
  BEGIN
  AllVisible (NARROW(p.context, T));
  END AllVisiblePop;

PROCEDURE <A NAME="AllInvisible"><procedure>AllInvisible</procedure></A> (t: T) =
 VAR cur: DisplayList.E;
  BEGIN
  t.LoseInputFocus();
  (* Have to kill input focus of anything moving to invisible list. *)
  LOOP
    cur := t.visible.First();
    IF cur = NIL THEN EXIT; END;
    cur.Remove ();
    t.invisible.Append (cur);
    END;
  t.Dirty (t.box, NIL);
  END AllInvisible;

PROCEDURE <A NAME="NextVisible"><procedure>NextVisible</procedure></A> (t: T) =
 VAR cur: DisplayList.E;
  BEGIN
  LOOP
    cur := t.invisible.First();
    IF cur = NIL THEN RETURN; END;
    cur.Remove ();
    t.visible.Append (cur);
    TYPECASE cur OF
    | SlideLineDLE.E (sle) =&gt;
      Reappear (sle);
      IF NOT sle.togetherWithNext THEN EXIT; END;
     ELSE cur.Dirty (cur.box, cur); EXIT;
      END;
    END;
  END NextVisible;

PROCEDURE <A NAME="NextSomething"><procedure>NextSomething</procedure></A> (t: T): BOOLEAN =
  BEGIN
  IF t.invisible.First() # NIL THEN NextVisible (t); RETURN TRUE;
   ELSE RETURN FALSE;
    END;
  END NextSomething;

PROCEDURE <A NAME="AllVisible"><procedure>AllVisible</procedure></A> (t: T) =
 VAR cur: DisplayList.E;
  BEGIN
  LOOP
    cur := t.invisible.First();
    IF cur = NIL THEN RETURN; END;
    cur.Remove ();
    t.visible.Append (cur);
    TYPECASE cur OF
    | SlideLineDLE.E (sle) =&gt; Reappear (sle);
     ELSE cur.Dirty (cur.box, cur);
      END;
    END;
  END AllVisible;

PROCEDURE <A NAME="NthVisible"><procedure>NthVisible</procedure></A> (t: T; n: INTEGER): DisplayList.T =
 VAR cur: DisplayList.E;
  BEGIN
  cur := t.visible.First();
  WHILE n &gt; 0 DO
    IF cur = NIL THEN RETURN NIL; END;
    cur := cur.Next();
    DEC (n);
    END;
  RETURN cur;
  END NthVisible;

TYPE RepaintClosure = Thread.Closure OBJECT item: SlideLineDLE.E; END;

PROCEDURE <A NAME="RepaintNormallyAFterPause"><procedure>RepaintNormallyAFterPause</procedure></A> (rc: RepaintClosure): REFANY RAISES {} =
  BEGIN
  Thread.Pause (2.0d0 * second);
  rc.item.Dirty (rc.item.box, rc.item);
  RETURN NIL;
  END RepaintNormallyAFterPause;

PROCEDURE <A NAME="Reappear"><procedure>Reappear</procedure></A> (item: SlideLineDLE.E) =
 CONST wait = 100.0d0 * millisecond;
 CONST delta = 0.167;
 VAR r, g, b: REAL;
 VAR ps: TEXT;
  PROCEDURE DownRed () =
    BEGIN
    r := MAX (0.0, r - delta);
    item.ImmediatePostScript ( &quot; &quot;
     &amp; Fmt.Real(r) &amp; &quot; &quot; &amp; Fmt.Real(g)
     &amp; &quot; &quot; &amp; Fmt.Real(b) &amp; &quot; setrgbcolor &quot; &amp; ps );
    Thread.Pause (wait);
    END DownRed;
  PROCEDURE DownGB () =
    BEGIN
    g := MAX (0.0, g - delta);
    b := MAX (0.0, b - delta);
    item.ImmediatePostScript ( &quot; &quot;
     &amp; Fmt.Real(r) &amp; &quot; &quot; &amp; Fmt.Real(g)
     &amp; &quot; &quot; &amp; Fmt.Real(b) &amp; &quot; setrgbcolor &quot; &amp; ps );
    Thread.Pause (wait);
    END DownGB;
  BEGIN
  ps :=  item.Repaint (item.box, item);
  (* May not really be on top, but we lie in the Dirty/Repaint calls. *)
  (* If really obscured, the repaints would look ugly any way. *)
  r := 1.0; g := 1.0; b := 1.0;
  WHILE g &gt; 0.0 DO DownGB(); END;
  WHILE r &gt; 0.0 DO DownRed(); END;
  item.ImmediatePostScript ( &quot; 0.0 0.0 0.0 setrgbcolor &quot; );
  (*
  EVAL Thread.Fork (
   NEW ( RepaintClosure,
    apply := RepaintNormallyAFterPause,
    item := item ) );
  *)
END Reappear;

PROCEDURE <A NAME="MakeChildFirst"><procedure>MakeChildFirst</procedure></A> (&lt;*UNUSED*&gt; t: T;
                          &lt;*UNUSED*&gt; e: Linked2Tree.E): Linked2Tree.E =
  BEGIN
  RETURN NIL;
  (* RETURN Linked2Tree.MakeChildFirst (t.visible, e); *)
  END MakeChildFirst;

PROCEDURE <A NAME="MakeChildLast"><procedure>MakeChildLast</procedure></A> (&lt;*UNUSED*&gt; t: T;
                         &lt;*UNUSED*&gt; e: Linked2Tree.E): Linked2Tree.E =
  BEGIN
  RETURN NIL;
  (* RETURN Linked2Tree.MakeChildLast (t.visible, e); *)
  END MakeChildLast;

PROCEDURE <A NAME="MakeChildFirstNOP"><procedure>MakeChildFirstNOP</procedure></A> (&lt;*UNUSED*&gt; t: Linked2Tree.T;
                             &lt;*UNUSED*&gt; e: Linked2Tree.E): Linked2Tree.E =
  BEGIN
  RETURN NIL;
  END MakeChildFirstNOP;

PROCEDURE <A NAME="MakeChildLastNOP"><procedure>MakeChildLastNOP</procedure></A> (&lt;*UNUSED*&gt; t: Linked2Tree.T;
                            &lt;*UNUSED*&gt; e: Linked2Tree.E): Linked2Tree.E =
  BEGIN
  RETURN NIL;
  END MakeChildLastNOP;

PROCEDURE <A NAME="Mouse"><procedure>Mouse</procedure></A> (t: T; window: DPSWindow.T; event: DPS.MouseEvent): BOOLEAN =
 VAR e: DisplayList.E;
  BEGIN
  Init (t, window);

  CASE event.whatChanged OF
  | DPS.Button.Left =&gt;
    IF event.clickType=DPS.ClickType.FirstDown THEN t.GetInputFocus (); END;
  | DPS.Button.Middle =&gt;
  | DPS.Button.Right =&gt;
    END; (* of CASE *)

  IF (event.whatChanged = DPS.Button.Right) (* For imbedded translator. *)
   OR t.canMouseChildren THEN
    e := t.Last();
    WHILE e # NIL DO
      IF e.Mouse (window, event) THEN RETURN TRUE; END;
      e := e.Previous();
      END;
    END;

  IF event.clickType # DPS.ClickType.FirstDown THEN RETURN FALSE; END;

  (* Used to allow user to highlight by pointing. *)
  (* But that &quot;cheated&quot; by looking at boxes of children, *)
  (* which may be bogus due to intermediate translation. *)

  CASE event.whatChanged OF
  | DPS.Button.Left =&gt;
  | DPS.Button.Middle =&gt; t.backgroundPopup.Popup (event.place, window);
  | DPS.Button.Right =&gt;
    END; (* of CASE *)

  RETURN TRUE;
  END Mouse;

PROCEDURE <A NAME="ShortHighlight"><procedure>ShortHighlight</procedure></A> (sle: SlideLineDLE.E) =
 VAR ps: TEXT;
  BEGIN
  ps :=  sle.Repaint (sle.box, sle);
  sle.ImmediatePostScript ( &quot; 1.0 0.0 0.0 setrgbcolor &quot; &amp; ps );
  sle.ImmediatePostScript ( &quot; 0.0 0.0 0.0 setrgbcolor &quot; );
  EVAL Thread.Fork (
   NEW ( RepaintClosure,
    apply := RepaintNormallyAFterPause,
    item := sle ) );
  END ShortHighlight;

PROCEDURE <A NAME="MaybeShortHighlight"><procedure>MaybeShortHighlight</procedure></A> (e: DisplayList.E) =
  BEGIN
  IF e # NIL THEN
    TYPECASE e OF SlideLineDLE.E(sle) =&gt; ShortHighlight (sle);
     ELSE
      END;
    END;
  END MaybeShortHighlight;

PROCEDURE <A NAME="Char"><procedure>Char</procedure></A> (e: E; window: DPSWindow.T; char: CHAR): BOOLEAN =
 VAR ee: DisplayList.E;
  BEGIN
  Init (e, window);
  ee := e.childWithInputFocus;
  IF ee # NIL THEN RETURN ee.Char (window, char); END;
  CASE char OF
  | ' ' =&gt;  RETURN NextSomething (e);
  | 'i' =&gt;  AllInvisible (e);
  | 'v' =&gt;  NextVisible (e);
  | 'a' =&gt;  AllVisible (e);
  | '1' =&gt;  MaybeShortHighlight ( NthVisible (e, 0) );
  | '2' =&gt;  MaybeShortHighlight ( NthVisible (e, 1) );
  | '3' =&gt;  MaybeShortHighlight ( NthVisible (e, 2) );
  | '4' =&gt;  MaybeShortHighlight ( NthVisible (e, 3) );
  | '5' =&gt;  MaybeShortHighlight ( NthVisible (e, 4) );
  | '6' =&gt;  MaybeShortHighlight ( NthVisible (e, 5) );
  | '7' =&gt;  MaybeShortHighlight ( NthVisible (e, 6) );
  | '8' =&gt;  MaybeShortHighlight ( NthVisible (e, 7) );
  | '9' =&gt;  MaybeShortHighlight ( NthVisible (e, 8) );
   ELSE RETURN FALSE;
    END; (* of CASE *)
  RETURN TRUE;
  END Char;
</PRE>********
PROCEDURE Key (t: T; window: DPSWindow.T; event: DPS.KeyEvent) =
 VAR got: CHAR;
 VAR e: DisplayList.E;
  BEGIN
  Init (t, window);
  got := DPS.CharFromKey (event.key, event.modifiers);
  IF got = '\000' THEN RETURN; END;
  e := t.Last();
  WHILE e # NIL DO 
    IF e.Char (window, got) THEN RETURN; END; 
    e := e.Previous(); 
    END;
  Err.Msg (<CODE>Ignored Keystroke = </CODE>, Text.FromChar(got), <CODE>.</CODE>);
  END Key;
*********

<P>  <PRE>BEGIN

  END OneSlideDLE.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
