<HTML>
<HEAD>
<TITLE>SRC Modula-3: dps/src/PopupButtonDLE.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>dps/src/PopupButtonDLE.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="PopupButtonDLE.m3">PopupButtonDLE</A></interface>;
</PRE>  A PopupButtonDLE.T is a subclass of a DisplayList.T. (And
    similarly for a PopupButtonDLE.E.)
<P>
    The PopupButtonDLE.T normally paints itself as a <CODE>button</CODE>
    shape, displaying its text field.
<P>
    If the button is moused, then a popup list of commands is
    additionally displayed.  The command list is an array of
    PopupButtonDLE.Item; each Item has a text value and a Proc
    method.
<P>
    If the user lets the mouse button up while over an Item, the Proc
    method of the item is called.
<P>
    Appropriate visual feedback is provided as the mosue is moved. 

<P><PRE>IMPORT <A HREF="DisplayList.i3">DisplayList</A>, <A HREF="DPS.i3">DPS</A>, <A HREF="DPSWindow.i3">DPSWindow</A>;

TYPE Item = OBJECT
  text: TEXT := &quot;&quot;;
  textPlace: DPS.Place; hot: BOOLEAN := FALSE;
 METHODS
  Proc ();
  END;

TYPE T = DisplayList.T OBJECT
  initialized: BOOLEAN := FALSE;
  text: TEXT := &quot;&quot;; hot: BOOLEAN := FALSE;
  items: REF ARRAY OF Item := NIL;
  itemBox: DPS.Box := DPS.Box { DPS.Place{0.0,0.0}, DPS.Place{0.0,0.0} };
 METHODS
  Proc (t: DPSWindow.T): REF ARRAY OF Item := ProcIsReallyNIL;
  (* Now longer can compare methods against NIL ... 28jan92 *)
 OVERRIDES
  Repaint := Repaint;
  Mouse := Mouse;
  END;
</PRE><BLOCKQUOTE><EM> If Proc is NIL then items is immutable. </EM></BLOCKQUOTE><PRE>

TYPE E = T;

PROCEDURE <A HREF="PopupButtonDLE.m3#Repaint">Repaint</A> (e: E; box: DPS.Box; only: REFANY := NIL): TEXT;
PROCEDURE <A HREF="PopupButtonDLE.m3#Mouse">Mouse</A> (e: E; t: DPSWindow.T; event: DPS.MouseEvent): BOOLEAN;

PROCEDURE <A HREF="PopupButtonDLE.m3#Init">Init</A> (e: E; t: DPSWindow.T);

PROCEDURE <A HREF="PopupButtonDLE.m3#ProcIsReallyNIL">ProcIsReallyNIL</A> (e: T; t: DPSWindow.T): REF ARRAY OF Item;

  END PopupButtonDLE.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
