<HTML>
<HEAD>
<TITLE>SRC Modula-3: dps/src/PopupMenuDLE.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>dps/src/PopupMenuDLE.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="PopupMenuDLE.i3">PopupMenuDLE</A></implements></module>;

IMPORT <A HREF="DLWindow.i3">DLWindow</A>, <A HREF="DPS.i3">DPS</A>, <A HREF="DPSWindow.i3">DPSWindow</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>;

CONST xMargin = 5.0;
CONST yMargin = 3.0;
CONST fontHeight = DPS.StandardFontPoints;
CONST fontDescender = 0.0;

CONST itemsBelowButton = 1.0;

CONST grayStrokeWidthText = &quot;4.0&quot;; (* Only 'inside' paints, due to clip. *)
</PRE><BLOCKQUOTE><EM>CONST colorStrokeWidthText = <CODE>4.0</CODE>;</EM></BLOCKQUOTE><PRE> (* Only 'inside' paints, due to clip. *)

PROCEDURE <A NAME="Repaint"><procedure>Repaint</procedure></A> (e: E; box: DPS.Box; &lt;*UNUSED*&gt; only: REFANY := NIL): TEXT =
 VAR data: TEXT := &quot;&quot;;
  BEGIN
  IF DPS.BoxesIntersect (e.box, box) THEN
    data := &quot; gsave &quot;
     &amp; PushBoxCoords (e.box) &amp; Fmt.Real(DPS.StandardFontPoints)
     &amp; &quot; 0.5 mul ButtonDLEDrawRoundedPath &quot;
     &amp; &quot; clip 0.95 setgray gsave fill grestore &quot;
     &amp; &quot;0.5 setgray &quot; &amp; grayStrokeWidthText &amp; &quot; setlinewidth stroke &quot;;
    IF e.items#NIL THEN FOR k := 0 TO NUMBER(e.items^)-1 DO
      data := data &amp; RewriteItemText (e, e.items^[k]);
      END; END;
    data := data &amp; &quot; grestore &quot;;
    END;
  RETURN data;
  END Repaint;

PROCEDURE <A NAME="RewriteItemText"><procedure>RewriteItemText</procedure></A> (&lt;*UNUSED*&gt; e: E; i:Item): TEXT =
 VAR data: TEXT;
  BEGIN
  data := &quot; &quot; &amp; Fmt.Real(i.textPlace.x) &amp; &quot; &quot;
    &amp; Fmt.Real(i.textPlace.y) &amp; &quot; moveto &quot;
    &amp; &quot; (&quot; &amp; i.text &amp; &quot;) &quot;
    &amp; &quot; ButtonDLEFont setfont &quot;;
  IF i.hot THEN data := data &amp; &quot; 0.0 1.0 1.0 sethsbcolor show &quot;;
   ELSE data := data &amp; &quot; 0.5 setgray show &quot;
    END;
  RETURN data;
  END RewriteItemText;

PROCEDURE <A NAME="RewriteItem"><procedure>RewriteItem</procedure></A> (e: E; i:Item) =
  BEGIN
  e.ImmediatePostScript ( &quot; gsave &quot; &amp; RewriteItemText(e, i) &amp; &quot; grestore &quot; );
  END RewriteItem;

PROCEDURE <A NAME="PushBoxCoords"><procedure>PushBoxCoords</procedure></A> (box: DPS.Box): TEXT =
  BEGIN
  RETURN &quot; &quot; &amp; Fmt.Real(box.low.x) &amp; &quot; &quot; &amp; Fmt.Real(box.low.y) &amp; &quot; &quot;
   &amp; Fmt.Real(box.high.x) &amp; &quot; &quot; &amp; Fmt.Real(box.high.y) &amp; &quot; &quot;;
  END PushBoxCoords;

PROCEDURE <A NAME="RecalculateItems"><procedure>RecalculateItems</procedure></A> (e: E; place: DPS.Place; t: DPSWindow.T) =
 VAR width, maxWidth: REAL;
  BEGIN
  IF e.items=NIL THEN e.box := DPS.ZeroBox; RETURN; END;
  IF NUMBER(e.items^) &lt; 1 THEN RETURN; END;
  e.box.high.y := place.y - itemsBelowButton;
  e.box.low.y := e.box.high.y
   - ( FLOAT(NUMBER(e.items^)) * fontHeight + yMargin + yMargin );
  maxWidth := 0.0;
  FOR k := 0 TO NUMBER(e.items^)-1 DO
    width := DPS.TextWidth (e.items^[k].text, t, &quot;ButtonDLEFont&quot;);
    e.items^[k].textPlace.y := e.box.high.y
      - ( yMargin + FLOAT(k+1)*fontHeight - fontDescender );
    maxWidth := MAX (maxWidth, width);
    END;
  e.box.low.x := place.x - (maxWidth/2.0 + xMargin);
  e.box.high.x := e.box.low.x + maxWidth + xMargin + xMargin;
  FOR k := 0 TO NUMBER(e.items^)-1 DO
    e.items^[k].textPlace.x := e.box.low.x + xMargin;
    END;
  END RecalculateItems;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (e: E; t: DPSWindow.T) =
  BEGIN
  IF e.initialized THEN RETURN; END;
  t.SendFoundation ( &quot; /ButtonDLEDrawCircledPath &quot;
   &amp; &quot; { /highy exch def /highx exch def /lowy exch def /lowx exch def &quot;
   &amp; &quot; /half highy lowy sub 2 div def &quot;
   &amp; &quot; newpath lowx half add highy moveto &quot;
   &amp; &quot; lowx half add lowy half add half 90 270 arc &quot;
   &amp; &quot; highx half sub lowy lineto &quot;
   &amp; &quot; highx half sub lowy half add half 270 90 arc &quot;
   &amp; &quot; lowx half add highy lineto closepath } def &quot; );
  t.SendFoundation ( &quot; /ButtonDLEDrawRoundedPath &quot;
   &amp; &quot; { /r exch def /highy exch def /highx exch def &quot;
   &amp; &quot; /lowy exch def /lowx exch def &quot;
   &amp; &quot; newpath lowx lowy r add moveto &quot;
   &amp; &quot; lowx r add highy r sub r 180 90 arcn &quot;
   &amp; &quot; highx r sub highy r sub r 90 0 arcn &quot;
   &amp; &quot; highx r sub lowy r add r 0 270 arcn &quot;
   &amp; &quot; lowx r add lowy r add r 270 180 arcn &quot;
   &amp; &quot;  closepath } def &quot; );
  t.SendFoundation ( &quot; /ButtonDLEFont /Times-Roman findfont &quot;
    &amp; Fmt.Real(fontHeight) &amp; &quot; scalefont def &quot; );
  (* Cannot calculate box until Popup() supplies a place. *)
  e.initialized := TRUE;
  END Init;

PROCEDURE <A NAME="ItemMoused"><procedure>ItemMoused</procedure></A> (e: E; &lt;*UNUSED*&gt;t: DPSWindow.T; place: DPS.Place): Item =
 VAR box:DPS.Box;
  BEGIN
  IF e.items#NIL THEN FOR k := 0 TO NUMBER(e.items^)-1 DO
    box := DPS.Box {
      DPS.Place {e.box.low.x, e.items^[k].textPlace.y},
      DPS.Place {e.box.high.x, e.items^[k].textPlace.y + fontHeight} };
    IF DPS.PlaceIsInBox (place, box) THEN RETURN e.items^[k]; END;
    END; END;
  RETURN NIL;
  END ItemMoused;

PROCEDURE <A NAME="Mouse"><procedure>Mouse</procedure></A> (e: T; window: DPSWindow.T; event: DPS.MouseEvent): BOOLEAN =
 VAR in: BOOLEAN;
 VAR new, old: Item;
 VAR fudgedBox: DPS.Box;
  BEGIN
  Init (e, window);
  in := DPS.PlaceIsInBox (event.place, e.box);
  &lt;* ASSERT e.hot *&gt;
  IF event.clickType = DPS.ClickType.LastUp THEN
    (* Not necessary: we will Remove e.hot := FALSE; *)
    fudgedBox := e.box;
    fudgedBox.low.y := fudgedBox.low.y - 1.0;
    fudgedBox.high.x := fudgedBox.high.x + 1.0;
    (* There ^^ is be something wrong with DPS clipping. *)
    e.Remove ();
    window.Dirty (fudgedBox, NIL);
    new := ItemMoused (e, window, event.place);
    IF new # NIL (* Can no longer test Proc#NIL *) THEN new.Proc(); END;
   ELSE (* Not LastUp. Keep correct item highlighted. *)
    new := ItemMoused (e, window, event.place);
    old := NIL;
    IF e.items#NIL THEN
      LOOP FOR k := 0 TO NUMBER(e.items^)-1 DO
        IF e.items^[k].hot THEN old := e.items^[k]; EXIT; END;
        END; EXIT; END;
      END;
    IF new # old THEN
      IF old # NIL THEN old.hot := FALSE; RewriteItem(e, old); END;
      IF new # NIL THEN new.hot := TRUE; RewriteItem(e, new); END;
      END;
    END;
  RETURN TRUE;
  END Mouse;

PROCEDURE <A NAME="Popup"><procedure>Popup</procedure></A> (t: T; place: DPS.Place; window: DLWindow.T) =
  BEGIN
  (* Should assert that it is not being displayed. *)
  (* Client must do this if window changes: t.initialized := FALSE; *)
  Init (t, window); (* Could arrange to test for 'different window' *)
  FOR k := 0 TO NUMBER(t.items^)-1 DO t.items^[k].hot := FALSE; END;
  t.hot := TRUE; (* We are called with the button already down! *)
  RecalculateItems (t, place, window);
  window.displayList.Append (t);
  t.Dirty (t.box, t);
  END Popup;

PROCEDURE <A NAME="ProcIsReallyNIL"><procedure>ProcIsReallyNIL</procedure></A> (&lt;*UNUSED*&gt; i: Item) =
  BEGIN
  END ProcIsReallyNIL;

  BEGIN
  END PopupMenuDLE.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
