<HTML>
<HEAD>
<TITLE>SRC Modula-3: dps/src/SimpleTextDLE.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>dps/src/SimpleTextDLE.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="SimpleTextDLE.i3">SimpleTextDLE</A></implements></module>;

IMPORT <A HREF="DisplayList.i3">DisplayList</A>, <A HREF="DPS.i3">DPS</A>, <A HREF="DPSWindow.i3">DPSWindow</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>;

CONST xMargin = 5.0;
CONST yMargin = 3.0;
CONST fontHeight = DPS.StandardFontPoints;
CONST fontDescender = 2.0;
CONST lineEscapement = 20.0;

PROCEDURE <A NAME="Repaint"><procedure>Repaint</procedure></A> (e: E; box: DPS.Box; &lt;*UNUSED*&gt; only: REFANY): TEXT =
 VAR lineCount: INTEGER;
 VAR data: TEXT := &quot;&quot;;
  BEGIN
  IF NOT DPS.BoxesIntersect (e.box, box) THEN RETURN NIL; END;
  data := DPS.EdgedBoxClipAndPaint (e.box);
  lineCount := NUMBER (e.lines^);
  FOR line := 0 TO lineCount-1 DO
    data := data &amp; &quot; &quot;
      &amp; Fmt.Real(e.box.low.x + xMargin) &amp; &quot; &quot;
      &amp; Fmt.Real (e.box.low.y + yMargin + fontDescender
         + FLOAT(lineCount-line-1) * lineEscapement )
      &amp; &quot; moveto &quot;
      &amp; &quot; (&quot; &amp; e.lines[line] &amp; &quot;) &quot; (* EscapeText called at Init time. *)
      &amp; &quot; ButtonDLEFont setfont 0.0 setgray show &quot;;
    END;
  RETURN &quot; gsave &quot; &amp; data &amp; &quot; grestore &quot;;
  END Repaint;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (e: E; window: DPSWindow.T) =
  BEGIN
  IF e.initialized THEN RETURN; END;
  window.SendFoundation ( &quot; /ButtonDLEFont /Times-Roman findfont &quot;
    &amp; Fmt.Real(fontHeight) &amp; &quot; scalefont def &quot; ); (* Many times alas. *)
  Recalculate (e, window);
  e.initialized := TRUE;
  END Init;

PROCEDURE <A NAME="Recalculate"><procedure>Recalculate</procedure></A> (e: E; window: DPSWindow.T) =
 VAR width: REAL;
 VAR lineCount, line: INTEGER;
 VAR maxWidth: REAL;
 VAR c: CHAR;
  BEGIN
  lineCount := 1;
  FOR k := 0 TO Text.Length(e.text)-2 DO
    IF Text.GetChar(e.text,k)='\n' THEN lineCount := lineCount + 1; END;
    END;
  e.lines := NEW (REF ARRAY OF TEXT, lineCount);
  FOR k := 0 TO lineCount-1 DO e.lines[k] := &quot;&quot;; END;
  line := 0;
  FOR k := 0 TO Text.Length(e.text)-1 DO
    c := Text.GetChar(e.text,k);
    IF c='\n' THEN line := line + 1;
     ELSE e.lines[line] := e.lines[line] &amp; Text.FromChar(c);
      END;
    END;
  maxWidth := 0.0;
  FOR k := 0 TO lineCount-1 DO
    e.lines[k] := DPS.EscapeText(e.lines[k]);
    width := DPS.TextWidth (e.lines[k], window, &quot;ButtonDLEFont&quot;);
    IF width &gt; maxWidth THEN maxWidth := width; END;
    END;
  e.box.high.x := e.box.low.x + xMargin + maxWidth + xMargin;
  e.box.high.y := e.box.low.y + yMargin + fontHeight + yMargin
   + FLOAT(lineCount-1) * lineEscapement;
  END Recalculate;

PROCEDURE <A NAME="Mouse"><procedure>Mouse</procedure></A> (e: E; window: DPSWindow.T; event: DPS.MouseEvent): BOOLEAN =
 VAR in: BOOLEAN;
 VAR affected: DisplayList.E;
  BEGIN
  Init (e, window);
  in := DPS.PlaceIsInBox (event.place, e.box);
  IF in THEN
    IF event.clickType = DPS.ClickType.FirstDown THEN
      affected := e.MoveToLast();
      IF affected#NIL THEN affected.Dirty (affected.box, affected); END;
      END;
    END;
  RETURN in;
  END Mouse;

PROCEDURE <A NAME="Replace"><procedure>Replace</procedure></A> (e: E; text: TEXT; window: DPSWindow.T := NIL) =
 VAR oldBox: DPS.Box;
  BEGIN
  e.text := text;
  IF window # NIL THEN (* Else better be before initialization. *)
    oldBox := e.box;
    Recalculate (e, window);
    window.Dirty ( DPS.BoxUnion (oldBox, e.box), NIL );
    END;
  END Replace;

  BEGIN
  END SimpleTextDLE.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
