<HTML>
<HEAD>
<TITLE>SRC Modula-3: dps/src/SlideXDLE.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>dps/src/SlideXDLE.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="SlideXDLE.m3">SlideXDLE</A></interface>;

IMPORT <A HREF="DisplayList.i3">DisplayList</A>, <A HREF="DisplayListStack.i3">DisplayListStack</A>, <A HREF="DPS.i3">DPS</A>, <A HREF="DPSWindow.i3">DPSWindow</A>;
IMPORT <A HREF="Linked2Tree.i3">Linked2Tree</A>, <A HREF="PopupMenuDLE.i3">PopupMenuDLE</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>;

TYPE Page = RECORD
  fixed: DisplayList.T := NIL;
  visible: DisplayListStack.T := NIL;
  invisible: Linked2Tree.T := NIL;
  END;

TYPE T = DisplayList.T OBJECT
  initialized: BOOLEAN := FALSE;
  window: DPS.T := NIL;
  canMouseChildren: BOOLEAN := FALSE;
  backgroundPopup: PopupMenuDLE.T;
  pages: ARRAY [0..9] OF Page;
  page: INTEGER := 0;
  lastPage: INTEGER := 0;
  minimumHeight, maximumHeight: REAL := 0.0;
 METHODS
  AppendFixed (e: Linked2Tree.E) := AppendFixed;
  AppendVariable (e: Linked2Tree.E) := AppendVariable;
  AllInvisible () := AllInvisible;
  NextVisible () := NextVisible;
 OVERRIDES
  Prepend := Prepend;
  Append := Append;
  InsertBefore := InsertBefore;
  InsertAfter := InsertAfter;
  MakeChildLast := MakeChildLast;
  MakeChildFirst := MakeChildFirst;
  Mouse := Mouse;
  Char := Char;
  Repaint := Repaint;
  END;
TYPE E = T;
TYPE R = T;

PROCEDURE <A HREF="SlideXDLE.m3#Init">Init</A> (t: T; window: DPSWindow.T);

PROCEDURE <A HREF="SlideXDLE.m3#AddPage">AddPage</A> ( t: T; window: DPSWindow.T;
 data: Rd.T; page: INTEGER := 999999 );

PROCEDURE <A HREF="SlideXDLE.m3#Prepend">Prepend</A> (t: T; e: Linked2Tree.E);
PROCEDURE <A HREF="SlideXDLE.m3#Append">Append</A> (t: T; e: Linked2Tree.E);
PROCEDURE <A HREF="SlideXDLE.m3#InsertBefore">InsertBefore</A> (t: T; e, before: Linked2Tree.E);
PROCEDURE <A HREF="SlideXDLE.m3#InsertAfter">InsertAfter</A> (t: T; e, after: Linked2Tree.E);

PROCEDURE <A HREF="SlideXDLE.m3#MakeChildLast">MakeChildLast</A> (t: T; e: Linked2Tree.E): Linked2Tree.E;
PROCEDURE <A HREF="SlideXDLE.m3#MakeChildFirst">MakeChildFirst</A> (t: T; e: Linked2Tree.E): Linked2Tree.E;

PROCEDURE <A HREF="SlideXDLE.m3#Mouse">Mouse</A> (e: E; t: DPSWindow.T; event: DPS.MouseEvent): BOOLEAN;
PROCEDURE <A HREF="SlideXDLE.m3#Char">Char</A> (e: E; t: DPSWindow.T; char: CHAR): BOOLEAN;

PROCEDURE <A HREF="SlideXDLE.m3#Repaint">Repaint</A> (t: T; box: DPS.Box; only: REFANY): TEXT;

PROCEDURE <A HREF="SlideXDLE.m3#AppendFixed">AppendFixed</A> (t: T; e: Linked2Tree.E);
PROCEDURE <A HREF="SlideXDLE.m3#AppendVariable">AppendVariable</A> (t: T; e: Linked2Tree.E); (* = Append *)

PROCEDURE <A HREF="SlideXDLE.m3#AllInvisible">AllInvisible</A> (t: T);
PROCEDURE <A HREF="SlideXDLE.m3#NextVisible">NextVisible</A> (t: T);

  END SlideXDLE.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
