<HTML>
<HEAD>
<TITLE>SRC Modula-3: dps/src/VContainerDLE.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>dps/src/VContainerDLE.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="VContainerDLE.i3">VContainerDLE</A></implements></module>;

IMPORT <A HREF="DisplayList.i3">DisplayList</A>, <A HREF="DPS.i3">DPS</A>, <A HREF="DPSWindow.i3">DPSWindow</A>, <A HREF="Linked2Tree.i3">Linked2Tree</A>, <A HREF="#x1">Err</A>;

PROCEDURE <A NAME="Repaint"><procedure>Repaint</procedure></A> (e: E; box: DPS.Box; only: REFANY := NIL): TEXT =
  BEGIN
  TYPECASE only OF
    NULL =&gt; RETURN DisplayList.Repaint (e, box, NIL); (* Paint my children. *)
  | E(ee)=&gt;
      IF ee = e THEN RETURN DisplayList.Repaint (e, box, NIL);
       ELSE
        Err.Msg (&quot;ee # e in VContainerDLE.Repaint&quot;);
        RETURN ee.Repaint (box, only);
        END;
    ELSE RETURN NIL;
    END;
  END Repaint;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (e: E; &lt;*UNUSED*&gt; window: DPSWindow.T) =
  BEGIN
  IF e.initialized THEN RETURN; END;
  Rearrange (e);
  e.initialized := TRUE;
  END Init;

PROCEDURE <A NAME="Mouse"><procedure>Mouse</procedure></A> (e: E; window: DPSWindow.T; event: DPS.MouseEvent): BOOLEAN =
  BEGIN
  Init(e, window);
  RETURN DisplayList.Mouse (e, window, event);
  END Mouse;

PROCEDURE <A NAME="Char"><procedure>Char</procedure></A> (t: T; window: DPSWindow.T; char: CHAR): BOOLEAN =
 VAR e: DisplayList.T;
  BEGIN
  e := t.childWithInputFocus;
  IF e # NIL THEN RETURN e.Char (window, char);END;
  RETURN FALSE;
  END Char;

PROCEDURE <A NAME="Prepend"><procedure>Prepend</procedure></A> (t: Linked2Tree.T; e: Linked2Tree.E) =
  BEGIN
  Linked2Tree.Prepend (t, e);
  Rearrange (t);
  END Prepend;

PROCEDURE <A NAME="Append"><procedure>Append</procedure></A> (t: Linked2Tree.T; e: Linked2Tree.E) =
  BEGIN
  Linked2Tree.Append (t, e);
  Rearrange (t);
  END Append;

PROCEDURE <A NAME="Remove"><procedure>Remove</procedure></A> (e: Linked2Tree.E) =
 VAR me: T;
  BEGIN
  me := e.parent;
  Linked2Tree.Remove (e);
  Rearrange (me);
  END Remove;

PROCEDURE <A NAME="MakeChildLast"><procedure>MakeChildLast</procedure></A> (t: Linked2Tree.T;
                         &lt;*UNUSED*&gt; e: Linked2Tree.E): Linked2Tree.E =
  BEGIN
  (* Since our children are not overlapped, we can leave their order alone. *)
  (* Important, as we use the order as our bottom-to-top ordering. *)
  RETURN t.MoveToLast();
  END MakeChildLast;

PROCEDURE <A NAME="Rearrange"><procedure>Rearrange</procedure></A> (me: T) =
 VAR ee: DisplayList.E;
 VAR y, h, w, maxW: REAL;
  BEGIN
  maxW := 0.0;
  y := me.box.low.y;
  ee := me.First(); (* Forward, so up in Display PostScript. *)
  IF ee = NIL THEN me.box.high.y := y; RETURN; END;
  WHILE ee # NIL DO
    w := ee.box.high.x - ee.box.low.x;
    h := ee.box.high.y - ee.box.low.y;
    maxW := MAX (maxW, w);
    ee.box.low.x := me.box.low.x; ee.box.high.x := ee.box.low.x + w;
    ee.box.low.y := y; ee.box.high.y := y + h;
    y := y + h + me.separation;
    ee := ee.Next();
    END;
  me.box.high.y := y - me.separation;
  me.box.high.x := me.box.low.x + maxW;
  END Rearrange;

  BEGIN
  END VContainerDLE.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Err is in:
</A><UL>
<LI><A HREF="Err.i3#0TOP0">dps/src/Err.i3</A>
<LI><A HREF="../../m3tk/src/misc/Err.i3#0TOP0">m3tk/src/misc/Err.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
