<HTML>
<HEAD>
<TITLE>SRC Modula-3: dps/src/WarpDLE.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>dps/src/WarpDLE.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="WarpDLE.i3">WarpDLE</A></implements></module>;

IMPORT <A HREF="DisplayList.i3">DisplayList</A>, <A HREF="DPS.i3">DPS</A>, <A HREF="DPSWindow.i3">DPSWindow</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>;
</PRE>******************
PROCEDURE BoxFromXYWH (x, y: REAL; w, h: REAL := 0.0): DPS.Box =
 VAR box: DPS.Box;
  BEGIN
  box.low.x := x; box.high.x := x + w;
  box.low.y := y; box.high.y := y + h;
  RETURN box;
  END BoxFromXYWH;
****************

<P><PRE>PROCEDURE <A NAME="Repaint"><procedure>Repaint</procedure></A> (t: T; box: DPS.Box; only: REFANY): TEXT =
 VAR text: TEXT := &quot;&quot;;
  BEGIN
  box.low.y := WarpY (t, box.low.y);
  box.high.y := WarpY (t, box.high.y);
  text := text &amp; DisplayList.Repaint (t, box, only);
  RETURN Warp (t, text);
  END Repaint;

PROCEDURE <A NAME="WarpY"><procedure>WarpY</procedure></A> (t: T; y: REAL): REAL = (* From mouse-ish coords to clients *)
  BEGIN
  IF t.multiplierWarpY = 1.0 THEN RETURN y; END;
  IF y &lt; t.bottomWarpY THEN RETURN y / t.multiplierWarpY; END;
  RETURN (y - t.bottomWarpY) + (t.bottomWarpY / t.multiplierWarpY);
  END WarpY;

PROCEDURE <A NAME="WarpYToScreen"><procedure>WarpYToScreen</procedure></A> (t: T; y: REAL): REAL =
  BEGIN (* From client's view to screen *)
  IF t.multiplierWarpY = 1.0 THEN RETURN y;
   ELSIF y &lt; (t.bottomWarpY / t.multiplierWarpY) THEN
    RETURN y * t.multiplierWarpY;
   ELSE RETURN (y - t.bottomWarpY / t.multiplierWarpY) + t.bottomWarpY;
    END;
  END WarpYToScreen;
</PRE>********
PROCEDURE WarpedHeight (t: T): REAL = 
  BEGIN
  IF t.multiplierWarpY = 1.0 THEN RETURN t.box.high.y; END;
  RETURN (t.box.high.y - t.bottomWarpY) + (t.bottomWarpY / t.multiplierWarpY);
  END WarpedHeight;
*********
 
<P><PRE>PROCEDURE <A NAME="Warp"><procedure>Warp</procedure></A> ( t: T; text: TEXT ): TEXT =
 VAR b1, b2: DPS.Box;
 VAR yTranslation: REAL;
  BEGIN
  IF t.multiplierWarpY = 1.0 THEN RETURN text; END;
  b1.low.x := 0.0; b1.high.x := 10000.0;
  b1.low.y := 0.0; b1.high.y := t.bottomWarpY;
  b2.low.x := 0.0; b2.high.x := 10000.0;
  b2.low.y := t.bottomWarpY; b2.high.y := 10000.0;
  yTranslation := t.bottomWarpY / t.multiplierWarpY - t.bottomWarpY;
  RETURN
    DPS.GSaveAndClip (b2)
    &amp; &quot; 0.0 0.0 &quot; &amp; Fmt.Real(yTranslation) &amp; &quot; sub translate &quot;
    &amp; text
    &amp; DPS.GRestore ()
    &amp; DPS.GSaveAndClip (b1)
    &amp; &quot; 1.0 &quot; &amp; Fmt.Real(t.multiplierWarpY) &amp; &quot; scale &quot;
    &amp; text
    &amp; DPS.GRestore ();
  END Warp;

PROCEDURE <A NAME="PostScriptToParentWarped"><procedure>PostScriptToParentWarped</procedure></A> (e: E; script: TEXT) =
 VAR p: DisplayList.T;
  BEGIN
  p := e.parent;
  IF p # NIL THEN
    p.ImmediatePostScript (Warp (e, script));
    END;
  END PostScriptToParentWarped;

PROCEDURE <A NAME="DirtyToParentWarped"><procedure>DirtyToParentWarped</procedure></A> (e: E; box: DPS.Box; only: DisplayList.T := NIL) =
 VAR p: DisplayList.T;
  BEGIN
  p := e.parent;
  IF p # NIL THEN
    box.low.y := WarpYToScreen (e, box.low.y);
    box.high.y := WarpYToScreen (e, box.high.y);
    (*
    box.low.y := 0.0;
    box.high.y := 1000.0;
    *)
    p.Dirty (box, only);
    END;
  END DirtyToParentWarped;

PROCEDURE <A NAME="Mouse"><procedure>Mouse</procedure></A> (t: T; window: DPSWindow.T; event: DPS.MouseEvent): BOOLEAN =
 VAR e: DisplayList.E;
  BEGIN
  event.place.y := WarpY (t, event.place.y);

  e := t.Last();
  WHILE e # NIL DO
    IF e.Mouse (window, event) THEN RETURN TRUE; END;
    e := e.Previous();
    END;

  RETURN FALSE;
  END Mouse;

  BEGIN

  END WarpDLE.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
