<HTML>
<HEAD>
<TITLE>SRC Modula-3: dps/src/wraps.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>dps/src/wraps.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module><implements><A HREF="wraps.i3">wraps</A></implements></module>;

IMPORT <A HREF="DPS.i3">DPS</A>, <A HREF="../../text/src/Text.i3">Text</A>;

PROCEDURE <A NAME="GetTransform"><procedure>GetTransform</procedure></A> ( ctxt: INTEGER;
  VAR ctm, invctm: ARRAY [0..5] OF REAL;
  VAR xOffset, yOffset: INTEGER ) =
  BEGIN
  GetTransformWrap ( ctxt, ADR(ctm[0]), ADR(invctm[0]), ADR(xOffset), ADR(yOffset) );
  END GetTransform;

PROCEDURE <A NAME="FetchInteger"><procedure>FetchInteger</procedure></A> ( ctxt: INTEGER;
 u: TEXT; alreadyLocked: BOOLEAN := FALSE ): INTEGER =
 VAR uu: UNTRACED REF ARRAY OF CHAR;
 VAR ret: INTEGER;
  BEGIN
  uu := MakeString (u);
  IF alreadyLocked THEN FetchIntegerWrap ( ctxt, ADR(uu[0]), ADR(ret) );
   ELSE
    TRY DPS.AcquireDPSMutex();
      FetchIntegerWrap ( ctxt, ADR(uu[0]), ADR(ret) );
     FINALLY DPS.ReleaseDPSMutex();
      END;
    END;
  DISPOSE (uu);
  RETURN ret;
  END FetchInteger;

PROCEDURE <A NAME="FetchNumber"><procedure>FetchNumber</procedure></A> ( ctxt: INTEGER;
 u: TEXT; alreadyLocked: BOOLEAN := FALSE ): REAL =
 VAR uu: UNTRACED REF ARRAY OF CHAR;
 VAR ret: REAL;
  BEGIN
  uu := MakeString (u);
  IF alreadyLocked THEN FetchNumberWrap ( ctxt, ADR(uu[0]), ADR(ret) );
   ELSE
    TRY DPS.AcquireDPSMutex();
      FetchNumberWrap ( ctxt, ADR(uu[0]), ADR(ret) );
     FINALLY DPS.ReleaseDPSMutex();
      END;
    END;
  DISPOSE (uu);
  RETURN ret;
  END FetchNumber;

PROCEDURE <A NAME="FetchString"><procedure>FetchString</procedure></A> ( ctxt: INTEGER;
 u: TEXT; alreadyLocked: BOOLEAN := FALSE ): TEXT =
 VAR uu, vv: UNTRACED REF ARRAY OF CHAR;
 VAR ret: TEXT := &quot;&quot;;
  BEGIN
  uu := MakeString (u);
  vv := NEW (UNTRACED REF ARRAY OF CHAR, 1000);
  IF alreadyLocked THEN FetchStringWrap ( ctxt, ADR(uu[0]), ADR(vv[0]) );
   ELSE
    TRY DPS.AcquireDPSMutex();
      FetchStringWrap ( ctxt, ADR(uu[0]), ADR(vv[0]) );
     FINALLY DPS.ReleaseDPSMutex();
      END;
    END;
  DISPOSE (uu);
  FOR j := 0 TO 999 DO
    IF ORD(vv^[j]) = 0 THEN RETURN ret; END;
    ret := ret &amp; Text.FromChar (vv^[j]);
    END;
  RETURN ret;
  END FetchString;

PROCEDURE <A NAME="XYHit"><procedure>XYHit</procedure></A> ( ctxt: INTEGER; x, y: REAL; u: TEXT ): BOOLEAN =
 VAR uu: UNTRACED REF ARRAY OF CHAR;
 VAR ret: BOOLEAN;
  BEGIN
  uu := MakeString (u);
  TRY DPS.AcquireDPSMutex();
    XYHitWrap ( ctxt, x, y, ADR(uu[0]), ADR(ret) );
   FINALLY DPS.ReleaseDPSMutex();
    END;
  DISPOSE (uu);
  RETURN ret;
  END XYHit;

PROCEDURE <A NAME="Stringwidth"><procedure>Stringwidth</procedure></A> ( ctxt: INTEGER; f: TEXT; s: TEXT; VAR x, y: REAL ) =
 VAR ff, ss: UNTRACED REF ARRAY OF CHAR;
  BEGIN
  ff := MakePSString (f);
  ss := MakePSString (s);
  TRY DPS.AcquireDPSMutex();
    StringwidthWrap ( ctxt, ADR(ff[0]), ADR(ss[0]), ADR(x), ADR(y) );
   FINALLY DPS.ReleaseDPSMutex();
    END;
  DISPOSE (ff); DISPOSE (ss);
  END Stringwidth;

PROCEDURE <A NAME="MakePSString"><procedure>MakePSString</procedure></A> (t: TEXT): UNTRACED REF ARRAY OF CHAR =
 VAR s: UNTRACED REF ARRAY OF CHAR;
 VAR len, wax: INTEGER;
 VAR k: INTEGER;
 VAR c: CHAR;
  BEGIN
  len := Text.Length(t);
  wax := 0;
  FOR j := 0 TO len-1 DO
    CASE Text.GetChar(t, j) OF
    | '(' =&gt; wax := wax + 1;
    | ')' =&gt; wax := wax + 1;
    | '\\' =&gt; wax := wax + 1;
      ELSE
      END; (* of CASE *)
    END; (* of FOR *)
  s := NEW (UNTRACED REF ARRAY OF CHAR, len+wax+1);
  k := 0;
  FOR j := 0 TO len-1 DO
    c := Text.GetChar(t, j);
    CASE c OF
    | '(' =&gt; s^[k] := '\\'; s^[k+1] := c; k := k + 2;
    | ')' =&gt; s^[k] := '\\'; s^[k+1] := c; k := k + 2;
    | '\\' =&gt; s^[k] := '\\'; s^[k+1] := c; k := k + 2;
     ELSE s^[k] := c; k := k + 1;
      END; (* of CASE *)
    END; (* of FOR *)
  s^[k] := '\000';
  RETURN s;
  END MakePSString;

PROCEDURE <A NAME="MakeString"><procedure>MakeString</procedure></A> (t: TEXT): UNTRACED REF ARRAY OF CHAR =
 VAR s: UNTRACED REF ARRAY OF CHAR;
 VAR len: INTEGER;
  BEGIN
  len := Text.Length(t);
  s := NEW (UNTRACED REF ARRAY OF CHAR, len+1);
  FOR j := 0 TO len-1 DO s^[j] := Text.GetChar(t, j); END;
  s^[len] := '\000';
  RETURN s;
  END MakeString;

  BEGIN
  END wraps.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
