<HTML>
<HEAD>
<TITLE>SRC Modula-3: etext/src/EmacsModel.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>etext/src/EmacsModel.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                         </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;

MODULE <module><implements><A HREF="EmacsModel.i3">EmacsModel</A></implements></module>;

IMPORT <A HREF="../../types/src/ASCII.i3">ASCII</A>, <A HREF="ISOChar.i3">ISOChar</A>, <A HREF="../../ui/src/vbt/KeyboardKey.i3">KeyboardKey</A>, <A HREF="KeyFilter.i3">KeyFilter</A>, <A HREF="KeyTrans.i3">KeyTrans</A>, <A HREF="../../ui/src/vbt/Latin1Key.i3">Latin1Key</A>,
       <A HREF="MTextUnit.i3">MTextUnit</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="TextPort.i3">TextPort</A>, <A HREF="TextPortClass.i3">TextPortClass</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>,
       <A HREF="../../vtext/src/VTDef.i3">VTDef</A>, <A HREF="../../vtext/src/VText.i3">VText</A>;
FROM <A HREF="TextPortClass.i3">TextPortClass</A> IMPORT IRange;

REVEAL
  <A NAME="T">T</A> = TextPortClass.Model BRANDED OBJECT
        clipboard                          := &quot;&quot;;
        mark     : [-1 .. LAST (CARDINAL)] := -1; (* -1 =&gt; not set *)
        downclick: CARDINAL                := 0;
        append                             := FALSE;
        lit                                := FALSE;
      OVERRIDES
        controlChord := ControlChord;
        copy         := Copy;
        highlight    := Highlight;
        init         := Init;
        mouse        := Mouse;
        optionChord  := OptionChord;
        paste        := Paste;
        position     := Position;
        read         := Read;
        seek         := Seek;
        select       := Select;
        write        := Write;
      END;
  <A NAME="EscapeMetaFilter">EscapeMetaFilter</A> = KeyFilter.T BRANDED OBJECT
                       sawEscape := FALSE
                     OVERRIDES
                       apply := ApplyEMFilter
                     END;

TYPE
  KQFilter = KeyFilter.T OBJECT
               state      := State.Initial
             OVERRIDES
               apply := ApplyKQFilter
             END;
  State = {Initial, SawControlK, SawControlQ};
</PRE> <CODE>EmacsModel.T.filter</CODE> is a finite-state machine that implements a
   1-character lookahead for control-K (successive control-K's append to the
   clipboard) and control-Q (quoted insert).  <CODE>Emacs.T.key</CODE> does the same for
   Escape (adding the Option modifier to the KeyRec). 

<P><PRE>CONST
  Primary = TextPort.SelectionType.Primary;
  Source  = TextPortClass.VType.Source;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (m: T; colorScheme: PaintOp.ColorScheme; keyfilter: KeyFilter.T):
  TextPortClass.Model =
  BEGIN
    TRY
      m.selection [Primary] :=
        NEW (TextPortClass.SelectionRecord, type := Primary,
             interval := VText.CreateInterval (
                           vtext := m.v.vtext, indexL := 0, indexR := 0,
                           options := VText.MakeIntervalOptions (
                                        style := VText.IntervalStyle.NoStyle,
                                        whiteBlack := colorScheme,
                                        whiteStroke := colorScheme,
                                        leading := colorScheme.bg)),
             mode := VText.SelectionMode.CharSelection, alias := VBT.NilSel)
    EXCEPT
    | VTDef.Error (ec) =&gt; m.v.vterror (&quot;Model Init&quot;, ec)
    END;
    m.keyfilter :=
      NEW (EscapeMetaFilter,
           next := NEW (KQFilter, next := NEW (TextPortClass.Composer,
                                               next := keyfilter)));
    RETURN m
  END Init;

PROCEDURE <A NAME="ControlChord"><procedure>ControlChord</procedure></A> (m: T; ch: CHAR; READONLY cd: VBT.KeyRec) =
  CONST name = &quot;Control Key&quot;;
  VAR v := m.v;
  BEGIN
    TRY
      CASE ISOChar.Upper [ch] OF
      | ' ', '@' =&gt; SetMark (m, v.index ())
      | '_' =&gt; TextPortClass.Undo (v)
      | 'A' =&gt; TextPortClass.ToStartOfLine (v)
      | 'B' =&gt; TextPortClass.ToPrevChar (v)
      | 'D' =&gt; EVAL TextPortClass.DeleteNextChar (v)
      | 'E' =&gt; TextPortClass.ToEndOfLine (v)
      | 'F' =&gt; TextPortClass.ToNextChar (v)
      | 'H' =&gt; m.seek (TextPortClass.DeletePrevChar (v).l)
      | 'I' =&gt; m.v.ULtabAction (cd)
      | 'J' =&gt; m.v.newlineAndIndent ()
      | 'K' =&gt; IF NOT v.readOnly THEN Kill (m, v, cd) END
      | 'M' =&gt; m.v.ULreturnAction (cd)
      | 'N' =&gt; TextPortClass.DownOneLine (v)
      | 'O' =&gt; TextPortClass.InsertNewline (v)
      | 'P' =&gt; TextPortClass.UpOneLine (v)
        (* Control-Q is handled by the filter method. *)
      | 'R' =&gt; v.findSource (cd.time, TextPortClass.Loc.Prev)
      | 'S' =&gt; v.findSource (cd.time, TextPortClass.Loc.Next)
      | 'T' =&gt; TextPortClass.SwapChars (v)
      | 'V' =&gt; TextPortClass.ScrollOneScreenUp (v); RETURN
      | 'W' =&gt; m.cut (cd.time)
      | 'Y' =&gt; m.paste (cd.time)
      | 'Z' =&gt; TextPortClass.ScrollOneLineUp (v); RETURN
      ELSE
        (* Don't normalize if unknown chord, including just ctrl itself. *)
        RETURN
      END
    EXCEPT
    | VTDef.Error (ec) =&gt; m.v.vterror (name, ec)
    | Rd.Failure (ref) =&gt; m.v.rdfailure (name, ref)
    | Rd.EndOfFile =&gt; m.v.rdeoferror (name)
    | Thread.Alerted =&gt;
    END;
    m.v.normalize (-1)
  END ControlChord;

PROCEDURE <A NAME="SetMark"><procedure>SetMark</procedure></A> (m: T; point: CARDINAL) =
  VAR rec := m.selection [Primary];
  BEGIN
    m.mark := point;
    m.downclick := point;
    rec.anchor.l := point;
    rec.anchor.r := point;
    m.highlight (rec, IRange {point, point, point})
  END SetMark;

PROCEDURE <A NAME="Highlight"><procedure>Highlight</procedure></A> (         m  : T;
                              rec: TextPortClass.SelectionRecord;
                     READONLY r  : IRange                         ) =
  CONST name = &quot;Highlight&quot;;
  BEGIN
    TRY
      VText.MoveInterval (rec.interval, r.left, r.right);
      VText.SwitchInterval (
        rec.interval, VAL (ORD (m.lit), VText.OnOffState));
      VText.MoveCaret (m.v.vtext, r.middle);
      VBT.Mark (m.v)
    EXCEPT
    | VTDef.Error (ec) =&gt; m.v.vterror (name, ec)
    | Rd.EndOfFile =&gt; m.v.rdeoferror (name)
    | Rd.Failure (ref) =&gt; m.v.rdfailure (name, ref)
    | Thread.Alerted =&gt;
    END
  END Highlight;

PROCEDURE <A NAME="Select"><procedure>Select</procedure></A> (m          : T;
                  time       : VBT.TimeStamp;
                  begin      : CARDINAL        := 0;
                  end        : CARDINAL        := LAST (CARDINAL);
                  type                         := Primary;
                  replaceMode                  := FALSE;
                  caretEnd                     := VText.WhichEnd.Right) =
  BEGIN
    m.lit := TRUE;               (* Changes the highlighting *)
    IF caretEnd = VText.WhichEnd.Right THEN
      SetMark (m, begin)
    ELSE
      SetMark (m, MIN (end, m.v.length ()))
    END;
    TextPortClass.Model.select (
      m, time, begin, end, type, replaceMode, caretEnd)
  END Select;

PROCEDURE <A NAME="Seek"><procedure>Seek</procedure></A> (m: T; position: CARDINAL) =
  CONST name = &quot;Seek&quot;;
  VAR rec := m.selection [Primary];
  BEGIN
    TRY
      VText.MoveCaret (m.v.vtext, position);
      IF m.approachingFromLeft AND position &lt; rec.anchor.r
           OR NOT m.approachingFromLeft AND position &lt;= rec.anchor.l THEN
        VText.MoveInterval (rec.interval, position, rec.anchor.r)
      ELSE
        VText.MoveInterval (rec.interval, rec.anchor.l, position)
      END;
      VBT.Mark (m.v)
    EXCEPT
    | VTDef.Error (ec) =&gt; m.v.vterror (name, ec)
    | Rd.EndOfFile =&gt; m.v.rdeoferror (name)
    | Rd.Failure (ref) =&gt; m.v.rdfailure (name, ref)
    | Thread.Alerted =&gt;
    END
  END Seek;

PROCEDURE <A NAME="Kill"><procedure>Kill</procedure></A> (m: T; v: TextPort.T; READONLY cd: VBT.KeyRec) =
  (* Delete to end of line, but also make the deleted text be the source
     selection. *)
  PROCEDURE clip (t: TEXT) =
    BEGIN
      IF m.append THEN
        m.clipboard := m.clipboard &amp; t
      ELSE
        m.clipboard := t
      END
    END clip;
  VAR
    here := v.index ();
    info := MTextUnit.LineInfo (v.vtext.mtext, here);
  BEGIN
    IF NOT m.takeSelection (VBT.Source, Primary, cd.time) THEN (* skip *)
    ELSIF here = info.rightEnd THEN
      (* We're already at the end of line. *)
      clip (v.getText (here, info.right));
      EVAL v.replace (here, info.right, &quot;&quot;)
    ELSE
      clip (v.getText (here, info.rightEnd));
      EVAL v.replace (here, info.rightEnd, &quot;&quot;)
    END
  END Kill;

PROCEDURE <A NAME="OptionChord"><procedure>OptionChord</procedure></A> (m: T; ch: CHAR; READONLY cd: VBT.KeyRec) =
  CONST name = &quot;Option Key&quot;;
  VAR
    ext: TextPort.Extent;
    v                    := m.v;
  BEGIN
    TRY
      CASE ISOChar.Upper [ch] OF
      | '_' =&gt; TextPortClass.Redo (v)
      | '&lt;' =&gt; m.seek (0)
      | '&gt;' =&gt; m.seek (LAST (CARDINAL))
      | 'B' =&gt;
          ext := TextPortClass.FindPrevWord (v);
          IF ext # TextPort.NotFound THEN m.seek (ext.l) END
      | 'D' =&gt; EVAL TextPortClass.DeleteToEndOfWord (v)
      | 'F' =&gt;
          ext := TextPortClass.FindNextWord (v);
          IF ext # TextPort.NotFound THEN m.seek (ext.r) END
      | 'H', ASCII.BS, ASCII.DEL =&gt; EVAL TextPortClass.DeleteToStartOfWord (v)
      | 'V' =&gt; TextPortClass.ScrollOneScreenDown (v); RETURN
      | 'W' =&gt; m.copy (cd.time)
      | 'Z' =&gt; TextPortClass.ScrollOneLineDown (v); RETURN
      ELSE
        IF cd.whatChanged = KeyboardKey.Left THEN
          OptionChord (m, 'b', cd)
        ELSIF cd.whatChanged = KeyboardKey.Right THEN
          OptionChord (m, 'f', cd)
        ELSE
          (* Don't normalize if unknown chord, including just option
             itself. *)
        END;
        RETURN
      END
    EXCEPT
    | VTDef.Error (ec) =&gt; m.v.vterror (name, ec)
    | Rd.Failure (ref) =&gt; m.v.rdfailure (name, ref)
    | Rd.EndOfFile =&gt; m.v.rdeoferror (name)
    | Thread.Alerted =&gt; RETURN
    END;
    m.v.normalize (-1)
  END OptionChord;

PROCEDURE <A NAME="Mouse"><procedure>Mouse</procedure></A> (m: T; READONLY cd: VBT.MouseRec) =
  VAR
    rec := m.selection [Primary];
    r   := TextPortClass.GetRange (m.v, cd.cp, rec.mode);
  BEGIN
    IF NOT m.v.getKFocus (cd.time) THEN RETURN END;
    IF m.mark = -1 THEN SetMark (m, r.middle) END;
    CASE cd.clickType OF
    | VBT.ClickType.FirstDown =&gt;
        CASE cd.whatChanged OF
        | VBT.Modifier.MouseL =&gt; (* Set point *)
            (* Needed in case we start dragging: *)
            m.downclick := r.middle;
            (* Cancel replace-mode and highlighting. *)
            m.lit := FALSE;
            rec.replaceMode := FALSE;
            TRY
              TextPortClass.ChangeIntervalOptions (m.v, rec)
            EXCEPT
            | VTDef.Error (ec) =&gt; m.v.vterror (&quot;Mouse&quot;, ec)
            END;
            IF cd.clickCount DIV 2 = 1 THEN
              (* double-click =&gt; set mark *)
              SetMark (m, r.middle)
            ELSE                 (* Left-click redefines anchor *)
              rec.anchor.l := m.mark;
              rec.anchor.r := m.mark;
              IF r.middle &lt; m.mark THEN
                m.highlight (rec, IRange {r.middle, r.middle, m.mark})
              ELSE
                m.highlight (rec, IRange {m.mark, r.middle, r.middle})
              END
            END;
            m.dragging := TRUE
        | VBT.Modifier.MouseM =&gt; m.copy (cd.time)
        | VBT.Modifier.MouseR =&gt;
            m.approachingFromLeft :=
              r.left &lt; (rec.anchor.l + rec.anchor.r) DIV 2;
            m.dragging := TRUE;
            m.lit := TRUE;
            m.extend (rec, r.left, r.right)
        ELSE
          m.dragging := FALSE
        END
    | VBT.ClickType.LastUp =&gt;
        IF m.dragging THEN
          rec.anchor.l := rec.interval.left ();
          rec.anchor.r := rec.interval.right ();
          m.dragging := FALSE
        END
    ELSE
      m.dragging := FALSE
    END                          (* CASE *)
  END Mouse;

PROCEDURE <A NAME="Position"><procedure>Position</procedure></A> (m: T; READONLY cd: VBT.PositionRec) =
  BEGIN
    IF m.mark # m.downclick THEN SetMark (m, m.downclick) END;
    m.lit := TRUE;
    TextPortClass.Model.position (m, cd)
  END Position;
</PRE>**********************  Reading  ***************************

<P><PRE>PROCEDURE <A NAME="Read"><procedure>Read</procedure></A> (m: T; READONLY s: VBT.Selection; time: VBT.TimeStamp): TEXT
  RAISES {VBT.Error} =
  BEGIN
    IF s = VBT.Source AND m.v.owns [Source] THEN
      RETURN m.clipboard
    ELSE
      RETURN TextPortClass.Model.read (m, s, time)
    END
  END Read;
</PRE>**********************  Writing  ***************************

<P><PRE>PROCEDURE <A NAME="Write"><procedure>Write</procedure></A> (m: T; READONLY s: VBT.Selection; time: VBT.TimeStamp; t: TEXT)
  RAISES {VBT.Error} =
  BEGIN
    IF s = VBT.Source AND m.v.owns [Source] THEN
      m.clipboard := t
    ELSE
      TextPortClass.Model.write (m, s, time, t)
    END
  END Write;
</PRE>**************** Other things ************************

<P><PRE>PROCEDURE <A NAME="Copy"><procedure>Copy</procedure></A> (m: T; time: VBT.TimeStamp) =
  VAR t := m.getSelectedText (Primary);
  BEGIN
    IF NOT Text.Empty (t) AND m.takeSelection (VBT.Source, Primary, time) THEN
      m.clipboard := t
    END
  END Copy;

PROCEDURE <A NAME="Paste"><procedure>Paste</procedure></A> (m: T; time: VBT.TimeStamp) =
  BEGIN
    TRY
      WITH t   = m.read (VBT.Source, time),
           p   = m.v.index (),
           len = Text.Length (t)            DO
        IF len # 0 AND m.v.replace (p, p, t) # TextPort.NotFound THEN
          m.select (time, p, p + len)
        END
      END
    EXCEPT
    | VBT.Error (ec) =&gt; m.v.vbterror (&quot;Paste&quot;, ec)
    END
  END Paste;

PROCEDURE <A NAME="ApplyEMFilter"><procedure>ApplyEMFilter</procedure></A> (self: EscapeMetaFilter; v: VBT.T; cd: VBT.KeyRec) =
  VAR c := cd.whatChanged;
  BEGIN
    IF self.sawEscape THEN
      IF KeyFilter.IsModifier (c) THEN (* skip *)
      ELSE
        cd.modifiers := cd.modifiers + VBT.Modifiers {VBT.Modifier.Option};
        self.sawEscape := FALSE;
        self.next.apply (v, cd)
      END
    ELSIF c = KeyboardKey.Escape OR VBT.Modifier.Control IN cd.modifiers
                                      AND c = Latin1Key.bracketleft THEN
      self.sawEscape := TRUE
    ELSE
      self.next.apply (v, cd)
    END
  END ApplyEMFilter;

PROCEDURE <A NAME="ApplyKQFilter"><procedure>ApplyKQFilter</procedure></A> (self: KQFilter; v: VBT.T; cd: VBT.KeyRec) =
  VAR
    tp     : TextPort.T := v;
    m      : T          := tp.m;
    c                   := cd.whatChanged;
    k                   := c = Latin1Key.K OR c = Latin1Key.k;
    q                   := c = Latin1Key.Q OR c = Latin1Key.q;
    control             := VBT.Modifier.Control IN cd.modifiers;
    cK                  := control AND k;
    cQ                  := control AND q;
  BEGIN
    m.append := FALSE;
    CASE self.state OF
    | State.Initial =&gt;
        IF cK THEN
          self.state := State.SawControlK;
          self.next.apply (v, cd)
        ELSIF cQ THEN
          self.state := State.SawControlQ
        ELSE
          self.next.apply (v, cd)
        END
    | State.SawControlK =&gt;
        IF cK THEN
          m.append := TRUE;
          self.next.apply (v, cd)
        ELSIF cQ THEN
          self.state := State.SawControlQ
        ELSIF KeyFilter.IsModifier (c) THEN (* ignore *)
        ELSE
          self.state := State.Initial;
          self.next.apply (v, cd)
        END
    | State.SawControlQ =&gt;
        IF NOT KeyFilter.IsModifier (c) THEN
          TextPort.Insert (tp, Text.FromChar (KeyTrans.TTY (cd)));
          self.state := State.Initial
        END
    END
  END ApplyKQFilter;

BEGIN
END EmacsModel.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
